package ibase.dashboard.sfa.ejb;
 
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
 
@Stateless
public class TargetVsAchievement extends ValidatorEJB  implements TargetVsAchievementRemote, TargetVsAchievementLocal

{
	GenericUtility genericUtility = new GenericUtility();
	
	/********** Start of method getTargetVsAchievement()
	* EJB Name           : TargetVsAchievement.java
	* Method Name        : getTargetVsAchievement(String,String)
	* Servlet Name       : TargetVsAchievementServlet
	* Metadata xml Name  : targetvsachievement.xml
	* 
	* */
	
	@SuppressWarnings("unchecked")
	public JSONObject getTargetVsAchievement(String dataSourceName,String defaultPreCode,String empCode) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count=0;		
	
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			
			if (defaultPreCode!= null && empCode!=null)
			 {
			    
			    System.out.println("TargetVsAchievement inside EJB passing Preriod code="+defaultPreCode +" and EmpCode ="+empCode);
			
			//Note: This sql used for testing purpose means static sql
			/*sql="SELECT dense_rank() over (order by A.ACT_AMT DESC) AS Rank ," +
				"A.SALES_PERS__FOR ,A.SP_NAME ,A.TARGET_AMT ," +
				"A.ACT_AMT FROM ( SELECT DET.SALES_PERS__FOR ,SP_NAME ,TARGET_AMT ," +
				"(SELECT SUM(SKU_VALUE) FROM STRG_MEET WHERE SALES_PERS=SP.SALES_PERS " +
				"AND STRG_TYPE='C' and to_char(event_date,'YYYYMM')=BUD.PRD_CODE) AS ACT_AMT " +
				"FROM TD_SALES_BUD BUD INNER JOIN TD_SALES_BUD_DET DET ON DET.TRAN_ID=BUD.TRAN_ID " +
				"INNER JOIN SALES_PERS SP ON SP.SALES_PERS=DET.SALES_PERS__FOR " +
				"WHERE SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START " +
				"WITH EMP_CODE = (SELECT EMP_CODE FROM EMPLOYEE " +
				"WHERE EMP_CODE='62851') CONNECT BY PRIOR EMP_CODE = REPORT_TO) " +
				"AND BUD.PRD_CODE='201512' )A ";*/
			
			sql="SELECT dense_rank() over (order by A.ACT_AMT DESC) AS Rank ," +
				"A.SALES_PERS__FOR ,A.SP_NAME ,A.TARGET_AMT ," +
				"A.ACT_AMT FROM ( SELECT DET.SALES_PERS__FOR ,SP_NAME ,TARGET_AMT ," +
				"(SELECT SUM(SKU_VALUE) FROM STRG_MEET WHERE SALES_PERS=SP.SALES_PERS " +
				"AND STRG_TYPE='C' and to_char(event_date,'YYYYMM')=BUD.PRD_CODE) AS ACT_AMT " +
				"FROM TD_SALES_BUD BUD INNER JOIN TD_SALES_BUD_DET DET ON DET.TRAN_ID=BUD.TRAN_ID " +
				"INNER JOIN SALES_PERS SP ON SP.SALES_PERS=DET.SALES_PERS__FOR " +
				"WHERE SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START " +
				"WITH EMP_CODE = (SELECT EMP_CODE FROM EMPLOYEE " +
				"WHERE EMP_CODE='"+empCode+"') CONNECT BY PRIOR EMP_CODE = REPORT_TO) " +
				"AND BUD.PRD_CODE='"+defaultPreCode+"' )A ";
			
			
			/*sql_secondLast =    " Select dense_rank() over (order by tgt_act desc) as Rank," +
					" Sales_Id, Salespers_Name, tgt_amt, ach_amt " +
					" From ( Select Sales_Pers__For as Sales_ID, sp.sp_name as Salespers_Name, " +
					" det.target_amt as tgt_amt, det.ach_amt as ach_amt, " +
					" (det.ach_amt*100)/det.target_amt as tgt_act  from TD_Sales_Bud  hdr, " +
					" td_sales_bud_det det, Sales_pers SP  " +
					" WHere hdr.tran_id = det.tran_id " +
					" And det.Sales_Pers__For = sp.Sales_Pers " +
					" And hdr.Prd_Code = '"+prdCode+"' ) " +
					" Order By Rank,tgt_amt desc "; */ 
			
			
		    pstmt = conn.prepareStatement(sql);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();
				rowData.put("rank",            checkNull(rs.getString("RANK")));
				rowData.put("sales_pers_code", checkNull(rs.getString("SALES_PERS__FOR")));
				rowData.put("sales_pers_name", checkNull(rs.getString("SP_NAME")));
				rowData.put("target_amt_g",      checkNull(rs.getString("TARGET_AMT"))+"@"+checkNull(rs.getString("SP_NAME"))+",{br}");
				rowData.put("Achievement_amt_g", checkNull(rs.getString("ACT_AMT"))+"@"+checkNull(rs.getString("SP_NAME"))+",{br}");
				rowData.put("target_amt_t",      checkNull(rs.getString("TARGET_AMT")));
				rowData.put("Achievement_amt_t", checkNull(rs.getString("ACT_AMT")));
	
				rawEffTimeJson.put(count, rowData);
				count++;
			 }
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println("TargetVsAchievement EJB Rawdata: "+rawEffTimeJson);
		   }
		 }		
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpAnalytics : getSDNoAttemptAnalyticsTopServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getTargetVsAchievement()  ******/
	

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

 }

