package ibase.webitm.ejb.mfg.adv;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;


import ibase.webitm.ejb.*;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;

import ibase.webitm.ejb.ITMDBAccessEJB;

import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless; 

@Stateless
public class WorderReopen extends ActionHandlerEJB implements WorderReopenLocal, WorderReopenRemote {
	GenericUtility genericUtility = GenericUtility.getInstance();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	static
	{
		System.out.println("--WorkOrderReopen called -- ");
	}
	public String actionHandler() throws RemoteException, ITMException {
		System.out.println("actionHandler() Method Called....");
		return "";
	}
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		String returnString=null;

		System.out.println(".......tranId......."+tranId);
		System.out.println(".......xtraParams..."+xtraParams);
		System.out.println(".......forcedFlag..."+forcedFlag);
		if(tranId!=null && tranId.trim().length() > 0 )
		{
			returnString = reopenWorkOrder(tranId,xtraParams,forcedFlag);
		}
		return returnString;
	}	
	
	public String reopenWorkOrder(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException
	{
		
		System.out.println("reopenWorkOrder method  called........");
		String sql = "";
		String errString = "" ;
		String status = "";
		int rowUpdate  =0;
		Connection conn = null;
		ConnDriver connDriver = null;
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		System.out.println("tran id = "+tranId);
		ibase.utility.E12GenericUtility genericUtility= null;
		Timestamp sysdate = null;
		//WorderReopen wordReopen = null;
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			genericUtility =new  ibase.utility.E12GenericUtility();
			java.util.Date dt = new java.util.Date();
			SimpleDateFormat sdf1= new SimpleDateFormat(genericUtility.getDBDateFormat());
			sysdate = java.sql.Timestamp.valueOf(sdf1.format(dt)+" 00:00:00.0");
		if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ) ||  "mysql".equalsIgnoreCase(CommonConstants.DB_NAME ))
		{
			sql =  " SELECT status FROM workorder WHERE work_order = ? for update ";
			
		}
		else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
		{
			sql =  " SELECT status FROM workorder WHERE work_order =  (updlock) WHERE work_order = ? ";
		}
		else
		{
			sql = " SELECT  status FROM workorder WHERE work_order = ? for update nowait ";
		}
		
		pstmt  = conn.prepareStatement(sql);
		pstmt.setString(1,tranId);
		rs = pstmt.executeQuery();
		if(rs.next())
		{
			status = rs.getString("status");System.out.println("--status--"+status);
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
/*		if("C".equalsIgnoreCase(status.trim()))
		{
			System.out.println("--transaction already closed--");
			errString = itmDBAccessEJB.getErrorString("","VTCLSHLD","","",conn);
		}*/
		 /*if("R".equalsIgnoreCase(status.trim()))
		{
			System.out.println("--Status is not closed--");
			errString = itmDBAccessEJB.getErrorString("","VTWOSTNC","","",conn);
		}
//		else if(!"Y".equalsIgnoreCase(conf.trim()))
//		{
//			System.out.println("-- unconfirmed order --");
//			errString = itmDBAccessEJB.getErrorString("","VTCOCONF3","","",conn);
//		}
		else if("F".equalsIgnoreCase(status.trim()))
		{
			System.out.println("-- Status is not closed  --");
			errString = itmDBAccessEJB.getErrorString("","VTWOSTNC","","",conn);
		}*/
		if("C".equalsIgnoreCase(status.trim()))
		{
			System.out.println("--order complete--");
			sql = " update workorder set status = 'R',status_date = ?, COMMENTS ='OPENED THE WORKORDER ON USERS REQUEST' where work_order =  ? ";
			pstmt  = conn.prepareStatement(sql);
			pstmt.setTimestamp(1,sysdate);
			pstmt.setString(2,tranId);
			rowUpdate = pstmt.executeUpdate(); 
			if(rowUpdate > 0 )
			{
				
				try
				{
					
					errString = itmDBAccessEJB.getErrorString("","VTWOSTRO","","",conn);
				}
				catch(Exception ex)
				{
					System.out.println("@@@@@ Did not Update");
					ex.printStackTrace();
				}
			}
		}
		else 
		{
			System.out.println("--Status is not closed--");
			errString = itmDBAccessEJB.getErrorString("","VTWOSTNC","","",conn);
		}
		}
	catch( Exception e)
	{			
			try 
			{
				conn.rollback(); 
				System.out.println("Exception.. "+e.getMessage());
				e.printStackTrace();	
				errString=e.getMessage();
				throw new ITMException(e);

			} 
			catch (SQLException ex) 
			{
				ex.printStackTrace();
				errString=ex.getMessage();
				throw new ITMException(ex);
			}
		
	}
	finally
	{		
			try
			{
				if(rowUpdate > 0)
				{
					conn.commit();
					System.out.println("--transaction commited--"+rowUpdate);
						
				}else
				{
					conn.rollback();
					System.out.println("--transaction rollback--");
				}
				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
	return errString;
} //end of  method

}
		
		



