/*
 * Author: Wasim Ansari
 * Date: 02-MAY-2016
 * Request: F17BBAS001 (GST Wizard)
 */

package ibase.webitm.servlet.gst;

import ibase.utility.CommonConstants;
import ibase.webitm.util.gst.GSTCommonUtil;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GSTWizUtilServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;

    public GSTWizUtilServlet() {
        super();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTWizUtilServlet START]XXXXXXXXXXXXXXXXXXXX");
		request.setCharacterEncoding(CommonConstants.ENCODING);
		String action = "", htmlData = "";
		
		GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
		
		try 
		{	
			action = request.getParameter("action");
			System.out.println("GSTWizUtilServlet ACTION ["+action+"]");
			
			if("previous".equalsIgnoreCase(action))
			{
				ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
				
				if(userInfo != null)
				{
					String objName 	= request.getParameter("OBJ_NAME");
					String formNo 	= request.getParameter("FORM_NO");
					String preFormVal = request.getParameter("PRE_FORM_VAL");
					String jspName = request.getParameter("JSP_NAME")!=null ? request.getParameter("JSP_NAME").trim() : "";
					
					System.out.println("OBJ_NAME["+objName+"]");
					System.out.println("FORM_NO["+formNo+"]");
					System.out.println("PRE_FORM_VAL["+preFormVal+"]");
					System.out.println("JSP_NAME["+jspName+"]");
					
					String editorId = (String) request.getSession().getAttribute( "WIZARD_BEAN_ID_" + objName );
		            System.out.println( " GSTWizUtilServlet :: editorId["+editorId+"]" );
		            
		            if ( request.getSession().getAttribute(  "WIZARD_BEAN_" + editorId ) != null )
					{
						System.out.println("GSTWizUtilServlet Wizard object found....");
						request.getSession().removeAttribute( "WIZARD_BEAN_" + objName );					
						//request.getSession().removeAttribute( "WIZARD_BEAN_ID_" + objName );
						
						request.getRequestDispatcher("/webitm/jsp/"+jspName+".jsp").forward(request, response);
					}
				}
				else
				{
					System.out.println("GSTWizUtilServlet_notLoggedIn");
				}
			}
			else if("SAVE_DETAIL_DATA".equalsIgnoreCase(action))
			{
				String prevHTMLData = request.getParameter("HTML_DATA");
				request.getSession().setAttribute( "GSTRECO_WIZ_DETAIL",prevHTMLData);
			}
			else if("DISPLAY_DETAIL_DATA".equalsIgnoreCase(action))
			{
				String htmlDataErr = (String) request.getSession().getAttribute( "GSTRECO_WIZ_DETAIL");
				request.getSession().removeAttribute( "GSTRECO_WIZ_DETAIL");
				
				response.setContentType("text/html");
		         
		        if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(htmlDataErr.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", CommonConstants.CONTENT_ENCODING);
					OutputStream outStream = response.getOutputStream();
					outStream.write(htmlDataErr.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("GET_ITM2MENU_DTLS".equalsIgnoreCase(action))
			{
				String retXML = "";
				retXML = gstCommonUtil.getItm2MenuDtls(request.getParameter("objName"));
				
				response.setContentType("text/html");
		         
		        if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retXML.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", CommonConstants.CONTENT_ENCODING);
					OutputStream outStream = response.getOutputStream();
					outStream.write(retXML.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
		} 
		catch (Exception e) 
		{
			System.out.println("GSTWizUtilServlet.doPost():doPost"+e.getMessage());
			e.printStackTrace();
		}
		
         System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTWizUtilServlet END]XXXXXXXXXXXXXXXXXXXX");
	}
}
