package ibase.client;



import ibase.e12ria.e12table.client.AbstractDataGrid;
import ibase.e12ria.e12table.client.ColumnInfoBean;
import ibase.e12ria.e12table.client.DataGridTableRowModel;
import ibase.e12ria.e12table.client.E12CustomColumn;
import ibase.e12ria.e12table.client.E12CustomTextCell;
import ibase.e12ria.e12table.client.ResizableHeader;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortEvent.ListHandler;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.dom.client.Node;
/**
 * This class is used to show the data in paged format.
 * 
 * @author base
 */

public class CustomGrid extends AbstractDataGrid<DataGridTableRowModel>
{
	private String rangeText = "50";
	ListDataProvider<DataGridTableRowModel> dataProvider  = new ListDataProvider<DataGridTableRowModel>();	
	ArrayList<DataGridTableRowModel> dataGridTableRowList = new ArrayList<DataGridTableRowModel>();
	ArrayList<FilterInfo> filterList=null;
	PopupPanel contextMenuPanel = new PopupPanel(true);
	private ScrollPanel scrollPanel = new ScrollPanel(); 
	private ArrayList<String> parameterList = new ArrayList<String>();
	private DataGridTableRowModel selDataGridTRModel = null;
	HashMap<String,   ArrayList<String>>  gridPropertyeMap=new HashMap<String,   ArrayList<String>>();
	String firstIndex="";
	String currentID = "";
	public CustomGrid(int pageSize) {
		super(pageSize);
	}

	@Override
	public void refresh() {
	}
  
	@Override
	public void performDoubleClick() {
	}

	@Override
	public void createContextMenu() {
	}
	/*Start code for progess bar to data building- Dhanendra 17Nov2014*/
	protected E12LoadingInterface e12LoadImg=new E12LoadingInterface();
	/*End code for progess bar to data building- Dhanendra 17Nov2014*/
	
	/*Add currentID Parameter to method by Dhanendra on date 16-09-2016*/
	@SuppressWarnings("unchecked")
	public FlexTable jsonToArrayList(HashMap<String, HashMap> gridNGraphMeataDataMap,JSONObject jsonObjGridData ,
			String dataSrc,String componentId,ArrayList<String> parameterList,ArrayList<FilterInfo> filterList, String firstIndex,String currentID)
	{
		e12LoadImg.setLoadingInfo("Building view...");
		e12LoadImg.setLoading(true);
		this.currentID = currentID;
		DataGridTableRowModel rowDataGrid= null;
		E12CustomTextCell.CellData celldata = null;
		ArrayList<ColumnInfoBean> dataGridTableColList = new ArrayList<ColumnInfoBean>();
		FlexTable flexTable= new FlexTable();
		//for arraylist of DataGridTableRowModel object (rows of data)
		HashMap<Integer, E12CustomTextCell.CellData> rowData =  null;
		gridNGraphMeataDataMap.toString().replace('=', ':');
		HashMap<String, ArrayList<String>> graphDataMap = null;
		HashMap<String,   ArrayList<String>>  graphSizeMap=null;
		HashMap<String,   ArrayList<String>>  graphCaptioneMap=null;
		HashMap<String,   ArrayList<String>>  graphAlignMap = null;
		//Added By Prashant Chavan on 09-Mar-15 [For Link in Grid Control] Start
		HashMap<String,   String>  graphMetaLinkMap = null;
		//Added By Prashant Chavan on 09-Mar-15 [For Link in Grid Control] End
		ArrayList<String> graphDtlList = new ArrayList<String>();
		ArrayList<String> graphAlignList=new ArrayList<String>();	
		ArrayList<String> graphCaptionList=new ArrayList<String>();	
		//Added By Prashant Chavan on 09-Mar-15 [For Link in Grid Control] Start
		//ArrayList<String>  graphMetaLinkList = new ArrayList<String>();
		//Added By Prashant Chavan on 09-Mar-15 [For Link in Grid Control] End
		HashMap<String,   String>  graphLinkFormatMap = null;
		this.firstIndex =firstIndex; 
		try
		{
			this.filterList=filterList;
			this.parameterList=parameterList;
			JSONObject jsonEachRow = null;
			int count=0;
			String  graphLinkFormat ="";
			JSONObject jsonObjData =(JSONObject) jsonObjGridData.get(dataSrc);
			graphDataMap=gridNGraphMeataDataMap.get(componentId);	
			//Added By Prashant Chavan on 11-Mar-15 [For Getting the Link name]
			graphMetaLinkMap=gridNGraphMeataDataMap.get("metadataNameLink"+componentId);
			graphLinkFormatMap =gridNGraphMeataDataMap.get("linkFormatType"+componentId);
			for(int jRowCtr=0;jRowCtr<jsonObjData.size();jRowCtr++)
			{
				rowData = new HashMap<Integer, E12CustomTextCell.CellData> ();	
				for (String graphKey : graphDataMap.keySet())
				{
					String  graphMetaLink ="";
					graphDtlList = graphDataMap.get(graphKey);
					if(graphMetaLinkMap.get(graphKey) != null )
					{
					  graphMetaLink = graphMetaLinkMap.get(graphKey);
					}
					if(graphLinkFormatMap.get(graphKey) != null )
					{
						graphLinkFormat = graphLinkFormatMap.get(graphKey);
					}
					jsonEachRow = new JSONObject();
				    jsonEachRow = (JSONObject)jsonObjData.get(""+jRowCtr);
				    count=rowData.size();
				    
				    for(int jDataCtr=0;jDataCtr<graphDtlList.size();jDataCtr++)
					{
							if(jsonEachRow.get(graphDtlList.get(jDataCtr))!=null)
							 {
								//Changed By Prashant Chavan on 11-Mar-15 [For Link Chart]  Start
							    if(graphMetaLink !=null && graphMetaLink !="")
							    {
							    	if(graphLinkFormat !=null && graphLinkFormat !="")
							    	{
							    		celldata =  new E12CustomTextCell.CellData(0,(""+jsonEachRow.get(""+graphDtlList.get(jDataCtr))).replace('"', ' '),graphMetaLink+"@"+graphLinkFormat);
							    	}else 
							    	{
							    	    celldata =  new E12CustomTextCell.CellData(0,(""+jsonEachRow.get(""+graphDtlList.get(jDataCtr))).replace('"', ' '),graphMetaLink);
							    	}
							    }
							    else
							    {
							    	celldata =  new E12CustomTextCell.CellData((""+jsonEachRow.get(""+graphDtlList.get(jDataCtr))).replace('"', ' '));
							    }
							    //Changed By Prashant Chavan on 11-Mar-15 [For Link Chart] End
							     celldata.setMandatory(true);
								 celldata.setOriginalText("Cell"+jDataCtr);
								 celldata.setName(""+(graphDtlList.get(jDataCtr)).replace('"', ' '));						
								 rowData.put(count, celldata);
								 count++;
							 }
					}	
				}
				celldata.setMandatory(true);
				celldata.setOriginalText("Cell"+graphDtlList.size());
				//celldata.setName("");						
				rowData.put(count, celldata);
				count++;
				rowDataGrid = new DataGridTableRowModel(rowData);	
				dataGridTableRowList.add(rowDataGrid);
			}
			ColumnInfoBean columnInfoBean=null;
			graphDataMap  	 =	gridNGraphMeataDataMap.get("columnName"+componentId);
			graphSizeMap  	 =	gridNGraphMeataDataMap.get("columnSize"+componentId);
			graphAlignMap 	 =	gridNGraphMeataDataMap.get("columnAlign"+componentId);
			graphCaptioneMap =  gridNGraphMeataDataMap.get("componentCaption"+componentId);
			for (String graphKey : graphDataMap.keySet())
			{
				graphDtlList.clear();
				graphDtlList = new ArrayList<String>();
				graphDtlList = graphDataMap.get(graphKey);
				for(int jDataCtr=0;jDataCtr<graphDtlList.size();jDataCtr++)
				{
					columnInfoBean = new ColumnInfoBean(""+(graphDtlList.get(jDataCtr)),"physicalName", "logicalName", ""+graphSizeMap.get(graphKey));
					dataGridTableColList.add(columnInfoBean);
					graphAlignList.add(""+graphAlignMap.get(graphKey));
				}
			}
			graphCaptionList.add(""+graphCaptioneMap.get("componentCaption"+componentId));
			//Window.alert("graphLinkFormat: "+graphLinkFormat);
			if(graphLinkFormat.contains("@"))
			{
				String arr[] = graphLinkFormat.split("@");
				if(arr[0].equalsIgnoreCase("F"))
				{
					flexTable=createTableComponent(dataGridTableRowList,dataGridTableColList,flexTable,graphAlignList,graphCaptionList,graphLinkFormat);
				}
				else
				{
				   flexTable.setStyleName("flexCSS");
				   flexTable=createTableComponent(dataGridTableRowList,dataGridTableColList,flexTable,graphAlignList,graphCaptionList);
				}
			}
			else
			{
			   flexTable.setStyleName("flexCSS");
			   flexTable=createTableComponent(dataGridTableRowList,dataGridTableColList,flexTable,graphAlignList,graphCaptionList);
			}
			
			e12LoadImg.setLoading(false);
		} catch (Exception e)
		{
			Window.alert(" Exception : DataGrid : jsonToArrayList(): [" + e.getMessage() + "]");
		}
		return flexTable;
	}
	
	
	/**
	 * It creates The AdvDataGrid Table .
	 * 
	 * @param dataGridTableRowList
	 * @return 
	 */
	final SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-mm-yy");
	public FlexTable createTableComponent( ArrayList< DataGridTableRowModel> dataGridTableRowList, ArrayList<ColumnInfoBean> dataGridTableColList, FlexTable flexTable,ArrayList<String> graphAlignList,ArrayList<String> graphCaptionList) 
	{
		CommonUtils.printOnConsole("******createTableComponent 1************");
		final int noOfRows = dataGridTableRowList.size();
		final int noOfColumns = dataGridTableColList.size();
		dataProvider.setList( dataGridTableRowList );
		//Add by Dnyaneshwar chavan on 07-DEC-2012 [WS2GSUN002 ||  ] Start
		E12CustomColumn firstColumn = null;
		//Add by Dnyaneshwar chavan on 07-DEC-2012 [WS2GSUN002 ||  ] End
		String caption ="";
		ResizableHeader<DataGridTableRowModel> header=null;
		//Added by Varsha V. for changing alignment for table header
		SafeHtml htmlColumnHeader = null;
		//Ended by Varsha V. for changing alignment for table header
		try
		{
			E12CustomTextCell.isValidate = false;
			E12CustomTextCell.currentCellElement = null;
			E12CustomTextCell.currentContext = null;
			E12CustomTextCell.incrFactor = 0;
			E12CustomTextCell.editableField = null;
			E12CustomTextCell.prvEditableField = null;
			//  handler for table sorting 
			final ListHandler<DataGridTableRowModel> sortHandler = new ListHandler<DataGridTableRowModel>( dataProvider.getList())
					{
						@Override
						public void onColumnSort(ColumnSortEvent event) {
							super.onColumnSort(event);
							dataProvider.refresh();
						}
					};
			this.addColumnSortHandler(sortHandler);
			int width = 0;
			for( int i= 0  ; i < noOfColumns ; i++ )
			{
				final int index = i;
			    ColumnInfoBean colInfo = dataGridTableColList.get( i );
			    final String colName = colInfo.getDisplayNameOfCol();
			    width = colInfo.getWidth();
				E12CustomColumn column = new E12CustomColumn(i, false);
				column.setSortable( true );
				if(graphAlignList.get(i).trim().equalsIgnoreCase("left"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
					//Added by Varsha V. for changing alignment for table header
					htmlColumnHeader =  new SafeHtml() {
						
						@Override
						public String asString() {
							// TODO Auto-generated method stub
							return "<p style=\"text-align:left;\">"+colName+"</p>";
						}
					};
					//Ended by Varsha V. for changing alignment for table header
				}
				else if(graphAlignList.get(i).trim().equalsIgnoreCase("right"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
					//Added by Varsha V. for changing alignment for table header
					htmlColumnHeader =  new SafeHtml() {
						
						@Override
						public String asString() {
							// TODO Auto-generated method stub
							return "<p style=\"text-align:right; padding-right: 10px;\">"+colName+"</p>";
						}
					};
					//Ended by Varsha V. for changing alignment for table header
				}
				else if(graphAlignList.get(i).trim().equalsIgnoreCase("center"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
					//Added by Varsha V. for changing alignment for table header
					htmlColumnHeader =  new SafeHtml() {
						
						@Override
						public String asString() {
							// TODO Auto-generated method stub
							return "<p style=\"text-align:center;\">"+colName+"</p>";
						}
					};
					//Ended by Varsha V. for changing alignment for table header
				}
				/*if ( i == 0 ) // commented for onload sorting
				{
					firstColumn = column;
				}*/
				

				sortHandler.setComparator( column , new Comparator<DataGridTableRowModel>() 
				{
				 	public int compare( DataGridTableRowModel o1, DataGridTableRowModel  o2 ) 
				 	{
				 		/*pass value to isValidDate1 with trim() By Dhanendra On Date 17-12-2015*/
				 		if(isValidDate1(o1.getCellText( index ).trim()) && isValidDate1(o2.getCellText( index ).trim()))
				 		{
				 			SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
				 			Date date1=null,date2=null;
							try 
							{
								 date1 = formatter.parse(o1.getCellText( index ).trim());
								 date2 = formatter.parse(o2.getCellText( index ).trim());
							} catch (Exception e) 
							{
								e.printStackTrace();
							}
							
							return date1.compareTo(date2);
				 		}
				 		else if(isValidDouble(o1.getCellText( index )) && isValidDouble(o2.getCellText( index )))
				 		{
				 			return Double.compare(Double.parseDouble(o1.getCellText( index )), Double.parseDouble(o2.getCellText( index )));
				 		}
				 		else
				 		{
				 			return o1.getCellText(index).compareTo(o2.getCellText( index ));
				 		}
				 	}
				});
				this.setColumnWidth( column, width +"px" );
				//Added by Varsha V. for removing left right border of column
				column.setCellStyleNames("removeBorderForGrid");
				//Ended by Varsha V. for removing left right border of column
				header = new ResizableHeader<DataGridTableRowModel>(colName, this, column ) {
					@Override
					public String getValue() {
						return colName;
					}
				};
				Header<String> footer1 = new Header<String>(new TextCell()) {
					@Override
					public String getValue() {
						return "";
					}
				};
				//Added and commented by Varsha V. for changing alignment for table header
				  //this.addColumn(column, header, null);
				  this.addColumn(column, htmlColumnHeader, null);
				//Added and commented by Varsha V. for changing alignment for table header
			}
			caption = graphCaptionList.get(0);			
			dataProvider.addDataDisplay( this );
			dataProvider.refresh();
			this.getColumnSortList().clear();
			this.getColumnSortList().push( firstColumn );
			this.getColumnSortList().push( firstColumn );
			ColumnSortEvent.fire(this, this.getColumnSortList());
		}
		catch (Exception e )
		{
			Window.alert("Exception in table "+ e.getMessage()) ;
		}
		GridThemes.applyDatagridThemes();
		//E12SimplePager.Resources pagerResources = GWT.create(E12SimplePager.Resources.class);
		//final E12SimplePager pager =new E12SimplePager(E12SimplePager.TextLocation.CENTER, pagerResources, false, 0 , true);
		
		
		HorizontalPanel excelBtnPnl = new HorizontalPanel();
		Button excelBtn = new Button();
		excelBtn.setTitle("Excel");
		excelBtn.setStyleName("excelExportImg");
		Image excelImg = new Image("FusionChart/images/excel.png");
		excelImg.setHeight("20px");
		excelBtn.getElement().appendChild(excelImg.getElement());
		excelBtnPnl.add(ibase.client.tabletoexcel.TableToExcelClientBuilder.fromTable(flexTable).withWidget(excelBtn).buildExportFormWidget());
		SimplePager.Resources displayPagerResources = GWT.create(SimplePager.Resources.class);
		final SimplePager displayPager = new SimplePager(SimplePager.TextLocation.CENTER, displayPagerResources, false, 0 , true, excelBtnPnl);
		displayPager.setDisplay(this);
		displayPager.setRangeText(rangeText);
		Command setRowCmd = new Command() {
			@Override
			public void execute() 
			{
				try
				{
					int rowNo= (int)Double.parseDouble( displayPager.getRangeText().trim() );
					if( rowNo > 0 && rowNo <= noOfRows)
					{
					    CustomGrid.this.setPageSize( rowNo );
					    displayPager.firstPage();
						dataProvider.refresh();
						rangeText = displayPager.getRangeText();
						displayPager.setRangeText(displayPager.getRangeText());
					}
					else
					{
						displayPager.setRangeText("Error");
					}
				}
				catch (Exception e)
				{
					displayPager.setRangeText("Error");
				}
			}
		};
		displayPager.setRangeCommand( setRowCmd );	
		String cellVal = Window.Location.getParameter("CELL_VAL") == null ? "" : Window.Location.getParameter("CELL_VAL");
		String brandName = Window.Location.getParameter("brand") == null ? "" : Window.Location.getParameter("brand");
		/* add code for Compliance Dashboard JNJ by Dhanendra 16/06/15*/
		String salesPers = Window.Location.getParameter("SALES_PERS") == null ? "" : Window.Location.getParameter("SALES_PERS");
		/*End code for Compliance Dashboard JNJ by Dhanendra 16/06/15*/
		/* add code for epa Dashboard  by Dhanendra 29/09/15*/
		String empCode = Window.Location.getParameter("EMP_CODE") == null ? "" : Window.Location.getParameter("EMP_CODE");
		/*End code for epa Dashboard  by Dhanendra 29/09/15*/
		if(caption.trim().length()==0 && cellVal.trim().length()>0)
		{
			if(brandName.trim().length()>0)
			{
				caption = brandName.trim()+" - "+cellVal.trim()+" (Stock Quantity)";
			}
			/* add code for Compliance Dashboard JNJ by Dhanendra 16/06/15*/
			else if(salesPers.trim().length()>0)
			{
				caption = salesPers.trim()+" - "+cellVal.trim();
			}
			/* add code for Compliance Dashboard JNJ by Dhanendra 16/06/15*/
			else if(empCode.trim().length()>0)
			{
				caption = "Employee Code : "+empCode.trim();
			}
			else 
			{
				caption = cellVal.trim();
			}
		}
		if(caption.trim().length()!=0)
		{
			flexTable.setText(0, 0, caption);
			flexTable.setWidget(1, 0, this);
			flexTable.setWidget(2, 0, displayPager);
			flexTable.getCellFormatter().setStyleName(0 ,0 , "FlexTable-ColumnHeaderCell");
			flexTable.getCellFormatter().setStyleName(1 ,0 , "gwt-ScrollTable");
			
			if( GridThemes.getBrowserVersion() == -1 )
			{
				flexTable.getCellFormatter().setStyleName(2 ,0 , "e12Pager");
			}
			else
			{
				flexTable.getCellFormatter().setStyleName(2 ,0 , "e12Pager-forIE");
			}
		}else
		{
			flexTable.setWidget(0, 0, this);
			flexTable.setWidget(1, 0, displayPager);
			flexTable.getCellFormatter().setStyleName(0 ,0 , "gwt-ScrollTable");
			
			if( GridThemes.getBrowserVersion() == -1 )
			{
				flexTable.getCellFormatter().setStyleName(1 ,0 , "e12Pager");
			}
			else
			{
				flexTable.getCellFormatter().setStyleName(1 ,0 , "e12Pager-forIE");
			}
		}
		//flexTable.setHeight( Window.getClientHeight() - 240 + "px" );
		flexTable.setHeight("270px"); //changed by Varsha V. for grid height
		setHeight("270px"); //changed by Varsha V. for grid height
		/*setHeight( Window.getClientHeight() - 207+ "px" );*/
		/*setHeight( ( ( Window.getClientHeight() - 250 ))+ "px" );*/
		addStyleName("e12AdvDataGrid-SideBars");
		Element theaderGrid = getTableHeadElement();
		//Added by Varsha V. for setting id for table header
		theaderGrid.setAttribute("id", "removeBorderGrid");
		//Added by Varsha V. for setting id for table header
		return flexTable;
	}
	
	@Override
	public FlexTable createTableComponent(
			ArrayList<DataGridTableRowModel> dataGridTableRowList,
			TreeMap<Integer, Object> dataGridTableColList) {
		return null;
	}

	@Override
	public FlexTable createTableComponent(ArrayList<DataGridTableRowModel> dataGridTableRowList,
			ArrayList<ColumnInfoBean> dataGridTableColList, FlexTable flexTable) 
	{
		return null;
	}
  
	
	public void showOptionMenu() 
	{}		
	
	/***For on click action of grid row --- added by swati 24-Feb-2015***/
	int xPosition = 0;
	int yPosition = 0;
	
	public void onBrowserEvent2(Event event) {
		super.onBrowserEvent2(event);
		//event.preventDefault();
		EventTarget eventTarget = event.getEventTarget();
		if (!Element.is(eventTarget)) {
			return;
		}

		final Element target = event.getEventTarget().cast();
		TableCellElement tableCell = findNearestParentCell(target);
		if (tableCell == null) {
			return;
		}

		Element trElem = tableCell.getParentElement();
		if (trElem == null) {
			return;
		}
		TableRowElement tr = TableRowElement.as(trElem);
        
		Element sectionElem = tr.getParentElement();
		if (sectionElem == null) {
			return;
		}
		TableSectionElement section = TableSectionElement.as(sectionElem);
		switch (DOM.eventGetType(event)) {
		       
		case Event.ONCLICK:
			if (section == getTableBodyElement()) {
				selectedRow = tr.getSectionRowIndex();
				xPosition = event.getClientX();
				yPosition = event.getClientY();
				performSingleClick(tr,tableCell);
			}
		default:
			break;
		}
	}
	
	StringBuffer pkFieldNames=null;
	StringBuffer pkFieldValue=null;
	@SuppressWarnings("unused")
	public void performSingleClick(TableRowElement tr,TableCellElement tableCell) 
	{
		if(tableCell.getElementsByTagName("a").getItem(0) !=null   )
		{
			String urlStr="";
			String propertyStr="";
			String comStr="";
			String metadataName="";
			String dispFilterStatus="";
			String linkFormat="";
			int count=0;
			String cellValue="";
			cellValue = tableCell.getInnerText();
			//Added by Aniket on 24-02-2017 Start
			if(cellValue.contains("&")){
				cellValue = cellValue.replaceAll("&", "and");
			}
			//Added by Aniket on 24-02-2017 End
			String period =parameterList.get(1);
			for (FilterInfo filterInfo : filterList)
			{
				if(count==0)
				{
					propertyStr = "&"+filterInfo.getFieldName()+"="+parameterList.get(count+1);
				}
				else
				{
					propertyStr = propertyStr+"&"+filterInfo.getFieldName()+"="+parameterList.get(count+1);
				}
				count++;
			}
			
			urlStr = tr.getInnerText();
			metadataName = ""+tableCell.getElementsByTagName("a").getItem(0).getAttribute("linkName");
			String parameterListString = "";
			for (int i = 0 ; i<tr.getChildCount();i++)
			{
				Node tdCell = tr.getChild(i).getFirstChild().getFirstChild();
				 if(tdCell!=null)
				 {
					Element spanElemt = tdCell.cast();
					String colName= spanElemt.getElementsByTagName("div").getItem(0).getAttribute("colname");
					String colval= spanElemt.getElementsByTagName("div").getItem(0).getAttribute("title");
					/*added by Aniket on 24-02-2017 for issue of getting incomplete value in drilldown Start*/
					if(colval.contains("&")){
						colval = colval.replaceAll("&", "and");
					}
					/*added by Aniket on 24-02-2017 for issue of getting incomplete value in drilldown End*/
					parameterListString = parameterListString + "&" + colName.trim() + "=" + colval.trim();
				 }
			}
			String splitArr[] = metadataName.split("@");
			metadataName = splitArr[0];
			linkFormat   = splitArr[1];
			dispFilterStatus = splitArr[2];
			/*add height from metadataxml by Dhanendra on date 19-08-2016*/
			String height = "";
			if(metadataName.indexOf("-")!=-1)
			{
				String splitArrTemp[] = metadataName.split("-");
				metadataName = splitArrTemp[0];
				height   = splitArrTemp[1];
			}else
			{
				height = "430";
			}
			/*add height from metadataxml by Dhanendra on date 19-08-2016*/
			
			//F means open url in the frame
			if(linkFormat.trim().length()>0 && linkFormat.trim().equalsIgnoreCase("F"))
			{
				/*add height parameter to buildGridFrame by Dhanendra*/
				/*Comment buildGridFrame method and add code for drill-down dashboard by Dhanendra on date 16-09-2016*/
				//buildGridFrame(metadataName,cellValue, propertyStr,urlStr,parameterListString,dispFilterStatus,height);
				final String url =  propertyStr+"&"+parameterListString+"&CELL_VAL="+cellValue.trim()+"&P1="+urlStr;
				SamePageOpenContainer samePageOpenContainer = new SamePageOpenContainer();
				samePageOpenContainer.getFrameJSONData(metadataName, url, currentID);
				/*Comment buildGridFrame method and add code for drill-down dashboard by Dhanendra on date 16-09-2016*/
				
			}
			//P means open url in the new window
			if(linkFormat.trim().length()>0 && linkFormat.trim().equalsIgnoreCase("P"))
			{
				Window.open("/ibase/dwh/GwtDashboardPage.html?metadataname="+metadataName+"&CELL_VAL="+cellValue.trim()+propertyStr+"&"+parameterListString+"&FLAG="+dispFilterStatus+"&P1="+urlStr+"&SALES_PERS="+firstIndex+"&FLAG=N", "_blank", "menubar=no,toolbar=no,location=no,resizable=yes,scrollbars=yes,status=no,height=450,width=700,top=100,left=300");
			}
			//N means open url in the new tab
			if(linkFormat.trim().length()>0 && linkFormat.trim().equalsIgnoreCase("N"))
			{
				Window.open("/ibase/dwh/GwtDashboardPage.html?metadataname="+metadataName+"&CELL_VAL="+cellValue.trim()+propertyStr+"&"+parameterListString+"&FLAG="+dispFilterStatus+"&P1="+urlStr,"", "");
			}
			/*Added by Chetan mahajan For show report on jsp page on click link on 1-July-2016 Start*/
			if(linkFormat.trim().length()>0 && linkFormat.trim().equalsIgnoreCase("JSP"))
			{
				Window.open(metadataName+"?CELL_VAL="+cellValue.trim()+propertyStr+"&"+parameterListString+"&P1="+urlStr, "_blank", "menubar=no,toolbar=no,location=no,resizable=yes,scrollbars=yes,status=no,height=700,width=1000,top=200,left=200");
			}
			/*Added by Chetan mahajan For show report on jsp page on click link on 1-July-2016 End*/
			//buildGridFrame(metadataName,cellValue, propertyStr,urlStr,parameterListString,dispFilterStatus);
		}
	}
	private native void buildGridFrame(String metadataName,String cellValue,String propertyStr,String urlStr,String parameterListString,String dispFilterStatus,String height)
	/*-{
		try {
				
				$wnd.createFrameContainer();
				// set height 430 and width 100% by dhanendra on date 21-10-2015
				//pass dyanmic height to frameContainer by dhanendra on date 19-08-2016
				document.getElementById('frameContainer').innerHTML = "<iframe scrolling='no' id='frame1' width='100%' height="+height+" frameborder='0' src='/ibase/dwh/GwtDashboardPage.html?metadataname="+metadataName+propertyStr+"&"+parameterListString+"&CELL_VAL="+cellValue.trim()+"&P1="+urlStr+"&FLAG=N'></iframe>";
				//document.getElementById('frameContainer').innerHTML = "<iframe scrolling='no' id='frame1' width='99%' height='230' frameborder='0' src='/ibase/dwh/GwtDashboardPage.html?metadataname="+metadataName+propertyStr+"&"+parameterListString+"&CELL_VAL="+cellValue.trim()+"&P1="+urlStr+"&FLAG="+dispFilterStatus+"'></iframe>";
				
			} catch (e) {
				alert("Excpeiton :: GraphComponent : createChart [" + e.message+ "]");
			}
		}-*/;
	private TableCellElement findNearestParentCell(Element elem) 
	{
		while ((elem != null) && (elem != getElement())) 
		{
			// This would allow us to use TableCellElement.is() -- much cleaner.
			String tagName = elem.getTagName();
			if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) 
			{
				return elem.cast();
			}
			elem = elem.getParentElement();
		}
		return null;
	}
	/***For on click action of grid row --- ended by swati 24-Feb-2015***/

	@Override
	public void showContextMenu(int selectedRow, int xPosition, int yPosition) {
		
	}

	@Override
	public void performOnTouch() {
		
	}

	@Override
	public void showOptionMenu(int selectedRow) {
		
	}
	
	public FlexTable createTableComponent( ArrayList<DataGridTableRowModel> dataGridTableRowList, ArrayList<ColumnInfoBean> dataGridTableColList, FlexTable flexTable,ArrayList<String> graphAlignList,ArrayList<String> graphCaptionList,String graphLinkFormat) 
	{
		CommonUtils.printOnConsole("******createTableComponent 2************");
		final int noOfRows = dataGridTableRowList.size();
		final int noOfColumns = dataGridTableColList.size();
		//Window.alert("dataGridTableColList:  "+dataGridTableColList.get(0));
		dataProvider.setList( dataGridTableRowList );
		//Add by Dnyaneshwar chavan on 07-DEC-2012 [WS2GSUN002 ||  ] Start
		E12CustomColumn firstColumn = null;
		//Add by Dnyaneshwar chavan on 07-DEC-2012 [WS2GSUN002 ||  ] End
		String caption ="";
		ResizableHeader<DataGridTableRowModel> header=null;
		try
		{
			E12CustomTextCell.isValidate = false;
			E12CustomTextCell.currentCellElement = null;
			E12CustomTextCell.currentContext = null;
			E12CustomTextCell.incrFactor = 0;
			E12CustomTextCell.editableField = null;
			E12CustomTextCell.prvEditableField = null;
			
			//  handler for table sorting 
			final ListHandler<DataGridTableRowModel> sortHandler = new ListHandler<DataGridTableRowModel>( dataProvider.getList())
					{
						@Override
						public void onColumnSort(ColumnSortEvent event) {
							super.onColumnSort(event);
							dataProvider.refresh();
						}
					};
			this.addColumnSortHandler(sortHandler);
			int width = 0;
			for( int i= 0  ; i < noOfColumns ; i++ )
			{
				final int index = i;
			    ColumnInfoBean colInfo = dataGridTableColList.get( i );
			    final String colName = colInfo.getDisplayNameOfCol();
			    width = colInfo.getWidth();
				E12CustomColumn column = new E12CustomColumn(i, false);
				column.setSortable( true );
				if(graphAlignList.get(i).trim().equalsIgnoreCase("left"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
				}
				else if(graphAlignList.get(i).trim().equalsIgnoreCase("right"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
				}
				else if(graphAlignList.get(i).trim().equalsIgnoreCase("center"))
				{
					column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
				}
				/*if ( i == 0 ) // aommented for onload sorting
				{
					firstColumn = column;
				}*/
				sortHandler.setComparator( column , new Comparator<DataGridTableRowModel>() {
				 	
				public int compare( DataGridTableRowModel o1, DataGridTableRowModel  o2 ) 
				 	{
					/*pass value to isValidDate1 with trim() By Dhanendra On Date 17-12-2015*/	
					if(isValidDate1(o1.getCellText( index ).trim()) && isValidDate1(o2.getCellText( index ).trim()))
				 		{
				 			SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
				 			Date date1=null,date2=null;
							try {
								 date1 = formatter.parse(o1.getCellText( index ).trim());
								 date2 = formatter.parse(o2.getCellText( index ).trim());
							} catch (Exception e) {
								e.printStackTrace();
							}
							return date1.compareTo(date2);
				 		}
				 		if(isValidDouble(o1.getCellText( index )) && isValidDouble(o2.getCellText( index )))
				 		{
				 			 double d1 = Double.parseDouble(o1.getCellText( index ));
				 		     double d2 = Double.parseDouble(o2.getCellText( index ));
				 			 return Double.compare(d1, d2);
				 		}
				 		else
				 		{
				 			//Window.alert("in string comparision");
						  return o1.getCellText(index).compareTo(o2.getCellText( index ));
				 		}
				 	}
				});
				this.setColumnWidth( column, width +"px" );
				header = new ResizableHeader<DataGridTableRowModel>(colName, this, column ) {
					@Override
					public String getValue() {
						return colName;
					}
				};
				Header<String> footer1 = new Header<String>(new TextCell()) {
					@Override
					public String getValue() {
						return "";
					}
				};
				
				this.addColumn(column, header, null);
			}
			caption = graphCaptionList.get(0);			
			dataProvider.addDataDisplay( this );
			dataProvider.refresh();
			this.getColumnSortList().clear();
			this.getColumnSortList().push( firstColumn );
			this.getColumnSortList().push( firstColumn );
			ColumnSortEvent.fire(this, this.getColumnSortList());
		}
		catch (Exception e )
		{
			Window.alert("Exception in table "+ e.getMessage()) ;
		}
		GridThemes.applyDatagridThemes();
		HorizontalPanel excelBtnPnl = new HorizontalPanel();
		Button excelBtn = new Button();
		excelBtn.setTitle("Excel");
		excelBtn.setStyleName("excelExportImg");
		Image excelImg = new Image("FusionChart/images/excel.png");
		excelImg.setHeight("20px");
		excelBtn.getElement().appendChild(excelImg.getElement());
		excelBtnPnl.add(ibase.client.tabletoexcel.TableToExcelClientBuilder.fromTable(flexTable).withWidget(excelBtn).buildExportFormWidget());
		SimplePager.Resources displayPagerResources = GWT.create(SimplePager.Resources.class);
		final SimplePager displayPager = new SimplePager(SimplePager.TextLocation.CENTER, displayPagerResources, false, 0 , true, excelBtnPnl);
		displayPager.setDisplay(this);
		displayPager.setRangeText(rangeText);
		Command setRowCmd = new Command() 
		{
			@Override
			public void execute() 
			{
				try
				{
					int rowNo= (int)Double.parseDouble( displayPager.getRangeText().trim() );
					//int rowNo= (int)Double.parseDouble( "24");
					if( rowNo > 0 && rowNo <= noOfRows)
					{
					    CustomGrid.this.setPageSize( rowNo );
					    displayPager.firstPage();
						dataProvider.refresh();
						rangeText = displayPager.getRangeText();
						displayPager.setRangeText(displayPager.getRangeText());
					}
					else
					{
						displayPager.setRangeText("Error");
					}
				}
				catch (Exception e)
				{
					displayPager.setRangeText("Error");
				}
			}
		};
		displayPager.setRangeCommand( setRowCmd );	
		String cellVal = Window.Location.getParameter("CELL_VAL") == null ? "" : Window.Location.getParameter("CELL_VAL");
		String brandName = Window.Location.getParameter("brand") == null ? "" : Window.Location.getParameter("brand");
		/*Add Code for sardia Dashboard to set on title by Dhanendra on Date 03-12-2015*/
		String personName = Window.Location.getParameter("personName") == null ? "" : Window.Location.getParameter("personName");
		/*End Code for sardia Dashboard to set on title by Dhanendra on Date 03-12-2015*/
		
		if(caption.trim().length()==0 && cellVal.trim().length()>0)
		{
			if(brandName.trim().length()>0)
			{
				caption = brandName.trim()+" - "+cellVal.trim()+" (Stock Quantity) ";
			}
			/*Add Code for sardia Dashboard to set on title by Dhanendra on Date 03-12-2015*/
			else if(personName.trim().length()>0)
			{
				caption = personName.trim()+" - "+cellVal.trim();
			}
			/*End Code for sardia Dashboard to set on title by Dhanendra on Date 03-12-2015*/
			/*else
			{
				caption = cellVal.trim();
			}*/
		}
		if(caption.trim().length()!=0)
		{
			flexTable.setText(0, 0, caption);
			flexTable.setWidget(1, 0, this);
			flexTable.setWidget(2, 0, displayPager);
			flexTable.getCellFormatter().setStyleName(0 ,0 , "FlexTable-ColumnHeaderCellFrame");
			flexTable.getCellFormatter().setStyleName(1 ,0 , "gwt-ScrollTableForFrame");
			
			if( GridThemes.getBrowserVersion() == -1 )
			{
				flexTable.getCellFormatter().setStyleName(2 ,0 , "e12Pager");
			}
			else
			{
				flexTable.getCellFormatter().setStyleName(2 ,0 , "e12Pager-forIE");
			}
		}else
		{
			flexTable.setWidget(0, 0, this);
			flexTable.setWidget(1, 0, displayPager);
			flexTable.getCellFormatter().setStyleName(0 ,0 , "gwt-ScrollTableForFrame");			
			if( GridThemes.getBrowserVersion() == -1 )
			{
				flexTable.getCellFormatter().setStyleName(1 ,0 , "e12Pager");
			}
			else
			{
				flexTable.getCellFormatter().setStyleName(1 ,0 , "e12Pager-forIE");
			}
		}
		flexTable.setHeight( Window.getClientHeight() - 240 + "px" );
		flexTable.setHeight("280px");
		setHeight("280px");
		flexTable.setStyleName("flexCSSFrame");
		addStyleName("e12AdvDataGrid-SideBarsFrame");
		
		return flexTable;
	}
	
	/**
	 * @param date
	 * @return true
	 * It checks Whether the given String is date.
	 */
	public boolean isValidDate( String date ) 
	{
		SimpleDateFormat sdf = new SimpleDateFormat("dd-mm-yy");
		Date testDate = null;
			try 
			{
						testDate = sdf.parse(  date  );
			}			
			catch(Exception ex){
				ex.printStackTrace();
			}
			return true;
	}
	
	
	public boolean isValidDouble( String Num ) 
	{
		double numToDouble=0.0;
			try 
			{
					numToDouble = Double.parseDouble(Num);
			}			
			catch(Exception NumberFormatException){
				return false;
			}
			return true;
	}
	public boolean isValidDate1( String dateString ) 
	{
		SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
			try 
			{
	    		Date date = formatter.parse(dateString);
			}			
			catch(Exception ParseException)
			{
				return false;
			}
			return true;
	}
	
	public void getParameterList(JSONObject metaDataJsnObj,String url,String childID)
	{
		Date date = new Date();
		MetaDataDtl dataDtl = new MetaDataDtl();
		filterList          =dataDtl.getFilters(metaDataJsnObj);
		int year=0;
		String month="";
		String scmMonth="";
		String monthYear="";
		year= 1900+date.getYear();
		month=String.valueOf(date.getMonth()+1);
		scmMonth=String.valueOf((date.getMonth()));
        if(month.trim().length()==1)
        {
        	month="0"+month;
        }
        monthYear=year+month;
        int count =0;
        if(filterList.size()>0)
        {
			for (FilterInfo filterInfo : filterList)
			{
				count++;
				//if(count==1)
				CommonUtils.printOnConsole("filterInfo.getFieldName() :"+filterInfo.getFieldName());
				if(filterInfo.getFieldName().equals("PRD_SALESDASH"))
				{
					String prdFilterName=filterInfo.getFieldName();
					if(prdFilterName=="PRD_SALESDASH")
					{
						if(scmMonth.trim().length()==1)
			            {
							scmMonth="0"+scmMonth;
			            }
			            monthYear=year+scmMonth;
			            parameterList.add(Window.Location.getParameter(filterInfo.getFieldName()) == null ? monthYear : Window.Location.getParameter(filterInfo.getFieldName()));
					}
					else
					{	
						parameterList.add(Window.Location.getParameter(filterInfo.getFieldName()) == null ? monthYear : Window.Location.getParameter(filterInfo.getFieldName()));
					}
				}
				/*Add code for current prd code by dhanendra on 06-10-2015 */
                else if(filterInfo.getFieldName().equals("CURRENT_PRDCODE"))
                {
                    parameterList.add(Window.Location.getParameter(filterInfo.getFieldName()) == null ? monthYear : Window.Location.getParameter(filterInfo.getFieldName()));
                }
                /*End code for current prd code by dhanendra on 06-10-2015 */
				else
				{
					
					//parameterList.add(Window.Location.getParameter(filterInfo.getFieldName()) == null ? "" : Window.Location.getParameter(filterInfo.getFieldName()));
					
					String guess = filterInfo.getFieldName();
					CommonUtils.printOnConsole("guess :"+guess);
				    int wordLgth = guess.length();
				    CommonUtils.printOnConsole("wordLgth :"+wordLgth);
				    int index = url.indexOf(guess);
				    CommonUtils.printOnConsole("index :"+index);
				    if(index !=-1)
				    {
				    	String newUri = url.substring(index + 1+wordLgth);
				    	CommonUtils.printOnConsole("newUri :"+newUri);
				    	int parameter = newUri.indexOf("&");
				    	if(parameter == -1 && guess.equals("P1"))
				    	{
				    		parameterList.add(newUri);	
				    	}else{
				    		CommonUtils.printOnConsole("parameter :"+parameter);
					    	String paramVal = newUri.substring(0,parameter);
					    	CommonUtils.printOnConsole("paramVal :"+paramVal);
					    	parameterList.add(paramVal == null ? "" : paramVal);
					    		
				    	}
				    	CommonUtils.printOnConsole("parameterList in  :"+parameterList);
				    }
				    else
				    {
				    	parameterList.add("");
				    }
				
				}
			}
        }
        /*else
        {
        	parameterList.add(Window.Location.getParameter("metadataname"));
        }*/
        GWTDashBoardReport  boardReport = new GWTDashBoardReport();
        parameterList.add(boardReport.getDefaultView(metaDataJsnObj));
        CommonUtils.printOnConsole("parameterList :"+parameterList);
        E12DashBoardPage e12DashBoardPage = new E12DashBoardPage(parameterList,metaDataJsnObj,childID);
        RootPanel.get("filterDiv").add(e12DashBoardPage);
	}
	
	/*Add Native method for clear div by Dhanendra on date 19-09-2016*/
	private static native void clearDivContainer(String ChartId)
	/*-{
		try {
			$wnd.clearDivOnCloseButton(ChartId);
		} catch (e) {
			E12CommonUtils.printOnConsole("Exception :: Custom Grid : clearDivOnCloseButton [" + e.message		+ "]");
		}
	}-*/;
	/*End Native method for clear div by Dhanendra on date 19-09-2016*/
	
	/*Add method for display summary in component title panel by dhanendra */
	public double getSubTitleSummary(JSONObject jsonObjGridData ,String dataSrc,String componentSubTitleProperty)
	{
		double subTitleValTotal = 0.0;
		try
		{
			
			JSONObject jsonObjFrGraph =(JSONObject) jsonObjGridData.get(dataSrc);
			
			for (int jsnCnt = 0; jsnCnt < jsonObjFrGraph.size(); jsnCnt++)
			{
				JSONObject fetchRowWiseVal = (JSONObject) jsonObjFrGraph.get(String.valueOf(jsnCnt));
				if(fetchRowWiseVal!=null)
				{
						if(fetchRowWiseVal.get(componentSubTitleProperty)!=null)
						{
							subTitleValTotal = subTitleValTotal + Math.round(Double.parseDouble(fetchRowWiseVal.get(componentSubTitleProperty).toString().replace('"', ' ').trim()));
						}
					
				}
			}
			
		}catch (Exception e) {
			CommonUtils.printOnConsole(" Exception :: CustomGrid  :: getSubTitleSummary [" + e.getMessage() + "]");
		}
		return subTitleValTotal;
	}
	/*End method for display summary in component title panel by dhanendra */
}
