<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
				<meta http-equiv="Cache-Control" content="no-store" />
				
				
			</head>

			<script type="text/javascript" src="/ibase/webitm/js/RequirementWizard.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    var maxCnt=0;
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail3."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail3."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    }
    
   

]]>

			</script>
			<body >


				<style type="text/css">

					.tableClass
					{margin-left:10px;margin-top:10px}

					.tableClass_rep
					{margin-left:0px}

					.header_td
					{border:inset
					0;background:#FFCCCC;font-family:verdana;font-size:9pt}

					.reset
					{border:inset 1;font-family:verdana;font-size:9pt;
					font-weight:bold}

					.input_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_leftAlign1
					{text-align:left;font-family:verdana;font-size:9pt}

					.tr_color
					{background:#B7E5F9}
					
					.hide
					{display:none }
					
					.Stock
					{background:#D7A5F9}
					
					.Planned
					{background:#D9D5F9}
					
					.WIP
					{background:#AAD5F9}
					
					.StockPlanned
					{background:#B7D5F9}
					
					.StockWIP
					{background:#A7B5F9}
					
					.PlannedWIP
					{background:#B7G5F9}
					
					.StockPlannedWIP
					{background:#ACD5F9}
					
				</style>

				<form name="requirement" METHOD="post" id="requirement"
					ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('3');" >
					
					<table id="travelTable" width="90%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">

						<xsl:for-each select="//Detail3">
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID" /><![CDATA[";
					maxId= detCnt; 												
				]]>
							</SCRIPT>

						</xsl:for-each>
						<tr>
							<td width="1%" class="header_td" nowrap="true" valign="bottom">
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Site Code</strong>
							</td>
						 	<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Code</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Supp Source</strong>
							</td>
							<td width="4%" class="header_td" nowrap="true" valign="bottom">
								<strong>Demand</strong>
							</td>
							<td width="15%" class="header_td" nowrap="true" valign="bottom">
								<strong>Supply</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Due Date</strong>
							</td>
							<td width="2%" class="header_td" nowrap="true" valign="bottom">
								<strong>Plan Supply</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Running Demand</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Running Supply</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Running Plan Supply</strong>
							</td>
							
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Indipendent Demand</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Bom Code</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Order Option</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Batch Qty Type</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Unit</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Min Order Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Integral Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Max Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Min Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Reorder Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Yield Perc</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Min Plan Perc</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Batch Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Purchase Rate</strong>
							</td>
							
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Purchase Lead Time</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Qc Lead Time</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>MFG Lead Time</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Description</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Stock Qty</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Other Supply</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Pending PO</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Pending DO</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Pending Indent</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Pending DR</strong>
							</td>

						</tr>
						

						<xsl:for-each select="//Detail3">

							
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<xsl:variable name="chkbox">
								<xsl:value-of select="@selected" />
							</xsl:variable>							
							<xsl:variable name="site_code">
								<xsl:value-of select="site_code" />
							</xsl:variable>
							<xsl:variable name="item_code">
								<xsl:value-of select="item_code" />
							</xsl:variable>
							
							<xsl:variable name="supp_sour">
								<xsl:value-of select="supp_sour" />
							</xsl:variable>
							<xsl:variable name="demand">
								<xsl:value-of select="demand" />
							</xsl:variable>
							<xsl:variable name="supply">
								<xsl:value-of select="supply" />
							</xsl:variable>
							<xsl:variable name="due_date">
								<xsl:value-of select="due_date" />
							</xsl:variable>
							<xsl:variable name="plan_supply">
								<xsl:value-of select="plan_supply" />
							</xsl:variable>
							<xsl:variable name="running_demand">
								<xsl:value-of select="running_demand" />
							</xsl:variable>
							<xsl:variable name="running_supply">
								<xsl:value-of select="running_supply" />
							</xsl:variable>
							<xsl:variable name="running_plan_supply">
								<xsl:value-of select="running_plan_supply" />
							</xsl:variable>
							<xsl:variable name="independent_demand">
								<xsl:value-of select="independent_demand" />
							</xsl:variable>
							<xsl:variable name="bom_code">
								<xsl:value-of select="bom_code" />
							</xsl:variable>
							<xsl:variable name="order_opt">
								<xsl:value-of select="order_opt" />
							</xsl:variable>
							<xsl:variable name="batch_qty_type">
								<xsl:value-of select="batch_qty_type" />
							</xsl:variable>
							<xsl:variable name="unit">
								<xsl:value-of select="unit" />
							</xsl:variable>
							<xsl:variable name="min_order_qty">
								<xsl:value-of select="min_order_qty" />
							</xsl:variable>
							<xsl:variable name="integral_qty">
								<xsl:value-of select="integral_qty" />
							</xsl:variable>
							<xsl:variable name="max_qty">
								<xsl:value-of select="max_qty" />
							</xsl:variable>
							<xsl:variable name="min_qty">
								<xsl:value-of select="min_qty" />
							</xsl:variable>
							<xsl:variable name="reorder_qty">
								<xsl:value-of select="reorder_qty" />
							</xsl:variable>
							<xsl:variable name="yield_perc">
								<xsl:value-of select="yield_perc" />
							</xsl:variable>
							<xsl:variable name="min_plan_perc">
								<xsl:value-of select="min_plan_perc" />
							</xsl:variable>
							<xsl:variable name="batch_qty">
								<xsl:value-of select="batch_qty" />
							</xsl:variable>
							<xsl:variable name="purc_rate">
								<xsl:value-of select="purc_rate" />
							</xsl:variable>
							<xsl:variable name="pur_lead_time">
								<xsl:value-of select="pur_lead_time" />
							</xsl:variable>
							<xsl:variable name="qc_lead_time">
								<xsl:value-of select="qc_lead_time" />
							</xsl:variable>
							<xsl:variable name="mfg_lead_time">
								<xsl:value-of select="mfg_lead_time" />
							</xsl:variable>
							<xsl:variable name="description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="stock_qty">
								<xsl:value-of select="stock_qty" />
							</xsl:variable>
							<xsl:variable name="oth_supply">
								<xsl:value-of select="oth_supply" />
							</xsl:variable>
							<xsl:variable name="pending_po">
								<xsl:value-of select="pending_po" />
							</xsl:variable>
							<xsl:variable name="pending_do">
								<xsl:value-of select="pending_do" />
							</xsl:variable>
							<xsl:variable name="pending_indent">
								<xsl:value-of select="pending_indent" />
							</xsl:variable>
							<xsl:variable name="pending_dr">
								<xsl:value-of select="pending_dr" />								
							</xsl:variable>
								
								<tr>									
									<td  class="td_leftAlign" align="left">  
										<xsl:choose>
											<xsl:when test="$chkbox ='Y'">
												  <!-- <script>
													<![CDATA[ orderVisit = parseInt("]]>
													<xsl:value-of select="order_of_visit" /><![CDATA[");]]>
												</script> -->
												<input type="checkbox"
													name="Detail3.{normalize-space($dbID)}.selectbox" id="Detail3.{normalize-space($dbID)}.selectbox"
													checked='Y' value="true"
													onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
											</xsl:when>
											<xsl:otherwise>
												<input type="checkbox"
													name="Detail3.{normalize-space($dbID)}.selectbox" id="Detail3.{normalize-space($dbID)}.selectbox"
													value="false" 
													onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.site_code"
											id="Detail3.{normalize-space($dbID)}.site_code" value="{$site_code}"
											size="10" ISCHANGED="false" />
										<xsl:value-of select="site_code" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.item_code" id="Detail3.{normalize-space($dbID)}.item_code"
											value="{$item_code}" size="10" ISCHANGED="false" />
										<xsl:value-of select="item_code" />
									</td>

									<td class="td_leftAlign" align="left">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.supp_sour"
											id="Detail3.{normalize-space($dbID)}.supp_sour" value="{$supp_sour}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="supp_sour" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.demand"
											id="Detail3.{normalize-space($dbID)}.demand" value="{$demand}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="demand" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.supply"
											id="Detail3.{normalize-space($dbID)}.supply" value="{$supply}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="supply" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.due_date"
											id="Detail3.{normalize-space($dbID)}.due_date" value="{$due_date}"
											size="10" ISCHANGED="false" />
										<xsl:value-of select="due_date" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.plan_supply"
											id="Detail3.{normalize-space($dbID)}.plan_supply" value="{$plan_supply}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="plan_supply" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.running_demand"
											id="Detail3.{normalize-space($dbID)}.running_demand" value="{$running_demand}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="running_demand" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.running_supply"
											id="Detail3.{normalize-space($dbID)}.running_supply" value="{$running_supply}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="running_supply" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.running_plan_supply"
											id="Detail3.{normalize-space($dbID)}.running_plan_supply" value="{$running_plan_supply}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="running_plan_supply" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.independent_demand"
											id="Detail3.{normalize-space($dbID)}.independent_demand" value="{$independent_demand}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="independent_demand" />
									</td>
									

									
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.bom_code" id="Detail3.{normalize-space($dbID)}.bom_code"
											value="{$bom_code}" size="10" ISCHANGED="false" />
										<xsl:value-of select="bom_code" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.order_opt" id="Detail3.{normalize-space($dbID)}.order_opt"
											value="{$order_opt}" size="10" ISCHANGED="false" />
										<xsl:value-of select="order_opt" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.batch_qty_type" id="Detail3.{normalize-space($dbID)}.batch_qty_type"
											value="{$batch_qty_type}" size="10" ISCHANGED="false" />
										<xsl:value-of select="batch_qty_type" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.unit" id="Detail3.{normalize-space($dbID)}.unit"
											value="{$unit}" size="10" ISCHANGED="false" />
										<xsl:value-of select="unit" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.min_order_qty"
											id="Detail3.{normalize-space($dbID)}.min_order_qty" value="{$min_order_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="min_order_qty" />
										<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.integral_qty"
											id="Detail3.{normalize-space($dbID)}.integral_qty" value="{$integral_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="integral_qty" />
									</td>
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.max_qty"
											id="Detail3.{normalize-space($dbID)}.max_qty" value="{$max_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="max_qty" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.min_qty"
											id="Detail3.{normalize-space($dbID)}.min_qty" value="{$min_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="min_qty" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.reorder_qty"
											id="Detail3.{normalize-space($dbID)}.reorder_qty" value="{$reorder_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="reorder_qty" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.yield_perc"
											id="Detail3.{normalize-space($dbID)}.yield_perc" value="{$yield_perc}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="yield_perc" />
									</td>
									
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.min_plan_perc"
											id="Detail3.{normalize-space($dbID)}.min_plan_perc" value="{$min_plan_perc}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="min_plan_perc" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.batch_qty"
											id="Detail3.{normalize-space($dbID)}.batch_qty" value="{$batch_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="batch_qty" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.purc_rate"
											id="Detail3.{normalize-space($dbID)}.purc_rate" value="{$purc_rate}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="purc_rate" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.pur_lead_time"
											id="Detail3.{normalize-space($dbID)}.pur_lead_time" value="{$pur_lead_time}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="pur_lead_time" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.qc_lead_time"
											id="Detail3.{normalize-space($dbID)}.qc_lead_time" value="{$qc_lead_time}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="qc_lead_time" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.mfg_lead_time"
											id="Detail3.{normalize-space($dbID)}.mfg_lead_time" value="{$mfg_lead_time}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="mfg_lead_time" />
									</td>
									<td class="td_leftAlign" align="left">
										<input type="hidden"
											name="Detail3.{normalize-space($dbID)}.description" id="Detail3.{normalize-space($dbID)}.description"
											value="{$description}" size="10" ISCHANGED="false" />
										<xsl:value-of select="description" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.stock_qty"
											id="Detail3.{normalize-space($dbID)}.stock_qty" value="{$stock_qty}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="stock_qty" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.oth_supply"
											id="Detail3.{normalize-space($dbID)}.oth_supply" value="{$oth_supply}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="oth_supply" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.pending_po"
											id="Detail3.{normalize-space($dbID)}.pending_po" value="{$pending_po}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="pending_po" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.pending_do"
											id="Detail3.{normalize-space($dbID)}.pending_do" value="{$pending_do}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="pending_do" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.pending_indent"
											id="Detail3.{normalize-space($dbID)}.pending_indent" value="{$pending_indent}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="pending_indent" />
									</td>
									<td class="td_leftAlign" style="text-align:right">
										<input type="hidden" name="Detail3.{normalize-space($dbID)}.pending_dr"
											id="Detail3.{normalize-space($dbID)}.pending_dr" value="{$pending_dr}"
											size="04" ISCHANGED="false" />
										<xsl:value-of select="pending_dr" />
									</td> 
									
								</tr>

						

						</xsl:for-each>

					</table>
					<div id="repeatPlacesDiv" style="margin-left:10px"></div>
					<table>
						<tr>
							<td>
								<input type="hidden" value="3" name="FORM_NO" ID="FORM_NO" />
								<input type="hidden" value="requirement" name="OBJ_NAME" />
								<input type="hidden" value="" name="action" id="action1" />
								<!-- <input type="hidden"  value="1:MP:3" name="formType" id="formType" />
								 -->
								
								<input type="submit" style="cursor:hand" value="Previous"
									id="Previous" name="Previous" title=''
									onclick="javascript:setDetail('previous')" />
								
							</td>
						</tr>
					</table>
					<table id="errorTravelTable" width="85%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">
						<xsl:for-each select="//error">
							<xsl:variable name="message">
								<xsl:value-of select="message" />
							</xsl:variable>
							<xsl:variable name="description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:variable name="dbID">
								<xsl:value-of select="@domId" />
							</xsl:variable>
							<xsl:variable name="column_name">
								<xsl:value-of select="@column_name" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<tr>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Message :
									</td>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Description :
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="message" />
								</td>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="description" />
								</td>
							</tr>
						</xsl:for-each>
						<xsl:for-each select="//error">
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<xsl:if test="$type = 'W'">
									<tr>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											Override
											Warnings :
										</td>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											<input type="checkbox" name="forceSave" value="false"
												onClick="javascript:setChecked(this)" />
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>
					</table>

				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>

