package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.sql.Timestamp;
import org.w3c.dom.Document;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 


@Stateless 
public class EmpBondAmount extends ValidatorEJB implements EmpBondAmountLocal,EmpBondAmountRemote
{
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("IN WF VAL DATA ------------>>");
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
	
		System.out.println("\n\n xmlString in wfValData \n:" + xmlString + "\n");
		System.out.println("\n\n xmlString1 in wfValData \n :" + xmlString1 +"\n");
		System.out.println("\n\n xmlString2 in wfValData \n :" + xmlString2 +"\n");
	
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			//ADDED FOR INVOIKING VALIDATION IN WORKFLOW
			if( objContext != null && Integer.parseInt(objContext) == 1 )
			{
				parentNodeList = dom2.getElementsByTagName("Header0");
				parentNode = parentNodeList.item(1);
				childNodeList = parentNode.getChildNodes();						
				for(int x=0;x<childNodeList.getLength();x++)
				{				
					childNode = childNodeList.item(x);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("Detail1"))
					{
						errString = wfValData(dom,dom1,dom2,"1",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}
					else if(childNodeName.equalsIgnoreCase("Detail2"))
					{						
						errString = wfValData(dom,dom1,dom2,"2",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}	
					else if(childNodeName.equalsIgnoreCase("Detail3"))
					{
						errString = wfValData(dom,dom1,dom2,"3",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}
				}
			}
			else
			{
				errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : EmpBondAmount : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag) throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(Document dom, Document dom1,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag) throws RemoteException,ITMException
	{
		return "";
	}
		
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0,cnt = 0;
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String userId = "";
		int currentFormNo=0,i=0;
		int childNodeListLength;		
		
		String empCode="",bondamt="",bondprd="",siteCode = "",lineno="";
				
		
		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			GenericUtility genericUtility = GenericUtility.getInstance();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						if (childNodeName.equalsIgnoreCase("emp_code"))
						{
							System.out.println("in emp_code item change -->>");
							empCode = getColumnValue("emp_code",dom);	
							
							if (empCode == null || empCode.trim().length() == 0 )
							{							
									errCode = "VNULEMPC";
									errString = getErrorString("emp_code",errCode,userId);
									break;	
							}
							else 
							{		
									sql = "select count(1) from employee where  emp_code = ? ";
									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1,empCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt(1);
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
									if(cnt == 0)
									{
										errCode = "VMEMPCD1";
										errString = getErrorString("emp_code",errCode,userId);
										
										break;
									}
								
							}
													
						}
						else if (childNodeName.equalsIgnoreCase("line_no"))
						{
							System.out.println("in line_no item change -->>");
							lineno = getColumnValue("line_no",dom);							


							if (lineno == null || lineno.trim().length() == 0 )
							{
									errCode = "VNULBLINE";
									errString = getErrorString("line_no",errCode,userId);
									break;
							}
							else
							{
								System.out.println("@ editFlag ---->>"+editFlag);
							  if (!( "E".equalsIgnoreCase(editFlag)))
							  {
								  System.out.println("@ editFlag  inside---->>"+editFlag);
									sql="select count(1) from employee_bond where emp_code = ? and line_no = ? ";
									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1,empCode);
									pstmt.setString(2,lineno);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt(1);
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
									if(cnt > 0)
									{
										errCode = "VETLINE";
										errString = getErrorString("line_no",errCode,userId);
										
										break;
									}
							   }
							}
							
						}
						
						
						else if (childNodeName.equalsIgnoreCase("bond_amt"))
						{
							System.out.println("in bond_amt item change -->>");
							bondamt = getColumnValue("bond_amt",dom);							


							if (bondamt == null || bondamt.trim().length() == 0 )
							{
									errCode = "VNULBAMT";
									errString = getErrorString("bond_amt",errCode,userId);
									break;
							}
							
						}
						
						
						else if (childNodeName.equalsIgnoreCase("bond_prd"))
						{
							System.out.println("in ebond_prd item change -->>");
							bondprd = getColumnValue("bond_prd",dom);							


							if (bondprd == null || bondprd.trim().length() == 0 )
							{
									errCode = "VNULBPRD";
									errString = getErrorString("bond_prd",errCode,userId);
									break;
							}
							
						}
					}// for loop end
					break;
				
			} //end switch
			
		}//end try
		catch(Exception e)
		{			
			e.printStackTrace();
			errString = e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}				
				if(pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}		
		return errString;
	}
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("IN ITEM CHANGE");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			dom = parseString(xmlString);			
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ChangeControlEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int ctr=0;
		String childNodeName = null;
		String columnValue = null;
		
		int currentFormNo = 0;
	
		String sql = "",empfname = "", empmname = "", emplname = "",empCode="";
		ConnDriver connDriver = new ConnDriver();

		
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			switch(currentFormNo)
			{
			case 1 :
				valueXmlString.append("<Detail1>");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				int childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				
				
				
				 if(currentColumn.trim().equalsIgnoreCase("emp_code"))
				{
					
					empCode = genericUtility.getColumnValue("emp_code",dom);
					sql = " Select emp_fname,emp_mname,emp_lname from employee where emp_code= ?";
					
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1,empCode);
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						empfname = rs.getString(1) == null ? "" : rs.getString(1);
						empmname = rs.getString(2) == null ? "" : rs.getString(2);
						emplname = rs.getString(3) == null ? "" : rs.getString(3);							 
						
					}
					
					valueXmlString.append("<emp_fname>").append("<![CDATA["+empfname+"]]>").append("</emp_fname>");
					valueXmlString.append("<emp_mname>").append("<![CDATA["+empmname+"]]>").append("</emp_mname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA["+emplname+"]]>").append("</emp_lname>");
					
					
					System.out.println("First Name :"+empfname+" Middle Name :"+empmname+" Last Name :"+emplname);
					
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
				}	
				valueXmlString.append("</Detail1>");
				break;
			}// end switch
			valueXmlString.append("</Root>");
			
		}
		catch(Exception e)
		{
			e.printStackTrace();			
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{	
					conn.close();
					conn = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("Return xml ---->>>>"+valueXmlString.toString());
		return valueXmlString.toString();
	}

}
