package ibase.webitm.ejb.fin;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;

import ibase.webitm.ejb.fin.adv.ReceiptAdvConf;

@javax.ejb.Stateless
public class ReceiptAutoConfPOS extends ValidatorEJB implements	ReceiptAutoConfPOSLocal, ReceiptAutoConfPOSRemote {

	FinCommon finCommon = new FinCommon();
	DistCommon distCommon = new DistCommon();
	FileOutputStream fos1 = null;
	E12GenericUtility genericUtility=new E12GenericUtility();
	Calendar calendar = Calendar.getInstance();

	public String postSave() throws RemoteException, ITMException {
		return "";
	}

	public String postSave(String domString, String editFlag,String xtraParams, Connection conn) throws RemoteException,ITMException 
	{
		java.util.Date startDate = new java.util.Date(System.currentTimeMillis());
		String startDateStr="";
		System.out.println("Intializing Log $$$$$..."+ intializingLog("Rcp_Aut_Cnf_Pos_log"));
		
		String retString="";
        try
        {
	        SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
	        startDate = new java.util.Date(System.currentTimeMillis());
	        calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
	        startDateStr = sdf1.format(startDate)+" "+calendar.get(Calendar.HOUR)+":"+calendar.get(Calendar.MINUTE)+":"+calendar.get(Calendar.SECOND);
	        fos1.write(("Receipt auto Confirm start at :- [" + startDateStr +"]\r\n\n").getBytes());
	        
	        fos1.write(("Dom String :- [" + domString +"]\r\n\n").getBytes());
	        
	        
	        retString = postSave(domString, editFlag, xtraParams, true, conn);
	        fos1.write(("After POST SAVE Return String:- [" + retString +"]\r\n\n").getBytes());
        } catch (IOException e2)
        {
	        // TODO Auto-generated catch block
	        e2.printStackTrace();
        } catch (Exception e2)
        {
	        // TODO Auto-generated catch block
	        e2.printStackTrace();
        }
        E12GenericUtility genericUtility = new E12GenericUtility();
//		GenericUtility genericUtility = GenericUtility.getInstance();
		Document dom = genericUtility.parseString(domString);
		PreparedStatement pstmt = null;
		ResultSet rs= null;
		String tranId = "";
		StringBuffer commInfo = new StringBuffer();
		String sql="",userType="",custCode="",tranType="",rcpMode="",bankCode="",refNo="",confDate="";
		String siteCode="",emailAddr="";
		String refDate="",remarks="",dlvMode="",dlvRef="",netAmt="",currCode="",exchRate="",empCodeAprv="",descr="",custName="";
		String formatCode="RECPT_MAIL";
		Timestamp tranDate=null;
		String errString="";
		ITMDBAccessEJB itmDBAccessEJB = null;
		
		if (retString.trim().length() == 0) 
		{
			System.out.println("@V@ Post save return string :-[" + retString+ "]");
			tranId = genericUtility.getColumnValue("tran_id", dom);
			ReceiptAdvConf obj = new ReceiptAdvConf();
			retString = obj.confirm(tranId, xtraParams, "", conn);
			System.out.println("@V@ Confirm return string :- [" + retString+ "]");
			try
            {
				itmDBAccessEJB = new ITMDBAccessEJB();
				
	            fos1.write(("After CONFIRM Return String:- [" + retString +"]\r\n\n").getBytes());
            } catch (IOException e1)
            {
	            // TODO Auto-generated catch block
	            e1.printStackTrace();
            }
			
			if (retString.contains("VTCICONF3")) 
			{
				//Added by Pankaj to send auto-mail to concern employee on 20/NOV/2015
				try
				{
					sql="SELECT TRAN_DATE,SITE_CODE,CUST_CODE,TRAN_TYPE,RCP_MODE,BANK_CODE,REF_NO,REF_DATE,REMARKS,DLV_MODE," +
							"DLV_REF,NET_AMT,CURR_CODE,EXCH_RATE,EMP_CODE__APRV,CONF_DATE FROM RECEIPT WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						tranDate = (rs.getTimestamp("TRAN_DATE"));
						siteCode = checkNull(rs.getString("SITE_CODE"));
						custCode = checkNull(rs.getString("CUST_CODE"));
						tranType = checkNull(rs.getString("TRAN_TYPE"));
						rcpMode = checkNull(rs.getString("RCP_MODE"));
						bankCode = checkNull(rs.getString("BANK_CODE"));
						refNo = checkNull(rs.getString("REF_NO"));
						refDate = checkNull(rs.getString("REF_DATE"));
						remarks = checkNull(rs.getString("REMARKS"));
						dlvMode = checkNull(rs.getString("DLV_MODE"));
						dlvRef = checkNull(rs.getString("DLV_REF"));
						netAmt = checkNull(rs.getString("NET_AMT"));
						currCode = checkNull(rs.getString("CURR_CODE"));
						exchRate = checkNull(rs.getString("EXCH_RATE"));
						empCodeAprv = checkNull(rs.getString("EMP_CODE__APRV"));
						confDate = checkNull(rs.getString("CONF_DATE"));
						System.out.println("refDate before>>>>"+refDate);
						System.out.println("tranDate>>>>"+tranDate);
						refDate = genericUtility.getValidDateString(refDate,genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
						confDate = genericUtility.getValidDateString(confDate,genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "select cust_name from customer where cust_code= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, custCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						custName = checkNull(rs.getString("cust_name"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "select email_addr from site where site_code= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						emailAddr = checkNull(rs.getString("email_addr"));
						System.out.println("email_addr>>> "+emailAddr);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql="SELECT descr FROM gencodes WHERE MOD_NAME = 'X' AND FLD_NAME = 'EMAIL_ID_AML' " +
							"and sh_descr in(select registr_5 from customer c,receipt r " +
							"where c.cust_code=r.cust_code and r.tran_id= ?) ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = checkNull(rs.getString("descr"));
						System.out.println("  descr  ::"+descr);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					//Added CDATA by manoj dtd 07/03/2016 to avoide special charator issue while sending mail
					commInfo.append("<ROOT>");
					commInfo.append("<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>BASE</ENTITY_CODE>");
					commInfo.append("<ENTITY_TYPE>").append("<![CDATA["+userType+"]]>").append("</ENTITY_TYPE>");
					commInfo.append("<TO_ADD>").append("<![CDATA["+descr+","+emailAddr+"]]>").append("</TO_ADD>");
					commInfo.append("<BCC_ADD></BCC_ADD>");
					commInfo.append("<FORMAT_CODE>").append("<![CDATA["+formatCode+"]]>").append("</FORMAT_CODE>");
					commInfo.append("<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>");
					commInfo.append("</MAIL>");
					commInfo.append("<XML_DATA><ROOT><Detail1><TRAN_ID>").append("<![CDATA["+tranId+"]]>").append("</TRAN_ID><TRAN_DATE>").append("<![CDATA["+tranDate+"]]>").append("</TRAN_DATE>" +
							"<CUST_CODE>").append("<![CDATA["+custCode+"]]>").append("</CUST_CODE><CUST_NAME>").append("<![CDATA["+custName+"]]>").append("</CUST_NAME><TRAN_TYPE>").append("<![CDATA["+tranType+"]]>").append("</TRAN_TYPE><RCP_MODE>").append("<![CDATA["+rcpMode+"]]>").append("</RCP_MODE>" +
							"<BANK_CODE>").append("<![CDATA["+bankCode+"]]>").append("</BANK_CODE><REF_NO>").append("<![CDATA["+refNo+"]]>").append("</REF_NO><REF_DATE>").append("<![CDATA["+refDate+"]]>").append("</REF_DATE>" +
							"<REMARKS>").append("<![CDATA["+remarks+"]]>").append("</REMARKS><CONF_DATE>").append("<![CDATA["+confDate+"]]>").append("</CONF_DATE><DLV_MODE>").append("<![CDATA["+dlvMode+"]]>").append("</DLV_MODE><DLV_REF>").append("<![CDATA["+dlvRef+"]]>").append("</DLV_REF>" +
							"<NET_AMT>"+netAmt+"</NET_AMT><CURR_CODE>"+currCode+"</CURR_CODE><EXCH_RATE>"+exchRate+"</EXCH_RATE>" +
							"<emp_code>").append("<![CDATA["+empCodeAprv+"]]>").append("</emp_code>");					
//					commInfo.append("<cc_to>"+travelCodeEmail+","+nsmCodeEmail+"</cc_to>");
					commInfo.append("</Detail1></ROOT></XML_DATA>");
					commInfo.append("</ROOT>");	
					EMail email = new EMail();
					email.sendMail(commInfo.toString(), "ITM"); 
					
					//retString = "submited";
					System.out.println("  information submited::");
				}
				catch( Exception e )
				{
					errString=e.toString();
					errString=itmDBAccessEJB.getErrorString("","LOADFAIL01","","",conn);
					e.printStackTrace();
					
					System.out.println("Exception ::"+ e.getMessage());
					throw new ITMException(e);
				}
			}
			else
			{
//				errString="Loading Failed";
				errString=itmDBAccessEJB.getErrorString("","LOADFAIL01","","",conn);
			}
			// End by Pankaj R on 20/NOV/15
		}
		else
		{
			errString=retString;
		}
		try
        {
	        fos1.write(("ERROR String return:- [" + errString +"]\r\n\n\n").getBytes());
        } catch (IOException e)
        {
	        // TODO Auto-generated catch block
	        e.printStackTrace();
        }
		return errString;
	}

	public String postSave(String domString, String editFlag,
			String xtraParams, boolean autoConfirm, Connection conn)
			throws RemoteException, ITMException {

		System.out.println("In ReceiptAdvPostSave ... ");

		PreparedStatement pstmt = null;
		Document dom = null;
		ResultSet rs = null;
		boolean isError = false;

		String tranIdRcp = "";
		String tranId = "", lineNo = "";
		String errString = "";
		String xmlString = null;
		String sql = null;
		String sqlC = null;
		StringBuffer xmlBuff = new StringBuffer();
		// PreparedStatement pstmt=null;
		String bankCode = null;
		String finEntity = null;
		String currCode = null;
		double exchRate = 0;
		double chqAmt = 0, chqAmtActual = 0, netAmt = 0, diffAmtExchTotal = 0, netAmtBc = 0;
		String tranDate = null;
		String custCode = null;
		String siteCode = null;
		String acctCodeBal = null;
		String acctCodeAr = null;
		String cctrCodeBal = null;
		String cctrCodeAr = null;
		String acctCodeAdv = null;
		String cctrCodeAdv = null;
		String refNo = null;
		String itemSer = null;
		String varValue = "";
		String loginEmpCode = "";
		String cctrFin = "";
		String cctrFinS = "";
		String acctFin = "";
		String acctFinS = "";
		String bdFluctuationCf = "";
		String sql1 = "";
		String errorString = "";

		double rcpAmt = 0, finChg = 0, diffAmtExchDet = 0, diffAmtExchAdv = 0, diffAmtExchEpc = 0, newAdvAmt = 0;
		double billAmtDet = 0, advAmtHdr = 0, adjAmtAdv = 0, bdAmt = 0, advAmtRact = 0, othAmt = 0.0, exchRateHdr = 0.0, taxAmt = 0, amount = 0.0, othAmttemp = 0.0;
		int cnt = 0,cnt2 = 0;;
		try {
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
//			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);

			tranId = genericUtility.getColumnValue("tran_id", dom);
			currCode = genericUtility.getColumnValue("curr_code",dom);

			sql = "select count(1) from receipt WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				cnt2 = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("@@@@@@@ tranId["+tranId+"]cnt2["+cnt2+"]");
			
			fos1.write(("Tran Id :[" + tranId +"]:: cnt2 :["+cnt2+"]\r\n\n").getBytes());
			
			sql = "select adv_amt, exch_rate,chq_amt,curr_Code from receipt WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				advAmtHdr = rs.getDouble(1);
				exchRateHdr = rs.getDouble(2);
				chqAmtActual = rs.getDouble(3);
				currCode = rs.getString(4);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			bdFluctuationCf = checkNull(finCommon.getFinparams("999999",
					"BD_FLUCTUATION_CF", conn));// added by sagar on 21/08/14..
			System.out.println(">>>>>>>>>>>>>>Finparam varValue:" + varValue);
			if (bdFluctuationCf == null
					|| bdFluctuationCf.trim().equalsIgnoreCase("NULLFOUND")) {
				bdFluctuationCf = "N";
			}
			if ("N".equals(bdFluctuationCf.trim())) // Condition added by sagar
													// on 21/08/14..
			{
				sql = "UPDATE rcpdet set exch_rate =  ? "
						+ " WHERE  tran_id = ? "
						+ " and (curr_code = ?  or exch_rate is null) ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, exchRateHdr);
				pstmt.setString(2, tranId);
				pstmt.setString(3, currCode);
				cnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;

				sql = "UPDATE rcpdet set diff_amt__exch =  (rcp_amt * EXCH_RATE__RCV) - (rcp_amt * exch_rate) "
						+ " WHERE  tran_id = ? "
						+ " and (curr_code = ?  or exch_rate is null) ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, currCode);
				cnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}

			sql = "select sum(diff_amt__exch), sum(tax_amt) from rcpdet WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				diffAmtExchDet = rs.getDouble(1);
				taxAmt = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			sql = "select sum(diff_amt__exch) from rcpadv WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				diffAmtExchAdv = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			sql = "select sum(diff_amt__exch) from rcpepc_adj WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				diffAmtExchEpc = rs.getDouble(1);
			}
			rs.close();
			rs = null;

			sql1 = "select sum(amount * exch_rate ) oth_amt from rcpacct WHERE  tran_id = ? AND eff_bank <> 'N'";
			pstmt = conn.prepareStatement(sql1);

			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				othAmttemp = rs.getDouble(1);

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("Other Amount Temp before division>>>>"
					+ othAmttemp);
			if (othAmttemp != 0) {

				othAmt = (othAmttemp / exchRateHdr);
			}

			System.out.println("ExchangeRate hdr after division>>>>>"
					+ exchRateHdr);
			System.out.println("Other Amount after division>>>>>" + othAmt);

			sql = "UPDATE receipt SET oth_amt = ?, tax_amt = ? WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);

			pstmt.setDouble(1, othAmt);
			pstmt.setDouble(2, taxAmt);
			pstmt.setString(3, tranId);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			System.out.println("Other Amount on update11111111>>>>>" + othAmt);

			sql = "select sum(adj_amt) from rcpadv WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				adjAmtAdv = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if ("N".equals(bdFluctuationCf.trim())) // Condition added by Manoj
													// on 22/08/14..
			{
				sql = "select sum(d.rcp_amt * d.exch_rate / h.exch_rate), sum(case when r.bill_disc = 'Y' then d.BILL_DISC_AMT  + d. FIN_CHG else 0 end ) "
						+ " from receipt h, rcpdet d, receivables r "
						+ " WHERE  h.tran_id = d.tran_id "
						+ " and r.tran_ser = d.ref_ser "
						+ " and r.ref_no = d.ref_no "
						+ " and r.line_no__ref = d.line_no__ref "
						+ " and h.tran_id = ? ";
			} else {
				sql = "select sum(d.rcp_amt * d.exch_rate__rcv / h.exch_rate), sum(case when r.bill_disc = 'Y' then d.BILL_DISC_AMT  + d. FIN_CHG else 0 end ) "
						+ " from receipt h, rcpdet d, receivables r "
						+ " WHERE  h.tran_id = d.tran_id "
						+ " and r.tran_ser = d.ref_ser "
						+ " and r.ref_no = d.ref_no "
						+ " and r.line_no__ref = d.line_no__ref "
						+ " and h.tran_id = ? ";
			}

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				billAmtDet = rs.getDouble(1);
				bdAmt = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			billAmtDet = roundVal(billAmtDet, 3);
			// chqAmt = billAmtDet + bdAmt + adjAmtAdv; // 21/01/14 bd amount
			// removed from bill_amt
			chqAmt = billAmtDet;// + adjAmtAdv;
			// 25/02/14 manoharan if all details are dropped t6he bill_amt
			// should be 0
			// if (chqAmt != 0)
			// {
			sql = "UPDATE receipt SET bill_amt = ?, ADVADJ_AMT = ? WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, chqAmt);
			pstmt.setDouble(2, adjAmtAdv);
			pstmt.setString(3, tranId);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			// }
			System.out.println("05/07/14 bill_amt [" + chqAmt
					+ "] billAmtDet [" + billAmtDet + "] advadj_amt ["
					+ adjAmtAdv + "] oth_amt [" + othAmt + "] taxAmt ["
					+ taxAmt + "] diffAmtExchDet [" + diffAmtExchDet
					+ "] diffAmtExchAdv [" + diffAmtExchAdv
					+ "] diffAmtExchEpc [" + diffAmtExchEpc + "]");
			// 21/03/14 manoharan update advance
			if (chqAmtActual != 0) {
				// 29/05/14 manoharan
				// 30/06/14 manoharan not to deduct dbamt
				// sql="select  chq_amt - ((case when bill_amt is null then 0 else bill_amt  end)+ (case when advadj_amt is null then 0 else advadj_amt end) - ?  +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt)  from receipt WHERE  tran_id = ? "
				// ;
				sql = "select  chq_amt - ((case when bill_amt is null then 0 else bill_amt  end) +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt)  from receipt WHERE  tran_id = ? ";
				pstmt = conn.prepareStatement(sql);

				// pstmt.setDouble(1,bdAmt );
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					newAdvAmt = rs.getDouble(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("newAdvAmt: " + newAdvAmt);
				if (newAdvAmt < 0) {

					errorString = itmDBAccessEJB.getErrorString("", "VTNEGADV",
							"", "", conn);
					System.out.println("errorString :" + errorString);
					// throw new
					// Exception("Advance amount calculated is becoming negative ["
					// + newAdvAmt + "]" );
				}
				// end 29/05/14 manoharan

				// 30/06/14 manoharan not to deduct dbamt
				// sql="UPDATE receipt SET adv_amt = chq_amt - ((case when bill_amt is null then 0 else bill_amt  end)+ (case when advadj_amt is null then 0 else advadj_amt end) - ?  +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt) WHERE  tran_id 					= ? "
				// ;
				sql = "UPDATE receipt SET adv_amt = chq_amt - ((case when bill_amt is null then 0 else bill_amt  end) +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt) WHERE  tran_id = ? ";
				pstmt = conn.prepareStatement(sql);

				// pstmt.setDouble(1,bdAmt );
				pstmt.setString(1, tranId);
				cnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;

				if (cnt > 0) {
					System.out.println("update successfully [" + cnt + "]");
				}
			}

			// - (case when bill_disc_amt is null then 0 else bill_disc_amt end)
			// removed on 21/01/14
			// change done by kunal on 01/feb/14 minus bill_disc_amt

			diffAmtExchTotal = diffAmtExchDet + diffAmtExchAdv + diffAmtExchEpc;

			sql = "select  ((case when adv_amt is null then 0 else  adv_amt end)+  (case when bill_amt is null then 0 else bill_amt  end)+ (case when advadj_amt is null then 0 else advadj_amt end) +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt) net_amt  from receipt WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);

			// pstmt.setDouble(1,bdAmt );
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				netAmt = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			netAmt = netAmt - bdAmt;
			netAmtBc = netAmt * exchRateHdr;

			/*
			 * sql="UPDATE receipt SET DIFF_AMT__EXCH = ? + ? + ?, net_amt = ((case when adv_amt is null then 0 else  adv_amt end)+  (case when bill_amt is null then 0 else bill_amt  end)+ (case when advadj_amt is null then 0 else advadj_amt end) - ?  +  (case when oth_amt is null then 0 else oth_amt end)  + (case when fin_chg is null then 0 else fin_chg end) + tax_amt) , "
			 * +
			 * " net_amt__bc  = ((case when adv_amt is null then 0 else  adv_amt end)+  (case when bill_amt is null then 0 else bill_amt  end)+ (case when advadj_amt is null then 0 else advadj_amt end)  -  ?  +  (case when oth_amt is null then 0 else oth_amt end)   + (case when fin_chg is null then 0 else fin_chg end) + tax_amt)  * exch_rate, "
			 * +" bill_disc_amt = ? WHERE  tran_id = ? " ; pstmt =
			 * conn.prepareStatement(sql);
			 * 
			 * pstmt.setDouble(1,diffAmtExchDet );
			 * pstmt.setDouble(2,diffAmtExchAdv );
			 * pstmt.setDouble(3,diffAmtExchEpc ); pstmt.setDouble(4,bdAmt
			 * );//added by kunal on 03/feb/14 pstmt.setDouble(5,bdAmt );
			 * //added by kunal on 03/feb/14 pstmt.setDouble(6,bdAmt );
			 * pstmt.setString(7,tranId ); cnt = pstmt.executeUpdate();
			 * pstmt.close(); pstmt = null;
			 */
			sql = "UPDATE receipt SET DIFF_AMT__EXCH = ? , net_amt = ? ,  net_amt__bc  = ?, bill_disc_amt = ? WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);

			pstmt.setDouble(1, diffAmtExchTotal);
			pstmt.setDouble(2, netAmt);
			pstmt.setDouble(3, netAmtBc);
			pstmt.setDouble(4, bdAmt);
			pstmt.setString(5, tranId);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			if (cnt > 0) {
				System.out.println("update successfully [" + cnt + "]");
			}

			if (cnt > 0) {
				System.out.println("update successfully [" + cnt + "]");
			}
		} catch (Exception e) {
			errorString=e.toString();
			try {
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			isError = true;
			System.out.println("Exception :DcdetPostSaveEJB : :==>\n"
					+ e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				System.out.println("isError [" + isError + "]");
				if (conn != null) {

					/*
					 * if( isError ) { conn.rollback(); } else { conn.commit();
					 * }
					 */
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

			} catch (Exception e) {
				System.out.println("Exception :SavexPreSaveEJB : :==>\n"
						+ e.getMessage());
				try {
					System.out.println("Before rollback");
					conn.rollback();
				}

				catch (SQLException sqle) {
					System.out.println(sqle);
				}
				throw new ITMException(e);
			}
		}
		System.out.println("Out DcdetPostSaveEJB ... ");
		return errorString;
	}

	/**
	 * Initialise and generate log file
	 * @param fileName
	 * @return String
	 */
	private String intializingLog(String fileName)
	{
		String log="intializingLog_Failed";
//		String strToWrite = "";
		String currTime = null;
		java.util.Date startDate = new java.util.Date(System.currentTimeMillis());
		String startDateStr="";
//		String folderName="RcpAutCnf";
		try{
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
			try
			{
				currTime = sdf1.format(new Timestamp(System.currentTimeMillis())).toString();
				currTime = currTime.replaceAll("-","");
				calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
				fileName = fileName+currTime+calendar.get(Calendar.HOUR)+""+calendar.get(Calendar.MINUTE)+".log";
//				folderName=folderName+calendar.get(Calendar.YEAR)+""+calendar.get(Calendar.MONTH)+calendar.get(Calendar.DATE);
				fos1 = new FileOutputStream(CommonConstants.JBOSSHOME + File.separator +"EDI"+File.separator+fileName);

			}
			catch(Exception e)
			{
				System.out.println("Exception []::"+e.getMessage());
				e.printStackTrace();
			}
			startDate = new java.util.Date(System.currentTimeMillis());
			calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
			startDateStr = sdf1.format(startDate)+" "+calendar.get(Calendar.HOUR)+":"+calendar.get(Calendar.MINUTE)+":"+calendar.get(Calendar.SECOND);
			fos1.write(("Fetching Records Started At " + startDateStr +"\r\n").getBytes());

		}
		catch(Exception e)
		{
			System.out.println("Exception []::"+e.getMessage());
			e.printStackTrace();
		}

		log ="intializingLog_Successesfull";
		return log;
	}
	
	private java.math.BigDecimal round(int scale, double round) {
		return new java.math.BigDecimal(round).setScale(scale,
				java.math.BigDecimal.ROUND_UP);
	}

	private double roundVal(double round, int scale) {
		return Math.round(round * Math.pow(10, scale)) / Math.pow(10, scale);
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input;
	}
}