package ibase.webitm.ejb.adm;


import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class LoanSchedulePrs extends ValidatorEJB implements LoanSchedulePrsLocal,LoanSchedulePrsRemote
{


	public String preSave() throws RemoteException, ITMException
	{
		return "";
	}


	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		boolean isError = false;
		Document updateDom = null;
		NodeList parentNodeList = null;

		System.out.println("\n\n xmlString in preSave \n:" + xmlString + "\n");

		try
		{
			dom = parseString(xmlString);
			parentNodeList = dom.getElementsByTagName("Detail2"); 

			if(parentNodeList.getLength() > 0)
			{
				StringBuffer tempXmlString = new StringBuffer() ;
				tempXmlString.append(xmlString);

				if(tempXmlString != null && tempXmlString.toString().trim().length() > 0)
				{
					updateDom = parseString(tempXmlString.toString());
				}

				errString = preSaveLogic(updateDom, editFlag, xtraParams, conn);
			}
			else
			{
				errString = preSaveLogic(dom, editFlag, xtraParams, conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :LoanSchedulePrs : :==>\n"+e.getMessage());
			e.printStackTrace();
			isError = true;
			throw new ITMException(e);
		}
		return (errString);
	}
	public String preSaveLogic(Document dom,String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0,cnt = 0;
		String childNodeName = null,childNodeValue = null;
		int currentFormNo=0,i=0;
		int childNodeListLength;
		String errString = "";
		String errCode = "";
		String sql = "";
		PreparedStatement pstmtDet = null;
		PreparedStatement pstmtDet1 = null;
		PreparedStatement pstmtDet2 = null;
		ResultSet resultSet = null;
		int noRows = 0;
		String userId = "";
		int numOfNullInst = 0 ;
		double amountAct = 0.0d;
		int noInstAct = 0;
		int noInstCreated = 0;
		String lineNo = "",loanNo = "",amount = "",noInst = "",instDed = "",prdCode = "",noInstDed = "",updateFlag = "";
		ArrayList<String> updateFlagList = null,lineNoList = null,loanNoList = null,noInstList = null,noInstDedList = null,amountList = null,prdCodeList = null;

		int currLineInstUsed = 0;
		int noOfInstOld = 0;
		int noOfInstCurrent = 0;
		double amountOld = 0d;
		double amountCurrent = 0d;
		String prdCodeCurrent = "";
		String prdCodeOld = "";
		boolean isNextLineUsed = false;

		try
		{
			System.out.println("======Inside PreSaveLogic Method============");

			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("UserId ::["+userId+"]");

			updateFlagList = new ArrayList<String>();
			lineNoList = new ArrayList<String>();
			loanNoList = new ArrayList<String>();
			noInstList = new ArrayList<String>();
			noInstDedList = new ArrayList<String>();
			amountList = new ArrayList<String>();
			prdCodeList = new ArrayList<String>();

			parentNodeList = dom.getElementsByTagName("Detail2");
			for(int row = 0; row <parentNodeList.getLength() ; row++)
			{
				parentNode = parentNodeList.item(row);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);				
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("attribute"))
					{
						updateFlag =   childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
					else if (childNodeName.equalsIgnoreCase("line_no"))
					{
						if(childNode.getFirstChild()!= null)
						{
							lineNo = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("loan_no"))
					{
						if(childNode.getFirstChild()!= null)
						{
							loanNo =  childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("amount"))
					{
						if(childNode.getFirstChild()!= null)
						{
							amount = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("no_inst"))
					{
						if(childNode.getFirstChild()!= null)
						{
							noInst = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("no_inst_ded"))
					{
						if(childNode.getFirstChild()!= null)
						{
							noInstDed = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("prd_code"))
					{
						if(childNode.getFirstChild()!= null)
						{
							prdCode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
				}
				updateFlagList.add(updateFlag);
				lineNoList.add(lineNo);
				loanNoList.add(loanNo);
				amountList.add(amount);
				noInstList.add(noInst);
				noInstDedList.add(noInstDed);
				prdCodeList.add(prdCode);


				lineNo = "";loanNo = "";amount = "";noInst = "";instDed = "";prdCode = "";noInstDed = "";updateFlag = "";
			}
			int lineNoarrayListsize =  lineNoList.size();

			sql = "select count(1) as cnt from loans_schedule_det where loan_no = ? and line_no = ? and process_type = 'PY'";

			pstmtDet = conn.prepareStatement(sql);

			sql = "select count(1) as cnt from loans_schedule_det where loan_no = ? and line_no > ? and process_type = 'PY'";

			pstmtDet1 = conn.prepareStatement(sql);

			sql = "select no_inst, amount, prd_code  from loans_schedule where loan_no = ? and line_no = ? ";

			pstmtDet2 = conn.prepareStatement(sql);

			for(int liCount = 0;liCount <= lineNoarrayListsize;liCount++)
			{
				updateFlag = updateFlagList.get(liCount);
				lineNo = lineNoList.get(liCount);
				loanNo = loanNoList.get(liCount);
				prdCode = prdCodeList.get(liCount);
				noInst = noInstList.get(liCount);
				noInstDed = noInstDedList.get(liCount);
				amount = amountList.get(liCount);

				sql = "";
				cnt = 0;
				currLineInstUsed = 0;
				noOfInstOld = 0;
				noOfInstCurrent = 0;
				amountOld = 0d;
				amountCurrent = 0d;
				prdCodeCurrent = "";
				prdCodeOld = "";
				isNextLineUsed = false;

				pstmtDet.setString(1, loanNo);
				pstmtDet.setString(2, lineNo);
				resultSet = pstmtDet.executeQuery();
				if(resultSet.next())
				{
					currLineInstUsed = resultSet.getInt("cnt");
				}
				if (resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				pstmtDet.clearParameters();

				pstmtDet1.setString(1, loanNo);
				pstmtDet1.setString(2, lineNo);
				resultSet = pstmtDet1.executeQuery();
				if(resultSet.next())
				{
					cnt = resultSet.getInt("cnt");
					if (cnt > 0)
					{
						isNextLineUsed = true;
					}
				}
				if (resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				pstmtDet1.clearParameters();

				pstmtDet2.setString(1, loanNo);
				pstmtDet2.setString(2, lineNo);
				resultSet = pstmtDet2.executeQuery();
				if(resultSet.next())
				{
					noOfInstOld = resultSet.getInt("no_inst");
					amountOld = resultSet.getDouble("amount");
					prdCodeOld = resultSet.getString("prd_code");
				}
				if (resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				pstmtDet2.clearParameters();

				if (updateFlag != null && updateFlag.equalsIgnoreCase("D"))
				{
					if (currLineInstUsed > 0)
					{
						errCode = "VTPRES";
						errString = getErrorString("line_no", errCode, userId);
						break;
					}
				}
				else
				{
					if(((noInst == null || noInst.trim().length() == 0) && (prdCode == null || prdCode.trim().length()== 0)))
					{
						numOfNullInst++;
						System.out.println(numOfNullInst+"[numOfNullInst]");
						if(numOfNullInst > 1)
						{
							errCode = "VTLNINST";
							errString = getErrorString("line_no", errCode, userId);	
							break;
						}
					}
					else if(noInst == null && prdCode != null)
					{
						errCode = "VTLNSCH4";
						errString = getErrorString("line_no", errCode, userId);	
						break;
					}
					else if (currLineInstUsed > 0)
					{
						amountCurrent = Double.parseDouble(amount);
						int noInstCurrent = 0;
						if (noInst != null)
						{
							noInstCurrent = Integer.parseInt(noInst);
						}
						else
						{
							noInstCurrent = 0;
						}
						if (prdCodeOld == null)
						{
							prdCodeOld = "";
						}
						if (prdCode == null)
						{
							prdCodeCurrent = "";
						}
						else
						{
							prdCodeCurrent = prdCode;
						}
						if (amountCurrent != amountOld || prdCodeOld != prdCodeCurrent)
						{
							errCode = "VTLNSCH2";
							errString = getErrorString("line_no", errCode, userId);	
							break;
						}
						if (noInstCurrent > 0 && noInstCurrent < currLineInstUsed)
						{
							errCode = "VTLNSCH1";
							errString = getErrorString("line_no", errCode, userId);	
							break;
						}
						if (isNextLineUsed && noInstCurrent > 0 && noInstCurrent > currLineInstUsed )
						{
							errCode = "VTLNSCH1";
							errString = getErrorString("line_no", errCode, userId);	
							break;
						}
					}
				}
			}
		}
		catch(Exception e)
		{			
			e.printStackTrace();
			errString = e.getMessage();
		}
		finally
		{
			try
			{
				if(resultSet != null )
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmtDet != null )
				{
					pstmtDet.close();
					pstmtDet = null;
				}
				if(pstmtDet1 != null )
				{
					pstmtDet1.close();
					pstmtDet1 = null;
				}
				if(pstmtDet2 != null )
				{
					pstmtDet2.close();
					pstmtDet2 = null;
				}
			}
			catch(Exception d)
			{
				System.out.println("Exception :LoanSchedulePrs : :==>\n"+d.getMessage());
				d.printStackTrace();
			}
		}		
		return errString;
	}
}
