package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "PRODUCT")
@XmlRootElement(name = "Product")
public class Product implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name = "PRODUCT_CODE")
	private String productCode;

	@Column(name = "DESCR")
	private String descr;

	@Column(name = "SH_DESCR")
	private String shDescr;

	@Column(name = "PRODUCT_TYPE")
	private String productType;

	@Column(name = "BRAND_CODE")
	private String brandCode;

	@Column(name = "ITEM_SER")
	private String itemSer;

	@Column(name = "ADD_USER")
	private String addUser;

	@Column(name = "ADD_TERM")
	private String addTerm;

	@Column(name = "ADD_DATE")
	private String addDate;

	@Column(name = "CHG_USER")
	private String chgUser;

	@Column(name = "CHG_TERM")
	private String chgTerm;

	@Column(name = "CHG_DATE")
	private String chgDate;

	public Product() {
	}

	public Product(String productCode, String descr, String shDescr, String productType, String brandCode, String itemSer, String addUser, String addTerm, String addDate, String chgUser, String chgTerm, String chgDate) 
	{
		this.productCode = productCode;
		this.descr = descr;
		this.shDescr = shDescr;
		this.productType = productType;
		this.brandCode = brandCode;
		this.itemSer = itemSer;
		this.addUser = addUser;
		this.addTerm = addTerm;
		this.addDate = addDate;
		this.chgUser = chgUser;
		this.chgTerm = chgTerm;
		this.chgDate = chgDate;
	}

	public String getProductCode() {
		return productCode;
	}

	@XmlElement
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getDescr() {
		return descr;
	}

	@XmlElement
	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getShDescr() {
		return shDescr;
	}

	@XmlElement
	public void setShDescr(String shDescr) {
		this.shDescr = shDescr;
	}

	public String getProductType() {
		return productType;
	}

	@XmlElement
	public void setProductType(String productType) {
		this.productType = productType;
	}

	public String getBrandCode() {
		return brandCode;
	}

	@XmlElement
	public void setBrandCode(String brandCode) {
		this.brandCode = brandCode;
	}

	public String getItemSer() {
		return itemSer;
	}

	@XmlElement
	public void setItemSer(String itemSer) {
		this.itemSer = itemSer;
	}

	public String getAddUser() {
		return addUser;
	}

	@XmlElement
	public void setAddUser(String addUser) {
		this.addUser = addUser;
	}

	public String getAddTerm() {
		return addTerm;
	}

	@XmlElement
	public void setAddTerm(String addTerm) {
		this.addTerm = addTerm;
	}

	public String getAddDate() {
		return addDate;
	}

	@XmlElement
	public void setAddDate(String addDate) {
		this.addDate = addDate;
	}

	public String getChgUser() {
		return chgUser;
	}

	@XmlElement
	public void setChgUser(String chgUser) {
		this.chgUser = chgUser;
	}

	public String getChgTerm() {
		return chgTerm;
	}

	@XmlElement
	public void setChgTerm(String chgTerm) {
		this.chgTerm = chgTerm;
	}

	public String getChgDate() {
		return chgDate;
	}

	@XmlElement
	public void setChgDate(String chgDate) {
		this.chgDate = chgDate;
	}

	@Override
	public String toString() {
		return "\n Product.toString >> [" + new JSONObject(this).toString() + "]";
	}

}
