package proteus.ecm.cache.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.hibernate.bean.Country;
import proteus.ecm.hibernate.bean.SiteItem;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.bean.State;

public class SystemCache 
{
	// #####################################################################
	//  SiteMaster
	// #####################################################################
	public void storeSites( List<SiteMaster> sites, String cacheName )
	{
		System.out.println("Inside storeSites >>" + cacheName);
		try 
		{
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for(SiteMaster site : sites)
			{
				cache.put(site.getSiteCode(), site);
			}
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeSites----\n");
			e.printStackTrace();
		}
	}

	// @RestService == > "/sys/site"
	public List<SiteMaster> getCachedSites(String cacheName)
	{
		System.out.println("Inside getCachedSites >>" + cacheName);
		List<SiteMaster> sites = null;
		try 
		{
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);

			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(SiteMaster.class).build();
			System.out.println(" getCachedSites Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				sites = query.list();
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException  e) 
		{
			System.out.println("getCachedSites()---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return sites;
	}

	// @RestService == > "/sys/site/{siteCode}"
	public SiteMaster getCachedSite(String siteCode, String cacheName) 
	{
		System.out.println("Inside getCachedSite >>" + cacheName);
		SiteMaster site = null;
		try 
		{
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(SiteMaster.class).having("siteCode").eq(siteCode).toBuilder().build();
			System.out.println("getCachedSite(single) Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				List<SiteMaster> sites = query.list();
				if(sites != null && sites.size() > 0)
				{
					site = sites.get(0);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedSite()---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause());
			e.printStackTrace();
		}
		return site;
	}

	// #####################################################################
	//  SiteItem
	// #####################################################################
	public void storeSiteItems(List<SiteItem> siteItems, String cacheName )
	{
		System.out.println("Inside storeSiteItems >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			HashMap<String, JSONObject> itemsTotMap = new HashMap<String, JSONObject>();
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for(SiteItem siteItem : siteItems)
			{
				cache.put(siteItem.getSiteCode() + "_" + siteItem.getItemCode(), siteItem);
				
				String key = siteItem.getScatCode();
				
				JSONObject scatObj = itemsTotMap.get(key);
				if( scatObj == null ){
					scatObj = new JSONObject();
					scatObj.put("count", 0);
					scatObj.put("list", new JSONObject());
				}
				
				JSONObject itemObj = scatObj.getJSONObject("list");
				itemObj.put(siteItem.getItemCode(), new JSONObject() );
				
				int cnt = scatObj.getInt("count");
				if( cnt > 0 ) {
					cnt++;
				}
				else
				{
					cnt = 1;
				}
				
				scatObj.put("count", cnt);
				scatObj.put("list", itemObj);
				itemsTotMap.put(key, scatObj);
			}
			cache.put("TOTAL_ITEMS", itemsTotMap);
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException | JSONException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeSites----\n");
			e.printStackTrace();
		}
	}

	// @RestService == > "/sys/siteitems/{siteCode}"
	public List<SiteItem> getCachedSiteItems(String siteCode, String cacheName)
	{
		System.out.println("Inside getCachedSiteItems >>" + cacheName);
		List<SiteItem> sites = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(SiteItem.class).having("siteCode").eq(siteCode).toBuilder().build();
			System.out.println("getCachedSiteItems Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				sites = query.list();
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedSiteItems()---- Exception type : " +e.getClass().getName() + "]"+e+"[" + e.getCause());
			e.printStackTrace();
		}
		return sites;
	}
	
	public List<String> getSiteItemsByScatCode(String siteCode, List<String> scatCodeList, String cacheName)
	{
		System.out.println("Inside getSiteItemsByScatCode >>" + cacheName);
		List<String> itemCodeList = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(SiteItem.class).having("siteCode").eq(siteCode).and().having("scatCode").in(scatCodeList).toBuilder().build();
			System.out.println(" getSiteItemsByScatCode Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				List<SiteItem> sites = query.list();
	 		    itemCodeList = new ArrayList<String>();
			    for(SiteItem siteItem : sites)
			    {
				   itemCodeList.add(siteItem.getItemCode());
			    }
			}
			System.out.println("getSiteItemsByScatCode[ " + siteCode + "][ " + scatCodeList + "][ " + itemCodeList + "]");
			
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getSiteItemsByScatCode()---- Exception type : " +e.getClass().getName() + "]"+e+"[" + e.getCause());
			e.printStackTrace();
		}
		return itemCodeList;
	}

	public SiteItem getCachedSiteItem(String siteCode, String itemCode, String cacheName) 
	{
		System.out.println("Inside getCachedSiteItem >>" + cacheName);
		SiteItem siteItem = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(SiteItem.class).having("siteCode").eq(siteCode).and().having("itemCode").eq(itemCode).toBuilder().build();
			System.out.println(" getCachedSiteItem Query Result Size:" + query.getResultSize());
			
			// Execute the query
			List<SiteItem> sites = query.list();
			if( ! sites.isEmpty() )
			{
				siteItem = sites.get(0);
			}
			System.out.println("getCachedSiteItem[ " + siteCode + "][ " + itemCode + "][ " + siteItem + "]");
			
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedSiteItem()---- Exception type : " +e.getClass().getName() + "]"+e+"[" + e.getCause());
			e.printStackTrace();
		}
		return siteItem;
	}

	public String getVerificationCode(String userCode) {
	    System.out.println("Inside getVerificationCode >>" + CacheManager.SYSTEM_CACHE_NAME);
	    String varCode = null;
	    try
	    {
	      Cache cache = CacheManager.getInstance().getCache(CacheManager.SYSTEM_CACHE_NAME);
	      if (cache.get(userCode) != null) {
	        varCode = (String)cache.get(userCode);
	      }
	      System.out.println("Inside getVerificationCode  varCode>>" + varCode);
	    }
	    catch (SecurityException|IllegalStateException|CacheException e)
	    {
	      System.out.println("getVerificationCode()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
	      e.printStackTrace();
	    }
	    return varCode;
    }

	public void storeVerificationCode(String userCode, String varCode) {
	    System.out.println("Inside storeVerificationCode >>" + CacheManager.SYSTEM_CACHE_NAME);
	    try
	    {
	      Cache cache = CacheManager.getInstance().getCache(CacheManager.SYSTEM_CACHE_NAME);
	      TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
	      tm.begin();
	      cache.put(userCode, varCode, 5, TimeUnit.MINUTES);
	      tm.commit();
	    }
	    catch (SecurityException|IllegalStateException|RollbackException|HeuristicMixedException|HeuristicRollbackException|NotSupportedException|SystemException|CacheException e)
	    {
	      System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeVerificationCode----\n");
	      e.printStackTrace();
	    }
    }
	
// #####################################################################
//  State
// #####################################################################
	
   public List<State> getCachedStates(String cacheName, String descr)
   {
     System.out.println("Inside getCachedStates >>" + cacheName);
     List states = null;
     try
     {
       Cache cache = CacheManager.getInstance().getCache(cacheName);
 
       QueryFactory queryFactory = Search.getQueryFactory(cache);
       descr = descr != null ? descr.toLowerCase() : "";
 
       Query query = queryFactory.from(State.class).having("ldescr").like(descr + "%").toBuilder().build();
       System.out.println(" getCachedStates Query Result Size:" + query.getResultSize() + query.toString());
 
       if (query.getResultSize() > 0)
       {
         states = query.list();
       }
	    }
	    catch (SecurityException|IllegalStateException|CacheException e)
	    {
	       System.out.println("getCachedStates()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
	       e.printStackTrace();
	    }
	     System.out.println("Return getCachedStates >>" + states);
	     return states;
	  }
	
	  public State getCachedState(String cacheName, String stateCode)
	  {
	     State state = null;
	     System.out.println("Inside getCachedState >>" + cacheName + stateCode);
	    try
	    {
	       if (stateCode == null) {
	         return null;
	      }
	       Cache cache = CacheManager.getInstance().getCache(cacheName);
	
	       QueryFactory queryFactory = Search.getQueryFactory(cache);
	
	       Query query = queryFactory.from(State.class).having("stateCode").eq(stateCode).toBuilder().build();
	       System.out.println(" getCachedState Query Result Size:" + query.getResultSize() + query.toString());
	
	       if (query.getResultSize() > 0)
	      {
	         List states = query.list();
	         state = (State)states.get(0);
	      }
	    }
	    catch (SecurityException|IllegalStateException|CacheException e)
	    {
	       System.out.println("getCachedState()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
	       e.printStackTrace();
	    }
	     System.out.println("Return getCachedState >State> " + state);
	     return state;
	  }
	
	  public void storeStates(List<State> allStates, String cacheName)
	  {
	     System.out.println("Inside storeSites >>" + cacheName + allStates);
	    try
	    {
	       Cache cache = CacheManager.getInstance().getCache(cacheName);
	       TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
	       tm.begin();
	       for (State state : allStates)
	      {
	         String ldescr = state.getDescr();
	         ldescr = ldescr != null ? ldescr.toLowerCase() : "";
	         state.setLdescr(ldescr);
	         cache.put(state.getStateCode(), state);
	      }
	       tm.commit();
	    }
	    catch (SecurityException|IllegalStateException|RollbackException|HeuristicMixedException|HeuristicRollbackException|NotSupportedException|SystemException|CacheException e)
	    {
	       System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeStates----\n");
	       e.printStackTrace();
	    }
	  }
	
	
// #####################################################################
//  Country
// #####################################################################
	
	  public List<Country> getCachedCountries(String cacheName, String descr)
	  {
	     System.out.println("Inside getCachedCountries >>" + cacheName);
	     List countries = null;
	    try
	    {
	       Cache cache = CacheManager.getInstance().getCache(cacheName);
	
	       QueryFactory queryFactory = Search.getQueryFactory(cache);
	       descr = descr != null ? descr.toLowerCase() : "";
	
	       Query query = queryFactory.from(Country.class).having("ldescr").like(descr + "%").toBuilder().build();
	       System.out.println(" getCachedCountries Query Result Size:" + query.getResultSize() + query.toString());
	
	       if (query.getResultSize() > 0)
	      {
	         countries = query.list();
	      }
	    }
	    catch (SecurityException|IllegalStateException|CacheException e)
	    {
	       System.out.println("getCachedCountries()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
	       e.printStackTrace();
	    }
	     System.out.println("Return getCachedCountries >>" + countries);
	     return countries;
	  }
	
	  public Country getCachedCountry(String cacheName, String countCode)
	  {
	     Country country = null;
	     System.out.println("Inside getCachedCountry >>" + cacheName + countCode);
	    try
	    {
	       if (countCode == null) {
	         return null;
	      }
	       Cache cache = CacheManager.getInstance().getCache(cacheName);
	
	       QueryFactory queryFactory = Search.getQueryFactory(cache);
	
	       Query query = queryFactory.from(Country.class).having("countCode").eq(countCode).toBuilder().build();
	       System.out.println(" getCachedCountry Query Result Size:" + query.getResultSize() + query.toString());
	
	       if (query.getResultSize() > 0)
	      {
	         List countries = query.list();
	         country = (Country)countries.get(0);
	      }
	    }
	    catch (SecurityException|IllegalStateException|CacheException e)
	    {
	       System.out.println("getCachedCountry()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
	       e.printStackTrace();
	    }
	     System.out.println("Return getCachedCountry >country> " + country);
	     return country;
	  }
	
	  public void storeCountries(List<Country> allCountries, String cacheName)
	  {
	     System.out.println("Inside storeSites >>" + cacheName + allCountries);
	    try
	    {
	       Cache cache = CacheManager.getInstance().getCache(cacheName);
	       TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
	       tm.begin();
	       for (Country country : allCountries)
	      {
	         String ldescr = country.getDescr();
	         ldescr = ldescr != null ? ldescr.toLowerCase() : "";
	         country.setLdescr(ldescr);
	         cache.put(country.getCountCode(), country);
	      }
	       tm.commit();
	    }
	    catch (SecurityException|IllegalStateException|RollbackException|HeuristicMixedException|HeuristicRollbackException|NotSupportedException|SystemException|CacheException e)
	    {
	       System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeCountries----\n");
	       e.printStackTrace();
	    }
	  }
}
