package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "SITEITEM")
@XmlRootElement(name = "SiteItem")
public class SiteItem implements java.io.Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "SITE_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String siteCode;

	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name = "ITEM_CODE")
	private String itemCode;

	@Column(name = "ECM_TYPE")
	private String ecmType;

	@Column(name = "SCAT_CODE")
	private String scatCode;

	
	public String getSiteCode() {
		return siteCode;
	}

	public String getItemCode() {
		return itemCode;
	}

	public String getEcmType() {
		return ecmType;
	}

	public String getScatCode() {
		return scatCode;
	}

	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}

	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public void setEcmType(String ecmType) {
		this.ecmType = ecmType;
	}

	public void setScatCode(String scatCode) {
		this.scatCode = scatCode;
	}
	
	@Override
	public String toString(){
		return "\n SiteItem.toString >> [" + new JSONObject(this).toString() + "]";
	}

}
