import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import { ItemDetail } from '../ecm-model/product-detail-model';
import { Store } from '@ngrx/store';

import {AppState} from '../ecm-store/reducers';
import {OrderActions} from '../ecm-store/actions';
import { Order } from '../ecm-model/order-model';
import { HostUrlService } from '../host-url.service';

@Injectable()
export class EcmOrderService {
    private orderActionUrl = '/ecm/service/orders';
    
    orderItems: Order[];
    
    constructor( private http: Http, private store: Store<AppState>, public hostUrlService : HostUrlService ) { }

    fetchOrder(): Observable<Order[]> {
        console.log( "fetch Orders Called" );
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
  
        return this.http.get( this.hostUrlService.hostUrl+this.orderActionUrl, options )
                   .map( (res) => this.extractData(res) )
                   .catch(this.handleError);
    }

    addToOrder(order) {
        console.log( "add orders StoreInOrders Called" );
        console.log(JSON.stringify(order));
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
        
       return this.http.post( this.hostUrlService.hostUrl+this.orderActionUrl, JSON.stringify(order) , options)
            .map( (res) => this.extractData(res) );
    }
    
    updateOrder( order ) {
        console.log( "add orders StoreInOrders Called" );
        console.log(JSON.stringify(order));
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });

        return this.http.post( this.hostUrlService.hostUrl+this.orderActionUrl, JSON.stringify(order) , options)
            .map( (res) => this.extractData(res) );
    }
    
//    
//    cancelOrder(itemCode) {
//        let headers = new Headers( { 'Content-Type': 'application/json' });
//        let options = new RequestOptions( { headers: headers });
//        
//        return this.http.delete( '/ibase/ecm/service/order'+itemCode, options)
//                    .map( (res) => this.extractData(res) );
//    }
    
    
    cancelOrder( order: Order ) {
        console.log( "deleteUserOrder Called", order);

        return this.http.delete( this.orderActionUrl + 'card/' + order.itemCode, {})
            .map( res => res.json() );

    }

    private extractData( res: Response ) {
        let respJson = res.json();
        console.log( 'extracData', respJson );
        if ( respJson != null ) {
            for ( let key of Object.keys( respJson ) ) {
                console.log( "getOrder Order ==> key: " + key )
                let data = respJson[key];

                try {
                    respJson[key] = JSON.parse( data );
                    console.log( "getOrder Orde try : " + respJson[key] );
                }
                catch ( e ) {
                    console.log( "getOrder Orde ==> key: ", data, typeof data === 'object' )
                    if ( typeof data === 'object' )
                        respJson[key] = this.formatObject( data );
                    else
                        respJson[key] = data;
                    console.log( "getOrder Orde catch : " + respJson[key] );
                }
            }
            console.log( 'extractData[' + JSON.stringify( respJson ) + ']' );
        }
        return respJson || {};
    }

    formatObject( respJson: any ) {

        console.log( 'formatObject', respJson );
        if ( respJson != null ) {
            for ( let key of Object.keys( respJson ) ) {
                console.log( "formatObject Order ==> key: " + key )
                let data = respJson[key];
                try {
                    respJson[key] = JSON.parse( data );
                    console.log( "formatObject Order try : " + respJson[key] );
                }
                catch ( e ) {
                    respJson[key] = data;
                    console.log( "formatObject itemDetail catch : " + respJson[key] );
                }
            }
            console.log( 'formatObject[' + JSON.stringify( respJson ) + ']' );
        }
        return respJson || {};
    }

    private handleError( error: Response | any ) {
        // In a real world app, we might use a remote logging infrastructure
        let errMsg: string;
        if ( error instanceof Response ) {
            const body = error.json() || '';
            const err = body.error || JSON.stringify( body );
            errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
        } else {
            errMsg = error.message ? error.message : error.toString();
        }
        console.error( 'Service handleError:' + errMsg );
        return Observable.throw( errMsg );
    }
}
