import { Directive, ElementRef, HostListener, Output, EventEmitter } from '@angular/core';
import { CreditCard } from './credit-card';
var CreditCardFormatDirective = (function () {
    function CreditCardFormatDirective(el) {
        this.el = el;
        this.changeType = new EventEmitter();
        this.setCardLength = new EventEmitter();
        this.target = this.el.nativeElement;
        this.cards = CreditCard.cards();
    }
    CreditCardFormatDirective.prototype.onKeypress = function (e) {
        if (CreditCard.restrictNumeric(e)) {
            if (CreditCard.isCardNumber(e.which, this.target)) {
                this.formatCardNumber(e);
            }
        }
        else {
            e.preventDefault();
            return false;
        }
    };
    CreditCardFormatDirective.prototype.onKeydown = function (e) {
        this.formatBackCardNumber(e);
    };
    CreditCardFormatDirective.prototype.onKeyup = function (e) {
        this.setCardType(e);
    };
    CreditCardFormatDirective.prototype.onPaste = function (e) {
        this.reFormatCardNumber(e);
    };
    CreditCardFormatDirective.prototype.onChange = function (e) {
        this.reFormatCardNumber(e);
    };
    CreditCardFormatDirective.prototype.onInput = function (e) {
        this.reFormatCardNumber(e);
        this.setCardType(e);
    };
    CreditCardFormatDirective.prototype.formatCardNumber = function (e) {
        var _this = this;
        var card, digit, length, re, upperLength, value;
        digit = String.fromCharCode(e.which);
        if (!/^\d+$/.test(digit)) {
            return;
        }
        value = this.target.value;
        card = CreditCard.cardFromNumber(value + digit);
        length = (value.replace(/\D/g, '') + digit).length;
        upperLength = 16;
        if (card) {
            upperLength = card.length[card.length.length - 1];
        }
        this.cardLength = upperLength;
        if (length >= upperLength) {
            return;
        }
        if ((this.target.selectionStart != null) && this.target.selectionStart !== value.length) {
            // return;
        }
        if (card && card.type === 'amex') {
            re = /^(\d{4}|\d{4}\s\d{6})$/;
        }
        else {
            re = /(?:^|\s)(\d{4})$/;
        }
        if (re.test(value)) {
            e.preventDefault();
            setTimeout(function () {
                _this.target.value = value + " " + digit;
            });
        }
        else if (re.test(value + digit)) {
            e.preventDefault();
            setTimeout(function () {
                _this.target.value = "" + value + digit + " ";
            });
        }
    };
    CreditCardFormatDirective.prototype.formatBackCardNumber = function (e) {
        var _this = this;
        var value = this.target.value;
        if (e.which !== 8) {
            return;
        }
        if ((this.target.selectionStart != null) && this.target.selectionStart !== value.length) {
            // return;
        }
        if (/\d\s$/.test(value)) {
            e.preventDefault();
            setTimeout(function () {
                _this.target.value = value.replace(/\d\s$/, '');
            });
        }
        else if (/\s\d?$/.test(value)) {
            e.preventDefault();
            setTimeout(function () {
                _this.target.value = value.replace(/\d$/, '');
            });
        }
    };
    CreditCardFormatDirective.prototype.setCardType = function (e) {
        var card, val = this.target.value, cardType = CreditCard.cardType(val) || 'unknown';
        if (!this.target.classList.contains(cardType)) {
            for (var i = 0, len = this.cards.length; i < len; i++) {
                card = this.cards[i];
                this.target.classList.remove(card.type);
            }
            this.target.classList.remove('unknown');
            this.target.classList.add(cardType);
            this.changeType.emit(cardType);
            this.setCardLength.emit(this.cardLength);
            this.target.classList.toggle('identified', cardType !== 'unknown');
        }
    };
    CreditCardFormatDirective.prototype.reFormatCardNumber = function (e) {
        var _this = this;
        setTimeout(function () {
            var value = CreditCard.replaceFullWidthChars(_this.target.value);
            value = CreditCard.formatCardNumber(value);
            _this.target.selectionStart = _this.target.selectionEnd = CreditCard.safeVal(value, _this.target);
        });
    };
    CreditCardFormatDirective.decorators = [
        { type: Directive, args: [{
                    selector: '[ccNumber]'
                },] },
    ];
    /** @nocollapse */
    CreditCardFormatDirective.ctorParameters = function () { return [
        { type: ElementRef, },
    ]; };
    CreditCardFormatDirective.propDecorators = {
        'changeType': [{ type: Output },],
        'setCardLength': [{ type: Output },],
        'onKeypress': [{ type: HostListener, args: ['keypress', ['$event'],] },],
        'onKeydown': [{ type: HostListener, args: ['keydown', ['$event'],] },],
        'onKeyup': [{ type: HostListener, args: ['keyup', ['$event'],] },],
        'onPaste': [{ type: HostListener, args: ['paste', ['$event'],] },],
        'onChange': [{ type: HostListener, args: ['change', ['$event'],] },],
        'onInput': [{ type: HostListener, args: ['input', ['$event'],] },],
    };
    return CreditCardFormatDirective;
}());
export { CreditCardFormatDirective };
//# sourceMappingURL=credit-card-format.directive.js.map