/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessorFC;
import org.apache.solr.search.facet.UnInvertedField;

class FacetFieldProcessorUIF
extends FacetFieldProcessorFC {
    UnInvertedField uif;
    TermsEnum te;

    FacetFieldProcessorUIF(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    protected void findStartAndEndOrds() throws IOException {
        this.uif = UnInvertedField.getUnInvertedField(((FacetField)this.freq).field, this.fcontext.searcher);
        this.te = this.uif.getOrdTermsEnum(this.fcontext.searcher.getLeafReader());
        this.startTermIndex = 0;
        this.endTermIndex = this.uif.numTerms();
        if (this.prefixRef != null && this.te != null) {
            this.startTermIndex = this.te.seekCeil(this.prefixRef.get()) == TermsEnum.SeekStatus.END ? this.uif.numTerms() : (int)this.te.ord();
            this.prefixRef.append(UnicodeUtil.BIG_TERM);
            this.endTermIndex = this.te.seekCeil(this.prefixRef.get()) == TermsEnum.SeekStatus.END ? this.uif.numTerms() : (int)this.te.ord();
        }
        this.nTerms = this.endTermIndex - this.startTermIndex;
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.uif.getTermValue(this.te, ord);
    }

    @Override
    protected void collectDocs() throws IOException {
        this.uif.collectDocs(this);
    }
}

