/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.stateful.BaseStatefulRemoteProxyFactory;
import org.jboss.ejb3.proxy.handler.BaseSessionRemoteProxyInvocationHandler;
import org.jboss.ejb3.proxy.handler.stateful.StatefulHomeRemoteProxyInvocationHandler;
import org.jboss.ejb3.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulRemoteProxyFactory
extends BaseStatefulRemoteProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulRemoteProxyFactory.class);
    private static final String STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS = "StatefulSessionClientInterceptors";

    public StatefulRemoteProxyFactory(SessionSpecContainer container, RemoteBinding binding) {
        super(container, binding);
    }

    @Override
    public void start() throws Exception {
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        String targetId = this.getTargetId();
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.getBinding());
        Object factoryProxy = this.createPojiProxy(targetId, interfaces, clientBindUrl);
        String jndiName = this.getJndiName();
        log.debug((Object)("Binding proxy factory for " + this.getContainer().getEjbName() + " in JNDI at " + jndiName + "StatefulProxyFactory" + " with client bind url " + clientBindUrl));
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(jndiName + "StatefulProxyFactory"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful remote proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        assert (!Dispatcher.singleton.isRegistered((Object)targetId)) : targetId + " is already registered";
        Dispatcher.singleton.registerTarget((Object)targetId, (Object)this);
        SessionSpecContainer statefulContainer = this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statefulContainer.getAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether()) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            String homeJndiName = ProxyFactoryHelper.getHomeJndiName((EJBContainer)statefulContainer);
            log.debug((Object)("Binding home proxy at " + homeJndiName));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)homeJndiName, (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        String jndiName = this.getJndiName();
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(jndiName + "StatefulProxyFactory"));
        Dispatcher.singleton.unregisterTarget((Object)this.getTargetId());
        SessionSpecContainer statefulContainer = this.getContainer();
        RemoteHome remoteHome = statefulContainer.getAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether()) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getHomeJndiName((EJBContainer)this.getContainer()));
        }
        super.stop();
    }

    public Object createHomeProxy(Class<?> homeInterface) {
        try {
            AdviceStack stack;
            String stackName = STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
            RemoteBinding binding = this.getBinding();
            if (binding.interceptorStack() != null && !binding.interceptorStack().trim().equals("")) {
                stackName = binding.interceptorStack();
            }
            if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
                throw new RuntimeException("unable to find interceptor stack: " + stackName);
            }
            StatefulHomeRemoteProxyInvocationHandler proxy = new StatefulHomeRemoteProxyInvocationHandler((Container)this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), this.getLocator());
            this.setEjb21Objects(proxy);
            Class[] intfs = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), intfs, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setEjb21Objects(BaseSessionRemoteProxyInvocationHandler proxy) {
        proxy.setHandle(this.createHandle());
        proxy.setHomeHandle(this.getHomeHandle());
        proxy.setEjbMetaData(this.getEjbMetaData());
    }

    @Override
    protected Class<?> getHomeType() {
        return ProxyFactoryHelper.getRemoteHomeInterface((Container)this.getContainer());
    }

    @Override
    String getStackNameInterceptors() {
        return STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
    }

    protected String getTargetId() {
        String jndiName = this.getJndiName();
        assert (jndiName != null) : "jndiName is null";
        return jndiName + "StatefulProxyFactory";
    }

    protected Object createPojiProxy(Object oid, Class<?>[] interfaces, String uri) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }
}

