/********************************************************
	Title : ShipmentIC
	Date  : 01/06/2012
	Developer: Mahesh Patidar
 ********************************************************/

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
//changed by sankara on 15/10/13 for clubing multiple ptcn
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@javax.ejb.Stateless
public class ShipmentIC extends ValidatorEJB implements ShipmentICRemote,ShipmentICLocal
{

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("WFVALDATA 111111");
		//changed by sankara on 15/10/13 for clubing multiple ptcn
		ibase.webitm.utility.wms.CommonWmsUtil.ALL_PTCN_EX_COUNT = 0;
		try
		{
			System.out.println("xmlString [" + xmlString + "]");
			System.out.println("xmlString1 [" + xmlString1 + "]");
			System.out.println("xmlString2 [" + xmlString2 + "]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: ShipmentIC: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();

			throw new ITMException(e);
		}
		System.out.println ( "Returning from ShipmentIC wfValData" );
		return ( errString ); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext,String editFlag, String xtraParams ) throws RemoteException, ITMException
	{
		String errString = "";
		//Changed by sumit on 22/09/12 create refSer variable.
		String refSer = "";
		ResultSet rs = null,rs1=null;
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1=null;
        GenericUtility genericUtility = GenericUtility.getInstance();
		
		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		NodeList parentList = null;
		NodeList parentNodeList = null;
		NodeList childList = null;
		Node parentNode= null;
		int noOfChilds ;
		String childNodeName = "";
		Node childNode =null;
		String userId = "",tranCodeHdr="";
		ArrayList arrayList = null;//Added by sumit on 23/01/13
		
		int cnt = 0;
		int ctr2 = 0;
		int lineNo = 0;
		int parentNodeListLength= 0;
		String columnValue = "";
		String columnValue1 = "",tranCode="";
		String sql = "";
		//Chnaged by Rohan on 31-07-13 for define variable.start
		String status ="";
		String palletNo = "";
		String cartonNo = "";
		String refId = "";
		//changed by sankara on 16/06/14 for duplicate pro number.
		String pronumber = "";
		String shipmentid = "";
		java.util.Date tranDate = null;
		String prdCode = "",siteCode="";
		//Chnaged by Rohan on 31-07-13 for define variable.end
		int currentFormNo = 0;		
		long pronoFromAmt = 0;		
		long pronoToAmt = 0;		
		long pronoLastAmt = 0;
		ConnDriver connDriver = null;
		//changed by sankara on 15/10/13 for clubing multiple ptcn
		ibase.webitm.utility.wms.CommonWmsUtil.ALL_PTCN_EX_COUNT = 0;
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			switch(currentFormNo)
			{
				case 1 :
				{
					parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if ( childNodeName.equalsIgnoreCase("shipment_date") )
						{
							columnValue = genericUtility.getColumnValue("shipment_date", dom);
							if(columnValue == null || columnValue.trim().length() == 0)
							{
								errList.add( "VTSHPDT" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						/*else if ( childNodeName.equalsIgnoreCase("shipment_id") )
						{
							columnValue = genericUtility.getColumnValue("shipment_id", dom);
							if(columnValue == null || columnValue.trim().length() == 0)
							{
								errList.add( "VMSHIDNULL" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}*/
						else if ( childNodeName.equalsIgnoreCase("site_code") )
						{
							columnValue = genericUtility.getColumnValue("site_code", dom);
							if(columnValue == null || columnValue.trim().length() == 0)
							{
								errList.add( "VMSITECD1" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								sql = "SELECT COUNT(*) FROM SITE WHERE SITE_CODE IN (SELECT SITE_CODE__SHIP FROM SORDER WHERE SITE_CODE__SHIP = ?)";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, columnValue);
								rs1 = pstmt1.executeQuery();
								if( rs1.next() )
								{
									cnt = rs1.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMSITE" );
										errFields.add( childNodeName.toLowerCase() );		
									}
									else //added by kunal on 15-feb-14 for period code
									{
										
										siteCode = genericUtility.getColumnValue("site_code", dom);
										cnt = 0; 
										System.out.println("364 site code ="+siteCode);
										if (genericUtility.getColumnValue("shipment_date", dom) != null)
										{
											tranDate = sdf1.parse(genericUtility.getColumnValue("shipment_date", dom));
											sql = "select code from period where ?  between fr_date and to_date";
											pstmt = conn.prepareStatement(sql);
											pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												prdCode = rs.getString(1);

											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;

											sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, siteCode);
											pstmt.setString(2, prdCode);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												cnt = rs.getInt(1);

											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;
											if (cnt == 0)
											{
												errList.add( "VTSITEPD" );
												errFields.add( childNodeName.toLowerCase() );
												break;
											}
											// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
											errCode = nfCheckPeriod("IC", tranDate, siteCode);
											System.out.println("425 Error Code = " + errCode);
											if (errCode != null && errCode.trim().length() > 0)
											{
												errList.add(errCode);
												errFields.add( childNodeName.toLowerCase() );
											}
										} 							 
									}//end 
								}
								rs1.close();
								rs1 = null;
								pstmt1.close();
								pstmt1 = null;
							}
							
						}//End of site_code validation
							
					
						/*
						else if ( childNodeName.equalsIgnoreCase("tran_code") )
						{
							columnValue = genericUtility.getColumnValue("tran_code", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from transporter where tran_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMTRAN1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
							else
							{
								errList.add( "VMTRANCD1" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						*/
						else if ( childNodeName.equalsIgnoreCase("stan_code__from") )
						{
							columnValue = genericUtility.getColumnValue("stan_code__from", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from station where stan_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMSTANCD1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("stan_code__to") )
						{
							columnValue = genericUtility.getColumnValue("stan_code__to", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from station where stan_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMSTANCD1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("frt_list") )
						{
							columnValue = genericUtility.getColumnValue("frt_list", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from freight_list where frt_list = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VTFRLEXT" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("curr_code")) 
						{
							columnValue = genericUtility.getColumnValue("curr_code", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "Select Count(*) from currency where curr_code = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VMCUR1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("load_type") )
						{
							columnValue = genericUtility.getColumnValue("load_type",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "select count(*) from gencodes where fld_name = 'LOAD_TYPE' and MOD_NAME = 'X' and fld_value = ?" ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VMLOADTY";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}

						else if ( childNodeName.equalsIgnoreCase("licence_no") )
						{
							columnValue = genericUtility.getColumnValue("licence_no",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "select count(*) from gencodes where fld_name = 'LICENCE_NO'  and fld_value = ?" ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VTLICENCE";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}

						else if ( childNodeName.equalsIgnoreCase("sale_order") )
						{
							columnValue = genericUtility.getColumnValue("sale_order",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "select count(*) from SORDER WHERE SALE_ORDER = ?" ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VTSORDCD1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}

						else if ( childNodeName.equalsIgnoreCase("dist_route") )
						{
							columnValue = genericUtility.getColumnValue("dist_route",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "select count(*) from DISTROUTE WHERE DIST_ROUTE = ?" ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VTDISTRT1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("pro_no") )   //changes lr_no to pro_no as per manoharan  sir
						{
							//changed by sankara on 16/06/14 for pro number duplicates start.
							System.out.println("cc");
							pronumber = checkNull(genericUtility.getColumnValue("pro_no", dom));
						    shipmentid = checkNull(genericUtility.getColumnValue("shipment_id", dom));
							System.out.println("pronumber::::::"+columnValue);
							System.out.println("tranid:::::::"+shipmentid);
							System.out.println("editFlag:::::"+editFlag);
							sql = " SELECT COUNT(*) AS COUNT FROM SHIPMENT WHERE PRO_NO = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, pronumber);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								cnt = rs.getInt("COUNT");
								System.out.println("cnt::::::::"+cnt);
							}
							if( cnt > 0 && !editFlag.equalsIgnoreCase("E") )
							{
								errCode = "VTINVPRONO";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							System.out.println("sankara:::::::");
							if( cnt > 0 && editFlag.equalsIgnoreCase("E") )
							{
								System.out.println("inside editFlag:::::"+editFlag);
								sql = " SELECT COUNT(*) AS COUNT FROM SHIPMENT WHERE PRO_NO = ? AND SHIPMENT_ID <> ? " ;
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, pronumber);
								pstmt1.setString(2, shipmentid);
								rs1 = pstmt1.executeQuery();
								if( rs1.next() )
								{
									cnt = rs1.getInt("COUNT");
									System.out.println("cnt1::::::::"+cnt);
								}
								if( cnt > 0 )
								{
									errCode = "VTINVPRONO";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								rs1.close();
								rs1 = null;
								pstmt1.close();
								pstmt1 = null;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							//changed by sankara on 11/06/14 for pro number duplicates end.
						/*	columnValue = checkNull(genericUtility.getColumnValue("tran_code", dom));
							columnValue1 = checkNull(genericUtility.getColumnValue("pro_no", dom));
							if(columnValue1.trim().length() > 0)
							{
								//columnValue1=columnValue1+"L";
								//pronoLastAmt = Integer.parseInt(columnValue1);
								pronoLastAmt = Long.parseLong(columnValue1);
								sql = "SELECT PRONO_FROM, PRONO_TO from transporter where tran_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									String pronoFrom = checkNull(rs.getString(1));
									String pronoTo = checkNull(rs.getString(2));
									if(pronoFrom.trim().length() > 0)
									{
										pronoFromAmt = Long.parseLong(pronoFrom);
									}
									if(pronoTo.trim().length() > 0)
									{
										pronoToAmt = Long.parseLong(pronoTo);
									}									
								}
								System.out.println("@@@@@ :: pronoLastAmt:["+pronoLastAmt+"]::pronoFromAmt:["+pronoFromAmt+"]::pronoToAmt:["+pronoToAmt+"]");
							        // comment by cpatil as per suggestion sir.	
								//if(pronoLastAmt < pronoFromAmt || pronoLastAmt > pronoToAmt)
								//{
								//	errList.add( "VMPRONOCD" );   //VMLRNOCD replace
								//	errFields.add( childNodeName.toLowerCase() );
								//}
								
							}
							else
							{
								errList.add( "VTPRONONUL" );  //VTLRNOCD replace
								errFields.add( childNodeName.toLowerCase() );
							}
						*/
						}
						//Changed by sankara on 07-02-13 validations required for state, station, country[Start...]
						else if ( childNodeName.equalsIgnoreCase("state_code") )
						{
							columnValue = genericUtility.getColumnValue("state_code",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) FROM STATE WHERE STATE_CODE = ? " ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "INVSTATE";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						else if ( childNodeName.equalsIgnoreCase("stan_code") )
						{
							columnValue = genericUtility.getColumnValue("stan_code",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) FROM STATION WHERE STAN_CODE = ? " ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "INVSTATION";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						else if ( childNodeName.equalsIgnoreCase("count_code") )
						{
							columnValue = genericUtility.getColumnValue("count_code",dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = " SELECT COUNT(*) FROM COUNTRY WHERE COUNT_CODE = ? " ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "INVCOUNTRY";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						//Changed by sankara on 07-02-13 validations required for state,station country[End...]
						/*
						//Changed by Rohan on 30-07-13 for no of pallet must be requried if ref-ser is not S-DSP.start
						else if ( childNodeName.equalsIgnoreCase("no_pallet") )
						{
							columnValue = checkNull(genericUtility.getColumnValue("no_pallet",dom));
							refSer = checkNull(genericUtility.getColumnValue("ref_ser",dom2));
							if(columnValue == null && columnValue.trim().length() <= 0 && !refSer.equalsIgnoreCase("S-DSP"))
							{
								errCode = "VTINVPALNO";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						//Changed by Rohan on 30-07-13 for no of pallet must be requried if ref-ser is not S-DSP.end
						  
						 */
					}
				}	
				break;
				
      			case 2 :
				{
					parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );					
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						
						if ( childNodeName.equalsIgnoreCase("ptcn") )
						{
							columnValue = genericUtility.getColumnValue("ptcn", dom);
							tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
							//Changed by sumit on 04/10/12 getting value of ref_ser  and do not validating ptcn other despatch.
							refSer = genericUtility.getColumnValue("ref_ser", dom);
							System.out.println(" ref ser -->["+refSer+"]");
							//Changed by sumit on 04/10/12 getting value of ref_ser  and do not validating ptcn other despatch.
							//if(columnValue != null && columnValue.trim().length() > 0 )
							if(columnValue != null && columnValue.trim().length() > 0 && "S-DSP".equalsIgnoreCase(refSer.trim()))
							{
								//added by shamim on 28/07/12
								ConsolidatToDoc consolidatToDoc= new ConsolidatToDoc();
								HashMap dataMap = consolidatToDoc.getAllTaskID(columnValue,conn);
								boolean isTasksConfirmed = consolidatToDoc.isAllTaskConfirmed(dataMap,conn);
								if(!isTasksConfirmed)
								{
									System.out.println(" All PTCN activity not completed");
									errList.add( "VTPTCNNC");
									errFields.add( childNodeName.toLowerCase() );		
									
								}

								sql = "SELECT COUNT(*) from wave_task_det where ptcn = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VTPTCNCD1");
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								// added by cpatil
								sql = "SELECT D.TRAN_CODE  FROM WAVE_TASK_DET W, DESPATCH D WHERE REF_ID = D.DESP_ID AND D.CONFIRMED != 'Y' and  W.PTCN= ?  ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									tranCode = rs.getString("TRAN_CODE");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								System.out.println("@@@@@ tranCodeHdr : ["+tranCodeHdr+"] ::::tran_code :["+tranCode+"]");
								if(tranCodeHdr != null && tranCodeHdr.trim().length() > 0 )
								{
								/*	// Changed by sankara on 08/08/13  user should allowed to change the transporter in shipment  start.	
									if(!(tranCodeHdr.equalsIgnoreCase(tranCode)))
									{
										errList.add( "VMTRANCDIF" );
										errFields.add( childNodeName.toLowerCase() );	
									}
									// Changed by sankara on 08/08/13  user should allowed to change the transporter in shipment end.		*/
								}
								// end
								
								//Changed by sumit on 23/01/13 validating repeat ptcn start
								arrayList = checkDuplicaterecord(dom2);
							  Set s = new HashSet(arrayList);
							  System.out.println("Size of arrayList ["+arrayList.size()+"]");
							  System.out.println("Size of Set ["+s.size()+"]");								  
							  if(s.size() < arrayList.size())
							  {
								  errList.add( "DUPPTCNNO" );
								  errFields.add( childNodeName.toLowerCase() );
							  }							  
							  s.clear();
							 //Changed by sumit on 23/01/13 validating repeat ptcn end	
							 //changed by sankara on 04/08/14 for duplicate site start.
							  String despatchsiteCode = "";
							  siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
							  refId = checkNull(genericUtility.getColumnValue("ref_id", dom));
							  System.out.println("siteCode::::::"+siteCode);
							  System.out.println("refId::::::"+refId);

							  sql  = " SELECT SITE_CODE FROM DESPATCH WHERE DESP_ID = ?  "; 		 
							  pstmt = conn.prepareStatement(sql);
							  pstmt.setString(1, refId);
							  rs = pstmt.executeQuery();
							  if( rs.next() )
							  {
								  despatchsiteCode = checkNull(rs.getString("SITE_CODE"));
								  System.out.println("despatchsiteCode::::::"+despatchsiteCode);
							  }
							  rs.close();rs = null;
							  pstmt.close();pstmt = null;	  

							  if( !siteCode.equalsIgnoreCase(despatchsiteCode) )
							  {
								  errList.add( "VTSITEDIFR" );
								  errFields.add( childNodeName.toLowerCase() );
							  }
							  //changed by sankara on 04/08/14 for duplicate site end.	   
								
							}
					
						}
						
						else if ( childNodeName.equalsIgnoreCase("ref_id") )
						{
							//Changed by sumit on 22/09/12 getting value of ref_ser.
							refSer = genericUtility.getColumnValue("ref_ser", dom);
							System.out.println("  refSer  ----> ["+refSer+"]");
							columnValue = genericUtility.getColumnValue("ref_id", dom);
							columnValue1 = genericUtility.getColumnValue("line_no", dom);
							if(columnValue1 != null && columnValue1.trim().length() > 0)
							{
								lineNo = Integer.parseInt(columnValue1.trim());
							}
							System.out.println("Line no["+lineNo+"]");
							
							if(columnValue != null && refSer != null && columnValue.trim().length() > 0)
							{
								//Changed by sumit on 22/09/12 validation for all reference series start.
								//sql = "SELECT COUNT(*) from despatch where desp_id = ? and confirmed != 'Y' ";
								//S-DSP DESPATCH - DESP_ID
								//D-ISS DISTORD_ISS - TRAN_ID, DIST_ORDER
								//C-ISS CONSUME_ISS - CONS_ISSUE
								//P-ORD   PORDER    - PURC_ORDER
								if("S-DSP".equalsIgnoreCase(refSer.trim()))
								{									
									sql = "SELECT COUNT(*) FROM DESPATCH WHERE DESP_ID = ? AND CONFIRMED != 'Y' ";
								}
								else if ("D-ISS".equalsIgnoreCase(refSer.trim()))
								{									
									sql = "SELECT COUNT(*) FROM DISTORD_ISS WHERE TRAN_ID = ? AND CONFIRMED != 'Y' ";
								}
								else if ("C-ISS".equalsIgnoreCase(refSer.trim()))
								{									
									sql = "SELECT COUNT(*) FROM CONSUME_ISS WHERE CONS_ISSUE = ? AND CONFIRMED != 'Y' ";
								}
								else if ("P-ORD".equalsIgnoreCase(refSer.trim()))
								{									
									sql = "SELECT COUNT(*) FROM PORDER WHERE PURC_ORDER = ? AND CONFIRMED != 'Y' ";
								}
								//changed by sankara on 12-07-13 added for purchase return[p-ret] confirmation start....
								else if ("P-RET".equalsIgnoreCase(refSer.trim()))
								{									
									sql = "SELECT COUNT(*) FROM PORCP WHERE TRAN_ID = ? AND CONFIRMED != 'Y' ";
								}
								//changed by sankara on 12-07-13 added for purchase return[p-ret] confirmation end....
								//Changed by sumit on 22/09/12 validation for all reference series end.
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0 )
									{
										errList.add( "VTDSPCON" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								
								//Changed by sumit 22/01/13 this validation is not required ( By Ashish Sir) start.
								/*parentNodeList = dom2.getElementsByTagName("Detail2");
								parentNodeListLength = parentNodeList.getLength();
								System.out.println("PARENT NODE LENGTH [ "+parentNodeListLength+"]");
								if("S-DSP".equalsIgnoreCase(refSer.trim()))
								{
									//Changed by sumit on 04/10/12 validation in case of despatch 
									//for(ctr2 = 0; ctr2 < (parentNodeListLength -1) ; ctr2++ )
									for(ctr2 = 0; ctr2 < (parentNodeListLength -1); ctr2++ )
									{
										parentNode = parentNodeList.item(ctr2);
										//Changed by sumit on 04/10/12 getting value of ref_ser  and do not validating ptcn other despatch.
										columnValue1 = genericUtility.getColumnValueFromNode("ref_id", parentNode);
										System.out.println("Desp_id["+columnValue1+"]");
										sql = "SELECT COUNT(*) from despatch where desp_id = ? and cust_code__dlv = (select cust_code__dlv from despatch where desp_id = ?) ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, columnValue);
										pstmt.setString(2, columnValue1);
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											cnt = rs.getInt(1);
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
										
										if(cnt == 0)
										{
											errList.add( "VTDSPINV" );
											errFields.add( childNodeName.toLowerCase() );		
										}
									}
								}*/
								//Changed by sumit 22/01/13 this validation is not required ( By Ashish Sir) end.
								
							}
							else
							{
								errList.add( "REFSERCD" );
								errFields.add( childNodeName.toLowerCase() );	
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("curr_code")) 
						{
							columnValue = genericUtility.getColumnValue("curr_code", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "Select Count(*) from currency where curr_code = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VMCUR1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("stan_code__ship") )
						{
							columnValue = genericUtility.getColumnValue("stan_code__ship", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from station where stan_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMSTANCD1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("stan_code__dlv") )
						{
							columnValue = genericUtility.getColumnValue("stan_code__dlv", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from station where stan_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMSTANCD1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("curr_code__frt")) 
						{
							columnValue = genericUtility.getColumnValue("curr_code__frt", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "Select Count(*) from currency where curr_code = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VMCUR1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("curr_code__bc")) 
						{
							columnValue = genericUtility.getColumnValue("curr_code__bc", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "Select Count(*) from currency where curr_code = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errCode = "VMCUR1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
						
						else if ( childNodeName.equalsIgnoreCase("tran_code") )
						{
							//Changes by Dadaso pawar on 03/04/15 [Start] [W14LSUN006]
							String adsiFlag = "",proNoFromStr = "",proNoToStr = "",proNoLastStr = "",remainProNoStr = "";
							int remainProNo = 0;
							//Changes by Dadaso pawar on 03/04/15 [End] [W14LSUN006]
							columnValue = genericUtility.getColumnValue("tran_code", dom);
									// genericUtility.getColumnValue("tran_code", dom);
							if(columnValue != null && columnValue.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) from transporter where tran_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt(1);
									if(cnt == 0)
									{
										errList.add( "VMTRAN1" );
										errFields.add( childNodeName.toLowerCase() );		
									}
									
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								//Changes by Dadaso pawar on 03/04/15 [Start] [W14LSUN006]
								DistCommon discommon = new DistCommon();
								remainProNoStr = checkNull(discommon.getDisparams( "999999", "REMAIN_PRO_NO", conn));
								remainProNoStr = remainProNoStr == null ? "NULLFOUND" : remainProNoStr.trim();
								System.out.println("remainProNoStr------>>["+remainProNoStr+"]");								
								sql = "SELECT ADSI_FLAG, PRONO_FROM,PRONO_TO,PRONO_LAST FROM TRANSPORTER WHERE TRAN_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									adsiFlag = rs.getString("ADSI_FLAG");
									proNoFromStr = rs.getString("PRONO_FROM");
									proNoToStr = rs.getString("PRONO_TO");
									proNoLastStr = rs.getString("PRONO_LAST");
								}
								rs.close();rs = null;
								pstmt.close();pstmt = null;				
								adsiFlag = adsiFlag == null ? "" : adsiFlag.trim();
								proNoFromStr = proNoFromStr == null ? "" : proNoFromStr.trim();
								proNoToStr = proNoToStr == null ? "" : proNoToStr.trim();
								proNoLastStr = proNoLastStr == null ? "" : proNoLastStr.trim();
								
								System.out.println("adsiFlag--->["+adsiFlag+"] proNoFromStr--->["+proNoFromStr+"]");
								System.out.println("proNoToStr--->["+proNoToStr+"] proNoLastStr--->["+proNoLastStr+"]");
								if(! "NULLFOUND".equalsIgnoreCase(remainProNoStr))
								{
									if(proNoLastStr.length() > 0 && proNoToStr.length() > 0)
									{
										remainProNo = Integer.parseInt(remainProNoStr);
										long proNoTo = Long.parseLong(proNoToStr);
										long proNoLast = Long.parseLong(proNoLastStr);

										if((proNoTo - proNoLast) < remainProNo)
										{
											errCode = "VTFWPRONR";//There are only last few pro nos are remaining
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());										
										}
									}

								}
								//Changes by Dadaso pawar on 03/04/15 [End] [W14LSUN006]
							}
							else
							{
								errList.add( "VMTRANCD1" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
				}
				//Changed by Rohan on 22-07-13 to add validation of pallet no should status must be "A".start
				/*
      			case 3 :
      			{

					parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if ( childNodeName.equalsIgnoreCase("pallet_no") )
						{
							
							palletNo = checkNull(genericUtility.getColumnValue("pallet_no", dom));
							cartonNo = checkNull(genericUtility.getColumnValue("carton_no", dom));
							refSer = checkNull(genericUtility.getColumnValue("ref_ser", dom2));
							refId = checkNull(genericUtility.getColumnValue("ref_id", dom2));
							System.out.println("Pallet No"+palletNo+"cartonNo"+cartonNo+"refSer"+refSer+"refId"+refId);
							if(columnValue == null || columnValue.trim().length() == 0)
							{
								errList.add( "VTNLPALLET" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								
								/*
								sql = "SELECT STATUS FROM PALLET_NO WHERE PALLET_NO = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, palletNo);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
								
									status = checkNull(rs.getString("STATUS"));
									System.out.println("Status of pallet:::::::::: "+status);
								}
								System.out.println("Status of pallet::::::>>>>>>>>>:::: "+status);
								if((!"".equalsIgnoreCase(status) || status != null ) && !"A".equalsIgnoreCase(status) )
								{
									errList.add( "VTINVPALET" );
									errFields.add( childNodeName.toLowerCase() );
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								*/
				/*
								if((!"".equalsIgnoreCase(refSer) || refSer != null) && ("D-ISS".equalsIgnoreCase(refSer.trim()) || "C-ISS".equalsIgnoreCase(refSer.trim()) || "P-RET".equalsIgnoreCase(refSer.trim()) ))
								{	
									if("D-ISS".equalsIgnoreCase(refSer.trim()))
									{
										sql = "SELECT COUNT(*) AS COUNT FROM DISTORD_ISS WHERE TRAN_ID = ? AND PALLET_NO = ? AND CARTON_NO = ?" ;
									}
									else if("C-ISS".equalsIgnoreCase(refSer.trim()))
									{
										sql = "SELECT COUNT(*) AS COUNT FROM CONSUME_ISS_DET WHERE CONS_ISSUE = ? AND PALLET_NO = ? AND CARTON_NO = ?" ;
									}
									else if("P-RET".equalsIgnoreCase(refSer.trim()))
									{
										sql = "SELECT COUNT(*) AS COUNT FROM PORCPDET WHERE TRAN_ID = ? AND PALLET_NO = ? AND CARTON_NO = ?" ;
									}
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, refId);
									pstmt.setString(2, palletNo);
									pstmt.setString(3, cartonNo);
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										cnt = rs.getInt("COUNT");
									}
									if(cnt <= 0 )
									{
										errList.add( "VTINVPNCN" );
										errFields.add( childNodeName.toLowerCase() );
									}
									
								}	
										
							}
						}
						
					}
				
      			}
      			*/
      			//Changed by Rohan on 22-07-13 to add validation of pallet no should status must be "A".start

			}
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception in ShipmentIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null && !conn.isClosed() )
				{
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ShipmentIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}

public String itemChanged() throws RemoteException, ITMException
{
	return "";
}
public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
{
	Document dom = null;
	Document dom1 = null;
	Document dom2 = null;
	String errString = null;
	GenericUtility genericUtility = GenericUtility.getInstance();
	try
	{
		if (xmlString != null && xmlString.trim().length()!=0)
		{
			dom = genericUtility.parseString(xmlString); 
		}
		if (xmlString1 != null && xmlString1.trim().length()!=0)
		{
			dom1 = genericUtility.parseString(xmlString1); 
		}
		if (xmlString2 != null && xmlString2.trim().length()!=0)
		{
			dom2 = genericUtility.parseString(xmlString2); 
		}
		errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		System.out.println ( "ErrString :" + errString);
	}
	catch (Exception e)
	{
		System.out.println ( "Exception :ShipmentIC :itemChanged(String,String):" + e.getMessage() + ":" );
		errString = genericUtility.createErrorString(e);
		throw new ITMException(e);
	}
	System.out.println ( "returning from ShipmentIC itemChanged" );
	return errString;
}
public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
{
	ResultSet rs = null, rs1 = null;;
	String sql = "";
	String columnValue = "";
	String columnValue1 = "";
	String siteCode = "";
	String childNodeName = "";
	String descr = "";
	String descr1 = "";
	String currCode = "";
	String loadType = "";
	String transitType = "";
	String freightType = "";
	String reStr = "";
	String frtTerm = "", prefix = "";
	//Chnaged by Rohan on 30-07-13 for define varable.start
	String cartonNo = "";
	String palletNo = "";
//  changed by sankara on 08/08/13 for define varible	
	String 	tranCodeHdr = "";
	//Chnaged by Rohan on 30-07-13 for define varable.end
	//Changed by Rohan on 12-08-13 for gross weight ogf shipment header populate in shipment content
	String grossWeight = "";
	int stdPickUp = 0;
	int pos = 0;
	
	//Changed by Rohan on 16-02-13 for change amt from int to double.start
	/*
	int amt1 = 0;
	int amt2 = 0;
	int amt3 = 0;
	*/
	double amt1 = 0.0;
	double amt2 = 0.0;
	double amt3 = 0.0;
	//Changed by Rohan on 16-02-13 for change amt from int to double.end
	
	long pronoLast = 0;
	int stdTransitTime = 0;
	int minValue = 0;
	Date effFrom = null;
	Date validUpto = null;
	NodeList parentNodeList = null;
	NodeList childNodeList = null;
	Node parentNode = null;
	Node childNode = null;
	int childNodeListLength = 0;
	int count = 0;
	int ctr = 0;
	String tranCode="",tranName="", sProno = "";
	Connection conn = null;
	PreparedStatement pstmt = null, pstmt1 = null;
	SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
	StringBuffer valueXmlString = new StringBuffer();
	int currentFormNo = 0;
	String lrNo = "";
	
	GenericUtility genericUtility = GenericUtility.getInstance();
	//changed by sankara on 03/01/14 for freight_amt_add in ship_docs 
	String freightamount = "";
	//changed by sankara on 22/09/14 for site transporter start.
    String siteCodeShip = "";
	try
	{
		siteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
		columnValue = genericUtility.getColumnValue( currentColumn, dom );
		ConnDriver connDriver = null;
		connDriver = new ConnDriver();
		conn = connDriver.getConnectDB("DriverValidator");
		if( objContext != null && objContext.trim().length() > 0 )
		{
			currentFormNo = Integer.parseInt( objContext );
		}
		valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

		switch ( currentFormNo )
		{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append( "<Detail1>\r\n" );
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					valueXmlString.append( "<shipment_date><![CDATA[" ).append( genericUtility.getValidDateTimeString(new Date(new java.util.Date().getTime()), genericUtility.getApplDateFormat()) ).append( "]]></shipment_date>\r\n" );
					valueXmlString.append( "<lr_date><![CDATA[" ).append( genericUtility.getValidDateTimeString(new Date(new java.util.Date().getTime()), genericUtility.getApplDateFormat()) ).append( "]]></lr_date>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
				}
								
				else if( currentColumn.trim().equalsIgnoreCase( "site_code" ) )
				{
					siteCode = genericUtility.getColumnValue("site_code",dom);
					sql = "SELECT descr,stan_code FROM SITE WHERE SITE_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
						descr1 = rs.getString(2);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></site_descr>\r\n" );
					
					valueXmlString.append( "<stan_code__from><![CDATA[" ).append( checkNull( descr1) ).append( "]]></stan_code__from>\r\n" );
					
					setNodeValue( dom, "stan_code__from", descr1 );
					reStr = itemChanged(dom, dom1, dom2, objContext, "stan_code__from", editFlag, xtraParams);
					pos = reStr.indexOf("<Detail1>");
					reStr = reStr.substring(pos + 9);
					pos = reStr.indexOf("</Detail1>");
					reStr = reStr.substring(0,pos);
					valueXmlString.append(reStr);
					
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "tran_code" ) )
				{
					//cpatil
					columnValue = genericUtility.getColumnValue("tran_code",dom1);
					lrNo = genericUtility.getColumnValue("lr_no",dom1);
					// 02/08/12 prefix considered to generate SSCC18 complaint number
					
					//changed by sankara on 22/09/14 for not used any where start. 
					/*if( columnValue != null && columnValue.trim().length() > 0)
					{
					sql = "SELECT tran_name, PRONO_LAST , PRONO_FROM, PREFIX FROM transporter WHERE tran_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
						descr1 = rs.getString(2);
						prefix = rs.getString(4);
						if(descr1 == null || descr1.trim().length() == 0)
						{
							descr1 = checkNull(rs.getString(3));
						}
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				
					if(descr1.trim().length() > 0)
					{
						pronoLast = Long.parseLong(descr1) + 1;
					}*/
					
					sql = "SELECT TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					//changed by sankara on 22/09/14 for not used any where end.
					
					//Changed by sumit on 10/11/12 commented this as pro_no and lr_no will insert from shipment, this logic is now written in shipmentconf start.
					/*if(pronoLast != 0)
					{
						//valueXmlString.append( "<lr_no><![CDATA[" ).append( pronoLast ).append( "]]></lr_no>\r\n" ); // commented to generate SSCC18 complaint number
				
						//valueXmlString.append( "<lr_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></lr_no>\r\n" ); // added to generate SSCC18 complaint number //commented as per suggestion   
							sProno = ("" + pronoLast).trim();
							System.out.println("manohar before prefix["+prefix+"]::::sProno["+sProno+"]");
							sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranCode);
							pstmt.setString(2, sProno);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								sProno = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						System.out.println("manohar after prefix["+prefix+"]::::sProno["+sProno+"]");
						//valueXmlString.append( "<pro_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></pro_no>\r\n" );
						//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" ); 
						valueXmlString.append( "<pro_no><![CDATA[" ).append( sProno ).append( "]]></pro_no>\r\n" );

						if (lrNo == null || lrNo.trim().length() ==0 )
						{
							sProno = getLrNo(xtraParams,conn);
							System.out.println("manohar before lr_no ["+sProno+"]");
							sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranCode);
							pstmt.setString(2, sProno);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								sProno = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						
							System.out.println("manohar after lr_no ["+sProno+"]");
							
							valueXmlString.append( "<lr_no><![CDATA[" ).append( sProno  ).append( "]]></lr_no>\r\n" ); 
						}
					}*/
					//Changed by sumit on 10/11/12 commented this as pro_no and lr_no will insert from shipment, this logic is now written in shipmentconf end.
					valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( descr) ).append( "]]></transporter_tran_name>\r\n" );
					//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" ); // added to generate SSCC18 complaint number //commented as per suggestion				
				}
				else if( currentColumn.trim().equalsIgnoreCase( "stan_code__from" ) )
				{
					columnValue = genericUtility.getColumnValue("stan_code__from",dom);
					columnValue1 = genericUtility.getColumnValue("stan_code__to",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(columnValue != null && columnValue1 != null)
					{
						sql = "select distance from distance  WHERE stan_code__from = ? and stan_code__to = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, columnValue1);
						pstmt.setString(2, columnValue);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							count = rs.getInt(1);
							if(count == 0)
							{
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								sql = "select distance from distance  WHERE stan_code__from = ? and stan_code__to = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								pstmt.setString(2, columnValue1);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt(1);								
								}
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append( "<station_a_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></station_a_descr>\r\n" );
					valueXmlString.append( "<distance><![CDATA[" ).append(count).append( "]]></distance>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "stan_code__to" ) )
				{
					columnValue = genericUtility.getColumnValue("stan_code__to",dom);
					columnValue1 = genericUtility.getColumnValue("stan_code__from",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(columnValue != null && columnValue1 != null)
					{
						sql = "select distance from distance  WHERE stan_code__from = ? and stan_code__to = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, columnValue1);
						pstmt.setString(2, columnValue);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							count = rs.getInt(1);
							if(count == 0)
							{
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								sql = "select distance from distance  WHERE stan_code__from = ? and stan_code__to = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								pstmt.setString(2, columnValue1);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt(1);								
								}
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append( "<station_b_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></station_b_descr>\r\n" );
					valueXmlString.append( "<distance><![CDATA[" ).append(count).append( "]]></distance>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "frt_list" ) )
				{
					columnValue = genericUtility.getColumnValue("frt_list",dom);
					sql = "SELECT DESCR, CURR_CODE, LOAD_TYPE, FRT_TERM, EFF_FROM, VALID_UPTO FROM  freight_list where frt_list = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
						currCode = rs.getString(2);
						loadType = rs.getString(3);
						frtTerm = rs.getString(4);
						effFrom = rs.getDate(5);
						validUpto = rs.getDate(6);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "SELECT std_pick_up, std_transit_time, transit_type, freight_type, min_value FROM  freight_rate where frt_list = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						stdPickUp = rs.getInt(1);
						stdTransitTime = rs.getInt(2);
						transitType = rs.getString(3);
						freightType = rs.getString(4);
						minValue = rs.getInt(5);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append( "<freight_list_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></freight_list_descr>\r\n" );

					if(genericUtility.getColumnValue("curr_code", dom) == null || genericUtility.getColumnValue("curr_code", dom).trim().length() == 0)
					{
						valueXmlString.append( "<curr_code><![CDATA[" ).append( checkNull( currCode) ).append( "]]></curr_code>\r\n" );
						setNodeValue( dom, "curr_code", currCode );
						reStr = itemChanged(dom, dom1, dom2, objContext, "curr_code", editFlag, xtraParams);
						pos = reStr.indexOf("<Detail1>");
						reStr = reStr.substring(pos + 9);
						pos = reStr.indexOf("</Detail1>");
						reStr = reStr.substring(0,pos);
						valueXmlString.append(reStr);
					}
					
					if(genericUtility.getColumnValue("load_type", dom) == null || genericUtility.getColumnValue("load_type", dom).trim().length() == 0)
					{
						valueXmlString.append( "<load_type><![CDATA[" ).append( checkNull( loadType) ).append( "]]></load_type>\r\n" );
						setNodeValue( dom, "load_type", loadType );
						reStr = itemChanged(dom, dom1, dom2, objContext, "load_type", editFlag, xtraParams);
						pos = reStr.indexOf("<Detail1>");
						reStr = reStr.substring(pos + 9);
						pos = reStr.indexOf("</Detail1>");
						reStr = reStr.substring(0,pos);
						valueXmlString.append(reStr);
					}
					
					valueXmlString.append( "<frt_term><![CDATA[" ).append( checkNull( frtTerm) ).append( "]]></frt_term>\r\n" );
					if(genericUtility.getColumnValue("call_date", dom) == null || genericUtility.getColumnValue("call_date", dom).trim().length() == 0)
					{
						valueXmlString.append( "<call_date><![CDATA[" ).append( sdf.format(effFrom) ).append( "]]></call_date>\r\n" );
					}
					if(genericUtility.getColumnValue("pick_up_date", dom) == null || genericUtility.getColumnValue("pick_up_date", dom).trim().length() == 0)
					{
						valueXmlString.append( "<pick_up_date><![CDATA[" ).append( sdf.format(validUpto) ).append( "]]></pick_up_date>\r\n" );
					}
					
					valueXmlString.append( "<std_pick_up><![CDATA[" ).append( stdPickUp ).append( "]]></std_pick_up>\r\n" );
					valueXmlString.append( "<std_transit_time><![CDATA[" ).append( stdTransitTime ).append( "]]></std_transit_time>\r\n" );
					valueXmlString.append( "<transit_type><![CDATA[" ).append( checkNull( transitType) ).append( "]]></transit_type>\r\n" );
					valueXmlString.append( "<freight_type><![CDATA[" ).append( checkNull( freightType) ).append( "]]></freight_type>\r\n" );
					valueXmlString.append( "<min_value><![CDATA[" ).append(  minValue ).append( "]]></min_value>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "curr_code" ) )
				{
					columnValue = genericUtility.getColumnValue("curr_code",dom);
					sql = "select descr from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<currency_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></currency_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "load_type" ) )
				{
					columnValue = genericUtility.getColumnValue("load_type",dom);
					if(columnValue != null && columnValue.trim().length() > 0)
					{
						sql = "select descr from gencodes where fld_name = 'LOAD_TYPE' and MOD_NAME = 'X' and fld_value = ?" ;
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							descr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append( "<gencodes_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></gencodes_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "gross_weight" ) )
				{
					columnValue = checkNull(genericUtility.getColumnValue("gross_weight",dom));
					columnValue1 = checkNull(genericUtility.getColumnValue("tare_weight",dom));
					if(columnValue.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get gross_weight in double 
						//amt1 = Integer.parseInt(columnValue);
						amt1 = Double.parseDouble(columnValue);
					}
					if(columnValue1.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get tare_weight in double 
						//amt2 = Integer.parseInt(columnValue1);
						amt2 = Double.parseDouble(columnValue1);
					}
					amt3 = amt1 - amt2 ;
					valueXmlString.append( "<net_amt><![CDATA[" ).append( amt3 ).append( "]]></net_amt>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "tare_weight" ) )
				{
					columnValue = checkNull(genericUtility.getColumnValue("gross_weight",dom));
					columnValue1 = checkNull(genericUtility.getColumnValue("tare_weight",dom));
					if(columnValue.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get gross_weight in double 
						//amt1 = Integer.parseInt(columnValue);
						amt1 = Double.parseDouble(columnValue);
					}
					if(columnValue1.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get tare_weight in double 
						//amt2 = Integer.parseInt(columnValue1);
						amt2 = Double.parseDouble(columnValue1);
					}
					amt3 = amt1 - amt2 ;
					valueXmlString.append( "<net_amt><![CDATA[" ).append( amt3 ).append( "]]></net_amt>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "freight_amt" ) )
				{
					columnValue = checkNull(genericUtility.getColumnValue("freight_amt",dom));
					columnValue1 = checkNull(genericUtility.getColumnValue("add_chgs",dom));
					if(columnValue.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get freight_amt in double
						//amt1 = Integer.parseInt(columnValue);
						amt1 = Double.parseDouble(columnValue);
					}
					if(columnValue1.trim().length() > 0)
					{
						//Changed by Rohan on 16-02-13 to get add_chgs in double
						//amt2 = Integer.parseInt(columnValue1);
						amt2 = Double.parseDouble(columnValue1);
					}
					amt3 = amt1 + amt2 ;
					valueXmlString.append( "<total_freight><![CDATA[" ).append( amt3 ).append( "]]></total_freight>\r\n" );
				}
				//Changed by sankara on 05-07-13 getting state code,station code,country code descriptions in item change[start....]
				if(currentColumn.trim().equalsIgnoreCase( "itm_defaultedit" ))
				{
					columnValue = genericUtility.getColumnValue("stan_code__from",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					columnValue = genericUtility.getColumnValue("stan_code__to",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
					    descr1 = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append( "<station_a_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></station_a_descr>\r\n" );
					valueXmlString.append( "<station_b_descr><![CDATA[" ).append( checkNull( descr1) ).append( "]]></station_b_descr>\r\n" );			
				}
				else if( currentColumn.trim().equalsIgnoreCase( "stan_code" ) )
				{
					columnValue = genericUtility.getColumnValue("stan_code",dom);
					sql = "select descr from station where stan_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<station_c_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></station_c_descr>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "state_code" ) )
				{
					columnValue = genericUtility.getColumnValue("state_code",dom);
					sql = "select descr from state where state_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<state_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></state_descr>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "count_code" ) )
				{
					columnValue = genericUtility.getColumnValue("count_code",dom);
					sql = "select descr from country where count_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<country_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></country_descr>\r\n" );
				}
				//Changed by sankara on 05-07-13 getting state code,station code,country code descriptions in item change[End.....]
				valueXmlString.append( "</Detail1>\r\n" );
				break;
			
			
			case 2:
			{
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				//changed by sankara on 10/10/13 for set tran_code itm_default in shipment header start.
				//chnaged by sankara on 03/06/14 for tran_code in case of consumption issue
				//tranCode = genericUtility.getColumnValue("tran_code",dom);
				tranCode = genericUtility.getColumnValue("tran_code",dom1);
				System.out.println("trancode:"+tranCode);
				//changed by sankara on 10/10/13 for set tran_code itm_default in shipment header end.
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					
					columnValue = genericUtility.getColumnValue("shipment_id", dom1);
					columnValue1 = genericUtility.getColumnValue("stan_code__from", dom1);
					valueXmlString.append( "<shipment_id><![CDATA[" ).append( checkNull(columnValue) ).append( "]]></shipment_id>\r\n" );
					
					valueXmlString.append( "<stan_code__ship><![CDATA[" ).append( checkNull(columnValue1) ).append( "]]></stan_code__ship>\r\n" );
					setNodeValue( dom, "stan_code__ship", columnValue1 );
					/*
					reStr = itemChanged(dom, dom1, dom2, objContext, "stan_code__ship", editFlag, xtraParams);
					pos = reStr.indexOf("<Detail2>");
					reStr = reStr.substring(pos + 9);
					pos = reStr.indexOf("</Detail2>");
					reStr = reStr.substring(0,pos);
					valueXmlString.append(reStr);
					*/
					columnValue1 = genericUtility.getColumnValue("tran_code", dom1);
					
					valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(columnValue1) ).append( "]]></tran_code>\r\n" );
					setNodeValue( dom, "tran_code", columnValue1 );
					//Changed by sumit on 06/10/12 for setting default value 'N'
					valueXmlString.append( "<desp_confirmed><![CDATA[" ).append( "N" ).append( "]]></desp_confirmed>\r\n" );
					//changed by sankara on 10/10/13 for set tran_code itm_default in shipment header start.										
					valueXmlString.append("</Detail2>");
					valueXmlString.append("<Detail1>");
				    valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );					
					valueXmlString.append("</Detail1>");
					valueXmlString.append("<Detail2>");
					//changed by sankara on 10/10/13 for set tran_code itm_default in shipment header end.
					/*
					reStr = itemChanged(dom, dom1, dom2, objContext, "tran_code", editFlag, xtraParams);
					pos = reStr.indexOf("<Detail2>");
					reStr = reStr.substring(pos + 9);
					pos = reStr.indexOf("</Detail2>");
					reStr = reStr.substring(0,pos);
					valueXmlString.append(reStr);
					 */
				}
		      //changed by sankara on 26/06/14 for transporter code in shipment detail start.		
		     /*	else if( currentColumn.trim().equalsIgnoreCase( "ptcn" ) )
				{
					columnValue = genericUtility.getColumnValue("ptcn",dom);
					columnValue1 = genericUtility.getColumnValue("ref_id",dom);
					if(columnValue != null && columnValue.trim().length() > 0 )
					{
						sql = "select REF_ID from wave_task_det where ptcn = ? AND REF_SER = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						pstmt.setString(2, "S-DSP");
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							valueXmlString.append( "<ref_id><![CDATA[" ).append( checkNull( rs.getString(1)) ).append( "]]></ref_id>\r\n" );
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						// added by cpatil on 8-sept-12 start 
						System.out.println("@@@@@ cpatil test");
						//Changed by sumit on 25/01/13 removed confirmed from sql.
						//sql = "SELECT D.TRAN_CODE  FROM WAVE_TASK_DET W, DESPATCH D WHERE REF_ID = D.DESP_ID AND D.CONFIRMED != 'Y' and  W.PTCN= ? ";
						sql = "SELECT D.TRAN_CODE  FROM WAVE_TASK_DET W, DESPATCH D WHERE REF_ID = D.DESP_ID  and  W.PTCN= ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							tranCode = rs.getString("tran_code");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
						
						//
						sql = "SELECT tran_name, PRONO_LAST , PRONO_FROM, PREFIX,tran_name FROM transporter WHERE tran_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							descr = rs.getString(1);
							descr1 = rs.getString(2);
							prefix = rs.getString(4);
							if(descr1 == null || descr1.trim().length() == 0)
							{
								descr1 = checkNull(rs.getString(3));
							}
							tranName=rs.getString(5);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(descr1.trim().length() > 0)
						{
							pronoLast = Long.parseLong(descr1) + 1;
						}
						// 18/09/12 manoharan
						sql = "SELECT tran_name, PRONO_LAST , PRONO_FROM, PREFIX,tran_name FROM transporter WHERE tran_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							descr = rs.getString(1);
							descr1 = rs.getString(2);
							prefix = rs.getString(4);
							if(descr1 == null || descr1.trim().length() == 0)
							{
								descr1 = checkNull(rs.getString(3));
							}
							tranName=rs.getString(5);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						
						// start tran_code check for previous
						// changed by sankara on 08/08/13 already declared as string....
						// String tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
					       tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
						// end tran code check for previous
						System.out.println("Header tran_code:"+tranCodeHdr);
						if(descr1.trim().length() > 0)
						{
							pronoLast = Long.parseLong(descr1) + 1;
						}
						//Changed by sumit on 10/11/12 commented this as this logic is now written in shipmentconf start.
						if(pronoLast != 0)
						{
							// 18/09/12 manoharan get from database function
							System.out.println("@@@@@ prefix["+prefix+"]::::pronoLast["+pronoLast+"]");
							System.out.println("@@@@@ tranCodeHdr["+tranCodeHdr+"]::::tranCode["+tranCode+"]");
							
							sProno = ("" + pronoLast).trim();
							System.out.println("manohar before sprono ["+sProno+"]");
							sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranCode);
							pstmt.setString(2, sProno);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								sProno = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("manohar after sprono ["+sProno+"]");
						}
						//Changed by sumit on 10/11/12 commented this as this logic is now written in shipmentconf start.
						if(tranCodeHdr != null && tranCodeHdr.trim().length() > 0 )
						{
							if( tranCodeHdr.equalsIgnoreCase(tranCode))
							{
								//valueXmlString.append( "<Detail1>\r\n" );
								//valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								//valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
								//valueXmlString.append( "<pro_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></pro_no>\r\n" );
								//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" );
								//valueXmlString.append( "</Detail1>\r\n" );
								//valueXmlString.append( "<Detail2>\r\n" );
								valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
								//valueXmlString.append( "</Detail2>\r\n" );							
							}
							else
							{
								System.out.println("@@@@@ tran_code of detail is different from header tran_code");
								//valueXmlString.append( "</Detail2>\r\n" );
								//valueXmlString.append( "<Detail1>\r\n" );
								//valueXmlString.append( "<tran_code><![CDATA[" ).append("").append( "]]></tran_code>\r\n" );
								//valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append("" ).append( "]]></transporter_tran_name>\r\n" );
								//valueXmlString.append( "<pro_no><![CDATA[" ).append("").append( "]]></pro_no>\r\n" );
								//valueXmlString.append( "<lr_no><![CDATA[" ).append("").append( "]]></lr_no>\r\n" );
								//valueXmlString.append( "</Detail1>\r\n" );
								//valueXmlString.append( "<Detail2>\r\n" );
								valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
								//valueXmlString.append( "</Detail2>\r\n" );
							}
						}
						else
						{
							valueXmlString.append( "</Detail2>\r\n" );
							valueXmlString.append( "<Detail1>\r\n" );
							valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
							valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
							//valueXmlString.append( "<pro_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></pro_no>\r\n" );							
							//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" );
							//Changed by sumit on 10/11/12 commented this as pro number will update from shipment confirmation.
							//valueXmlString.append( "<pro_no><![CDATA[" ).append(sProno).append( "]]></pro_no>\r\n" );							
							lrNo = genericUtility.getColumnValue("lr_no",dom1);
							//Changed by sumit on 10/11/12 this code copied to ShipmentConf, commented from here (as per manoharan sir) start
							if (lrNo == null || lrNo.trim().length() == 0)
							{
								sProno = getLrNo(xtraParams,conn);
								System.out.println("manohar before lr_no ["+sProno+"]");
								sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranCode);
								pstmt.setString(2, sProno);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									sProno = checkNull(rs.getString(1));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("manohar after lr_no ["+sProno+"]");
								valueXmlString.append( "<lr_no><![CDATA[" ).append( sProno  ).append( "]]></lr_no>\r\n" ); 
							}
							//Changed by sumit on 10/11/12 this code copied to ShipmentConf, commented from here (as per manoharan sir) end
							//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(xtraParams,conn) ).append( "]]></lr_no>\r\n" ); 
							valueXmlString.append( "</Detail1>\r\n" );
							valueXmlString.append( "<Detail2>\r\n" );
							valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
							valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
							//valueXmlString.append( "</Detail2>\r\n" );
						}
						//}
						// added by cpatil on 8-sept-12 end
						//valueXmlString.append( "<Detail2>\r\n" );
					}
					valueXmlString.append( "<ref_ser><![CDATA[S-DSP]]></ref_ser>\r\n" );
					//changed by sankara on 03/01/14 display despatch freight_amt_add in ship_docs start.
					sql = " SELECT FREIGHT_AMT_ADD FROM DESPATCH WHERE PTCN = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						freightamount = checkNull(rs.getString("FREIGHT_AMT_ADD"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<freight_amt_add><![CDATA[" ).append(freightamount).append( "]]></freight_amt_add>\r\n" );
					//changed by sankara on 03/01/14 display despatch freight_amt_add in ship_docs end.
				}*/
				else if( currentColumn.trim().equalsIgnoreCase( "ptcn" ) )
				{
					columnValue = genericUtility.getColumnValue("ptcn",dom);
					columnValue1 = genericUtility.getColumnValue("ref_id",dom);
					if(columnValue != null && columnValue.trim().length() > 0 )
					{
						sql = "select REF_ID from wave_task_det where ptcn = ? AND REF_SER = ?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, columnValue);
						pstmt1.setString(2, "S-DSP");
						rs1 = pstmt1.executeQuery();
						if( rs1.next() )
						{
							valueXmlString.append( "<ref_id><![CDATA[" ).append( checkNull( rs1.getString(1)) ).append( "]]></ref_id>\r\n" );
							/*}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;*/

							// added by cpatil on 8-sept-12 start 
							System.out.println("@@@@@ cpatil test");
							//Changed by sumit on 25/01/13 removed confirmed from sql.
							//sql = "SELECT D.TRAN_CODE  FROM WAVE_TASK_DET W, DESPATCH D WHERE REF_ID = D.DESP_ID AND D.CONFIRMED != 'Y' and  W.PTCN= ? ";
							sql = "SELECT D.TRAN_CODE  FROM WAVE_TASK_DET W, DESPATCH D WHERE REF_ID = D.DESP_ID  and  W.PTCN= ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								tranCode = rs.getString("tran_code");

							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(tranCode != null && tranCode.trim().length() >0)
							{		
								valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								
								//changed by sankara on 22/09/14 not used any where start.
								/*sql = "SELECT tran_name, PRONO_LAST , PRONO_FROM, PREFIX,tran_name FROM transporter WHERE tran_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranCode);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									descr = rs.getString(1);
									descr1 = rs.getString(2);
									prefix = rs.getString(4);
									if(descr1 == null || descr1.trim().length() == 0)
									{
										descr1 = checkNull(rs.getString(3));
									}
									tranName=rs.getString(5);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if(descr1.trim().length() > 0)
								{
									pronoLast = Long.parseLong(descr1) + 1;
								}
								// 18/09/12 manoharan
								sql = "SELECT tran_name, PRONO_LAST , PRONO_FROM, PREFIX,tran_name FROM transporter WHERE tran_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranCode);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									descr = rs.getString(1);
									descr1 = rs.getString(2);
									prefix = rs.getString(4);
									if(descr1 == null || descr1.trim().length() == 0)
									{
										descr1 = checkNull(rs.getString(3));
									}
									tranName=rs.getString(5);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;*/
								
								sql = "SELECT TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranCode);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									tranName=rs.getString(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								//changed by sankara on 22/09/14 not used any where end.
								
								// start tran_code check for previous
								// changed by sankara on 08/08/13 already declared as string....
								// String tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
								tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
								// end tran code check for previous
								System.out.println("Header tran_code:"+tranCodeHdr);
								if(descr1.trim().length() > 0)
								{
									pronoLast = Long.parseLong(descr1) + 1;
								}
								//Changed by sumit on 10/11/12 commented this as this logic is now written in shipmentconf start.
								/*if(pronoLast != 0)
										{
											// 18/09/12 manoharan get from database function
											System.out.println("@@@@@ prefix["+prefix+"]::::pronoLast["+pronoLast+"]");
											System.out.println("@@@@@ tranCodeHdr["+tranCodeHdr+"]::::tranCode["+tranCode+"]");

											sProno = ("" + pronoLast).trim();
											System.out.println("manohar before sprono ["+sProno+"]");
											sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, tranCode);
											pstmt.setString(2, sProno);
											rs = pstmt.executeQuery();
											if( rs.next() )
											{
												sProno = checkNull(rs.getString(1));
											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;
											System.out.println("manohar after sprono ["+sProno+"]");
										}*/
								//Changed by sumit on 10/11/12 commented this as this logic is now written in shipmentconf start.
								System.out.println("tested shipment.......");
								if(tranCodeHdr != null && tranCodeHdr.trim().length() > 0 )
								{
									if( tranCodeHdr.equalsIgnoreCase(tranCode))
									{
										System.out.println("18/06/14 checked in if");
										//valueXmlString.append( "<Detail1>\r\n" );
										//valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
										//valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
										//valueXmlString.append( "<pro_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></pro_no>\r\n" );
										//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" );
										//valueXmlString.append( "</Detail1>\r\n" );
										//valueXmlString.append( "<Detail2>\r\n" );
										valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
										valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
										//valueXmlString.append( "</Detail2>\r\n" );							
									}
									else
									{
										System.out.println("18/06/14 checked in else");
										System.out.println("@@@@@ tran_code of detail is different from header tran_code");
										valueXmlString.append( "</Detail2>\r\n" );
										valueXmlString.append( "<Detail1>\r\n" );
										valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
										valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
										valueXmlString.append( "</Detail1>\r\n" );
										valueXmlString.append( "<Detail2>\r\n" );
										valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
										valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
										//valueXmlString.append( "</Detail2>\r\n" );
									}
								}
								else
								{
									valueXmlString.append( "</Detail2>\r\n" );
									valueXmlString.append( "<Detail1>\r\n" );
									valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
									valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
									//valueXmlString.append( "<pro_no><![CDATA[" ).append( getSSCC(prefix, pronoLast, conn) ).append( "]]></pro_no>\r\n" );							
									//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(prefix,pronoLast,xtraParams,conn) ).append( "]]></lr_no>\r\n" );
									//Changed by sumit on 10/11/12 commented this as pro number will update from shipment confirmation.
									//valueXmlString.append( "<pro_no><![CDATA[" ).append(sProno).append( "]]></pro_no>\r\n" );							
									lrNo = genericUtility.getColumnValue("lr_no",dom1);
									//Changed by sumit on 10/11/12 this code copied to ShipmentConf, commented from here (as per manoharan sir) start
									/*if (lrNo == null || lrNo.trim().length() == 0)
											{
												sProno = getLrNo(xtraParams,conn);
												System.out.println("manohar before lr_no ["+sProno+"]");
												sql = "SELECT fn_prono(?,to_char(?)) FROM dual";
												pstmt = conn.prepareStatement(sql);
												pstmt.setString(1, tranCode);
												pstmt.setString(2, sProno);
												rs = pstmt.executeQuery();
												if( rs.next() )
												{
													sProno = checkNull(rs.getString(1));
												}
												rs.close();
												rs = null;
												pstmt.close();
												pstmt = null;
												System.out.println("manohar after lr_no ["+sProno+"]");
												valueXmlString.append( "<lr_no><![CDATA[" ).append( sProno  ).append( "]]></lr_no>\r\n" ); 
											}*/
									//Changed by sumit on 10/11/12 this code copied to ShipmentConf, commented from here (as per manoharan sir) end
									//valueXmlString.append( "<lr_no><![CDATA[" ).append( getLrNo(xtraParams,conn) ).append( "]]></lr_no>\r\n" ); 
									valueXmlString.append( "</Detail1>\r\n" );
									valueXmlString.append( "<Detail2>\r\n" );
									valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
									valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
									//valueXmlString.append( "</Detail2>\r\n" );

								}
							} //if(tranCode != null && tranCode.trim().length() >0)
							else
							{
								valueXmlString.append( "<ref_id><![CDATA[" ).append( "" ).append( "]]></ref_id>\r\n" );
								valueXmlString.append( "<tran_code><![CDATA[" ).append( "" ).append( "]]></tran_code>\r\n" );
								valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( "").append( "]]></transporter_tran_name>\r\n" );
							}




						} //if( rs.next() )
						else
						{
							valueXmlString.append( "<ref_id><![CDATA[" ).append( "" ).append( "]]></ref_id>\r\n" );
							valueXmlString.append( "<tran_code><![CDATA[" ).append( "" ).append( "]]></tran_code>\r\n" );
							valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( "").append( "]]></transporter_tran_name>\r\n" );

						}//else
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
						//}
						// added by cpatil on 8-sept-12 end
						//valueXmlString.append( "<Detail2>\r\n" );
					}
					else
					{
						valueXmlString.append( "<ref_id><![CDATA[" ).append( "" ).append( "]]></ref_id>\r\n" );
						valueXmlString.append( "<tran_code><![CDATA[" ).append( "" ).append( "]]></tran_code>\r\n" );
						valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( "").append( "]]></transporter_tran_name>\r\n" );
					}
					valueXmlString.append( "<ref_ser><![CDATA[S-DSP]]></ref_ser>\r\n" );
					//changed by sankara on 03/01/14 display despatch freight_amt_add in ship_docs start.
					sql = " SELECT FREIGHT_AMT_ADD FROM DESPATCH WHERE PTCN = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						freightamount = checkNull(rs.getString("FREIGHT_AMT_ADD"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<freight_amt_add><![CDATA[" ).append(freightamount).append( "]]></freight_amt_add>\r\n" );
					//changed by sankara on 03/01/14 display despatch freight_amt_add in ship_docs end.
				}
				//changed by sankara on 08/10/14 for set tran_code in case of D-ISS and C-ISS start.
				else if( currentColumn.trim().equalsIgnoreCase( "ref_id" ) )
				{				
					columnValue = genericUtility.getColumnValue("ref_ser",dom);
					columnValue1 = genericUtility.getColumnValue("ref_id",dom);
					System.out.println("refid::::::::::"+columnValue);
					System.out.println("refseries::::::::::"+columnValue1);
					
					if(columnValue1 != null && columnValue1.trim().length() > 0 )
					{						
						if("C-ISS".equalsIgnoreCase(columnValue))
						{
							sql = " SELECT TRAN_CODE FROM CONSUME_ISS WHERE CONS_ISSUE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue1);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								tranCode = checkNull(rs.getString("TRAN_CODE"));
								System.out.println("tranCodeconsissue:::::::"+tranCode);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						if("D-ISS".equalsIgnoreCase(columnValue))
						{
							sql = "SELECT TRAN_CODE FROM DISTORD_ISS WHERE TRAN_ID = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue1);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								tranCode = checkNull(rs.getString("TRAN_CODE"));
								System.out.println("tranCodedistbution:::::::"+tranCode);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						if("S-DSP".equalsIgnoreCase(columnValue))
						{
							sql = "SELECT TRAN_CODE FROM DESPATCH WHERE DESP_ID = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue1);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								tranCode = checkNull(rs.getString("TRAN_CODE"));
								System.out.println("tranCodemanualdespatch:::::::"+tranCode);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						
						if(tranCode != null && tranCode.trim().length() >0)
						{		
							valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );

							sql = "SELECT TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranCode);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								tranName=rs.getString(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							tranCodeHdr = genericUtility.getColumnValue("tran_code", dom1);
							System.out.println("Header tran code:"+tranCodeHdr);

							if(tranCodeHdr != null && tranCodeHdr.trim().length() > 0 )
							{
								if( tranCodeHdr.equalsIgnoreCase(tranCode))
								{
									System.out.println("18/06/14 checked in if");								
									valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
									valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );													
								}
								else
								{
									System.out.println("18/06/14 checked in else");
									System.out.println("@@@@@ tran_code of detail is different from header tran_code");
									valueXmlString.append( "</Detail2>\r\n" );
									valueXmlString.append( "<Detail1>\r\n" );
									valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
									valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
									valueXmlString.append( "</Detail1>\r\n" );
									valueXmlString.append( "<Detail2>\r\n" );
									valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
									valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
								}
							}
							else
							{
								valueXmlString.append( "</Detail2>\r\n" );
								valueXmlString.append( "<Detail1>\r\n" );
								valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
								valueXmlString.append( "</Detail1>\r\n" );
								valueXmlString.append( "<Detail2>\r\n" );
								valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(tranCode) ).append( "]]></tran_code>\r\n" );
								valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( tranName) ).append( "]]></transporter_tran_name>\r\n" );
							}
						} //if(tranCode != null && tranCode.trim().length() >0)
						else
						{
							//valueXmlString.append( "<ref_id><![CDATA[" ).append( "" ).append( "]]></ref_id>\r\n" );
							valueXmlString.append( "<tran_code><![CDATA[" ).append( "" ).append( "]]></tran_code>\r\n" );
							valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( "").append( "]]></transporter_tran_name>\r\n" );
						}

					} //if( rs.next() )
					else
					{
						valueXmlString.append( "<ref_id><![CDATA[" ).append( "" ).append( "]]></ref_id>\r\n" );
						valueXmlString.append( "<tran_code><![CDATA[" ).append( "" ).append( "]]></tran_code>\r\n" );
						valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( "").append( "]]></transporter_tran_name>\r\n" );

					}
				}
				//changed by sankara on 08/10/14 for set tran_code in case of D-ISS and C-ISS end.
				//changed by sankara on 26/06/14 for transporter code in shipment detail end.		
				else if( currentColumn.trim().equalsIgnoreCase( "curr_code" ) )
				{
					columnValue = genericUtility.getColumnValue("curr_code",dom);
					sql = "select descr from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<currency_a_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></currency_a_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "stan_code__ship" ) )
				{
					columnValue = genericUtility.getColumnValue("stan_code__ship",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<station_a_descr><![CDATA[" ).append( checkNull( descr ) ).append( "]]></station_a_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "stan_code__dlv" ) )
				{
					columnValue = genericUtility.getColumnValue("stan_code__dlv",dom);
					sql = "select descr from station  WHERE stan_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<station_b_descr><![CDATA[" ).append( checkNull( descr ) ).append( "]]></station_b_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "curr_code__frt" ) )
				{
					columnValue = genericUtility.getColumnValue("curr_code__frt",dom);
					sql = "select descr from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<currency_b_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></currency_b_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "curr_code__bc" ) )
				{
					columnValue = genericUtility.getColumnValue("curr_code__bc",dom);
					sql = "select descr from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append( "<currency_c_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></currency_c_descr>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "tran_code" ) )
				{
					columnValue = genericUtility.getColumnValue("tran_code",dom);
					sql = "SELECT tran_name FROM transporter WHERE tran_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					//changed by sankara on 08/08/13 if tran_code changed in ship detail dispayed in header start..    
					//	valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( descr) ).append( "]]></transporter_tran_name>\r\n" );		
				    if( !tranCodeHdr.equalsIgnoreCase(columnValue))
					{
						valueXmlString.append( "</Detail2>\r\n" );
						valueXmlString.append( "<Detail1>\r\n" );
						valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(columnValue) ).append( "]]></tran_code>\r\n" );
						valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( descr) ).append( "]]></transporter_tran_name>\r\n" );		
						valueXmlString.append( "</Detail1>\r\n" );
						valueXmlString.append( "<Detail2>\r\n" );
						valueXmlString.append( "<tran_code><![CDATA[" ).append( checkNull(columnValue) ).append( "]]></tran_code>\r\n" );
						valueXmlString.append( "<transporter_tran_name><![CDATA[" ).append( checkNull( descr) ).append( "]]></transporter_tran_name>\r\n" );
					}
					//changed by sankara on 08/08/13 if tran_code changed in ship detail dispayed in header end..    
					
				}

				
				else if( currentColumn.trim().equalsIgnoreCase( "gross_weight" ) )
				{
					System.out.println("inside the gross_weight detail2");
					columnValue = checkNull(genericUtility.getColumnValue("gross_weight",dom));
					columnValue1 = checkNull(genericUtility.getColumnValue("tare_weight",dom));
					if(columnValue.trim().length() > 0)
					{
						//changed by Rohan on 16-02-13 to get amount in double 
						//amt1 = Integer.parseInt(columnValue);
						amt1 = Double.parseDouble(columnValue);
					}
					if(columnValue1.trim().length() > 0)
					{
						//changed by Rohan on 16-02-13 to get amount in double 
						//amt2 = Integer.parseInt(columnValue1);
						amt2 = Double.parseDouble(columnValue1);
					}
					amt3 = amt1 - amt2 ;
					System.out.println("amount1 "+amt1 + " amount2 "+amt2);
					valueXmlString.append( "<net_amt><![CDATA[" ).append( amt3 ).append( "]]></net_amt>\r\n" );
				}
				
				else if( currentColumn.trim().equalsIgnoreCase( "tare_weight" ) )
				{
					System.out.println("inside the tare_weight detail2");
					columnValue = checkNull(genericUtility.getColumnValue("gross_weight",dom));
					columnValue1 = checkNull(genericUtility.getColumnValue("tare_weight",dom));
					if(columnValue.trim().length() > 0)
					{
						//changed by Rohan on 16-02-13 to get amount in double 
						//amt1 = Integer.parseInt(columnValue);
						amt1 = Double.parseDouble(columnValue);
					}
					if(columnValue1.trim().length() > 0)
					{
						//changed by Rohan on 16-02-13 to get amount in double 
						//amt2 = Integer.parseInt(columnValue1);
						amt2 = Double.parseDouble(columnValue1);
					}
					amt3 = amt1 - amt2 ;
					System.out.println("amount1 "+amt1 + " amount2 "+amt2);
					valueXmlString.append( "<net_amt><![CDATA[" ).append( amt3 ).append( "]]></net_amt>\r\n" );
				}
				valueXmlString.append( "</Detail2>\r\n" );
				System.out.println("------------------------COMPLETE DESCRIPTION-------------------");
				break;
			}
			//Changed by Rohan on 30-7-13 for generation carton no and pallet no in itm default.start
			case 3:
			{
			
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail3>");
				childNodeListLength = childNodeList.getLength();
				grossWeight = checkNull(genericUtility.getColumnValue("gross_weight",dom2));	
				System.out.println("Gross weight All dom?@@22@@"+grossWeight);
				grossWeight = checkNull(genericUtility.getColumnValue("gross_weight",dom));
				System.out.println("Gross weight All dom@@00@@?"+grossWeight);
				grossWeight = checkNull(genericUtility.getColumnValue("gross_weight",dom1));
				System.out.println("Gross weight All dom@@11@@"+grossWeight);
				
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//Changed by Rohan on 12-08-13 for gross weight ogf shipment header populate in shipment content
					grossWeight = checkNull(genericUtility.getColumnValue("gross_weight",dom1));
					System.out.println("Gross weight All dom@@11@@----->"+grossWeight);
					
					cartonNo = generateCartonNo("w_carton_no_gen",xtraParams,conn);
					palletNo = generatePalletNo("w_palletprc",xtraParams,conn);
					
					System.out.println("cartonNo:"+cartonNo+":palletNo:"+palletNo+"]");
					valueXmlString.append( "<carton_no><![CDATA[" ).append( checkNull(cartonNo) ).append( "]]></carton_no>\r\n" );
					valueXmlString.append( "<pallet_no><![CDATA[" ).append( checkNull(palletNo )).append( "]]></pallet_no>\r\n" );
					valueXmlString.append( "<gross_weight><![CDATA[" ).append(grossWeight).append( "]]></gross_weight>\r\n" );
					
				}
				
				valueXmlString.append( "</Detail3>\r\n" );
				break;
			}
			//Changed by Rohan on 30-7-13 for generation carton no and pallet no in itm default.end
		}
	}
	catch(Exception e)
	{
		System.out.println( "Exception :Shipment :itemChanged(Document,String):" + e.getMessage() + ":" );
		valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			if( conn != null && ! conn.isClosed() )
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				conn.close();
			}
			//System.out.println("------------------------INSIDE FINALLY-------------------");
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Shipment:itemChanged :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
	}
	valueXmlString.append( "</Root>\r\n" );	
	System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
	return valueXmlString.toString();
}
private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
{
	Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

	if( tempNode != null )
	{
		if( tempNode.getFirstChild() == null )
		{
			CDATASection cDataSection = dom.createCDATASection( nodeVal );
			tempNode.appendChild( cDataSection );
		}
		else
		{
			tempNode.getFirstChild().setNodeValue(nodeVal);
		}
	}
	tempNode = null;
}	
private String checkNull( String input )
{
	if ( input == null )
	{
		input = "";
	}
	return input;
}	
	// 02/08/12 manoharan following method added to generate SSCC18 complaint number
	private String getSSCC(String mfgCode, long runNumber, Connection conn) throws Exception 
	{
		boolean isOdd = false;
		long sumOdd = 0, sumEven = 0;
		String inputStr = "", sscc18 = "",  runNumberStr =""; //mfgCode = "0351672",
		//ibase.utility.GenericUtility genUtility = ibase.utility.GenericUtility.getInstance();
		long  chkDigit = 0,curDigit = 0;
		int ctr=0,  padLen = 0; // runNumber = 4967235
		try
		{
			if (mfgCode == null) 
			{
				mfgCode = "";
			}
			sumOdd = 0;
			sumEven = 0;
			padLen = 16 - mfgCode.length(); // total length should be 16 excluding extension digit and check digit
			System.out.println("@@@@@ mfgCode.length()["+mfgCode.length()+"]");
			System.out.println("@@@@@ padLen["+padLen+"]");
			runNumberStr = String.valueOf(runNumber); //"0000000000000000" + 
			runNumberStr = runNumberStr.substring(runNumberStr.length() - padLen ,runNumberStr.length()); 
			inputStr = mfgCode + runNumberStr;
			for (int pos = inputStr.length() - 1; pos >= 0 ; pos--)
			{
				curDigit = Long.parseLong(inputStr.substring(pos,pos+1));
				if  ( (pos % 2) == 0)
				{
					sumEven +=  curDigit;
				}
				else
				{
					sumOdd += curDigit;
				}
				
			}
			// step 1  - multiple odd sum with 3
			sumOdd = sumOdd * 3;
			chkDigit =  10 - ((sumEven + sumOdd) % 10) ;
			//System.out.println(  " Integer(chkDigit).toString() [" + String.valueOf(chkDigit) +"]" );
			//sscc18 = 
			sscc18 = inputStr + String.valueOf(chkDigit);
			System.out.println(" chkDigit [" + chkDigit + "] sumOdd [" + sumOdd + "] sumEven [" + sumEven + "] inputStr [" + inputStr + "] sscc18 [" + sscc18 +"]" );
			
				
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return sscc18;
	}
	
	private String getLrNo( String xtraParams,Connection conn) throws Exception
	{

		boolean isOdd = false;
		int sumOdd = 0, sumEven = 0;
		String inputStr = "", lrNo = "",  runNumberStr =""; //mfgCode = "0351672",
		//ibase.utility.GenericUtility genUtility = ibase.utility.GenericUtility.getInstance();
		int ctr, curDigit = 0, chkDigit = 0, padLen = 0; // runNumber = 4967235
		long runNumber=0;
		//TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), "BASE",CommonConstants.DB_NAME);
		String windowName="";
		PreparedStatement pSel = null;
		PreparedStatement pIns = null;	
		ResultSet rsSel = null;
	//	Connection conn = null;
		String mfgCode = null;
		String sSel = "";
		String sIns = "";
		String siteCode = "";
		String labelType = "";
		String labelID = "";
		String keyString = "";
		String tranIDCol = "";
		String refSer = "";
		String retString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{
			if (mfgCode == null) 
			{
				mfgCode = "04";
			}
			System.out.println("@@@@@ getLrNo called..........");
			windowName = "w_bol_gen";
			sSel = "SELECT KEY_STRING, TRAN_ID_COL,REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pSel = conn.prepareStatement(sSel);
			pSel.setString(1, windowName);
			rsSel = pSel.executeQuery();
			if( rsSel.next() )
			{
				keyString = rsSel.getString( "KEY_STRING" );
				tranIDCol = rsSel.getString("TRAN_ID_COL");
				refSer = rsSel.getString("REF_SER");
			}
			//refSer="BOL-NO";
			String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"site_code");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			System.out.println(genericUtility.getDBDateFormat());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			String currDate = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(timestamp).toString();
			StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>");
			xmlValues = xmlValues.append("<Header></Header>");
			xmlValues = xmlValues.append("<Detail1>");
			xmlValues.append( "<dummy>").append("<![CDATA[]]>").append("</dummy>\r\n" );
			xmlValues.append( "<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>\r\n" );
			xmlValues.append( "<tran_date>").append("<![CDATA[" + currDate + "]]>").append("</tran_date>\r\n");
			xmlValues.append( "<loginCode><![CDATA[" ).append(loginCode).append( "]]></loginCode>\r\n" );
			xmlValues.append( "<lr_no></lr_no>\r\n");
			xmlValues.append( "<bol_no></bol_no>\r\n");
			xmlValues = xmlValues.append( "</Detail1></Root>");
			
			System.out.println("refSer:["+refSer+"]:::tranIDCol:["+tranIDCol+"]::::keyString:["+keyString+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), "BASE",CommonConstants.DB_NAME);
			
			runNumber = Long.parseLong(tg.generateTranSeqID(refSer, tranIDCol, keyString, conn));
			conn.commit();
			System.out.println("runNumber:["+runNumber+"]");
	
			padLen = 16 - mfgCode.length(); // total length should be 16 excluding extension digit and check digit
			
			runNumberStr = "0000000000000000" + String.valueOf(runNumber);
			runNumberStr = runNumberStr.substring(runNumberStr.length() - padLen ,runNumberStr.length()); 
			lrNo = mfgCode + runNumberStr;
			System.out.println(  " lrNo [" + lrNo + "] lrNo.length() [" +  lrNo.length() + "]" );
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return lrNo;
	
	}
	
	//Changed by sumit on 23/01/13 getting attribute value start.
	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = GenericUtility.getInstance().serializeDom(detailNode);
			Document dom = GenericUtility.getInstance().parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	//Changed by sumit on 23/01/13 getting attribute value end.
	//Changed by sumit on 23/01/13 checking duplicate PTCN start.
	private ArrayList checkDuplicaterecord(Document dom) throws ITMException
	{
		ArrayList arryList = new ArrayList();
		
		NodeList parentNodeList = null, childNodeList  = null;
		Node parentNode = null, childNode = null;
	    int parentNodeListLength = 0;
	    String childNodeName = "";
		
		try {
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for (int row = 0; row < parentNodeList.getLength(); row++) 
			{
				parentNode = parentNodeList.item(row);				
				String updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
				System.out.println(" sumit updateFlag ["+updateFlag+"]");
				childNodeList = parentNode.getChildNodes();
				
				//System.out.println("************* first For loop *************["+ parentNode.getNodeName() + "]");
				for (int col = 0; col < childNodeList.getLength(); col++) {
					childNode = childNodeList.item(col);
					
					if (childNode.getNodeType() == childNode.ELEMENT_NODE) {
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeNamechildNodeName ** ["+childNodeName+"]");
						if( !"D".equalsIgnoreCase(updateFlag))
						{
							if ("ptcn".equalsIgnoreCase(childNodeName)) 
							{
								arryList.add(childNode.getFirstChild().getNodeValue().trim());
								//arrayList.add(i,childNode.getFirstChild().getNodeValue());
								//map = sprsCode != null ? sprsCode : "";
								System.out.println("=====ptcn-->[" + arryList+ "]");
								
							}
						}
					}
				}
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return arryList;
	}	
	//Changed by sumit on 23/01/13 checking duplicate PTCN end.
	private String generateCartonNo(String windowName,String xtraParams,Connection conn)throws Exception
	{
		String errString = "";		
		String sql = "",sqlInsert = "";
		PreparedStatement pstmt = null,pstmtInsert = null;
		ResultSet rs = null;
		String chgUser="",chgTerm="",keyString="",tranIDCol="",refSer="";
		String xmlString="",tranIDSer="";
		int updCnt = 0;
		String crtnType = "";
		String cartonNumber="";
		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		try
		{
			System.out.println("*****************going for generation oc carton no***************************");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			
			Timestamp currDate = new Timestamp(System.currentTimeMillis());
			xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
            "\r\n</header><Detail1>"+
            "\r\n<carton_no></carton_no>"+
            "</Detail1></Root>";
			System.out.println("xmlString : : : : :"+xmlString);
			TransIDGenerator tg = new TransIDGenerator(xmlString,"BASE",CommonConstants.DB_NAME);
			
			sql = "SELECT KEY_STRING, TRAN_ID_COL,REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				keyString = rs.getString( "KEY_STRING" );
				tranIDCol = rs.getString("TRAN_ID_COL");
				refSer = rs.getString("REF_SER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt =null;
			keyString = keyString.substring(keyString.indexOf(","));
		
			sqlInsert = "INSERT INTO CARTON_MASTER (CARTON_NO, STATUS, CHG_DATE, CHG_USER, CHG_TERM, " +
			" CARTON_TYPE) VALUES (?,?,?,?,?,?) ";
			
			pstmtInsert = conn.prepareStatement(sqlInsert);
			tranIDSer = tg.generateTranSeqID(refSer, tranIDCol, keyString, conn);
			cartonNumber = getSSCC18("", Integer.parseInt(tranIDSer), conn);
			System.out.println("Generated Key :: "+tranIDSer);
			if (tranIDSer.indexOf("ERROR") > -1 )
			{
				errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
				return errString;
			}
		
			pstmtInsert.setString(1,cartonNumber);
			pstmtInsert.setString(2,"A");
			pstmtInsert.setTimestamp(3,currDate);
			pstmtInsert.setString(4,chgUser);
			pstmtInsert.setString(5,chgTerm);
			pstmtInsert.setString(6,"N");
			updCnt = pstmtInsert.executeUpdate();
			

			if(updCnt > 0)
			{
				errString = cartonNumber;
			}
			
			if(pstmtInsert != null)
			{
				pstmtInsert.close();
				pstmtInsert = null;
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);		
		}
		finally
		{			
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInsert != null)
				{
					pstmtInsert.close();
					pstmtInsert = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);		
			}
		}
		
		return errString;
	}
	//Changed by Rohan on 30-7-13 for generation carton no.end
	//Changed by Rohan on 30-7-13 for generation pallet no.start
	private String generatePalletNo(String windowName,String xtraParams,Connection conn)throws Exception
	{
		String sSel = "";
		String sIns = "";
		String cartonID = "";
		String palletNo = "";
		String printer = "";
	    String PalletLabel = "";
	    String keyString = "",refSer = "",tranIDCol = "";
		int numCarton = 0;
		int numPallet = 0;
		int updCnt = 0;
		PreparedStatement pSel = null;
		PreparedStatement pIns = null;	
		ResultSet rsSel = null;
		//Connection conn = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		/*setting LabelType using window name*/
		
		try
		{	
			System.out.println("*****************going for generation of Pallet no***************************");
			/*
			ConnDriver connDriver = new ConnDriver();			
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			*/
			sSel = "SELECT KEY_STRING, TRAN_ID_COL,REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pSel = conn.prepareStatement(sSel);
			pSel.setString(1, windowName);
			rsSel = pSel.executeQuery();
			if( rsSel.next() )
			{
				keyString = rsSel.getString( "KEY_STRING" );
				tranIDCol = rsSel.getString("TRAN_ID_COL");
				refSer = rsSel.getString("REF_SER");
			}

			String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			
			StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>");
			xmlValues = xmlValues.append("<Header></Header>");
			xmlValues = xmlValues.append("<Detail1>");
			
			if(windowName.trim().equals("w_palletprc"))
			{
				numPallet = 1;	
				xmlValues = xmlValues.append("<pallet_no></pallet_no>");
			}
			xmlValues = xmlValues.append( "</Detail1></Root>");
			
			Timestamp currDate = new Timestamp(System.currentTimeMillis());
			
			TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), "BASE",CommonConstants.DB_NAME);
		
			sIns = " INSERT INTO PALLET_NO (PALLET_NO,STATUS) VALUES (?,'A') "; 
			pIns = conn.prepareStatement(sIns);
			palletNo = tg.generateTranSeqID(refSer, tranIDCol, keyString, conn);
			pIns.setString(1,palletNo);
			updCnt = pIns.executeUpdate();
			
			System.out.println(":ROWS INSERTED:["+updCnt+"]");
			
		} 
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);		
		}
		finally
		{			
			try
			{
				if(rsSel != null)
				{
					rsSel.close();
					rsSel = null;
				}
				if(pIns != null)
				{
					pIns.close();
					pIns = null;
				}
				if(pSel != null)
				{
					pSel.close();
					pSel = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);		
			}
		}
		
		return palletNo ;
	}
	//Changed by Rohan on 30-7-13 for generation pallet no.start
	//Changed by Rohan on 31-07-13 generate SSCC18 complaint number
	// 02/08/12 manoharan following method added to generate SSCC18 complaint number
	private String getSSCC18(String mfgCode, int runNumber, Connection conn) throws Exception 
	{
		boolean isOdd = false;
		int sumOdd = 0, sumEven = 0;
		String inputStr = "", sscc18 = "",  runNumberStr =""; //mfgCode = "0351672",
		//ibase.utility.GenericUtility genUtility = ibase.utility.GenericUtility.getInstance();
		int ctr, curDigit = 0, chkDigit = 0, padLen = 0; // runNumber = 4967235
		try
		{
			if (mfgCode == null || mfgCode.length() <= 0) 
			{
				mfgCode = "04";
			}
			sumOdd = 0;
			sumEven = 0;
			padLen = 16 - mfgCode.length(); // total length should be 16 excluding extension digit and check digit
			
			runNumberStr = "0000000000000000" + String.valueOf(runNumber);
			
			runNumberStr = runNumberStr.substring(runNumberStr.length() - padLen ,runNumberStr.length()); 
			inputStr = mfgCode + runNumberStr;
			
			System.out.println(  " inputStr [" + inputStr + "] inputStr.length() [" +  inputStr.length() + "]" );
			for (int pos = inputStr.length() - 1; pos >= 0 ; pos--)
			{
				
				curDigit = Integer.parseInt(inputStr.substring(pos,pos+1));
				System.out.println(  " pos [" + pos +"] curDigit [" + curDigit + "]" );
				if  ( (pos % 2) == 0)
				{
					sumEven +=  curDigit;
				}
				else
				{
					sumOdd += curDigit;
				}
				
			}
			// step 1  - multiple odd sum with 3
			sumOdd = sumOdd * 3;
			chkDigit =  10 - ((sumEven + sumOdd) % 10) ;
			
			if(chkDigit > 9)
			{
				chkDigit = 0;
			}
			//System.out.println(  " Integer(chkDigit).toString() [" + String.valueOf(chkDigit) +"]" );
			//sscc18 = 
			sscc18 ="0" + inputStr + String.valueOf(chkDigit);
			System.out.println(" chkDigit [" + chkDigit + "] sumOdd [" + sumOdd + "] sumEven [" + sumEven + "] inputStr [" + inputStr + "] sscc18 [" + sscc18 +"]" );
			
				
		}
		catch(Exception e){
		throw e;
		}
		return sscc18;
	}
 
}