package ibase.webitm.servlet.wms;

import ibase.webitm.utility.wms.WebServiceAuthenticationService;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import oracle.net.ano.AuthenticationService;

public class WebServiceAuthenticationFilter implements javax.servlet.Filter 
{
	public static final String AUTHENTICATION_HEADER = "Authorization";

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,FilterChain filter) throws IOException, ServletException
	{
		if (request instanceof HttpServletRequest)
		{
			HttpServletRequest httpServletRequest = (HttpServletRequest) request;
			String authCredentials = httpServletRequest.getHeader(AUTHENTICATION_HEADER);

			WebServiceAuthenticationService authenticationService = new WebServiceAuthenticationService();

			boolean authenticationStatus = authenticationService.authenticate(authCredentials);

			if (authenticationStatus)
			{
				filter.doFilter(request, response);
			}
			else
			{
				if (response instanceof HttpServletResponse)
				{
					HttpServletResponse httpServletResponse = (HttpServletResponse) response;
					httpServletResponse.getWriter().println("Please enter correct username and password!");
					httpServletResponse.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
				}
			}
		}
	}

	@Override
	public void destroy() {
	}

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}
}