<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/default.css"/>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body >

<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/ITMWizardCalendar.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/MilestonePayGen.js"></script>

<script>
	var calendertop = 100;
	var calenderleft = 200;
	var selectedObj = null;
	var global_date_format ="dd/MM/yy";
	var global_date_type= "date";




	function assignDate( date )
	{
	document.getElementById( selectedObj ).value = date;
	document.getElementById( selectedObj ).focus();
	}
	
	function displayActCode1(actCode, actDescr,setId ,domId)
    {
 
	document.getElementById("Detail1."+domId+".purc_order").value = actCode;
	}
   
   function displayActCode2(actCode, actDescr,setId ,domId)
   {
   	document.getElementById("Detail1."+domId+".proj_code").value = actCode;
   }


	function checkForactFinish()
	{
	var actCode = "";
	if ( document.getElementById("Detail1..activity_code") != null )
	{
	actCode = document.getElementById("Detail1..activity_code").value;
	}
	else
	{
	actCode = document.getElementById("Detail1.1.activity_code").value;
	}
	var finishButton = document.getElementById("ActFinish");
	var nextButton = document.getElementById("ActNext");

	if(actCode != null &amp; (actCode == "CL" || actCode == "SL" || actCode == "TL"
	|| actCode == "PL" || actCode == "BD" || actCode == "HL" || actCode ==
	"SD" || actCode == "OH" || actCode == "CO" || actCode == "ED"))
	{
	finishButton.disabled = false;
	nextButton.disabled = true;
	}
	else
	{
	finishButton.disabled = true;
	nextButton.disabled = false;

	}
	}
	function addLoadEvent(func)
	{
	var oldonload = window.onload;
	if (typeof window.onload != 'function')
	{
	window.onload = func;
	}
	else
	{
	window.onload = function()
	{
	if (oldonload)
	{
	oldonload();
	}
	func();
	}
	}
	}
	addLoadEvent(checkForactFinish);
</script>

<style type="text/css">

.tableClass
{margin-left:10px;margin-top:20px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:11pt;text-align:center}

.header_td1
{border:inset 0;font-family:"Times New Roman", Times, serif;font-size:10pt;text-align:left}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}


.td_leftAlign1
{text-align:left;font-family:"Times New Roman", Times, serif;font-size:9pt;color: #0099CC;}

.td_leftAlign2
{text-align:right;font-family:"Times New Roman", Times, serif;font-size:9pt;color: #0099CC;}




.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.hide
{display:none }


</style>



<form name = "Wizard_activity" METHOD="POST" ACTION="/ibase/ITMWizardHandlerServlet" autocomplete="off"  onSubmit="javascript:return validateActivity('1');">


	
	<table id="activityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1" width="60%" >
		<tr>
			<td class="header_td1" colspan="4">
				<strong>Milestone Pay Generation</strong>
			</td>
		</tr>
		
		
		<xsl:for-each select="//Detail1">

                        <xsl:variable name="process_date"><xsl:value-of select="process_date"/></xsl:variable>
			<xsl:variable name="release_against"><xsl:value-of select="release_against"/></xsl:variable>
			<xsl:variable name="proj_code"><xsl:value-of select="proj_code"/></xsl:variable>
			<xsl:variable name="purc_order"><xsl:value-of select="purc_order"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="dbID"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			
           <tr>
				<td class="td_leftAlign2"  nowrap="true"  width="10%">
					<strong>Purchase Order :</strong>
				</td>
				<td  >
					<input type="text" class="input_editable" size="15" value="{$purc_order}" name="Detail1.{normalize-space($dbID)}.purc_order" id="Detail1.{normalize-space($dbID)}.purc_order" maxlength="10" ISCHANGED="false"/>
					<a href="javascript:callActivityTypeJSP1( '{normalize-space($dbID)}','{normalize-space($purc_order)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a>
				</td>
				
				<td class="td_leftAlign1" nowrap="true" width="10%">
					<strong>Project Code :</strong>
				</td>
				<td>
					<input type="text" class="input_editable" size="15" value="{$proj_code}" name="Detail1.{normalize-space($dbID)}.proj_code" id="Detail1.{normalize-space($dbID)}.proj_code" maxlength="10" ISCHANGED="false"/>
					<a href="javascript:callActivityTypeJSP2( '{normalize-space($dbID)}','{normalize-space($proj_code)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" id="project_pophelp" border="0"/> </a>
				</td>
			</tr>



			<!-- <tr>
				<td class="td_leftAlign1" nowrap="true">
					<strong>Release Against:</strong>
				</td>
				<td>
				
                             <select id="Detail1.{normalize-space($dbID)}.release_against"
								name="Detail1.{normalize-space($dbID)}.release_against" class="input_editable"
												value="{$release_against}" style="height: 20px" tabindex="1">
												<option value="05">Project milestone</option>
												<option value="06">User-defined Milestone</option>
								</select>
				</td>
				<td class="td_leftAlign1" nowrap="true">
					<strong>Process Date :</strong>
				</td>
				<td>
                    <input type="text" class="input_editable" size="15" value="{$process_date}" name="Detail1.{normalize-space($dbID)}.process_date" id="Detail1.{normalize-space($dbID)}.process_date" maxlength="8"  ISCHANGED="false" /> 
					<img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.process_date'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.process_date','','','MM/DD/YY');"/>
					<img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.process_date'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.process_date','','','DD/MM/YY');"/>
				</td>
				
			</tr> -->
			<tr>
				<td class="td_leftAlign1" nowrap="true">
					<strong>Milestone Process Adhoc :</strong>
				</td>
				<td>
				<input type="checkbox" name="adhocFlag"  id="adhocFlag" value="false" onClick="setCheckedFlag(this ,'{normalize-space($dbID)}')"/>
				</td>
				<td>
				<!-- <input type="hidden" name="Detail1..adhoc_value" value="false" id="Detail1..adhoc_value" /> -->
				<input type="hidden" name="Detail1.{normalize-space($dbID)}.adhoc_value" value="false" id="Detail1.{normalize-space($dbID)}.adhoc_value" />
				</td>
			</tr>
			
			<tr>
			<td >
				<div id = "teamCodes{normalize-space($dbID)}" name="teamCodes{normalize-space($dbID)}" style="display:none"><span id = "teamSpanCodes{normalize-space($dbID)}" ><font  face="Verdana">
				</font></span></div>
			</td>
			</tr>
		</xsl:for-each>
		<tr>
		<td colspan="2">
			<input  type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="milestone_pay_gen" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />
			
		 <input type="submit" style="cursor:hand"  value="Next" name = "ActNext" id = "ActNext" title=''  onclick="return setActionVal('next')"/>  
		</td>
               </tr>
	</table>
	<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
			
			<xsl:for-each select="//error">
			    			    
				<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="message"/>
					</td>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
					<tr>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Override Warnings :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							<input  type="checkbox"  name="forceSave"  value="false" onClick="setChecked(this)"/>
						</td>
					</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
			
	</table>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
