<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
	<head>				
		<link type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css"/>		
	</head>
	<body> 
		<div>					
			<table width="100%" class="tTableHeader">
			<tr>
				<td colspan="4" align="center" class="tTitle">Debit Note</td>
			</tr>			
			<tr>
				<td>
					<span class="tLabel">Transaction ID : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/tran_id"/></span>
				</td>
				<td>
					<span class="tLabel">Transaction Date : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/tran_date"/></span>
				</td>
				<td colspan="2">
					<span class="tLabel">Site: </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/site_code"/> [<xsl:value-of select="//Detail1/site_descr"/>]</span>
				</td>
			</tr>
			<tr>
				<td>
					<span class="tLabel">Reference Series : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/tran_ser"/></span>
				</td>
				<td>
					<span class="tLabel">Currency Code : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/curr_code"/></span>
				</td>
				<td>
					<span class="tLabel">Exchange Rate : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/exch_rate"/></span>
				</td>
				<td>
					<span class="tLabel">Amount : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/amount"/></span>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<span class="tLabel">Account : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/acct_code"/> [<xsl:value-of select="//Detail1/accounts_descr"/>]</span>
				</td>
				<td>
					<span class="tLabel">Cost center : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/cctr_code"/></span>
				</td>
				<td>
					<span class="tLabel">Analysis Code : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/anal_code"/></span>
				</td>				
			</tr>
			<tr>
				<td colspan="3">
					<span class="tLabel">Remarks : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/remarks"/></span>
				</td>			
				<td>
					<span class="tLabel">Change User : </span>
					<span class="tLabelData"><xsl:value-of select="//Detail1/change_user"/></span>
				</td>
			</tr>
			</table>	
		</div>
			
		<br /><br />
			
		<xsl:if test="//Detail2/line_no!=''">
		<div>
			<table width="100%" class="tTableDetail">						
			<tr>
				<td colspan="7" align="center" class="tTitleD">Pay Detail</td>
			</tr>
			<tr>
				<td class="tLabelD">Line No</td>
				<td class="tLabelD">Reason Code</td>
				<td class="tLabelD">DR/CR Amount</td>
				<td class="tLabelD">Tax Amount</td>
				<td class="tLabelD">Net Amount</td>
				<td class="tLabelD">Account</td>
				<td class="tLabelD">Cost center</td>
			</tr>
			<xsl:for-each select="//Detail2">						
				<tr>
					<td class="tLabelDataD"><xsl:value-of select="line_no"/></td>
					<td class="tLabelDataD"><xsl:value-of select="reas_code"/></td>
					<td class="tLabelDataD"><xsl:value-of select="drcr_amt"/></td>
					<td class="tLabelDataD"><xsl:value-of select="tax_amt"/></td>
					<td class="tLabelDataD"><xsl:value-of select="net_amt"/></td>
					<td class="tLabelDataD"><xsl:value-of select="acct_code"/> [<xsl:value-of select="accounts_descr"/>]</td>
					<td class="tLabelDataD"><xsl:value-of select="cctr_code"/></td>
				</tr>
			</xsl:for-each>			
			</table>
		</div>
		</xsl:if>
		
		<br />
		
		<xsl:if test="//Detail3/line_no!=''">
		<div>
			<table width="100%" class="tTableDetail">						
			<tr>
				<td colspan="5" align="center" class="tTitleD">Pay Account</td>
			</tr>					
			<tr>
				<td class="tLabelD">Line No</td>
				<td class="tLabelD">Analysis Code</td>
				<td class="tLabelD">Amount</td>
				<td class="tLabelD">Account</td>
				<td class="tLabelD">Cost center</td>
			</tr>			
			<xsl:for-each select="//Detail3">						
			<tr>
				<td class="tLabelDataD"><xsl:value-of select="line_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="anal_code"/></td>
				<td class="tLabelDataD"><xsl:value-of select="amount"/></td>
				<td class="tLabelDataD"><xsl:value-of select="acct_code"/> [<xsl:value-of select="accounts_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="cctr_code"/></td>
			</tr>			
			</xsl:for-each>			
			</table>		
		</div>
		</xsl:if>
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
