package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class BudgetGroupAcctConfirm  extends ActionHandlerEJB implements BudgetGroupAcctConfirmLocal,BudgetGroupAcctConfirmRemote
{

	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------actionHandler method of BudgetGroupAcctConfirm ------------- : ");
		String retString = "";		
		try
		{						
			retString = confirmBudget(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :BudgetGroupAcctConfirm :actionHandler():" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	
	private String confirmBudget(String tranId,String xtraParams,String forcedFlag) 
	{

		System.out.println("--------------confirm method of BudgetGroupAcctConfirm ------------- ");
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		 ITMDBAccessEJB itmdbAccess=new ITMDBAccessEJB();
		 ResultSet rs = null;
		PreparedStatement pstmt = null;	
		String retString = "",errString="";
		String sql = "",confirmed="";
				
		try
		{	
			 conn = ConnDriver.getConnectDB("DriverITM");
			 conn.setAutoCommit(false);				
			sql = "select confirmed from bud_grp_acct where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString(1)==null ? "":rs.getString(1);
			}	
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			if( confirmed != null && confirmed.equalsIgnoreCase("Y") )
			{
				errString = itmdbAccess.getErrorString("", "VTALLCONF", "", "", conn);
				return errString;
			}
			else
			{
				int updCnt =updateConfirm(conn,tranId,xtraParams);			
				System.out.println("UPDATE COUNT --updCnt-->>"+updCnt);
				if (updCnt > 0 )
				{			
					retString=new ITMDBAccessEJB().getErrorString("", "VTCONSUCC", "", "", conn);
					conn.commit();
					System.out.println("Confirm and conf date updated successfully.......");
					
				}
			}
				
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
		
	}
	
	
	
	
	private int updateConfirm(Connection conn,String tranId,String xtraParams)
	{
		System.out.println("---------in updateConfirm method------------");
		String loginEmpCode ="",sql;
		PreparedStatement pstmt1=null;
		int count=0;
		sql="update bud_grp_acct set confirmed = ?,conf_date = ?,emp_code__aprv = ? where tran_id = ?";
		try
		{	
			loginEmpCode=GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			pstmt1 = conn.prepareStatement( sql );	
			pstmt1.setString(1, "Y");
			pstmt1.setTimestamp(2, this.getCurrdateAppFormat()); 
			pstmt1.setString(3, loginEmpCode);
			pstmt1.setString(4, tranId);
			
			count = pstmt1.executeUpdate();
			System.out.println("confirm updated -------->>>>>>>>>updCount :"+count);			
			
		}
		
		catch(SQLException se)
		{
			se.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();					
		}
		try
		{
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;					
			}
				
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			e.printStackTrace();
			
		}
		return count;
	}
	
	private java.sql.Timestamp getCurrdateAppFormat()
    {
        GenericUtility genericUtility = GenericUtility.getInstance();
		Timestamp timestamp = null;
        try
        {
            java.util.Date date = null;
            timestamp = new Timestamp(System.currentTimeMillis());            
            SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
            date = simpledateformat.parse(timestamp.toString());
            timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
        }
        catch(Exception exception)
        {
            System.out.println("Exception in [BudgetGroupAcctConfirm] getCurrdateAppFormat " + exception.getMessage());
            exception.printStackTrace();
        }
        return timestamp;
    }
}
