
package ibase.webitm.ejb.fin;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.system.config.*;
import ibase.wrkflw.*;
import ibase.wrkflw.utility.WorkflowLogger;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.*;

@Stateless
public class BudGrpAmdWS extends ValidatorEJB implements BudGrpAmdWSLocal, BudGrpAmdWSRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public String BudGrpAmdWS(String tranID, String processId, String refSeries, String flag ) throws ITMException ,RemoteException
	{
		Connection                  conn = null;
		ConnDriver            connDriver = null;
		String retString = "";
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			if("A".equalsIgnoreCase(flag) || "R".equalsIgnoreCase(flag))//Quotation Approve
			{
				System.out.println("updateRejectionRemark() Called !!! ");
				retString = updateRejectionRemark(tranID,processId, refSeries,flag);
			}
					}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
		
	}
	
		private String getRejectionRemark(Connection conn, String refID, String processId, String refSeries,String flag) throws ITMException ,RemoteException
	{	
		PreparedStatement pstmtCheckStatus = null;
		ResultSet rsCheckStatus = null;
		String rejectionRemark = "";
		try
		{
			System.out.println("@@@@@ getRejectionRemark()===>>> refID["+refID+"]:::processId["+processId+"]:::refSeries["+refSeries+"]::::flag["+flag+"]");
			
			String getRejectionRemarkSql = "SELECT SIGN_REMARKS FROM OBJ_SIGN_TRANS " +
					  "WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = (SELECT MAX(LINE_NO) FROM OBJ_SIGN_TRANS "+
					  "WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = ? ) "; 
			
			
			PreparedStatement pstmtGetRejRemark = conn.prepareStatement(getRejectionRemarkSql);
			pstmtGetRejRemark.setString(1,refSeries);
			pstmtGetRejRemark.setString(2,refID);
			pstmtGetRejRemark.setString(3,refSeries);
			pstmtGetRejRemark.setString(4,refID);
			pstmtGetRejRemark.setString(5,flag );
			ResultSet rsGetRejRemark = pstmtGetRejRemark.executeQuery();
			
			if(rsGetRejRemark.next())
			{
				rejectionRemark = rsGetRejRemark.getString("SIGN_REMARKS");
			}
			int updateCount = pstmtGetRejRemark.executeUpdate();
			rsGetRejRemark.close();
			rsGetRejRemark = null;
			pstmtGetRejRemark.close();
			pstmtGetRejRemark = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(rsCheckStatus != null)
				{
					rsCheckStatus.close();
					rsCheckStatus = null;
				}
				if(pstmtCheckStatus != null)
				{
					pstmtCheckStatus.close();
					pstmtCheckStatus = null;
				}
			}catch(Exception e)
			{
				System.out.println("Exception ::"+e.getMessage());
			}
		}
		System.out.println("rejectionRemark =["+rejectionRemark+"]");
		return rejectionRemark;
	}
	private String updateRejectionRemark(String refID, String processId, String refSeries,String flag) throws ITMException ,RemoteException
	{	
		Connection conn = null;
		PreparedStatement pstmtCheckStatus = null;
		ResultSet rsCheckStatus = null;
		String retString = "1",flagStatus="";
		try
		{
			ConnDriver conDriver = new ConnDriver();
			
			conn = conDriver.getConnectDB("DriverITM");
			System.out.println("@@@@@ getRejectionRemark()===>>> refID["+refID+"]:::processId["+processId+"]:::refSeries["+refSeries+"]::::flag["+flag+"]");
			if("A".equalsIgnoreCase(flag))
			{
				flagStatus = "Approved";
			}
			else if("R".equalsIgnoreCase(flag))
			{
				String rejectionRemark = getRejectionRemark(conn, refID, processId, refSeries,flag);
				flagStatus = "Rejected - " + rejectionRemark;
			}
			
			String updateRejectionRemarkSql = "UPDATE budgrp_allo_amd  SET WF_STATUS = ? WHERE amd_no = ?";
			PreparedStatement pstmtUpdRejRemark = conn.prepareStatement(updateRejectionRemarkSql);
			pstmtUpdRejRemark.setString(1,flagStatus );
			pstmtUpdRejRemark.setString(2,refID);
			int updateCount = pstmtUpdRejRemark.executeUpdate();
			pstmtUpdRejRemark.close(); pstmtUpdRejRemark = null;
			System.out.println("updateCount[updateRejectionRemark] =["+updateCount+"]");
			if( updateCount > 0 )
			{
				retString = "1";
				conn.commit();
			}
			else
			{
				retString = "0";
			}
		}
		catch(Exception e)
		{
			retString = "0";
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(rsCheckStatus != null)
				{
					rsCheckStatus.close();
					rsCheckStatus = null;
				}
				if(pstmtCheckStatus != null)
				{
					pstmtCheckStatus.close();
					pstmtCheckStatus = null;
				}
				if(conn != null)
				{
					if(retString == "1")
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}catch(Exception e)
			{
				System.out.println("Exception ::"+e.getMessage());
			}
		}
		System.out.println("retString =["+retString+"]");
		return retString;
	}
	
	
	

} //confirm end
