package ibase.webitm.ejb.adm.adv;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;

import ibase.system.config.ConnDriver;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.rmi.RemoteException;
import javax.ejb.Stateless; 

@Stateless 
public class BondRecoveryConfirm extends ActionHandlerEJB implements BondRecoveryConfirmLocal,BondRecoveryConfirmRemote
{
	String loginEmpCode="";
	int updcnt1=0;
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		
		String retString = "";
		try
		{
			
			Connection conn=null;		
			retString = confirm( tranId, xtraParams, forcedFlag, conn);		
		
		}
		catch(Exception e)
		{
			System.out.println("Exception :BondRecoveryConfirm :confirm():" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
		}
		return retString;
	}
	
	public String confirm( String tranId, String xtraParams, String forcedFlag, Connection conn)
	{
		System.out.println("--------------confirm method of BondRecoveryConfirm -------------");
		ResultSet rs=null;
		PreparedStatement pstmt = null;	
		conn=null;
		ITMDBAccessEJB itmdbAccess=new ITMDBAccessEJB();
		String sql="",confirmed="",errString="",empcode="",retString="";
		double recAmtAct=0.0,empBondReco=0.0;
		int updCnt=0;
		try
		{
			loginEmpCode = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			ConnDriver connDriver=new ConnDriver();
			conn=connDriver.getConnectDB("DriverValidator");
			conn.setAutoCommit(false);
			
			sql = "SELECT emp_code,CONFIRMED FROM BOND_RECOVERY WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString("CONFIRMED")==null ? "":rs.getString("CONFIRMED");
				empcode=rs.getString(1);
			}	
			
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( confirmed != null && confirmed.equalsIgnoreCase("Y") )
			{
				errString = itmdbAccess.getErrorString("", "AEBCONF", "", "", conn);
				return errString;
			}
			else 
			{				
				sql="select bond_amt__reco from employee where emp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, empcode);
				rs = pstmt.executeQuery(); 
				if(rs.next())   empBondReco=rs.getDouble(1);
				pstmt.close();rs.close();
				pstmt = null;rs=null;
				
				
				sql="select emp_code,recovery_amt__act  from bond_recovery where tran_id = ?";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery(); 
				
				if(rs.next()) recAmtAct=rs.getDouble(2);
				System.out.println("Recovery amt actual : "+recAmtAct);
				sql="update employee set BOND_AMT__RECO = ? where emp_code = ?";
				pstmt = conn.prepareStatement( sql );
				pstmt.setDouble(1,recAmtAct+empBondReco);
				pstmt.setString(2,empcode);
				updCnt = pstmt.executeUpdate();
				System.out.println("recAmtAct+empBondReco "+(recAmtAct+empBondReco));

				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}	
				updcnt1 =updateConfirm(conn,tranId);			
				System.out.println("UPDATE COUNT --updCnt-->>"+updCnt+" updcnt1 -->>"+updcnt1);
				if (updCnt > 0 && updcnt1 >0 )
				{	
					retString=new ITMDBAccessEJB().getErrorString("", "VCONFSUC", "", "", conn);
					conn.commit();
					System.out.println("confirmed,empCodeAprv, BOND_AMT__RECO columns are updated successfully.......row(s) updated :"+updCnt);
					
				}else
				{
					
					retString=new ITMDBAccessEJB().getErrorString("", "VCONFUSUC", "", "", conn);
					conn.rollback();
				} 
			}
			
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
	}
	public int updateConfirm(Connection conn,String tranId)
	{
		System.out.println("in updateConfirm method -------->>>");
		
		int count=0;
		String sql = "UPDATE BOND_RECOVERY SET CONFIRMED = ?,CONF_DATE = ?,EMP_CODE__APRV = ? WHERE TRAN_ID = ?";
		PreparedStatement pstmt1=null;
		try
		{			
			pstmt1 = conn.prepareStatement( sql );	
			pstmt1.setString(1, "Y");
			pstmt1.setTimestamp(2, this.getCurrdateAppFormat()); 
			pstmt1.setString(3, loginEmpCode);
			pstmt1.setString(4, tranId);
			
			count = pstmt1.executeUpdate();
			System.out.println("confirm updated -------->>>>>>>>>updCount :"+count);
			
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();					
		}
		try
		{
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;					
			}
				
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			e.printStackTrace();
			
		}
		return count;
	}
	private java.sql.Timestamp getCurrdateAppFormat()
    {
        GenericUtility genericUtility = GenericUtility.getInstance();
		Timestamp timestamp = null;
        try
        {
            java.util.Date date = null;
            timestamp = new Timestamp(System.currentTimeMillis());            
            SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
            date = simpledateformat.parse(timestamp.toString());
            timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
        }
        catch(Exception exception)
        {
            System.out.println("Exception in [EmpBondDefConfirm] getCurrdateAppFormat " + exception.getMessage());
        }
        return timestamp;
    }
}
