/**
 *  Purpose: Dashboard for Inventory Occupancy, Reuest ID: D15DKAT008  
 *  Author: Sneha Mestry
 *  Date: 15-07-2015
 */


package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class InventoryOccupancy extends ValidatorEJB implements InventoryOccupancyRemote, InventoryOccupancyLocal
{
		
	public InventoryOccupancy()
	{}
	E12GenericUtility genericUtility = new E12GenericUtility();
	//1.This is the main method to show the parent graph 
	@SuppressWarnings("unchecked")	
	
	public JSONObject getInventoryOccupancyDetails(String dataSourceName, String siteCode) throws RemoteException, ITMException
	{
		
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();	
		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB(dataSourceName);
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			int count = 0, total = 0, used = 0;
			double percentage = 0, totalDso = 0, usedDso = 0, percentageDso = 0, 
				   totalPso = 0, usedPso = 0, percentagePso = 0, totalCaspk = 0, usedCaspk = 0, percentageCaspk = 0,
				   totalActpk = 0, usedActpk = 0, percentageActpk = 0 ;

			System.out.println(" ************** Overall ****************** ");
			sql = "select count(distinct loc_code) AS TOTAL from location where site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				total = rs.getInt("TOTAL");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			sql = "select  count(distinct loc_code) AS USED from stock where site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				used = rs.getInt("USED");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}	
			
			if (total == 0)
			{
				percentage = 0;
				
			}else{
				percentage = (((double)used / (double)total) * 100); 
			}

			rowData = new JSONObject();
			rowData.put("descr", "Overall");
			rowData.put("link", "");
			rowData.put("total", total);
			rowData.put("occupied", used);
		    rowData.put("value", Math.round(percentage));
			rawDataJson.put(count, rowData);
			System.out.println("rawDataJson for Overall :::::::::: " + rawDataJson);
			count++;
			
			System.out.println(" ************** DSO ****************** ");
			sql = "select count(distinct loc_code) AS TOTAL_DSO from location where inv_stat = 'DSO' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totalDso = rs.getInt("TOTAL_DSO");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			sql = "select  count(distinct loc_code) AS USED_DSO from stock where inv_stat = 'DSO' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				usedDso = rs.getInt("USED_DSO");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			if (totalDso == 0)
			{
				percentage = 0;
				
			}else{
				percentageDso = (((double)usedDso / (double)totalDso) * 100); 
			}

			rowData = new JSONObject();
			rowData.put("descr", "DSO");
			rowData.put("link", "DSO");
			rowData.put("total", totalDso);
			rowData.put("occupied", usedDso);
		    rowData.put("value", Math.round(percentageDso));
			rawDataJson.put(count, rowData);
			System.out.println("rawDataJson for DSO :::::::::: " + rawDataJson);
			count++;

			System.out.println(" ************** PSO ****************** ");
			sql = "select count(distinct loc_code) AS TOTAL_PSO from location where inv_stat = 'PSO' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totalPso = rs.getInt("TOTAL_PSO");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			sql = "select  count(distinct loc_code) AS USED_PSO from stock where inv_stat = 'PSO' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				usedPso = rs.getInt("USED_PSO");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			if (totalPso == 0)
			{
				percentage = 0;
				
			}else{
				percentagePso = (((double)usedPso / (double)totalPso) * 100); 
			}
		
			rowData = new JSONObject();
			rowData.put("descr", "PSO");
			rowData.put("link", "PSO");
			rowData.put("total", totalPso);
			rowData.put("occupied", usedPso);
		    rowData.put("value", Math.round(percentagePso));
			rawDataJson.put(count, rowData);
			System.out.println("rawDataJson for PSO :::::::::: " + rawDataJson);
			count++;
			

			System.out.println(" ************** CASPK ****************** ");
			sql = "select count(distinct loc_code) AS TOTAL_CASPK from location where inv_stat = 'CASPK' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totalCaspk = rs.getInt("TOTAL_CASPK");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			sql = "select  count(distinct loc_code) AS USED_CASPK from stock where inv_stat = 'CASPK' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				usedCaspk = rs.getInt("USED_CASPK");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			if (totalCaspk == 0)
			{
				percentage = 0;
				
			}else{
				percentageCaspk = (((double)usedCaspk / (double)totalCaspk) * 100) ; 
			}
			
			rowData = new JSONObject();
			rowData.put("descr", "Case Pick");
			rowData.put("link", "CASPK");
			rowData.put("total", totalCaspk);
			rowData.put("occupied", usedCaspk);
		    rowData.put("value", Math.round(percentageCaspk));
			rawDataJson.put(count, rowData);
			System.out.println("rawDataJson for CASPK :::::::::: " + rawDataJson);
			count++;
			
			System.out.println(" ************** ACTPK ****************** ");
			sql = "select count(distinct loc_code) AS TOTAL_ACTPK from location where inv_stat = 'ACTPK' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totalActpk = rs.getInt("TOTAL_ACTPK");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			sql = "select  count(distinct loc_code) AS USED_ACTPK from stock where inv_stat = 'ACTPK' and site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				usedActpk = rs.getInt("USED_ACTPK");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			if (totalActpk == 0)
			{
				percentage = 0;
				
			}else{
				percentageActpk = (((double)usedActpk / (double)totalActpk) * 100);  
			}
			
			rowData = new JSONObject();
			rowData.put("descr", "Active Pick");
			rowData.put("link", "ACTPK");
			rowData.put("total", totalActpk);
			rowData.put("occupied", usedActpk);
		    rowData.put("value", Math.round(percentageActpk));
			rawDataJson.put(count, rowData);
			System.out.println("rawDataJson for ACTPK :::::::::: " + rawDataJson);
			count++;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}				
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ReplTask.getReplTaskDetails(String dataSourceName, String siteCode):" + d.getMessage());
				throw new ITMException(d);
			}
		}
	
		return rawDataJson;
	}
/*
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "0";
		}
		else
		{
			return str.trim();
		}

	}
*/
	
}

