package ibase.webitm.ejb.wms;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.ReceiptAdvConfLocal;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

@Stateless
public class UploadOrderEJB extends ActionHandlerEJB implements UploadOrderEJBLocal,UploadOrderEJBRemote
{
	String siteCodeG = "";
	public String uploadSalesOrder(String xmlString, UserInfoBean userInfo, String xtraParams) throws Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;		
		ResultSet rs = null;
		String sql = "",retString = "",siteCode = "",itemCodeOrd = "",unitRate = "",custCodeH = "",
		packCode = "",quantity = "",saleOrderNo = "",itemCodeS = "",lineNoS = "",rate = "",
		custTranId = "",newCustCode = "",ErrSaleOrder = "",taxCodeFinParm = "",currCode = "";
		String orderCheck = "N"; //Changed by wasim on 03-07-2015 
		int taxAmt = 0, taxAmtMagento = 0; //Changed by wasim on 03-07-2015 
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB(); //Changed by wasim on 03-07-2015 
		int count = 0,sCtr = 0;
		Document dom = null;
		double quantityS = 0,totAmt = 0,netTotAmt = 0,absDiffAmt = 0;
		E12GenericUtility genericUtility = null;
		HashMap <String,String> headerValuesMap=new HashMap<String,String>();
		StringWriter errors = new StringWriter();
		java.sql.Timestamp currDate = null;
		boolean isError = false;	
		CommonWmsUtil commonUtilObj = new  CommonWmsUtil();
		FinCommon finCommon = new FinCommon();
		DistCommon distcommon = new DistCommon();

		String exchRate = "";
		String finEntity = "";
		String finCurrCode = "";
		//Added by Santosh on 04/04/2017
		String rcpMode = "";
		//Added by sarita on 26DEC2017
		String userId = "";

		try
		{
			//Added by sarita on 26DEC2017 to get userId
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			genericUtility = new E12GenericUtility();
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			genericUtility = new E12GenericUtility();
			xmlString = xmlString == null ? "" :xmlString.trim();
			System.out.println("xmlString in  uploadSalesOrder----->["+xmlString+"]");			
			if(xmlString.length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				headerValuesMap = getSorderHdrData(dom);
				if(headerValuesMap != null && headerValuesMap.size() > 0)
				{
					custCodeH = checkNull(headerValuesMap.get("cust_code"));
					siteCode = checkNull(headerValuesMap.get("site_code"));
					this.siteCodeG = siteCode;
					System.out.println("CustCodeH----siteCode----->>["+custCodeH+"] ["+siteCode+"]");		        		
					sql = "SELECT COUNT(*) FROM CUSTOMER WHERE CUST_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, custCodeH);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if(custCodeH.length() == 0)
					{
						custTranId = checkNull( generateTranId( "w_customer", siteCode, currDateStr, conn) );
						System.out.println("custTranId ---------->>["+custTranId+"]");
						if(custTranId.length() > 0)
						{
							headerValuesMap.put("cust_code", custTranId);
							String custStr = insertInCustomerMaster (headerValuesMap, xtraParams,conn);
							System.out.println("custStr11---->>["+custStr+"]");
							if("Success".equalsIgnoreCase(custStr))
							{
								conn.commit();
							}
						}						

					}
					else if(count == 0 && custCodeH.length() > 0)
					{
						String custStr = insertInCustomerMaster (headerValuesMap, xtraParams,conn);
						System.out.println("custStr---->>["+custStr+"]");
						headerValuesMap.put("cust_code", custCodeH);
						if("Success".equalsIgnoreCase(custStr))
						{
							conn.commit();
						}
					}
					else
					{
						System.out.println("Existing customer found..............");
					}
				}
				else
				{
					System.out.println("headerValesMap is null...............");
				}

				System.out.println("custCodeH@@---------->>["+custCodeH+"]");	        	
				newCustCode = headerValuesMap.get("cust_code").toString();	        	
				System.out.println("newCustCode@@---------->>["+newCustCode+"]");
				setNodeValue(dom, "cust_code", newCustCode);
				setNodeValue(dom, "cust_code__dlv", newCustCode);
				setNodeValue(dom, "cust_code__bil", newCustCode);  	

				System.out.println("siteCodeG------>>["+siteCodeG+"]");	

				//Changed by manish on 23/02/16 for setting Exchange Rate from FinnCommon [start]
				currCode = checkNull(headerValuesMap.get("curr_code"));
				sql = " SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCodeG);
				rs = pstmt.executeQuery();

				while (rs.next())
				{
					finEntity = checkNull(rs.getString("FIN_ENTITY"));
				}				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;


				sql = " SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,finEntity);
				rs = pstmt.executeQuery();

				while (rs.next())
				{
					finCurrCode = checkNull(rs.getString("CURR_CODE"));
				}				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(currCode.equals(finCurrCode))
				{
					exchRate = "1";
					System.out.println("Exchange Rate is="+exchRate);
				}
				else
				{
					System.out.println("TODAY IS="+currDateStr);
					System.out.println("Order Site="+siteCodeG);

					Double exchRateFinn = finCommon.getDailyExchRateSellBuy(currCode.trim(),"",siteCodeG.trim(),currDateStr.trim(),"S", conn);


					if(exchRateFinn != null)
					{
						exchRateFinn = distcommon.getRndamt(exchRateFinn, "R", 0.000001);
					}

					exchRate = String.valueOf(exchRateFinn);
					System.out.println("Exch Rate from FinnCommon="+exchRate);
					if(exchRate != null && exchRate.equals(""))
					{
						sql = " SELECT std_exrt FROM currency WHERE CURR_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,currCode);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							exchRate = checkNull(rs.getString("std_exrt"));
						}
						rs.close();  rs = null;
						pstmt.close(); pstmt = null;
					}
					System.out.println("Exchange Rate is="+exchRate);

				}
				setNodeValue(dom, "exch_rate", exchRate);
				//Changed by manish on 23/02/16 for setting Exchange Rate from FinnCommon [end]


				xmlString = genericUtility.serializeDom(dom);
				xmlString = "<?xml version='1.0' encoding='UTF-8'?>" + xmlString;
				System.out.println("After Encoding"+xmlString);
				ErrSaleOrder = genericUtility.getColumnValue("sale_order", dom);
				System.out.println("ErrSaleOrder------>>["+ErrSaleOrder+"]");
				//headerValuesMap = getSorderHdrData(dom);
				//System.out.println("After getSorderHdrData headerValuesMap------>>"+headerValuesMap); UNIT


				//Changed By Manish 02/03/16 check sorder exist.start
				sql = "SELECT COUNT(*) FROM sorder WHERE SALE_ORDER = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ErrSaleOrder);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sCtr = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(sCtr > 0)
				{
					retString = "Sales Order Number : ( "+ErrSaleOrder + ") Exist !!!";
					return retString;
				}
				//Changed By Manish 02/03/16 check sorder exist.end


				System.out.println("xmlString Before save data------>>["+xmlString+"]");
				//added  by sarita on 26DEC2017 to add userId
				//retString=saveData(this.siteCodeG, xmlString, conn);
				retString=saveData(this.siteCodeG, xmlString, conn,userId);
				System.out.println("Before retString------>>["+retString+"]");
				if(retString != null && retString.indexOf("Success") > -1)
				{			
					conn.commit();
					System.out.println("retString.indexOf(Success) > -1)");
					System.out.println("Transaction committed successfully........");
					String[] arrayForTranId = retString.split("<TranID>");
					int endIndex = arrayForTranId[1].indexOf("</TranID>");

					saleOrderNo = arrayForTranId[1].substring(0,endIndex);					
					System.out.println("saleOrderNo------>>>["+saleOrderNo+"]");
					
					//Added by Santosh on 04/04/2017 to create receipt for RCP mode G/M [Start]
					rcpMode = genericUtility.getColumnValue("rcp_mode", dom);
					System.out.println("RCP mode in header["+rcpMode+"]");
					if( ("G".equalsIgnoreCase(rcpMode) || "M".equalsIgnoreCase(rcpMode)) && rcpMode.trim().length() > 0 && rcpMode != null )
					{
						createAdvReceipt(saleOrderNo, headerValuesMap.get("cust_code"), headerValuesMap, xtraParams);
					}
					//Added by Santosh on 04/04/2017 to create receipt for RCP mode G/M [End]

					//Changed by wasim on 03-07-2015 to check tax_amount with megento server [START] 
					sql="SELECT VAR_VALUE FROM DISPARM WHERE VAR_NAME = 'IS_ORDER_CHECK' ";
					pstmt=conn.prepareStatement(sql);
					rs=pstmt.executeQuery(); 
					if(rs.next())
					{
						orderCheck = rs.getString("VAR_VALUE");
					}
					rs.close();
					rs=null;										
					pstmt.close();
					pstmt=null;	

					if(orderCheck.equals("Y"))
					{
						sql=" SELECT SUM(TAX_AMT) AS TAXAMOUNT FROM TAXTRAN T,TAX X WHERE T.TRAN_ID = ? "+
						" AND T.TRAN_CODE = 'S-ORD' AND TRIM(T.TAX_CODE) = TRIM(X.TAX_CODE) AND X.TAX_TYPE ='S' ";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, saleOrderNo);
						rs=pstmt.executeQuery(); 
						if(rs.next())
						{
							taxAmt = rs.getInt("TAXAMOUNT");
						}
						rs.close();
						rs=null;										
						pstmt.close();
						pstmt=null;
						System.out.println("Tax Amount is ="+taxAmt);

						sql=" SELECT TOT_AMT,NET_TOT_AMT,UDF__NUM2 FROM SORDER WHERE SALE_ORDER = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, saleOrderNo);
						rs=pstmt.executeQuery(); 
						if(rs.next())
						{
							totAmt = rs.getDouble("TOT_AMT");
							netTotAmt = rs.getDouble("NET_TOT_AMT");
							taxAmtMagento = rs.getInt("UDF__NUM2");
						}
						rs.close();
						rs=null;										
						pstmt.close();
						pstmt=null;
						taxCodeFinParm = checkNull(commonUtilObj.getfinparm("999999", "TAX_CODE", conn));
						System.out.println("taxCodeFinParm------->>["+taxCodeFinParm+"]");						
						sql="select abs(sum(tax_amt))  from taxtran where tran_id = ? and tax_code =  ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, saleOrderNo);
						pstmt.setString(2, taxCodeFinParm);
						rs=pstmt.executeQuery(); 
						if(rs.next())
						{
							absDiffAmt = rs.getDouble(1);							
						}
						rs.close();
						rs=null;										
						pstmt.close();
						pstmt=null;
						System.out.println("totAmt ="+totAmt);
						System.out.println("netTotAmt ="+netTotAmt);
						System.out.println("Tax Amount from Magento is ="+taxAmtMagento);
						System.out.println("absDiffAmt ="+absDiffAmt);
						if(totAmt == netTotAmt)
						{
							double diff = Math.abs(taxAmt - taxAmtMagento);
							System.out.println("ABS Amount---->>"+diff);							
							if(taxAmt == taxAmtMagento || diff == absDiffAmt )
							{
								retString = confirmSaleOrder("sorder",saleOrderNo,xtraParams,"",conn);
								System.out.println("After retString------>>["+retString+"]");
								if(retString !=null && retString.indexOf("PRCSTATUS") > -1)
								{
									//deleteUnconfirmRecord(saleOrderMagentoG, conn);
									//rowsDoneCnt++;
									sql="select line_no,item_code,quantity from sorddet where sale_order=? order by line_no";
									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1, saleOrderNo);
									rs=pstmt.executeQuery(); 
									while(rs.next())
									{
										lineNoS=rs.getString(1);
										itemCodeS=checkNull(rs.getString(2));
										quantityS=rs.getDouble(3);									
										//stock allocation
										retString=sorderAllocate(saleOrderNo, lineNoS, itemCodeS, quantityS,"", conn );
										System.out.println("errorString sorderAllocate---->>["+retString+"]");
										if(retString != null && retString.length() > 0)
										{	
											isError = true;
											writeLogAndSendMail(saleOrderNo,retString, userInfo, conn);
											//return retString;
											return "Success "+saleOrderNo+" Error on Confirm ";  // change by manish on 05/03/2016 to return success msg to ERP if order is not confirm.
										}
									}
									rs.close();
									rs=null;										
									pstmt.close();
									pstmt=null;	
									if(retString == null || retString.length() == 0)
									{
										retString = "Success "+saleOrderNo;
										return retString;
									}						

								}
								else
								{
									isError = true;
									writeLogAndSendMail(saleOrderNo,retString, userInfo, conn);
									//return retString; //Error could not return to Magento server
									return "Success "+saleOrderNo+ " Error on Confirm ";  // change by manish on 05/03/2016 to return success msg to ERP if order is not confirm.
								}
							}
							else
							{
								isError = true;
								System.out.println("Unconfimed order generated, Tax Amount does not match with magento server.");								
								retString = itmDBAccessEJB.getErrorString("","VTTAXMGTO","","",conn);
								writeLogAndSendMail(saleOrderNo,retString, userInfo, conn);
								//return retString; //Error could not return to Magento server
								return "Success "+saleOrderNo+ " Error on Confirm ";  // change by manish on 05/03/2016 to return success msg to ERP if order is not confirm.
							}
						}
						else
						{
							isError = true;
							System.out.println("Unconfirmed order generated,Total amount and net amount not matched.");								
							retString = itmDBAccessEJB.getErrorString("","VTTOTNETNM","","",conn);
							writeLogAndSendMail(saleOrderNo,retString, userInfo, conn);
						}


					}

					/*retString = confirmSaleOrder("sorder",saleOrderNo,xtraParams,"",conn);
					System.out.println("After retString------>>["+retString+"]");
					if(retString !=null && retString.indexOf("PRCSTATUS") > -1)
					{
						//deleteUnconfirmRecord(saleOrderMagentoG, conn);
						//rowsDoneCnt++;
						sql="select line_no,item_code,quantity from sorddet where sale_order=? order by line_no";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, saleOrderNo);
						rs=pstmt.executeQuery(); 
						while(rs.next())
						{
							lineNoS=rs.getString(1);
							itemCodeS=checkNull(rs.getString(2));
							quantityS=rs.getDouble(3);									
							//stock allocation
							retString=sorderAllocate(saleOrderNo, lineNoS, itemCodeS, quantityS,"", conn );
							System.out.println("errorString sorderAllocate---->>["+retString+"]");
							if(retString != null && retString.length() > 0)
							{
								return retString;
							}
						}
						rs.close();
						rs=null;										
						pstmt.close();
						pstmt=null;	
						if(retString == null || retString.length() == 0)
						{
							retString = "Success "+saleOrderNo;
							return retString;
						}						

					}
					else
					{
						return retString;
					}*/
					//Changed by wasim on 03-07-2015 to check tax_amount with megento server [END] 
				}
				else
				{
					writeLogAndSendMail(ErrSaleOrder,retString, userInfo, conn);
					System.out.println("Sale order not save...............rollback");
					isError = true;
					conn.rollback();					
					return retString;
					//throw new Exception(retString);
				}

			}
			else
			{
				System.out.println("sale order xml is blank or null...................");				
			}


		}
		catch(Exception e)
		{
			isError = true;
			writeLogAndSendMail(ErrSaleOrder,retString, userInfo, conn);
			System.out.println("Exception in  UploadSorderBean  : uploadSalesOrder---------");
			e.printStackTrace();
			e.printStackTrace(new PrintWriter(errors));
			return errors.toString();

		}
		finally
		{
			System.out.println("isError uploadSalesOrder-------"+isError);			
			if(isError)
			{
				conn.rollback();				
			}
			if(rs != null)
			{
				rs.close();
				rs = null;				
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;				
			}
			if(conn!=null)
			{
				conn.close();
				conn = null;
			}
		}
		return "";
	}
	private void writeLogAndSendMail(String saleOrderNo,String errorString, UserInfoBean userInfo, Connection conn) throws Exception
	{
		String mailFlag = "",attachFlag = "",formatCode = "",attachPath = "",fileName1 = "";
		CommonWmsUtil commonWmsUtil = CommonWmsUtil.getInstance();
		DistCommon discommon = new DistCommon();
		Document dom = null;
		E12GenericUtility genericUtility = null;
		final Logger logger = Logger.getLogger(UploadOrderEJB.class.getName());
		try
		{		
			genericUtility  = new E12GenericUtility();
			mailFlag = checkNull(discommon.getDisparams("999999","WMS_MAIL_FLAG",conn));
			attachFlag= checkNull(discommon.getDisparams("999999","WMS_ATTACHMENT_FLAG",conn));
			formatCode = checkNull(discommon.getDisparams("999999","WMS_FORMAT_CODE",conn));
			dom = commonWmsUtil.getDDDom("DDSalesConfig");
			attachPath = checkNull(genericUtility.getColumnValue("SALES_INTEGRATION_LOG_PATH", dom));
			System.out.println("mailFlag-------"+mailFlag);
			System.out.println("attachement Flag-------"+attachFlag);
			System.out.println("formatCode-------"+formatCode);
			System.out.println("attachPath-------"+attachPath);

			if(saleOrderNo != null && saleOrderNo.length() > 0)
			{
				fileName1 = saleOrderNo+"_Error";
			}
			else
			{
				fileName1 = "ErrorSalesIntegration";
			}

			String separator = String.valueOf( attachPath.charAt(attachPath.length() - 1));
			if(!separator.equalsIgnoreCase(File.separator) )
			{
				attachPath = attachPath + File.separator;
			}

			System.out.println("Error File Name--->>["+fileName1+"]");			
			System.out.println("Error File Path--->>["+attachPath+"]");
			File file=new File(attachPath);
			file.mkdirs();
			File file1 = new File(attachPath + fileName1);
			file1.createNewFile();
			//file.mkdirs();
			System.out.println("PATH123 :"+file1.getAbsolutePath());
			Handler fh = new FileHandler(file1.getAbsolutePath(), true);
			fh.setFormatter(new SimpleFormatter());  // Set the log format								
			logger.addHandler(fh);								
			logger.setLevel(Level.FINE);								
			logger.log(Level.SEVERE, errorString, errorString);								
			fh.flush();
			fh.close();	    


			commonWmsUtil.sendMail(mailFlag,attachFlag,formatCode,attachPath +fileName1,errorString, userInfo, conn);		
		}
		catch(Exception e)
		{

		}
	}
	private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	{
		Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		if( tempNode != null )
		{
			if( tempNode.getFirstChild() == null )
			{
				CDATASection cDataSection = dom.createCDATASection( nodeVal );
				tempNode.appendChild( cDataSection );
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	}
	public String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws ITMException,Exception 
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = checkNull(rs.getString(1));					
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{				
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;    	    		
			}
			if(pstmt != null)
			{    			
				pstmt.close();    	    	
				pstmt = null;	
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;

	}

	public String confirmSaleOrder(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement psmt = null;
		ResultSet rs = null;
		boolean isError = false;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmSaleOrder mothod----------------");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,businessObj);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,serviceCode);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String("");
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (psmt != null )
				{
					psmt.close();
					psmt = null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	private String insertInCustomerMaster (HashMap <String,String>headerValesMap,String xtraParams,Connection conn) throws Exception
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		int count = 0;
		String sql="",loginCode = "",remoteHost = "",stateCodeDlv = "",stationCode = "",cityDlv = "",shName = "",custName = "", fullName = "",dlvadd1 = "",dlvadd2 = "",dlvadd3 = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		Calendar currentDate = Calendar.getInstance();
		SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
		String currDate = simpleDateFormatObj.format(currentDate.getTime());
		remoteHost = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		java.sql.Timestamp currentDate1 = new Timestamp(System.currentTimeMillis());

		//Changed by wasim to set data from finparm on 12-08-2015 [START]
		CommonWmsUtil common = new  CommonWmsUtil();
		String acctCodeAdv = "", cctrCodeAdv = "", acctCodeAr  = "", cctrCodeAr  = "";
		//Changed by wasim to set data from finparm on 12-08-2015 [END]

		//currDate =genericUtility.getValidDateString( tranDate, genericUtility.getApplDateFormat(),dateFormat );
		System.out.println("currDate---->>"+currDate);
		System.out.println("----------new Customer found ---------------------- ");

		try
		{
			if(headerValesMap.containsKey("stan_code"))
			{
				stationCode = checkNull(headerValesMap.get("stan_code"));
				sql = "SELECT COUNT(*) FROM STATION WHERE STAN_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stateCodeDlv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count == 0)
				{
					stationCode = "UKE40";
				}
			}
			else
			{
				stationCode = "UKE40";
			}
			if(headerValesMap.containsKey("state_code__dlv"))
			{
				stateCodeDlv = checkNull(headerValesMap.get("state_code__dlv"));
				sql = "SELECT COUNT(*) FROM STATE WHERE STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stateCodeDlv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count == 0)
				{
					stateCodeDlv = "UKENG";
				}
			}
			else
			{
				stateCodeDlv = "UKENG";
			}

			//Changed by wasim on to set data from finparm 12-08-2015 [START]
			/* acctCodeAdv = checkNull(common.getfinparm("999999", "DD_ACCT_CODE__ADV", conn));
			   cctrCodeAdv = checkNull(common.getfinparm("999999", "DD_CCTR_CODE__ADV", conn));
			   acctCodeAr  = checkNull(common.getfinparm("999999", "DD_ACCT_CODE__AR", conn));
			   cctrCodeAr  = checkNull(common.getfinparm("999999", "DD_CCTR_CODE__AR", conn));*/

			//Changed by Manish for getting actual values from database for these fields on 19/01/16 for DDUK[start]
			acctCodeAdv = checkNull(common.getfinparm("999999", "DD_ACCT_CODE__ADV", conn));
			cctrCodeAdv = common.getfinparm("999999", "DD_CCTR_CODE__ADV", conn);
			acctCodeAr  = checkNull(common.getfinparm("999999", "DD_ACCT_CODE__AR", conn));
			cctrCodeAr  = common.getfinparm("999999", "DD_CCTR_CODE__AR", conn);
			//Changed by Manish for getting actual values from database for these fields on 19/01/16 for DDUK[end]

			System.out.println("ACCT_CODE__ADV="+acctCodeAdv);
			System.out.println("CCTR_CODE__ADV="+cctrCodeAdv);
			System.out.println("ACCT_CODE__AR="+acctCodeAr);
			System.out.println("CCTR_CODE__AR="+cctrCodeAr);
			//Changed by wasim on to set data from finparm 12-08-2015 [END]

			//Changed by Manish on 02/03/16 to set dlv_city,dlv_add1, dlv_add2, dlv_add3 up to size [start]
			cityDlv = checkNull(headerValesMap.get("dlv_city"));
			if (cityDlv.length() > 20)
			{
				cityDlv = cityDlv.substring(0, 20);
			}
			dlvadd1 = checkNull(headerValesMap.get("dlv_add1"));
			if (dlvadd1.length() > 30)
			{
				dlvadd1 = dlvadd1.substring(0, 30);
			}
			dlvadd2 = checkNull(headerValesMap.get("dlv_add2"));
			if (dlvadd2.length() > 40)
			{
				dlvadd2 = dlvadd2.substring(0, 40);
			}
			dlvadd3 = checkNull(headerValesMap.get("dlv_add3"));
			if (dlvadd3.length() > 30)
			{
				dlvadd3 = dlvadd3.substring(0, 30);
			}
			//Changed by Manish on 02/03/16 to set dlv_city ,dlv_add1, dlv_add2, dlv_add3 up to size [end]



			//Changed by Manish on 05/03/16 to set sh_name,cust_name,full_name up to size [start]
			custName = checkNull(headerValesMap.get("buyer_name"));
			//Changed by Manish on 05/03/16 to set sh_name,cust_name,full_name up to size [end]

			sql = "insert into customer ( cust_code,cust_type,cust_name,sh_name,group_code,addr1,addr2,addr3,city,state_code,"
				+ "pin,count_code,stan_code, tele1,tele2,tele3,fax,cust_code__bil,credit_lmt,chq_name,"
				+ "curr_code,acct_code__ar,cctr_code__ar,tax_chap,cr_term,tran_code,sales_pers,channel_partner,site_code,dis_link,"
				+ "fin_link,black_listed,contact_code,trans_mode,rcp_mode,ignore_credit,pending_order,ignore_days,round,round_to,"
				+ "located_at,stop_business,sales_option,dlv_term,hold_shipment,acct_code__adv,cctr_code__adv,site_code__pbus,part_qty,split_factor,"
				+ "curr_code__frt,curr_code__ins,adhoc_repl_perc,full_name,rate_round,rate_round_to,master_pack,cancel_bo,single_lot,asn_reqd,"
				+ "return_allowed,edi_reqd,chg_date,chg_term,chg_user,wave_type,email_addr,registr_1) "//68
				+ "values (?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?)"; //68
			pstmt=conn.prepareStatement(sql);

			pstmt.setString(1, headerValesMap.get("cust_code")); //cust_code
			pstmt.setString(2,"D"); //cust_type

			//Changed by Manish on 05/03/16 to set cust_name,sh_name up to size  [start]
			//			pstmt.setString(3, headerValesMap.get("buyer_name")); //cust_name 
			if (custName.length() > 50)
			{
				pstmt.setString(3, custName.substring(0, 50)); //cust_name 
			}
			else
			{
				pstmt.setString(3, custName); //cust_name 
			}

			//			pstmt.setString(4, headerValesMap.get("buyer_name")); //sh_name  
			/*	if (custName.length() > 25)
			{
				pstmt.setString(4, custName.substring(0, 25)); //sh_name 
			}
			else
			{
				pstmt.setString(4, custName); //sh_name 
			}*/
			//Changed by Manish on 05/03/16 to set cust_name,sh_name up to size  [end]
			pstmt.setString(4, " ");  // Changed by Manish on 07/03/16 to set space to column sh_name 
			pstmt.setString(5, headerValesMap.get("cust_code"));//group_code
			/*pstmt.setString(6, headerValesMap.get("dlv_add1"));//addr1
			pstmt.setString(7, headerValesMap.get("dlv_add2"));//addr2
			pstmt.setString(8, headerValesMap.get("dlv_add2"));//addr3*/	

			//	pstmt.setString(9, headerValesMap.get("dlv_city"));//city
			pstmt.setString(6, dlvadd1);//addr1
			pstmt.setString(7, dlvadd2);//addr2
			pstmt.setString(8, dlvadd3);//addr3
			pstmt.setString(9, cityDlv);//city

			pstmt.setString(10, stateCodeDlv);//state_code

			//pstmt.setString(11, headerValesMap.get("dlv_pin"));//pin
			String dlvPin=  headerValesMap.get("dlv_pin");
			if(dlvPin.length() > 7)
			{
				pstmt.setString(11, dlvPin);//pin
			}
			else
			{	    		
				dlvPin = "000000" + dlvPin;
				dlvPin = dlvPin.substring(dlvPin.length() - 6);
				pstmt.setString(11, dlvPin);//pin
			}
			pstmt.setString(12, headerValesMap.get("count_code__dlv"));//count_code
			pstmt.setString(13, stationCode);//stan_code    			
			pstmt.setString(14, headerValesMap.get("tel1__dlv"));//tele1
			pstmt.setString(15, headerValesMap.get("tel2__dlv"));//tele2
			pstmt.setString(16, headerValesMap.get("tel3__dlv"));//tele3
			pstmt.setString(17, headerValesMap.get("fax__dlv"));//fax
			pstmt.setString(18, headerValesMap.get("cust_code"));//cust_code__bil
			pstmt.setString(19, "0");//credit_lmt
			pstmt.setString(20, "");//chq_name


			pstmt.setString(21, headerValesMap.get("curr_code"));//curr_code
			//Changed by wasim on 12-08-2015 to set data from finparm [Start]
			pstmt.setString(22, acctCodeAr);//acct_code__ar
			pstmt.setString(23, cctrCodeAr);//cctr_code__ar
			//pstmt.setString(22, "1030001");//acct_code__ar
			//pstmt.setString(23, "CC01");//cctr_code__ar
			//Changed by wasim on 12-08-2015 to set data from finparm [END]
			pstmt.setString(24, "");//tax_chap
			pstmt.setString(25, headerValesMap.get("cr_term"));//cr_term
			pstmt.setString(26, headerValesMap.get("tran_code"));//tran_code
			pstmt.setString(27, "SP00001");//sales_pers
			pstmt.setString(28, "N");//channel_partner
			pstmt.setString(29, headerValesMap.get("site_code"));//site_code
			pstmt.setString(30, "N");//dis_link

			pstmt.setString(31, "N");//fin_link
			pstmt.setString(32, "N");//black_listed
			pstmt.setString(33, "DUMMY");//contact_code
			pstmt.setString(34, headerValesMap.get("trans_mode"));//trans_mode
			pstmt.setString(35, headerValesMap.get("rcp_mode"));//rcp_mode
			pstmt.setString(36, "0");//ignore_credit
			pstmt.setString(37,"N");//pending_order
			pstmt.setString(38, "0");//ignore_days
			pstmt.setString(39, "N");//round
			pstmt.setString(40, "0");//round_to

			pstmt.setString(41, "");//located_at
			pstmt.setString(42, "N");//stop_business
			pstmt.setString(43, "A");//sales_option
			pstmt.setString(44, "NA");//dlv_term
			pstmt.setString(45, "N");//hold_shipment
			//Changed by wasim on 12-08-2015 to set data from finparm [Start]
			pstmt.setString(46, acctCodeAdv);//acct_code__adv
			pstmt.setString(47, cctrCodeAdv);//cctr_code__adv
			//pstmt.setString(46, "1030001");//acct_code__adv
			//pstmt.setString(47, "CC01");//cctr_code__adv
			//Changed by wasim on 12-08-2015 to set data from finparm [END]
			pstmt.setString(48, "");//site_code__pbus
			pstmt.setString(49, "0");//part_qty
			pstmt.setString(50, "0");//split_factor

			pstmt.setString(51, headerValesMap.get("curr_code"));//curr_code__frt  
			pstmt.setString(52, headerValesMap.get("curr_code"));//curr_code__ins
			pstmt.setString(53, "0");//adhoc_repl_perc

			//Changed by Manish on 05/03/16 to set full_name to size  [start]
			//		pstmt.setString(54, headerValesMap.get("buyer_name"));//full_name
			if (custName.length() > 70)
			{
				pstmt.setString(54, custName.substring(0, 70)); //full_name 
			}
			else
			{
				pstmt.setString(54, custName); //full_name 
			}
			//Changed by Manish on 05/03/16 to set full_name to size  [end]

			pstmt.setString(55, "N");//rate_round
			pstmt.setString(56, "0");//rate_round_to
			pstmt.setString(57, "N");//master_pack
			pstmt.setString(58, "0");//cancel_bo
			pstmt.setString(59, "N");//single_lot
			pstmt.setString(60, "N");//asn_reqd

			pstmt.setString(61, "N");//return_allowed
			pstmt.setString(62, "N");//edi_reqd
			System.out.println("before Time stamp chg_date tranDate...................");		
			//pstmt.setString(63, currDate);//chg_date tranDate
			pstmt.setTimestamp(63, currentDate1);
			pstmt.setString(64, remoteHost);//chg_term
			pstmt.setString(65, loginCode);//chg_user
			pstmt.setString(66, "W0001");//wave_type
			pstmt.setString(67, headerValesMap.get("notify_to"));//email_addr
			
			//changed by Manish on 25/04/16 to set the value of vender_no in registr_1[start]
			pstmt.setString(68, headerValesMap.get("vender_no"));//registr_1
			//changed by Manish on 25/04/16 to set the value of vender_no in registr_1[end]
			
			int rows=pstmt.executeUpdate();
			System.out.println("Customer rows inserted------->>"+rows);    	
			if(rows > 0)
				return "Success";
			else
				return "Error";
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}


	}
	private String sorderAllocate(String saleOrder, String lineNo, String itemCode, double allocQty,String xtraParams, Connection conn ) throws ITMException
	{


		System.out.println("updateSOrder calling ....**************..........["+saleOrder+"]");
		String getDataSql = null;
		String sorditemSql=null;
		String itemCodeOrd = null ;
		String unitStd = null ;
		String lotSl= null;
		String lotNo = null;
		String locCode = null;
		String itemShDescr = null;
		String locDescr = null;
		String unit = null;
		String grade = null;
		String siteCodeMfg =null;
		String itemRef = null;
		String status =null;
		//Changed By Pragyan 
		String invStat = "";
		//Changed By Pragyan 18/02/13 to check previous replenishment Location.start
		String replHistStr = "",prvReplID="",prvLocCodeTo="",prvPickOrd="",isRepl="",replQuantity="";
		String locType = "",locTypeParent="";	
		int prvReplLineNo = 0;	
		int prvPickLineNo = 0;
		int locZonePref = 0;
		double height = 0,len = 0,width =0,netwt=0;
		int noArt;
		java.sql.Date expDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date mfgDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date dateAlloc= new java.sql.Date(System.currentTimeMillis());
		String updateSorditem = null;
		String insertSql = null;
		String updateSordalloc = null;
		String updateSql= null;
		String flag = null;
		//Changed by Rohan on 29-12-11 as said by gulzar.start
		String resrvLoc  = "",casePickLoc="",activePickLoc="",deepStoreLoc="",partialResrvLoc="";		
		double stockQuantity = 0;
		double qtyAvailAlloc = 0;
		double lotQtyToBeAllocated = 0;
		double qtyDesp =0;
		double quantity =0;
		double convQtyStduom = 0 ;
		double quantityStduom = 0 ;
		double pendingQuantity = 0;
		int intCnt=0;
		int updCnt=0;
		String orderByStkStr = "";
		String errString = "";
		String error = "";
		String errCode = "",sql="",expLev="";
		//Connection conn = null;
		PreparedStatement pstmtStock = null,pstmt=null;

		PreparedStatement pstmtStockInsertSordAlloc = null;
		//Changed by Rohan on 13-04-12 To create prepared statement & result set.start
		String manStockData = ""; 
		//PreparedStatement pstmt = null;
		ResultSet rSet = null;
		//Change by Rohan on 4/7/12 To add min_shilf_life
		String minShelf = "";
		PreparedStatement pstmtShelf = null;
		ResultSet rSetShelf = null;
		int minShelfLife = 0; 
		//Changed by Rohan on 27-08-13 for define variable
		int maxShelfLife = 0;
		//Change by Rohan on 4/7/12 To add min_shilf_life
		Statement st = null;
		ResultSet rs = null ;
		ResultSet rsSItem = null;
		HashMap tempMap = null;
		ArrayList tempList = null;
		HashMap strAllocate = null;
		boolean isStockToDock = false;
		boolean isActives = false;

		ArrayList tempListForRepl =null;//Added by Ashish
		String directPickLoc = "";
		double palletVolume = 0.0 ,packSize = 0.0, perItemVolume = 0.0,
		caseVolume = 0.0,packSize1 = 0.0,caseVolume1 = 0.0,
		caseWeight =0.0,itemWeight = 0.0,caseCount =0.0;
		//Changed By Pragyan 06-DEC-13 to get Stock alloc quantity as per KB sir
		double stkAllocQty = 0.0;
		String hazardous = "";
		//changed by pragyan on 31/05/14 for single lot
		String currentSelectdLotNo = "";
		InvAllocTraceBean invAllocTrace = new InvAllocTraceBean();
		DistCommon discommon = new DistCommon();
		E12GenericUtility genericUtility = new E12GenericUtility();
		//Added by Santosh on 25/04/2017
		String orderSiteCode = "";
		try
		{			
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			java.util.Date currDate1 = new java.util.Date();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			String currDateStr = sdf.format(currDate1);
			java.sql.Timestamp tranDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateString( currDateStr , applDateFormat, dbDateFormat ) + " 00:00:00.0") ;

			//siteCode = genericUtility.getColumnValue("site_code",headerDom);
			System.out.println("siteCode------>>>>"+ this.siteCodeG+"]");
			//Changed by Santosh on 25/04/2017 to get sitecode from sorditem
			//sql="SELECT EXP_LEV FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_NO = ?";
			sql="SELECT EXP_LEV, SITE_CODE FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_NO = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1,saleOrder);
			pstmt.setString(2,lineNo);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				expLev=checkNull(rs.getString(1));	
				//Added by Santosh on 25/04/2017
				orderSiteCode = checkNull(rs.getString("SITE_CODE"));
			}	
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			System.out.println("expLev---------->>["+expLev+"]");
			//palletVolume  = Double.parseDouble(discommon.getDisparams("999999","PER_PALLET__VOLUME",conn));
			resrvLoc  = discommon.getDisparams("999999","RESERV_LOCATION",conn);
			casePickLoc  = discommon.getDisparams("999999","CASE_PICK_INVSTAT",conn);
			activePickLoc  = discommon.getDisparams("999999","ACTIVE_PICK_INVSTAT",conn);
			deepStoreLoc = discommon.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
			//partialResrvLoc = discommon.getDisparams("999999","PRSRV_INVSTAT",conn);
			//directPickLoc = genericUtility.getColumnValue("direct_pick_loc",headerDom);
			System.out.println("CASE_PICK_INVSTAT"+casePickLoc+"ACTIVE_PICK_INVSTAT"+activePickLoc+"RESERV_LOCATION"+resrvLoc+"Reserve Location["+partialResrvLoc+"]");


			getDataSql = "SELECT STOCK.LOT_NO,STOCK.LOT_SL,"
				+"STOCK.LOC_CODE, "
				+"STOCK.UNIT,  "
				+"(STOCK.QUANTITY - STOCK.ALLOC_QTY - (CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 ELSE STOCK.HOLD_QTY END)) AS QTY_AVAIL_ALLOC ,"
				+"STOCK.GRADE,STOCK.EXP_DATE,STOCK.CONV__QTY_STDUOM,STOCK.QUANTITY, " 
				+"STOCK.MFG_DATE,STOCK.SITE_CODE__MFG, "						  
				+"STOCK.NO_ART,INVSTAT.INV_STAT,ITEM.LOC_TYPE__PARENT,ITEM.LOC_TYPE,ITEM.LOC_ZONE__PREF,STOCK.ALLOC_QTY "  
				+"FROM STOCK,ITEM,LOCATION,INVSTAT " 
				+"WHERE (ITEM.ITEM_CODE = STOCK.ITEM_CODE) "
				+"AND (LOCATION.LOC_CODE = STOCK.LOC_CODE ) "
				+"AND (LOCATION.INV_STAT = INVSTAT.INV_STAT) "
				+"AND INVSTAT.AVAILABLE = 'Y' "
				+"AND STOCK.ITEM_CODE = ? AND STOCK.SITE_CODE = ? "
				+"AND (STOCK.QUANTITY - STOCK.ALLOC_QTY - CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 ELSE STOCK.HOLD_QTY END) > 0  " // 25/06/12 manoharan 
				+"AND NOT EXISTS (SELECT 1 FROM INV_RESTR I WHERE I.INV_STAT = INVSTAT.INV_STAT AND I.REF_SER = 'S-DSP' ) "
				+" AND LOCATION.INV_STAT IN(?,?,?,?,?) ORDER BY STOCK.EXP_DATE,INVSTAT.ALLOC_PREF, STOCK.LOC_CODE ";
			pstmtStock = conn.prepareStatement(getDataSql);

			pstmtStock.setString(1,itemCode);
			//Changed by Santosh on 25/04/2017
			//pstmtStock.setString(2,siteCodeG);
			pstmtStock.setString(2,orderSiteCode);
			pstmtStock.setString(3,resrvLoc);
			pstmtStock.setString(4,casePickLoc);
			pstmtStock.setString(5,activePickLoc);
			pstmtStock.setString(6,deepStoreLoc);
			pstmtStock.setString(7,partialResrvLoc);
			rs = pstmtStock.executeQuery();
			System.out.println("siteCode------"+ siteCodeG);
			System.out.println("itemCode------"+ itemCode);
			System.out.println("Select completed");


			while(rs.next())
			{
				isStockToDock = false;
				System.out.println( "INSIDE WHILE LOOP...........For allocation.["+allocQty);
				//LOT_NO
				lotNo = rs.getString(1);
				//LOT_SL
				lotSl = rs.getString(2);
				//LOC_CODE
				locCode = rs.getString(3);
				//UNIT
				unit = rs.getString(4);
				//QTY_AVAIL_ALLO
				qtyAvailAlloc = rs.getDouble(5);
				System.out.println("qtyAvailAlloc--------------->"+qtyAvailAlloc);
				//GRADE
				grade = rs.getString(6);
				//EXP_DATE
				expDate =rs.getDate(7);
				//CONV__QTY_STDUOM
				convQtyStduom=rs.getDouble(8);
				//QUANTITY
				quantity= rs.getDouble(9);
				//MFG_DATE
				mfgDate = rs.getDate(10);
				//SITE_CODE__MFG
				siteCodeMfg = rs.getString(11);
				noArt = rs.getInt(12);
				invStat = rs.getString(13);
				locTypeParent = checkNull(rs.getString(14)); //Changes done by chandni 08-06-12(instead of loc_type, loc_type__parent should be selected)
				//Changed by sankara on 03-08-2012 for adding locType
				locType= rs.getString(15);
				locZonePref = rs.getInt(16);
				//Changed By Pragyan 06-DEC-13 to get Stock alloc quantity as per KB sir
				stkAllocQty = rs.getDouble(17);


				//Changed By Pragyan 31-MAY-14 for single lot start


				HashMap itmVolumeMap = getItemVoumeMap(itemCode,lotNo,conn);
				double packSizeActive = (Double)itmVolumeMap.get("PACK_SIZE");
				//Changed by Rohan on 8/2/12 to get packsize of item.end
				System.out.println("GOING FOR populateReplHistory************************");
				System.out.println("Return qty from function:::::"+qtyAvailAlloc);

				invStat = invStat != null?invStat.trim():"";
				System.out.println("allocQty"+allocQty+"qtyAvailAlloc:::"+qtyAvailAlloc);




				if (allocQty >= qtyAvailAlloc)
				{
					lotQtyToBeAllocated = qtyAvailAlloc;
				}
				else
				{
					System.out.println("Enetr in else");
					lotQtyToBeAllocated = allocQty;
				}


				System.out.println("Stock To Dock change["+isStockToDock+"]");

				allocQty -= lotQtyToBeAllocated ;

				System.out.print("AllocQty = " + lotQtyToBeAllocated);
				System.out.print("AllocQty2 = " + allocQty);
				if (lotQtyToBeAllocated > 0) 
				{		

					invStat = invStat != null?invStat.trim():"";


					System.out.println("Finally  Loc Code["+locCode+"]");

					strAllocate = new HashMap();
					strAllocate.put("tran_date",tranDate);
					strAllocate.put("ref_ser","S-ALC");
					strAllocate.put("ref_id",saleOrder);
					strAllocate.put("ref_line", "" + lineNo);
					//Changed by Santosh on 11/05/2017 to ser orderSiteCode
					//strAllocate.put("site_code",siteCodeG);
					strAllocate.put("site_code",orderSiteCode);
					strAllocate.put("item_code",itemCode);
					strAllocate.put("loc_code",locCode);
					strAllocate.put("lot_no",lotNo);
					strAllocate.put("lot_sl",lotSl);
					strAllocate.put("alloc_qty",new Double(lotQtyToBeAllocated));
					strAllocate.put("chg_user",new E12GenericUtility().getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
					strAllocate.put("chg_term",new E12GenericUtility().getValueFromXTRA_PARAMS(xtraParams,"termId"));
					strAllocate.put("chg_win","W_SORDER");

					System.out.println("To allocate ::: " + strAllocate.toString()+"]lotQtyToBeAllocated["+lotQtyToBeAllocated+"]");

					errString = invAllocTrace.updateInvallocTrace(strAllocate, conn);


					System.out.println("invAllocTrace errString ::: " + errString);
					if (errString != null && errString.trim().length() > 0 )
					{
						break;
					}
					strAllocate = null;		

					sorditemSql = "SELECT ITEM_CODE,ITEM_CODE__ORD,UNIT, QTY_DESP, ITEM_REF,"
						+" QUANTITY - QTY_DESP PENDING_QUANTITY "
						+" FROM SORDITEM WHERE SALE_ORDER = '" + saleOrder + "' "
						+" AND LINE_NO = '" + lineNo + "' ";

					System.out.println("sorditemSql:::"+sorditemSql);
					st = conn.createStatement();
					rsSItem = st.executeQuery(sorditemSql);
					if (rsSItem.next())
					{
						//ITEM_CODE
						itemCode = rsSItem.getString(1);
						System.out.println("itemCode::::"+ itemCode);
						//ITEM_CODE__ORD
						itemCodeOrd = rsSItem.getString(2);	
						//UNIT
						unitStd = rsSItem.getString(3);	
						//QTY_DESP
						qtyDesp = 0;
						//ITEM_REF
						itemRef = rsSItem.getString(5);	
						//PENDING_QUANTITY
						pendingQuantity = rsSItem.getDouble(6);
					}					
					rsSItem.close();

					//Changed by sumit on 31/01/13 changing below quantity as per unit start
					pendingQuantity = getStockQtyAfterConvert(saleOrder, lineNo, itemCodeOrd, pendingQuantity, 1, conn);					
					updateSorditem ="UPDATE SORDITEM  SET QTY_ALLOC = CASE WHEN QTY_ALLOC IS NULL THEN 0 ELSE QTY_ALLOC END  +   " + new Double(lotQtyToBeAllocated).toString()
					+" WHERE SALE_ORDER = '" + saleOrder + "' "
					+" AND LINE_NO = '" + lineNo + "' "
					+" AND EXP_LEV = '" + expLev + "' ";

					System.out.println("updateSql------->"+updateSorditem);
					st.executeUpdate(updateSorditem);
					System.out.println("UPDATE  SUCCESS FOR SORDITEM....>>>>>>>>");

					sorditemSql = "SELECT COUNT(1) FROM SORDALLOC " 
						+ " WHERE SALE_ORDER = '" + saleOrder + "' "
						+ " AND LINE_NO = '" + lineNo + "' "
						+ " AND EXP_LEV = '" + expLev + "' "
						+ " AND ITEM_CODE__ORD = '" + itemCodeOrd + "' "
						+ " AND ITEM_CODE = '" + itemCode + "' "
						+ " AND LOT_NO = '" + lotNo + "' "
						+ " AND LOT_SL = '" + lotSl + "' "
						+ " AND LOC_CODE = '" + locCode + "' " ;
					rsSItem =  st.executeQuery(sorditemSql);
					int count = 0 ;
					if (rsSItem.next())
					{
						count = rsSItem.getInt(1);
					}
					if (count > 0 )
					{					
						//updateSql = "UPDATE SORDALLOC SET QTY_ALLOC =  QTY_ALLOC + " + new Double(lotQtyToBeAllocated).toString()
						updateSql = "UPDATE SORDALLOC SET WAVE_FLAG = 'Y' , QTY_ALLOC =  QTY_ALLOC + " + new Double(lotQtyToBeAllocated).toString()
						+ " WHERE SALE_ORDER = '" + saleOrder + " ' "
						+ " AND LINE_NO = '" + lineNo + "' "
						+ " AND EXP_LEV = '" + expLev + "' "
						+ " AND ITEM_CODE__ORD = '" + itemCodeOrd + "' "
						+ " AND ITEM_CODE = '" + itemCode + "' "
						+ " AND LOT_NO = '" + lotNo + "' "
						+ " AND LOT_SL = '" + lotSl + "' "
						+ " AND LOC_CODE = '" + locCode + "' " ;
						System.out.println("updateSql:::>>>>"+ updateSql);	
						st.executeUpdate(updateSql);
						System.out.println("UPDATE  SUCCESS FOR SORDALLOC....");
					}
					else
					{					
						insertSql ="INSERT INTO SORDALLOC (SALE_ORDER,LINE_NO,EXP_LEV,ITEM_CODE__ORD,SITE_CODE ,"
							+"ITEM_CODE,QUANTITY ,LOT_NO, LOT_SL, LOC_CODE, UNIT, QTY_ALLOC,"
							+"ITEM_REF, DATE_ALLOC, STATUS,ITEM_GRADE, EXP_DATE, ALLOC_MODE, "
							+" CONV__QTY_STDUOM, UNIT__STD, QUANTITY__STDUOM, "
							//+"MFG_DATE, SITE_CODE__MFG ) "
							+"MFG_DATE, SITE_CODE__MFG,WAVE_FLAG ) "
							+"VALUES ( ?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,"
							//+" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ;
							+" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? ) " ;

						pstmtStockInsertSordAlloc = conn.prepareStatement(insertSql);

						System.out.println("Insert Sql :"+ insertSql );					
						pstmtStockInsertSordAlloc.setString(1, saleOrder);
						System.out.println("saleOrder------->"+saleOrder);					
						pstmtStockInsertSordAlloc.setString(2, lineNo);
						System.out.println("lineNo------->"+lineNo);					
						pstmtStockInsertSordAlloc.setString(3, expLev);
						System.out.println("EXP_LEV------->"+expLev);					
						pstmtStockInsertSordAlloc.setString(4, itemCodeOrd);
						System.out.println("itemCode------->"+itemCodeOrd);					
						//Changed by Santosh on 11/05/2017 to set orderSiteCode
						//pstmtStockInsertSordAlloc.setString(5, siteCodeG);
						pstmtStockInsertSordAlloc.setString(5, orderSiteCode);
						System.out.println("siteCode------->"+siteCodeG);					
						System.out.println("orderSiteCode------->"+orderSiteCode);					
						pstmtStockInsertSordAlloc.setString(6, itemCode);
						System.out.println("itemCode------->"+itemCode);					
						pstmtStockInsertSordAlloc.setDouble(7, pendingQuantity);
						System.out.println("pendingQuantity------->"+pendingQuantity);

						pstmtStockInsertSordAlloc.setString(8, lotNo);
						System.out.println("lotNo------->"+lotNo);					
						pstmtStockInsertSordAlloc.setString(9, lotSl);
						System.out.println("lotSl------->"+lotSl);				
						pstmtStockInsertSordAlloc.setString(10, locCode);
						System.out.println("locCode------->"+locCode);					
						pstmtStockInsertSordAlloc.setString(11, unit);
						System.out.println("unit------->"+unit);				
						pstmtStockInsertSordAlloc.setDouble(12, lotQtyToBeAllocated);
						System.out.println("lotQtyToBeAllocated------->"+lotQtyToBeAllocated);

						pstmtStockInsertSordAlloc.setString(13,itemRef);
						System.out.println("itemRef------->"+itemRef);					
						pstmtStockInsertSordAlloc.setDate(14,dateAlloc);
						System.out.println("dateAlloc------->"+dateAlloc);					
						pstmtStockInsertSordAlloc.setString(15,"P");
						System.out.println("status------->P");					
						pstmtStockInsertSordAlloc.setString(16,grade);
						System.out.println("grade------->"+grade);					
						pstmtStockInsertSordAlloc.setDate(17,expDate);
						System.out.println("expDate------->"+expDate);
						pstmtStockInsertSordAlloc.setString(18,"M");
						pstmtStockInsertSordAlloc.setDouble(19,convQtyStduom);
						System.out.println("convQtyStduom------->"+convQtyStduom);					
						pstmtStockInsertSordAlloc.setString(20,unitStd);
						System.out.println("unitStd------->"+unitStd);					
						quantityStduom = convQtyStduom * lotQtyToBeAllocated ;					
						pstmtStockInsertSordAlloc.setDouble(21,quantityStduom);
						System.out.println("quantityStduom------->"+quantityStduom);					
						pstmtStockInsertSordAlloc.setDate(22,mfgDate);
						System.out.println("mfgDate------->"+mfgDate);					
						pstmtStockInsertSordAlloc.setString(23,siteCodeMfg);
						System.out.println("siteCodeMfg------->"+siteCodeMfg);
						pstmtStockInsertSordAlloc.setString(24,"N");
						System.out.println("WAVE FLAG-------> Y");


						intCnt = pstmtStockInsertSordAlloc.executeUpdate();
						System.out.println("insertion  success ...............>>>>>>>>");
						pstmtStockInsertSordAlloc.close();
					}//end else
					st.close();
					//Changed By Pragyan.end



				}//end of if(lotQtyToBeAllocated > 0)
			}//end of while

			if(st != null)
			{
				st.close();
				st = null;
			}
			if(pstmtStock != null)
			{
				pstmtStock.close();
				pstmtStock = null;
			}
			if(pstmtStockInsertSordAlloc != null)
			{
				pstmtStockInsertSordAlloc.close();
				pstmtStockInsertSordAlloc = null;
			}
			if(pstmtShelf != null)
			{
				pstmtShelf.close();
				pstmtShelf = null;
			}
			if(rSetShelf != null)
			{
				rSetShelf.close();
				rSetShelf = null;
			}
			if(rsSItem != null)
			{
				rsSItem.close();
				rsSItem = null;
			}
			if(rs != null)
			{
				rs.close();
				rs =null;
			}
			//Changed by Rohan on 29-08-12 for bug fixing
			//pstmtStock.clearParameters();

		}
		catch(SQLException se)
		{
			System.out.println("SQLException :" + se);	
			se.printStackTrace();
			errString = se.getMessage();
			//return errString;
			throw se;
		}

		catch(Exception e)
		{
			System.out.println("Exception :" + e);	
			errString = e.getMessage();
			e.printStackTrace();	
			throw e;


		}
		finally
		{
			try
			{
				if(conn != null)
				{	
					if(st != null)
					{
						st.close();
						st = null;
					}
					if(pstmtStock != null)
					{
						pstmtStock.close();
						pstmtStock = null;
					}
					if(rs != null)
					{
						rs.close();
						rs =null;
					}

					if(rsSItem != null)
					{
						rsSItem.close();
						rsSItem = null;
					}
					if(pstmtStockInsertSordAlloc != null)
					{
						pstmtStockInsertSordAlloc.close();
						pstmtStockInsertSordAlloc = null;
					}
					if(st != null)
					{
						st.close();
						st = null;
					}
					if(pstmtShelf != null)
					{
						pstmtShelf.close();
						pstmtShelf = null;
					}
					if(rSetShelf != null)
					{
						rSetShelf.close();
						rSetShelf = null;
					}
					//conn.close();
					//conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				return errString ;

			}
			return errString;
		}



	}

	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		return tranId;
	}//generateTranTd()
	private HashMap getItemVoumeMap(String itemCode,String lotNo,Connection con)throws Exception
	{
		double packSize = 0,itemSize = 0,lotSize = 0;
		PreparedStatement pstmt = null;
		//Changed By Pragyan 12/03/13 To set hazardous item check
		String sql="",hazardous = "";
		//Changed By Rekha To add columns required for ADSI
		String harmonizCode = "",harmonizDescr = "",originCountry = "";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		HashMap dataVolumeMap = new HashMap();

		try {		
			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				+" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				+" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				+" ITEM I,ITEM_LOT_PACKSIZE L"
				+" WHERE I.ITEM_CODE = L.ITEM_CODE"
				+" AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ?"
				+" AND  I.ITEM_CODE = ?";


			pstmt = con.prepareStatement(sql);
			if(lotNo != null && lotNo.length() > 0)
			{
				pstmt.setString(1, lotNo);
				pstmt.setString(2, lotNo);
			}
			else
			{				
				return dataVolumeMap = getItemVoumeMap(itemCode, con);
				//Changed By Pragyan 05-DEC-13 as per KB sir in case of blank lot no take the data for max of lot_no__to.end
			}
			pstmt.setString(3, itemCode);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemWeight = rs.getDouble("ITEM_WEIGHT");
				//Changed By Pragyan 12/03/13 To set hazardous item check
				hazardous = rs.getString("HAZARD");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				packSize = rs.getDouble("SHIPSIZE");				
				lotWeight = rs.getDouble("LOT_WEIGHT");
				harmonizCode = rs.getString("HARMONIZATION_NO");
				harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				originCountry = rs.getString("ORIGIN_COUNTRY");
			}			

			itemSize = itmLen * itmWidth * itmHeight;
			lotSize = lotHeight * lotWidth * lotLen;

			dataVolumeMap.put("PACK_SIZE", packSize);
			dataVolumeMap.put("ITEM_SIZE", itemSize);
			dataVolumeMap.put("LOT_SIZE", lotSize);
			//Changed By Pragyan 12/03/13 To set hazardous item check
			dataVolumeMap.put("HAZARDOUS", hazardous);
			dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			dataVolumeMap.put("ITEM_LEN", itmLen);
			dataVolumeMap.put("ITEM_WID", itmWidth);
			dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			dataVolumeMap.put("LITEM_LEN", lotLen);
			dataVolumeMap.put("LITEM_WID", lotWidth);
			dataVolumeMap.put("LITEM_HEIGHT", lotHeight);




			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}



		} catch (Exception e) {
			// TODO: handle exception		
			throw e;
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(rs != null)
				{
					rs.close();
					rs = null;

				}
			}
			catch(Exception e)
			{
				throw e;
			}
		}

		return dataVolumeMap;


	}
	private double getStockQtyAfterConvert(String saleOrder, String lineNo,String itemCode,double quantity,int check, Connection conn) throws ITMException
	{


		String sql = "";
		String itemUnit = "";
		String orderUnit = "";
		String unitStd = "";	 
		double convQtyStduom = 0.0;
		double newQty = 0.0;
		double convFact = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		DistCommon discommon = new DistCommon();
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			//System.out.println(" -- saleOrder ["+saleOrder+"] lineNo ["+lineNo+"] itemCode ["+itemCode+"] ");
			sql = "SELECT DISTINCT ITEM.UNIT ,SORDDET.UNIT AS ORDER_UNIT,SORDDET.UNIT__STD AS  UNIT__STD, " +
			" SORDDET.CONV__QTY_STDUOM FROM ITEM, SORDDET WHERE ITEM.ITEM_CODE = ? " +
			" AND SORDDET.SALE_ORDER = ? AND SORDDET.LINE_NO = ? AND ITEM.ITEM_CODE = SORDDET.ITEM_CODE ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, saleOrder);
			pstmt.setString(3, lineNo);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				itemUnit = rs.getString("UNIT");
				orderUnit = rs.getString("ORDER_UNIT");
				unitStd = checkNull(rs.getString("UNIT__STD"));
				convQtyStduom = rs.getDouble("CONV__QTY_STDUOM");			
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			ArrayList convQtyList = new ArrayList();

			if(!orderUnit.equalsIgnoreCase(unitStd))
			{
				if(convQtyStduom != 0 && check == 1)
				{
					convFact = convQtyStduom;
				}
				System.out.println(" orderUnit ["+orderUnit+"] itemUnit ["+itemUnit+"] unitStd ["+unitStd+"] convQtyStduom ["+convQtyStduom+"]  convFact["+convFact+"]");
				if( check == 1 )
				{
					convQtyList = new ArrayList();
					convQtyList = discommon.getConvQuantityFact(orderUnit, unitStd, itemCode, quantity, convFact,conn);
				}
				else if ( check == 2 )
				{
					convQtyList = new ArrayList();
					convQtyList = discommon.getConvQuantityFact(unitStd, orderUnit, itemCode, quantity, convFact,conn);
				}
				System.out.println("convQtyList = "+convQtyList);
				newQty = Double.parseDouble(convQtyList.get(1).toString());
				System.out.println("newQty ["+newQty+"]");

				if(newQty == -999999999)
				{
					newQty = 0;								
				}
				if (convQtyStduom == 0)
				{
					convQtyStduom= Double.parseDouble(convQtyList.get(0).toString());
				}
			}
			else
			{
				newQty = quantity;
			}
			//pendingQty = meffQty;

		}
		catch(Exception ex)
		{		 
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		return newQty;


	}
	private HashMap getItemVoumeMap(String itemCode,Connection con)throws Exception
	{


		double packSize = 0,itemSize = 0,lotSize = 0;
		PreparedStatement pstmt = null;
		String sql="",hazardous = "";
		String harmonizCode = "",harmonizDescr = "",originCountry = "";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		HashMap dataVolumeMap = new HashMap();

		System.out.println("As Lot No Passed as Blank Calling Override method for getItemVoumeMap");
		try {

			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				+" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				+" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				+" ITEM I,ITEM_LOT_PACKSIZE L"
				+" WHERE I.ITEM_CODE = L.ITEM_CODE"
				+" AND L.LOT_NO__TO IN (SELECT MAX(LOT_NO__TO) FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ?)"
				+" AND  I.ITEM_CODE = ?";


			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, itemCode);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemWeight = rs.getDouble("ITEM_WEIGHT");
				//Changed By Pragyan 12/03/13 To set hazardous item check
				hazardous = rs.getString("HAZARD");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				packSize = rs.getDouble("SHIPSIZE");				
				lotWeight = rs.getDouble("LOT_WEIGHT");
				harmonizCode = rs.getString("HARMONIZATION_NO");
				harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				originCountry = rs.getString("ORIGIN_COUNTRY");
			}
			itemSize = itmLen * itmWidth * itmHeight;
			lotSize = lotHeight * lotWidth * lotLen;

			dataVolumeMap.put("PACK_SIZE", packSize);
			dataVolumeMap.put("ITEM_SIZE", itemSize);
			dataVolumeMap.put("LOT_SIZE", lotSize);
			dataVolumeMap.put("HAZARDOUS", hazardous);
			dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			dataVolumeMap.put("ITEM_LEN", itmLen);
			dataVolumeMap.put("ITEM_WID", itmWidth);
			dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			dataVolumeMap.put("LITEM_LEN", lotLen);
			dataVolumeMap.put("LITEM_WID", lotWidth);
			dataVolumeMap.put("LITEM_HEIGHT", lotHeight);




			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}



		} catch (Exception e) {
			// TODO: handle exception

			throw e;
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(rs != null)
				{
					rs.close();
					rs = null;

				}
			}
			catch(Exception e)
			{			
				throw e;
			}
		}

		return dataVolumeMap;


	}
	private HashMap<String,String> getSorderHdrData(Document dom) throws Exception
	{
		HashMap<String,String> headerValesMap = new HashMap<String,String>();
		E12GenericUtility genericUtility = new E12GenericUtility();
		String custCode = "",custName = "",groupCode = "",addr1 = "",addr2 = "",addr3 = "",stateCode = "";
		String pin = "",countCode = "",stanCode = "",tele1 = "",tele2 = "",tele3 = "",emailAdd = "";
		String fax = "",custCodeBil = "",currCode = "",tranCode = "",siteCode = "",transMode = "";
		String loginCode = "",remoteHost = "",currCodeFrt = "",dlvCity= "",stateCodeDlv = "",dlvPin = "";
		String countCodeDlv = "", crTerm= "",rcpMode = "",buyerName = "",notifyTo = "",siteCodeHdr = "";

		String salesPers = "",taxEnv = "",pordDateStr = "",itemSer = "",saleOrderMangento = "",udfStr1 = "",
		trnAmountStr = "",pordMode = "",siteCodeShip = "",remarks = "",totAmt = "",dlvTo = "",
		vendorTxCode = "",exchRateStr = "",ordAmtStr = "",dueDateStr = "",taxDateStr = "",acctCodeSal = "",
		securityKey = "",frtAmtStr = "",empCodeOrd = "",orderDateStr = "",taxAmtStr = "",dlvTerm = "",
		vpsTxId = "",saleOrder = "",priceList = "",venderNo = "";

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;

		if(dom != null)
		{	    
			System.out.println("dom in getSorderHdrData----->>["+genericUtility.serializeDom(dom)+"]");	
			parentNodeList = dom.getElementsByTagName("Detail1");
			childNodeListLength = parentNodeList.getLength();
			System.out.println("childNodeListLength@----->>"+childNodeListLength);
			for (int ctr = 0; ctr < childNodeListLength; ctr++)
			{				
				childNode = parentNodeList.item(ctr);			
				String childNodeName = childNode.getNodeName();
				System.out.println("Child name --->> "+childNodeName);	

				if (childNode.getNodeType() == Node.ELEMENT_NODE)
				{
					Element eElement = (Element) childNode;
					saleOrder =  checkNull(eElement.getElementsByTagName("sale_order").item(0).getTextContent());	
					siteCodeHdr =  checkNull(eElement.getElementsByTagName("site_code").item(0).getTextContent());	
					System.out.println("siteCodeHdr----->"+siteCodeHdr);
					custCode =  checkNull(eElement.getElementsByTagName("cust_code").item(0).getTextContent());	
					addr1 =  checkNull(eElement.getElementsByTagName("dlv_add1").item(0).getTextContent());	
					addr2 =  checkNull(eElement.getElementsByTagName("dlv_add2").item(0).getTextContent());	
					addr3 =  checkNull(eElement.getElementsByTagName("dlv_add3").item(0).getTextContent());						
					dlvCity =  checkNull(eElement.getElementsByTagName("dlv_city").item(0).getTextContent());	
					stateCodeDlv =  checkNull(eElement.getElementsByTagName("state_code__dlv").item(0).getTextContent());	
					System.out.println("cust_code----->"+custCode+ "stateCodeDlv---->"+stateCodeDlv);
					dlvPin =  checkNull(eElement.getElementsByTagName("dlv_pin").item(0).getTextContent());	
					countCodeDlv =  checkNull(eElement.getElementsByTagName("count_code__dlv").item(0).getTextContent());	
					tele1 =  checkNull(eElement.getElementsByTagName("tel1__dlv").item(0).getTextContent());					
					tele2 =  checkNull(eElement.getElementsByTagName("tel2__dlv").item(0).getTextContent());	
					stanCode =  checkNull(eElement.getElementsByTagName("stan_code").item(0).getTextContent());	
					fax =  checkNull(eElement.getElementsByTagName("fax__dlv").item(0).getTextContent());					
					currCode =  checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());	
					crTerm =  checkNull(eElement.getElementsByTagName("cr_term").item(0).getTextContent());	
					tranCode =  checkNull(eElement.getElementsByTagName("tran_code").item(0).getTextContent());	
					transMode =  checkNull(eElement.getElementsByTagName("trans_mode").item(0).getTextContent());	
					rcpMode =  checkNull(eElement.getElementsByTagName("rcp_mode").item(0).getTextContent());
					System.out.println("curr_code----->"+currCode+ "rcp_mode---->"+rcpMode);
					buyerName =  checkNull(eElement.getElementsByTagName("buyer_name").item(0).getTextContent());	
					notifyTo =  checkNull(eElement.getElementsByTagName("notify_to").item(0).getTextContent());	
					System.out.println("buyerName----->"+buyerName);	


					orderDateStr =  checkNull(eElement.getElementsByTagName("order_date").item(0).getTextContent());
					itemSer =  checkNull(eElement.getElementsByTagName("item_ser").item(0).getTextContent());
					saleOrderMangento =  checkNull(eElement.getElementsByTagName("cust_pord").item(0).getTextContent());
					pordDateStr =  checkNull(eElement.getElementsByTagName("pord_date").item(0).getTextContent());
					salesPers =  checkNull(eElement.getElementsByTagName("sales_pers").item(0).getTextContent());
					taxEnv =  checkNull(eElement.getElementsByTagName("tax_env").item(0).getTextContent());			


					taxDateStr =  checkNull(eElement.getElementsByTagName("tax_date").item(0).getTextContent());
					priceList =  checkNull(eElement.getElementsByTagName("price_list").item(0).getTextContent());
					crTerm =  checkNull(eElement.getElementsByTagName("cr_term").item(0).getTextContent());
					exchRateStr =  checkNull(eElement.getElementsByTagName("exch_rate").item(0).getTextContent());
					dueDateStr =  checkNull(eElement.getElementsByTagName("due_date").item(0).getTextContent());


					System.out.println("dueDateStr----->"+dueDateStr);
					remarks =  checkNull(eElement.getElementsByTagName("remarks").item(0).getTextContent());					
					ordAmtStr =  checkNull(eElement.getElementsByTagName("ord_amt").item(0).getTextContent());
					taxAmtStr =  checkNull(eElement.getElementsByTagName("tax_amt").item(0).getTextContent());				
					totAmt =  checkNull(eElement.getElementsByTagName("tot_amt").item(0).getTextContent());					

					dlvTerm =  checkNull(eElement.getElementsByTagName("dlv_term").item(0).getTextContent());
					frtAmtStr =  checkNull(eElement.getElementsByTagName("frt_amt").item(0).getTextContent());
					empCodeOrd =  checkNull(eElement.getElementsByTagName("emp_code__ord").item(0).getTextContent());					


					dlvTo =  checkNull(eElement.getElementsByTagName("dlv_to").item(0).getTextContent());
					//acctCodeSal =  checkNull(eElement.getElementsByTagName("acct_code__sal").item(0).getTextContent());
					siteCodeShip =  checkNull(eElement.getElementsByTagName("site_code__ship").item(0).getTextContent());
					pordMode =  checkNull(eElement.getElementsByTagName("pord_mode").item(0).getTextContent());
					udfStr1 =  checkNull(eElement.getElementsByTagName("udf__str1").item(0).getTextContent());

					System.out.println("udfStr1----->"+udfStr1);
					vendorTxCode =  checkNull(eElement.getElementsByTagName("vendor_tx_code").item(0).getTextContent());
					vpsTxId =  checkNull(eElement.getElementsByTagName("vps_tx_id").item(0).getTextContent());
					securityKey =  checkNull(eElement.getElementsByTagName("security_key").item(0).getTextContent());
					trnAmountStr =  checkNull(eElement.getElementsByTagName("trn_amount").item(0).getTextContent());
					System.out.println("vendorTxCode----->"+vendorTxCode+"] vpsTxId--->>["+vpsTxId+"]");
					System.out.println("securityKey----->"+securityKey+"] trnAmountStr--->>["+trnAmountStr+"]");				
					//changed by Manish on 25/04/16 to get the value of vender_no [start]
					if(eElement.getElementsByTagName("vender_no").item(0) != null)
					{
						venderNo =  checkNull(eElement.getElementsByTagName("vender_no").item(0).getTextContent());	
					}
					System.out.println("venderNo----->"+venderNo);	
					//changed by Manish on 25/04/16 to get the value of vender_no [end]

				}
			}	    	 

			/*custCode=genericUtility.getColumnValue("cust_code", dom);
	    	addr1=genericUtility.getColumnValue("dlv_add1", dom);
	    	addr2=genericUtility.getColumnValue("dlv_add2", dom);
	    	addr3=genericUtility.getColumnValue("dlv_add3", dom);
	    	dlvCity=genericUtility.getColumnValue("dlv_city", dom);
	    	stateCodeDlv=genericUtility.getColumnValue("state_code__dlv", dom);
	    	dlvPin=genericUtility.getColumnValue("dlv_pin", dom);

	    	countCodeDlv=genericUtility.getColumnValue("count_code__dlv", dom);
	    	stanCode=genericUtility.getColumnValue("stan_code", dom);
	    	tele1=genericUtility.getColumnValue("tel1__dlv", dom);
	    	tele2=genericUtility.getColumnValue("tel2__dlv", dom);
	    	//tele3=genericUtility.getColumnValue("tel3__dlv", dom);
	    	fax=genericUtility.getColumnValue("fax__dlv", dom);

	    	currCode=genericUtility.getColumnValue("curr_code", dom);
	    	crTerm=genericUtility.getColumnValue("cr_term", dom);

	    	tranCode=genericUtility.getColumnValue("tran_code", dom);
	    	siteCode=genericUtility.getColumnValue("site_code", dom);

	    	transMode=genericUtility.getColumnValue("trans_mode", dom);
	    	rcpMode=genericUtility.getColumnValue("rcp_mode", dom); 

	    	buyerName=genericUtility.getColumnValue("buyer_name", dom);
	    	notifyTo=genericUtility.getColumnValue("notify_to", dom);*/

			headerValesMap.put("sale_order",saleOrder);

			headerValesMap.put("cust_code",custCode);
			headerValesMap.put("dlv_add1",addr1);
			headerValesMap.put("dlv_add2",addr2);
			headerValesMap.put("dlv_add3",addr3);
			headerValesMap.put("dlv_city",dlvCity);
			headerValesMap.put("state_code__dlv",stateCodeDlv);
			headerValesMap.put("dlv_pin",dlvPin);
			headerValesMap.put("count_code__dlv",countCodeDlv);

			headerValesMap.put("stan_code",stanCode);
			headerValesMap.put("tel1__dlv",tele1);
			headerValesMap.put("tel2__dlv",tele2);
			headerValesMap.put("tel3__dlv",tele3);
			headerValesMap.put("fax__dlv",fax);
			headerValesMap.put("curr_code",currCode);
			headerValesMap.put("cr_term",crTerm);
			headerValesMap.put("tran_code",tranCode);
			headerValesMap.put("site_code",siteCodeHdr);

			headerValesMap.put("trans_mode",transMode);
			headerValesMap.put("rcp_mode",rcpMode);
			headerValesMap.put("buyer_name",buyerName);
			headerValesMap.put("notify_to",notifyTo);	

			headerValesMap.put("order_date",orderDateStr);
			headerValesMap.put("item_ser",itemSer);
			headerValesMap.put("cust_pord",saleOrderMangento);
			headerValesMap.put("pord_date",pordDateStr);
			headerValesMap.put("sales_pers",salesPers);

			headerValesMap.put("tax_date",taxDateStr);
			headerValesMap.put("price_list",priceList);
			headerValesMap.put("cr_term",crTerm);
			headerValesMap.put("exch_rate",exchRateStr);
			headerValesMap.put("due_date",dueDateStr);

			headerValesMap.put("remarks",remarks);
			headerValesMap.put("ord_amt",ordAmtStr);
			headerValesMap.put("tax_amt",taxAmtStr);
			headerValesMap.put("tot_amt",totAmt);

			headerValesMap.put("dlv_term",dlvTerm);
			headerValesMap.put("frt_amt",frtAmtStr);
			headerValesMap.put("emp_code__ord",empCodeOrd);
			headerValesMap.put("dlv_to",dlvTo);
			headerValesMap.put("acct_code__sal",acctCodeSal);
			headerValesMap.put("site_code__ship",siteCodeShip);
			headerValesMap.put("pord_mode",pordMode);
			headerValesMap.put("udf__str1",udfStr1);

			headerValesMap.put("vendor_tx_code",vendorTxCode);
			headerValesMap.put("vps_tx_id",vpsTxId);
			headerValesMap.put("security_key",securityKey);
			headerValesMap.put("trn_amount",trnAmountStr);
			//changed by Manish on 25/04/16 to put the value of vender_no in map [start]
			headerValesMap.put("vender_no",venderNo);
			//changed by Manish on 25/04/16 to put the value of vender_no in map [end]
		}
		else
		{
			System.out.println("in getSorderHdrData dom is null...............................");
		}
		return headerValesMap;
	}
	//replace and added by sarita on 26DEC2017 to add userId parameter
	//private String saveData(String siteCode, String xmlString, Connection conn) throws ITMException, Exception
	private String saveData(String siteCode, String xmlString, Connection conn,String userId) throws ITMException, Exception
	{

		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

			String [] authencate = new String[2];
			//replace and added by sarita on 26DEC2017 to keep first object of user array as userID 
			//authencate[0] = "";
			authencate[0] = userId;
			authencate[1] = "";
			System.out.println("xmlString in masterStateful :::: " + xmlString);
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
			masterStateful = null;			

		}
		catch(ITMException e)
		{			
			System.out.println("ITMException ::saveData :==>");
			throw new ITMException(e);
		}
		catch(Exception e)
		{			
			System.out.println("Exception ::saveData :==>");
			throw new Exception(e);
		}
		return retString;

	}

	public String checkNull(String str)
	{
		if(str == null)
		{
			str="";
		}
		return str.trim();

	}
	//Added by Santosh on 04/04/2017 to create receipt for rcp mode G/M [Start]
	private void createAdvReceipt(String salesOrderNo, String custCode, HashMap<String,String> headerValuesMap, String xtraParams)
	{
		boolean isError = false;
		int count = 0;
		double chqAmt = 0.0, exchRateD = 0.0;
		double initialValue=0.0;
		String tranId = "", chgTerm = "", chgUser = "", acctCodeAr = "", cctrCodeAr = "", acctCodeAdv = "", cctrCodeAdv = "", custBankRef = "";
		String remarks = "", currCode = "", rcpMode = "", bankCode = "", finEntity = "",  exchRate = "", siteCode = "", finCurrCode = "", currCodeBank = "";
		String acctCodeBal = "", cctrCodeBal = "", acctCodeCf = "", currDateStr = "", cctrCodeCf = "", acctCodeCfAr = "", cctrCodeCfAr = "";
		String errString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		FinCommon finCommon = new FinCommon();
		DistCommon discommon = new DistCommon();
		AppConnectParm appConnect = new AppConnectParm();
		ReceiptAdvConfLocal receiptAdvConfLocal = null;
		try
		{
			System.out.println("############createAdvReceipt######### Start");
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			java.sql.Date curDate = new java.sql.Date(System.currentTimeMillis());
			java.sql.Timestamp currentDate = new Timestamp(System.currentTimeMillis());	
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chgUser = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			rcpMode = headerValuesMap.get("rcp_mode");
			chqAmt = Double.parseDouble(headerValuesMap.get("tot_amt"));
			siteCode = headerValuesMap.get("site_code");
			remarks = "Advance receipt against SO No. "+salesOrderNo;
			currCode = headerValuesMap.get("curr_code");
			conn = getConnection();
			
			tranId = generateTranTd("w_receipt_adv", new SimpleDateFormat(e12GenericUtility.getApplDateFormat()).format(currentDate), headerValuesMap.get("site_code"), conn);
			
			if(custCode != null && custCode.length() > 0)
			{
				sql = "SELECT ACCT_CODE__AR,CCTR_CODE__AR,CURR_CODE,ACCT_CODE__ADV,CCTR_CODE__ADV,BANK_NAME FROM CUSTOMER WHERE CUST_CODE = ?";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, custCode);			   
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCodeAr = rs.getString("ACCT_CODE__AR");
					cctrCodeAr = rs.getString("CCTR_CODE__AR");
					acctCodeAdv = rs.getString("ACCT_CODE__ADV");
					cctrCodeAdv = rs.getString("CCTR_CODE__ADV");
					custBankRef = rs.getString("BANK_NAME");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			
			sql = " select descr from gencodes where mod_name = ? and fld_name = ? ";
			pstmt = conn.prepareStatement(sql);
			if( "G".equalsIgnoreCase(rcpMode))
			{
				pstmt.setString(1, "W_SAGEPAY");
			}
			else if("M".equalsIgnoreCase(rcpMode))
			{
				pstmt.setString(1, "W_PAYPAL");
			}
			pstmt.setString(2, currCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{					
				bankCode = checkNull(rs.getString("descr"));
			}
			System.out.println("Bank Code is="+bankCode);
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			sql = " select fin_entity from bank where bank_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{					
				finEntity = checkNull(rs.getString("fin_entity"));	
			}
			System.out.println("Fin Entity is="+finEntity);
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(bankCode != null && bankCode.length() > 0)
			{
				sql = "SELECT ACCT_CODE__BAL, CCTR_CODE__BAL, ACCT_CODE__CF,"
					+ "CCTR_CODE__CF,ACCT_CODE__CF_AR, CCTR_CODE__CF_AR,CURR_CODE "
					+ "FROM BANK WHERE BANK_CODE = ?";			   

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bankCode);			   
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					acctCodeBal = rs.getString("ACCT_CODE__BAL");
					cctrCodeBal = rs.getString("CCTR_CODE__BAL");
					acctCodeCf = rs.getString("ACCT_CODE__CF");
					cctrCodeCf = rs.getString("CCTR_CODE__CF");
					acctCodeCfAr = rs.getString("ACCT_CODE__CF_AR");
					cctrCodeCfAr = rs.getString("CCTR_CODE__CF_AR");
					currCodeBank = rs.getString("CURR_CODE");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("ACCT_CODE__BAL@@ ::: "+acctCodeBal);
				System.out.println("curr_code ::: "+currCode);

				if(acctCodeCfAr != null && acctCodeCfAr.trim().length() != 0)
				{
					acctCodeCf = acctCodeCfAr;
				}
				if(cctrCodeCfAr != null && cctrCodeCfAr.trim().length() != 0)
				{
					cctrCodeCf = cctrCodeCfAr;
				}

				sql = " SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				rs = pstmt.executeQuery();

				while (rs.next())
				{
					finEntity = checkNull(rs.getString("FIN_ENTITY"));
				}				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;


				sql = " SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,finEntity);
				rs = pstmt.executeQuery();

				while (rs.next())
				{
					finCurrCode = checkNull(rs.getString("CURR_CODE"));
				}				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(currCodeBank.equals(finCurrCode))
				{
					exchRate = "1";
				}
				else
				{
					currDateStr = new SimpleDateFormat(e12GenericUtility.getApplDateFormat()).format(currentDate);
					System.out.println("TODAY IS="+currDateStr);
					System.out.println("Order Site="+siteCode);

					Double exchRateFinn = finCommon.getDailyExchRateSellBuy(currCode.trim(),"",siteCode.trim(),currDateStr.trim(),"S", conn);


					if(exchRateFinn != null)
					{
						exchRateFinn = discommon.getRndamt(exchRateFinn, "R", 0.000001);
					}

					exchRate = String.valueOf(exchRateFinn);
					System.out.println("Exch Rate from FinnCommon="+exchRate);
					if(exchRate != null && exchRate.equals(""))
					{
						exchRate = getColumnDescr(conn, "std_exrt", "currency", "curr_code", currCode);
					}
				}
				
				exchRateD = Double.parseDouble(exchRate);

				System.out.println("exchRateD-------->>"+exchRateD);
			}
			
			sql = "INSERT INTO RECEIPT ( TRAN_ID,TRAN_DATE,CUST_CODE,RCP_MODE,BANK_CODE,REF_NO,REF_DATE,"
				+ "EFF_DATE,SITE_CODE,CHG_DATE,CHG_USER,CHG_TERM,ACCT_CODE__AR,CCTR_CODE__AR,"//14
				+ "CURR_CODE,ACCT_CODE__ADV,CCTR_CODE__ADV,CUST_BANK_REF,EXCH_RATE,EXCH_RATE_SPOT,"
				+ "FIN_ENTITY,ACCT_CODE__BAL,CCTR_CODE__BAL,ACCT_CODE__CF,CCTR_CODE__CF,REMARKS,CHQ_AMT, "//27
				+ "CONFIRMED, OTH_AMT,ADV_AMT,ADVADJ_AMT,NET_AMT,NET_AMT__BC,TRAN_TYPE,AUTO_RECD,ITEM_SER,"
				+ "SALE_ORDER   ) "
				+ "VALUES ( ?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,? ,?,?,?,?)";

				System.out.println("Insert SQL ::- "+sql);

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				pstmt.setDate(2,curDate);
				pstmt.setString(3,custCode);
				pstmt.setString(4,rcpMode);
				pstmt.setString(5,bankCode);
				pstmt.setString(6,salesOrderNo);
				pstmt.setTimestamp(7,currentDate);
				pstmt.setTimestamp(8,currentDate);
				pstmt.setString(9,siteCode);
				pstmt.setTimestamp(10,currentDate);
				pstmt.setString(11,chgUser);
				pstmt.setString(12,chgTerm);
				pstmt.setString(13,acctCodeAr);
				pstmt.setString(14,cctrCodeAr);
				pstmt.setString(15,currCode);
				pstmt.setString(16,acctCodeAdv);
				pstmt.setString(17,cctrCodeAdv);
				pstmt.setString(18,custBankRef);
				pstmt.setDouble(19,exchRateD);
				pstmt.setDouble(20,exchRateD);
				pstmt.setString(21,finEntity);
				pstmt.setString(22,acctCodeBal);
				pstmt.setString(23,cctrCodeBal);
				pstmt.setString(24,acctCodeCf);
				pstmt.setString(25,cctrCodeCf);
				pstmt.setString(26,remarks);
				pstmt.setDouble(27,chqAmt);
				pstmt.setString(28,"N");
				pstmt.setDouble(29,initialValue);
				pstmt.setDouble(30,chqAmt);
				pstmt.setDouble(31,initialValue);
				pstmt.setDouble(32,chqAmt);
				pstmt.setDouble(33,chqAmt);
				pstmt.setString(34,"A");
				pstmt.setString(35,"N");
				pstmt.setString(36,headerValuesMap.get("item_ser"));
				pstmt.setString(37,salesOrderNo);

				count = pstmt.executeUpdate();
				System.out.println("No of records inserted successfully in RECEIPT are : "+count);
				
				if(count > 0)
				{
					ctx = new InitialContext(appConnect.getProperty());
					receiptAdvConfLocal = (ReceiptAdvConfLocal)ctx.lookup("ibase/ReceiptAdvConf/local");							
					errString = receiptAdvConfLocal.confirm(tranId, xtraParams, "",conn);
					System.out.println("errString After confirmed------>>["+errString+"]");
		
					if(errString.indexOf("VTCICONF3") > -1)
					{
						conn.commit();
						System.out.println("Advanced receipt generated and confirmed successfully..................");
					}
					else
					{
						conn.rollback();
					}						
				}
				
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				System.out.println("############createAdvReceipt######### End");
			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("UploadOrderEJB.createAdvReceipt():Exception occurred["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				
				if(isError)
				{
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.rollback();
				}
				
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("UploadOrderEJB.createAdvReceipt():finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
			
		}
	}
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = '"+windowName+"'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			System.out.println("keyString :"+rs.toString());
			String tranSer1 = "";
			String keyString = "";
			String keyCol = "";
			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{			
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
	
	//Added by Santosh on 04/04/2017 to create receipt for rcp mode G/M [End]
}
