/**
 *  PURPOSE  : Process for Fright Updation
 *  AUTHOR   : Samadhan On 21/04/2015  
 *  Obj_name : w_fright_upd
 *  Request Id:  D15AKAT011
 */

package ibase.webitm.ejb.wms;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@javax.ejb.Stateless
public class FrightUpdPrc extends ProcessEJB implements FrightUpdPrcLocal,FrightUpdPrcRemote //SessionBean
{

	DistCommon discommon = new DistCommon();
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		System.out.println("getData(xmlString,xmlString2,windowName,xtraParams CALLED..."+ xmlString);
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			long startTime2 = System.currentTimeMillis();
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
			long endTime2 = System.currentTimeMillis();
			System.out.println("DIFFERANCE IN TIME FOR GET DATA IN SECONDS:::["+(endTime2-startTime2)/1000+"]");

		}
		catch (Exception e)
		{
			System.out.println("Exception :FrightUpdIC :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr; 
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		
		String resultString = "";
		
		Connection conn=null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		String suppCode="";
		String amount="";
		String errString="";
		String siteCode="";
		String chgUser="";
		String chgTerm="";
		int totalRecCnt=0,count=0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength=0;
		E12GenericUtility genericUtility = new E12GenericUtility(); 
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

		System.out.println("Header Dom="+genericUtility.serializeDom(headerDom));	
		retTabSepStrBuff = new StringBuffer( "<?xml version='1.0' encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n" +
		"<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");

		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;	
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{	
				childNode = childNodeList.item(ctr);
				String childNodeName = childNode.getNodeName();
				System.out.println("childNodeName.editFlag." + childNodeName+".."+childNode.getFirstChild());
			}

			siteCode = genericUtility.getColumnValue("site_code",headerDom);
			suppCode = genericUtility.getColumnValue("supp_code",headerDom);
			System.out.println("Supplier Code: "+suppCode);

			amount = genericUtility.getColumnValue("amount",headerDom);
			System.out.println("Amount: "+amount);

			if(suppCode == null || suppCode.trim().length() == 0)
			{
				String sql = "select count(1) from supplier where supp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, suppCode);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				pstmt.close();

				if(count == 0 )
				{	 
					errString = itmDBAccessEJB.getErrorString("","VTSUPP1","","",conn);
					return errString;
				}	
			}
			if(amount == null || amount.trim().length() == 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTFAMTNVL","","",conn);
				return errString;
			}
			else
			{
				if(Double.valueOf(amount)<=0)
				{
					errString = itmDBAccessEJB.getErrorString("","VTFAMTNVL","","",conn);
					return errString;
				}
			}


			String getDataSql = "SELECT DISTINCT R.TRAN_ID,R.PURC_ORDER,R.AMOUNT,SYSDATE FROM PORDER P, PORCP R ,PORCPDET D WHERE P.PURC_ORDER = R.PURC_ORDER " +
			"AND P.PURC_ORDER=D.PURC_ORDER AND R.CONFIRMED = 'N' AND " +
			"P.STATUS != 'C' AND P.CONFIRMED = 'Y' AND P.SUPP_CODE = ? AND P.SITE_CODE__ORD = ? ORDER BY R.PURC_ORDER ASC ";

			pstmt = conn.prepareStatement(getDataSql);
			pstmt.setString(1, suppCode.trim());
			pstmt.setString(2, siteCode.trim());

			rs = pstmt.executeQuery();


			if(rs.next())
			{
				do{

					retTabSepStrBuff.append( "<Detail2>\r\n" );				
					retTabSepStrBuff.append( "<tran_id><![CDATA[" ).append(rs.getString(1)).append( "]]></tran_id>\r\n" );
					retTabSepStrBuff.append( "<purc_order_no><![CDATA[" ).append(rs.getString(2)).append( "]]></purc_order_no>\r\n" );
					Double purcAmt = rs.getDouble(3);
					retTabSepStrBuff.append( "<amount><![CDATA[" ).append(purcAmt).append( "]]></amount>\r\n" );
					retTabSepStrBuff.append( "<chg_user><![CDATA[" ).append(chgUser).append( "]]></chg_user>\r\n" );
					retTabSepStrBuff.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					retTabSepStrBuff.append( "<chg_date><![CDATA[" ).append(rs.getString(4)).append( "]]></chg_date>\r\n" );
					retTabSepStrBuff.append( "<temp_rec_cnt><![CDATA[" ).append(totalRecCnt).append( "]]></temp_rec_cnt>\r\n" );
					retTabSepStrBuff.append( "</Detail2>\r\n" );

				}while(rs.next());
				retTabSepStrBuff.append( "</Header0>\r\n</group0>\r\n</DocumentRoot>\r\n" );		
				resultString = retTabSepStrBuff.toString();
				System.out.println("ResultString....." + resultString);
				pstmt.clearParameters();
				pstmt.close();
				rs.close();
			}
			else
			{ 	
				errString = itmDBAccessEJB.getErrorString("","RECNOTF","","",conn);
				return errString;
			}
		}
		
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try {
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;								
				}	
				
				conn.close();
				conn = null;
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}	
		
		return resultString;	
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("below genericUtility--------------->>>>>>>>>");
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
			}

			long startTime22 = System.currentTimeMillis();
			retStr = process(headerDom, detailDom, windowName, xtraParams);
			long endTime22 = System.currentTimeMillis();
			System.out.println("DIFFERANCE IN TIME FOR TOTAL PROCESS IN SECONDS:::["+(endTime22-startTime22)/1000+"]"); 
		}
		catch (Exception e)
		{
			System.out.println("Exception :StockAllocationPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		return retStr;	
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{			

		E12GenericUtility genericUtility = new E12GenericUtility(); 
		System.out.println("process Method Called.......................");
		System.out.println("detailDom------------------->"+genericUtility.serializeDom(detailDom));	
		System.out.println("headerDom------------------->"+genericUtility.serializeDom(headerDom));	
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		NodeList parentNodeList = null;
		int childNodeListLength=0;
		String childNodeName="";
		Connection conn = null;
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		String errString = "";
		String amount="";
		String tranId="";
		String chgUser="";
		String chgTerm="";
		Double totlPurcAmt = null;
		ArrayList<String> tranIdList = new ArrayList<String>();
		StringBuffer sqlBuf = new StringBuffer();
		StringBuffer tPurcAmtSqlBuf = new StringBuffer();
		
		int pstmtCount=1;
		try
		{
			//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using previous component Start
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			MasterStatefulLocal masterStatefulLocal = null;	
			String xmlInEditMode ="";
			Document dom = null;
			Node root = null;
			String xmlParseStr ="";
			masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local"); 
			String userInfo = getUserInfo(xtraParams);
			masterStatefulLocal.setUserInfo(userInfo, "");
			//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using previous component End
			//Commented by Santosh on 14-06-2016
			//ConnDriver connDriver = new ConnDriver();
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;	
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{	
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName.editFlag." + childNodeName+".."+childNode.getFirstChild());
			}

			NodeList nodeListDtl = detailDom.getElementsByTagName("Detail2");

			for (int ctr = 0; ctr < nodeListDtl.getLength(); ctr++)
			{				
				childNode = nodeListDtl.item(ctr);			
				childNodeName = childNode.getNodeName();
				System.out.println("Child name --->> "+childNodeName);	
				if (childNode.getNodeType() == Node.ELEMENT_NODE)
				{
					Element eElement = (Element) childNode;					
					tranId =  checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());								
					System.out.println("Tran Id --->["+tranId+"]");					
					tranIdList.add(tranId);
				}
			}

			amount = genericUtility.getColumnValue("amount",headerDom);
			System.out.println("Amount: "+amount);
			if(amount == null || amount.trim().length() == 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTFAMTNVL","","",conn);
				return errString;
			}
			else
			{
				if(Double.valueOf(amount)<=0)
				{
					errString = itmDBAccessEJB.getErrorString("","VTFAMTNVL","","",conn);
					return errString;
				}
			}

			if(sqlBuf != null && sqlBuf.length() > 0)
			{
				sqlBuf.delete(0, sqlBuf.length());
			}
			sqlBuf.append("SELECT DISTINCT R.TRAN_ID,R.PURC_ORDER,R.AMOUNT,SYSDATE FROM  PORCP R WHERE R.TRAN_ID IN (");

			sqlBuf.append(getWhats(tranIdList));
			sqlBuf.append( " )");

			sqlBuf.append(" ORDER BY R.PURC_ORDER ASC ");

			pstmt = conn.prepareStatement(sqlBuf.toString());

			pstmtCount=1;
			for(String temp : tranIdList)
			{
				pstmt.setString(pstmtCount++,temp);						
			}

			rs = pstmt.executeQuery();

			if(tPurcAmtSqlBuf != null && tPurcAmtSqlBuf.length() > 0)
			{
				tPurcAmtSqlBuf.delete(0, tPurcAmtSqlBuf.length());
			}
			tPurcAmtSqlBuf.append("SELECT SUM(R.AMOUNT) FROM  PORCP R WHERE  R.TRAN_ID IN (");

			tPurcAmtSqlBuf.append(getWhats(tranIdList));
			tPurcAmtSqlBuf.append( " )");

			pstmt1 = conn.prepareStatement(tPurcAmtSqlBuf.toString());

			pstmtCount=1;
			for(String temp : tranIdList)
			{
				pstmt1.setString(pstmtCount++,temp);						
			}

			rs1 = pstmt1.executeQuery();

			if(rs1.next())
			{ 
				totlPurcAmt = rs1.getDouble(1);
			}
			pstmt1.close();
			rs1.close();

			System.out.println("Total Purch Amount"+totlPurcAmt);

			String SqlSord = "UPDATE PORCP SET FRT_AMT =  ? , CHG_USER = ? , CHG_TERM = ? , CHG_DATE = SYSDATE WHERE TRAN_ID = ? ";
			pstmt = conn.prepareStatement(SqlSord);
			while(rs.next())
			{	
				Double purcAmt = rs.getDouble(3);
				System.out.println("Purchase Amount: "+purcAmt);
				Double freightAmt= (purcAmt * Double.valueOf(amount))/totlPurcAmt;						
				System.out.println("*****Fright Amount--->"+freightAmt);
				String tranId1 = rs.getString(1);
				System.out.println("*****Tran Id--->"+tranId1);
				
				//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using old component Start
				/*
				pstmt.setDouble(1, Double.valueOf(String.format("%.2f", freightAmt)));
				pstmt.setString(2, chgUser.trim());
				pstmt.setString(3, chgTerm.trim());
				pstmt.setString(4, tranId1.trim());
				pstmt.executeUpdate();
				*/
				
				/*
				String getDataSql = "select SUM(quantity) from porcpdet where tran_id = ?";
				double qnty=0;
				double frt_rate=0;
				pstmt1 = conn.prepareStatement(getDataSql);
				pstmt1.setString(1, tranId1.trim());
				rs1 = pstmt1.executeQuery();
				
				if(rs1.next())
				{
					qnty = rs1.getDouble(1);
				}
				frt_rate = (freightAmt/qnty);				
				pstmt1.close();
				rs1.close();
				*/				
				
				xmlInEditMode=	masterStatefulLocal.getDetailXMLDomString("porcp", "1", "E", tranId1, "");
					
				/*File fXmlFile = new File("/home/base/Desktop/Text File.xml");
	    		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
	    		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
	    		org.w3c.dom.Document document = genericUtility.parseFile(fXmlFile);
	    		xmlInEditMode = genericUtility.serializeDom(document);*/
	    		
	    		xmlInEditMode = xmlInEditMode.substring(0, xmlInEditMode.indexOf("</DocumentRoot>"));
	    		
	    		xmlInEditMode = xmlInEditMode + "<Detail1 dbID=\""+tranId1+"\" domID=\"1\" objContext=\"1\" objName=\"porcp\">\n\r";
	    		xmlInEditMode = xmlInEditMode + "<attribute pkNames=\"tran_id:\" selected=\"N\" status=\"O\" updateFlag=\"E\"/>\n\r";
	    		xmlInEditMode = xmlInEditMode + "<frt_amt><![CDATA["+freightAmt+"]]></frt_amt>\n\r";
	    		//xmlInEditMode = xmlInEditMode + "<frt_rate><![CDATA["+frt_rate+"]]></frt_rate>";
	    		//xmlInEditMode = xmlInEditMode + "<frt_type><![CDATA[Q]]></frt_type>";
	    	
	    		xmlInEditMode = xmlInEditMode + "</Detail1>\n\r";
	    		xmlInEditMode = xmlInEditMode + "</DocumentRoot>\n\r";
	    		
				dom = genericUtility.parseString(xmlInEditMode);

				setNodeValue(dom, "frt_amt",String.valueOf(freightAmt));
								
				root = dom.getElementsByTagName("Header0").item(0);
				
				Element objContext = dom.createElement("objContext");
				objContext.appendChild(dom.createTextNode("1"));
				root.appendChild(objContext);
				
				Element keyValue = dom.createElement("keyValue");
				keyValue.appendChild(dom.createTextNode("1"));
				root.appendChild(keyValue);
				
				Element objName = dom.createElement("objName");
				objName.appendChild(dom.createTextNode("porcp"));
				root.appendChild(objName);
				
				Element pageContext = dom.createElement("pageContext");
				pageContext.appendChild(dom.createTextNode("2"));
				root.appendChild(pageContext);
				
				Element editFlag = dom.createElement("editFlag");
				editFlag.appendChild(dom.createTextNode("E"));
				root.appendChild(editFlag);
				
				Element focusedColumn = dom.createElement("focusedColumn");
				focusedColumn.appendChild(dom.createTextNode(""));
				root.appendChild(focusedColumn);
				
				Element action = dom.createElement("action");
				action.appendChild(dom.createTextNode("EDIT"));
				root.appendChild(action);
				
				Element elementName = dom.createElement("elementName");
				elementName.appendChild(dom.createTextNode(""));
				root.appendChild(elementName);
				
				Element taxKeyValue = dom.createElement("taxKeyValue");
				taxKeyValue.appendChild(dom.createTextNode(""));
				root.appendChild(taxKeyValue);
				
				Element saveLevel = dom.createElement("saveLevel");
				saveLevel.appendChild(dom.createTextNode("1"));
				root.appendChild(saveLevel);
				
				Element forcedSave = dom.createElement("forcedSave");
				forcedSave.appendChild(dom.createTextNode("true"));
				root.appendChild(forcedSave);
				
				Element taxInFocus = dom.createElement("taxInFocus");
				taxInFocus.appendChild(dom.createTextNode("false"));
				root.appendChild(taxInFocus);
				
				Element pkValues = dom.createElement("pkValues");
				pkValues.appendChild(dom.createTextNode(tranId1));
				root.appendChild(pkValues);
				
				xmlParseStr = genericUtility.serializeDom(dom);

				System.out.println("\n\nXml After Parse================>"+xmlParseStr);
				
				xmlParseStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+xmlParseStr;
				
				String retString = masterStatefulLocal.processRequest(userInfo, xmlParseStr, true, conn); 
				
				System.out.println("Return String from ProcessRequest:=>"+retString);
				
				if((retString.toUpperCase().indexOf("SUCCESS")==-1))
				{
				return retString;
				}
				//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using old component End
			}
			//pstmt.executeBatch();
			
			pstmt.close();
			rs.close();
			conn.commit();
			} catch (Exception e) {
			try 
			{
				conn.rollback();
			} 
			catch (SQLException e1) 
			{
				e1.printStackTrace();
			}
			e.printStackTrace();

		}
		finally
		{
			try {
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;								
				}	
				if( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;								
				}
				if( rs != null )
				{
					rs.close();
					rs = null;								
				}
				if( rs1 != null )
				{
					rs1.close();
					rs1 = null;								
				}
				conn.close();
				conn = null;
			} catch (SQLException e) 
			{

				e.printStackTrace();
			}
		}	

		errString = itmDBAccessEJB.getErrorString("","VTCOMPL","","",conn);
		return errString;



	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	
	private String getWhats( ArrayList<String> arrList )	
	{
		String mark="";
		for(String temp : arrList)
		{
			mark = mark + "?,";
			System.out.print("Fields:"+temp);
		}
		if(mark !=null && mark.length() > 0)
		{
			mark = mark.substring(0,mark.length() - 1);
		}
		return mark;
	}
	
	//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using old component Start
	public String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String chgTerm = "";
		//Added by sarita on 26DEC2017
		String transDB = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			//added  by sarita on 26DEC2017 to insert transDB parameter
			transDB = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"transDB");
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			//added  by sarita on 26DEC2017 to insert transDB parameter
			userInfoStr.append("<transDB>").append("<![CDATA["+transDB+"]]>").append("</transDB>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}
	
	private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	{
		Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		if( tempNode != null )
		{
			if( tempNode.getFirstChild() == null )
			{
				CDATASection cDataSection = dom.createCDATASection( nodeVal );
				tempNode.appendChild( cDataSection );
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	}
	
	//Changed By samadhan on 21/07/2015 for get xml in edit mode & update frt amt using old component End


}