package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.AttendanceComplianceRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class AttendanceCompSummaryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		AttendanceComplianceRemote attenanceComplianceRemote = null;
		InitialContext context            = null;
		AppConnectParm appConnectParm     = new AppConnectParm();
		String dataSourceName = "";
		String loginId        = "";
		String period        = "", salesPers = "";
		try
		{
			response.setContentType("application/xml");

			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			
			dataSourceName = request.getParameter("dataSourceName");
			salesPers 	   = request.getParameter("salesPers");
			period 	       = request.getParameter("period");
			
			System.out.println("in AttendanceCompSummaryServlet  salesPers :"+salesPers+"===== period :"+period+" ======loginId: "+loginId);
			
			if(salesPers != null && salesPers.length()>0)
			{
				salesPers = salesPers;
			}
			else
			{
				salesPers = loginId;
			}
			context                         = new InitialContext(appConnectParm.getProperty());
			attenanceComplianceRemote       = (AttendanceComplianceRemote) context.lookup("ibase/AttendanceCompliance/remote");
			JSONObject jsonObjData    		= (JSONObject) attenanceComplianceRemote.getComplianceSummary(dataSourceName, salesPers, period);
			OutputStream outputStream   	= response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for AttendanceCompSummaryServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : AttendanceCompSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}