package ibase.dashboard.common.hibernate.dao;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.security.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.hql.ast.origin.hql.parse.HQLParser.new_key_return;
import org.hibernate.hql.ast.origin.hql.parse.HQLParser.set_key_return;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.dashboard.common.hibernate.bean.Employee;
import ibase.dashboard.common.hibernate.bean.LoginTrace;
import ibase.dashboard.common.hibernate.bean.UserProfile;
import ibase.dashboard.common.hibernate.utility.HibernateUtil;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
//import jersey.repackaged.com.google.common.collect.Lists;

//6DBC5A495F0F2C5371D59DC89EB06F41
public class AccountActivityDao 
{
	private static String siteTranDB = "DEFAULT";


	public String getUserActivityData(String loginCode, String profileId)throws Exception
	{
		JSONObject activityDataFinal = new JSONObject();
		JSONArray activityDataFinalArray = new JSONArray();
		System.out.println("getUserActivityData>>>");
		profileId=profileId.trim();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYYMMdd");
		String today = LocalDate.now().format(formatter);
		System.out.println("today date ["+today+"]");

		DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("dd-MM-YY");
		String todayFormat = LocalDate.now().format(formatter1);
		System.out.println("today1 date ["+todayFormat+"]");
		
		/* For ADMIN and ADM user all users data read */
		if( "ADMIN".equalsIgnoreCase(profileId) || "ADM".equalsIgnoreCase(profileId) )
		{
			List<JSONObject> fileDataList= getUserActivityFileData(null,today);
			System.out.println("getUserActivityData>>>"+ fileDataList);
			HashMap<String, JSONObject> minMaxTimeList= getMinMaxTime(todayFormat,null);
			HashMap<String, JSONObject> minMaxBatteryStatus = getBatteryStatus(todayFormat);
			List<String> loginUserList = getLoginUsers(todayFormat);
			System.out.println("loginUserList in Admin case:::::"+loginUserList);
			
			JSONObject activityData = new JSONObject();
			JSONArray deviceTypeList= getDeviceType(loginUserList, todayFormat);
			
			JSONObject clientAppList= getClientApp(activityData,loginUserList, todayFormat);
			
			JSONObject osNameList= getOsName(activityData,loginUserList, todayFormat);
			
			System.out.println(" activityData Device data object::::"+activityData);
			activityDataFinal.put("ACTIVITY_GRAPH_DATA",activityData);
			
			if(fileDataList.isEmpty())  //No User perform userActivity.
			{
				if(loginUserList != null){
					for(String usersId : loginUserList){
						activityData=fileNotFoundUsers(activityData,minMaxTimeList,minMaxBatteryStatus,usersId);
						activityDataFinalArray.put(activityData);
					}
				}
				System.out.println("activityDataFinal for if"+activityDataFinal);
			}
			else  //User perform userActivity
			{
				List<String> fileUsersList = new ArrayList<String>();
				for(JSONObject fileDataObj : fileDataList ) 
				{
					String userId = fileDataObj.optString("userId");
					String activityDate = fileDataObj.optString("activityDate");
					String fileContents = fileDataObj.optString("fileContents");
					fileUsersList.add(userId);
					System.out.println("fileUsersList in Admin case::::::::: "+fileUsersList);
					System.out.println("fileName::::::::: ["+userId+"]["+activityDate+"]");
					activityData = createActivityData(userId, fileContents);
					activityData = updateMinMaxTime(activityData, minMaxTimeList.get(userId)) ;
					activityData = checkUserForBatteryStatus(activityData, minMaxBatteryStatus,userId) ;					
					activityDataFinalArray.put(activityData);
				}
				loginUserList.removeAll(fileUsersList); //For some user who didn't perform userActivity
				System.out.println("loginUserList after:::"+loginUserList);
				for(String usersId  : loginUserList)
				{
					activityData=fileNotFoundUsers(activityData,minMaxTimeList,minMaxBatteryStatus,usersId);
					activityDataFinalArray.put(activityData);
				}
			}
			activityDataFinalArray = prepareAllUsersData(activityDataFinalArray);
			activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
			
		}
		/* For Profile Ids except ADMIN and ADM */
		else
		{
			List<String> userDataList = getUserDetails(loginCode,profileId); // For User who have team
			System.out.println("userDataList AFTER>>>"+userDataList);
			HashMap<String, JSONObject> minMaxTimeList= getMinMaxTime(todayFormat,userDataList);
			HashMap<String, JSONObject> minMaxBatteryStatus = getBatteryStatus(todayFormat);
			
			JSONObject selfActivityData = new JSONObject();
			JSONArray deviceTypeList= getDeviceType(userDataList, todayFormat);
			JSONObject clientAppList= getClientApp(selfActivityData,userDataList, todayFormat);
			JSONObject osNameList= getOsName(selfActivityData,userDataList, todayFormat);
			activityDataFinal.put("ACTIVITY_GRAPH_DATA",selfActivityData);

			List<JSONObject> fileDataList= getUserActivityFileData(userDataList, today);
			System.out.println("fileDataList AFTER>>>"+fileDataList);

			JSONObject teamMemberActivityData = new JSONObject();
			JSONArray teamActivityData = new JSONArray();

			if(fileDataList.isEmpty()) // For users which is in userDataList didn't perform any userActivity .
			{
				selfActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,loginCode);
				userDataList.remove(loginCode);
				System.out.println("userDataList in After removing logincode:::"+userDataList);
				if(userDataList != null){
					for(String usersId : userDataList){
						teamMemberActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
						teamActivityData.put(teamMemberActivityData);
					}
					if(teamActivityData.length()>0){
						selfActivityData.put("TEAM", teamActivityData);				
					}
				}
				activityDataFinalArray.put(selfActivityData);
				activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
				System.out.println("activityDataFinal for if"+activityDataFinal);
				
			}
			else //For users which is in userDataList perform userActivity.
			{
				List<String> fileUsersList = new ArrayList<String>();
				for(JSONObject fileDataObj : fileDataList )
				{
					System.out.println("Inside file else:::"+userDataList);
					String userId = fileDataObj.optString("userId");
					String activityDate = fileDataObj.optString("activityDate");
					String fileContents = fileDataObj.optString("fileContents");
					System.out.println("fileName::::::::: ["+userId+"]["+activityDate+"]");
					fileUsersList.add(userId);
						if( userId.equalsIgnoreCase(loginCode))
						{
							selfActivityData = createActivityData(userId, fileContents);
							selfActivityData = checkUserForMinMaxTime(selfActivityData, minMaxTimeList,userId) ;
							selfActivityData = checkUserForBatteryStatus(selfActivityData, minMaxBatteryStatus,userId) ;					
						}
						else
						{
							teamMemberActivityData = createActivityData(userId, fileContents);
							teamMemberActivityData = checkUserForMinMaxTime(teamMemberActivityData,minMaxTimeList,userId) ;
							teamMemberActivityData = checkUserForBatteryStatus(teamMemberActivityData, minMaxBatteryStatus,userId) ;					
							teamActivityData.put(teamMemberActivityData);
						}
					System.out.println("fileUsersList in else::::::::: ["+fileUsersList+"]");
				}
				userDataList.removeAll(fileUsersList);
				System.out.println("userDataList after:::"+userDataList);
				for(String usersId  : userDataList) // For users which is in userDataList if some user didn't perform user Activity
				{
					if( usersId.equalsIgnoreCase(loginCode))
					{
						selfActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
						System.out.println("selfActivityData after:::"+selfActivityData);
					}
					else {
						teamMemberActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
						teamActivityData.put(teamMemberActivityData);
						System.out.println("teamActivityData after:::"+teamActivityData);
					}
				}
				if(fileDataList != null && fileDataList.size() > 0 )
				{
					if( selfActivityData == null )
					{
						selfActivityData = getUserDetail(new JSONObject(), loginCode);
						selfActivityData = updateMinMaxTime(selfActivityData, minMaxTimeList.get(loginCode)) ;
						selfActivityData = checkUserForBatteryStatus(selfActivityData, minMaxBatteryStatus,loginCode) ;					
					}
					if(teamActivityData.length()>0)
					{
						selfActivityData.put("TEAM", teamActivityData);				
					}
					activityDataFinalArray.put(selfActivityData);
				}
			}
			activityDataFinalArray = prepareTeamUsersData(activityDataFinalArray);
			activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
		}
		System.out.println("activityDataFinal data " + activityDataFinal.toString());
		return activityDataFinal.toString();
	}

	/*If user activity file not Present*/
	private JSONObject fileNotFoundUsers(JSONObject selfActivityData,HashMap<String, JSONObject> minMaxTimeList,HashMap<String, JSONObject> minMaxBatteryStatus,String usersId) throws JSONException {
		selfActivityData = getUserDetail(new JSONObject(), usersId);
		selfActivityData = checkUserForMinMaxTime(selfActivityData, minMaxTimeList,usersId) ;
		selfActivityData = checkUserForBatteryStatus(selfActivityData, minMaxBatteryStatus,usersId) ;					
	    return selfActivityData;
	}
	
	private JSONArray prepareAllUsersData(JSONArray activityDataFinal) {
		//TO GET All Login User Data 
		return activityDataFinal;
	}

	private JSONArray prepareTeamUsersData(JSONArray activityDataFinal) {
		//TO GET Team Login User Data 
		return activityDataFinal;
	}

	private JSONObject updateMinMaxTime(JSONObject activityData, JSONObject minMaxTimeObj) throws JSONException
	{
		if(minMaxTimeObj !=null) 
		{
	    	activityData.put("LOGIN_TIME", checkNull(minMaxTimeObj.opt("loginTime")));
	    	activityData.put("LOGOUT_TIME", checkNull(minMaxTimeObj.opt("logoutTime")));
			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
			return activityData;
		}
		{
	    	activityData.put("LOGIN_TIME", "NA");
	    	activityData.put("LOGOUT_TIME", "NA");
			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
			return activityData;
		}
	}
	
	private JSONObject checkUserForMinMaxTime(JSONObject activityData,HashMap<String, JSONObject> minMaxTimeObj,String userId) throws JSONException 
	{
		System.out.println("checkUserForMinMaxTime activity data::::"+activityData);
		System.out.println("checkUser checkUserForMinMaxTime:::::::userId ["+userId+"] minMaxTimeObj"+minMaxTimeObj);
		if(minMaxTimeObj.get(userId) != null)
		{
			activityData = updateMinMaxTime(activityData, minMaxTimeObj.get(userId)) ;	
			return activityData;
		}
		else // If perticular userId data not present.
		{
			activityData = updateMinMaxTime(activityData, null) ;	
			return activityData;
		}
		
	}
	
	private JSONObject updateMinMaxBatteryStatus(JSONObject activityData, JSONObject minMaxBatteryStatus) throws JSONException
	{
		if(minMaxBatteryStatus !=null)
		{
	    	activityData.put("LOGIN_BATTERY_STATUS", checkNull(minMaxBatteryStatus.opt("loginBatteryStatus")));
	    	activityData.put("LOGOUT_BATTERY_STATUS",checkNull(minMaxBatteryStatus.opt("logoutBatteryStatus")));
			System.out.println("minMaxBatteryStatus query result:::::::"+minMaxBatteryStatus);
			return activityData;
		}
		else
		{
	    	activityData.put("LOGIN_BATTERY_STATUS", "NA");
	    	activityData.put("LOGOUT_BATTERY_STATUS","NA");
			System.out.println("minMaxBatteryStatus else query result:::::::"+minMaxBatteryStatus);
			return activityData;
		}
	}
	
	private JSONObject checkUserForBatteryStatus(JSONObject activityData,HashMap<String, JSONObject> minMaxBatteryStatus,String userId) throws JSONException 
	{
		System.out.println("checkUser:::::::userId ["+userId+"] minMaxBatteryStatus"+minMaxBatteryStatus);
		if(minMaxBatteryStatus.get(userId) != null)
		{
			activityData = updateMinMaxBatteryStatus(activityData, minMaxBatteryStatus.get(userId)) ;	
			return activityData;
		}
		else
		{
			activityData = updateMinMaxBatteryStatus(activityData, null) ;	 //If perticular userId data not present.
			return activityData;
		}
		
	}
	
	private JSONObject getUserDetail(JSONObject activityData, String userCode) throws JSONException
	{
		Employee employee= getEmployeeDetail(userCode);
		if( employee != null )
		{
			activityData.put("NAME", employee.getEmpFname());
			activityData.put("DESIGNATION", employee.getDesignation());
			activityData.put("USER_ID", userCode);
		}
		return activityData;
	}
	
	/* Read user activity file */
	private JSONObject createActivityData(String userCode, String activityLogXml)
	{
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		ArrayList<String> objNameList = new ArrayList<String>();
		JSONObject activityData = new JSONObject();
		try 
		{
			System.out.println("Inside create activity data");
			Document activityDoc = e12GenericUtility.parseString(activityLogXml);
			
			NodeList activitySessIdNL = activityDoc.getElementsByTagName("ACTIVITY_SESSION_ID");
			
			activityData = processSessionIds( userCode, activitySessIdNL );
			
			JSONArray sessionArray = activityData.optJSONArray("ALL_SESSIONS");
			System.out.println("sessionArrayList"+sessionArray);
			
			activityData.remove("ALL_SESSIONS");
			
			NodeList activityNL = activityDoc.getElementsByTagName("ACTIVITY");

			//System.out.println("Inside getUserActivityData" + activityNL +" >> "+ activityNL.getLength() );
			if( activityNL != null && activityNL.getLength() > 0 )
			{
				int len = activityNL.getLength();
				for( int j = 0; j < len; j++)
				{
					String activityObj = "";
					String activityTitle = "";
					String activitySeesionId = "";
					String activityIcon="";
					NodeList activityChildNL = activityNL.item(j).getChildNodes();
					//System.out.println("processActivityAction i" + i);
					System.out.println("==");
					int actChLen = activityChildNL.getLength();
					//System.out.println("processActivityAction actChLen" + actChLen);
					for( int actCh = 0; actCh < actChLen; actCh++)
					{
						Node activityChildNode = activityChildNL.item(actCh);
						if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
						{
							String activityChName = activityChildNode.getNodeName();
							String activityChValue = activityChildNode.getFirstChild() != null ?  activityChildNode.getFirstChild().getNodeValue() : activityChildNode.getNodeValue();
							
							System.out.println("Inside getUserActivityData >> ["+ activityChName + "] activityChValue >>" + activityChValue + "]" );
							activityChValue = activityChValue == null ? "NA" : activityChValue;
							System.out.println("After activityChValue >>" + activityChValue + "]" );
							if( "ACTIVITY_OBJECT".equalsIgnoreCase( activityChName ) )
							{
								activityObj = activityChValue;
								//activityObj = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityObj[" + activityObj + "]");
								
								if(activityObj != null && objNameList.indexOf(activityObj) == -1 )
								{
									objNameList.add(activityObj);
								}
							}
							else if("ACTIVITY_ICON".equalsIgnoreCase( activityChName ))
							{
								System.out.println("inside activity icon");
								activityIcon = activityChValue.equalsIgnoreCase("NA") ?  "e12Menu.png" : activityChValue;
								System.out.println( "activityIcon [" + activityIcon +"]");
							}

							else if("ACTIVITY_TITLE".equalsIgnoreCase( activityChName ))
							{
								activityTitle = activityChValue;
								//activityTitle = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityTitle [" + activityTitle +"]");
							}
							else if( "ACTIVITY_SESSION_ID".equalsIgnoreCase( activityChName ) )
							{
								activitySeesionId = activityChValue;
								
								//activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
     							//System.out.println(activityChName + "[" + activitySeesionId + "]");
							}
							else if( "ACTIVITY_ACTION".equalsIgnoreCase( activityChName ) )
							{
								System.out.println( "ACTIVITY_OBJECT[" + activityObj + "]");
								System.out.println( "activityTitle[" + activityTitle + "]");
								System.out.println( "ACTIVITY_SESSION_ID[" + activitySeesionId + "]");
								//System.out.println("[" + activityChildNode.getChildNodes() + "]");
								//System.out.println( processActivityAction(activityChildNode) );
								
								JSONObject activityObjData = activityData.optJSONObject(activitySeesionId);
								if( activityObjData == null )
								{
									activityObjData = new JSONObject();
								}
								
								JSONObject prevActivityObj = activityObjData.optJSONObject(activityObj);
								if( prevActivityObj == null )
								{
									prevActivityObj = new JSONObject();
								}
								
								JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
								if( prevArray == null )
								{
									prevArray = new JSONArray();
								}
								//System.out.println(prevArray);
								
								prevActivityObj.put("DESCR", activityTitle);
								prevActivityObj.put("ICON", activityIcon);
								prevActivityObj.put("DATA", processActivityAction(activityChildNode, prevArray) );
								
								activityObjData.put(activityObj, prevActivityObj);
								
								activityData.put(activitySeesionId, activityObjData);
								
							}
						}
					}
				}
			}

			//System.out.println( activityData );
			JSONArray allSeesionArray = new JSONArray();
			int arrayLen = sessionArray.length();
			System.out.println("Object data "+arrayLen);
			for( int sessIdx = 0; sessIdx < arrayLen; sessIdx ++ )
			{
				String sessionId = sessionArray.optString(sessIdx);
				System.out.println("inside sessionid>>"+sessionId);
				JSONObject activityObjData = activityData.optJSONObject(sessionId);
				
				if( activityObjData == null )
				{
					activityObjData = new JSONObject();
				}
				
				JSONArray allObjectArray = new JSONArray();
				
				ArrayList<ActivityTime> objTimeArray = new ArrayList<ActivityTime>();
				for( String objName : objNameList )
				{
					JSONObject prevActivityObj = activityObjData.optJSONObject(objName);
					if( prevActivityObj != null )
					{
						JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
						if( prevArray.length() > 0 )
						{
							ActivityTime totalTime = calcTotalTime(prevArray);
							
							prevActivityObj.remove("DATA");
							prevActivityObj.put("ACCESS_TIME", totalTime.toJSON());
							
							objTimeArray.add(totalTime);
						}
						prevActivityObj.put("OBJ_NAME", objName);
						
						activityObjData.remove(objName);
						allObjectArray.put(prevActivityObj);
					}
				}
				
				int len = objTimeArray.size();
		        if( len > 0 )
		        {
		        	ActivityTime objTotalTime = objTimeArray.get(0);
		        	System.out.println(" objTotalTime >>" + objTotalTime);
		        	for(int idx = 1; idx < len; idx++)
		        	{
		        		ActivityTime actTime = objTimeArray.get(idx);
		        		objTotalTime.addTime(actTime);
		        		System.out.println(" totalTime >" + idx + ">" + objTotalTime);
		        	}
		        	activityObjData.put("ACCESS_TIME", objTotalTime.toJSON());
		        }
		        
		        activityObjData.put("OBJECTS", allObjectArray);
				
				activityData.remove(sessionId);
				
				allSeesionArray.put( activityObjData );
			}
			activityData.put("SESSIONS", allSeesionArray);
			activityData.put("TEAM", new JSONArray());
			
			activityData = getUserDetail(activityData, userCode);
			
			System.out.println("activity data " + activityData.toString());
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return activityData;
	}
	
	
	private ActivityTime calcTotalTime(JSONArray prevArray) throws JSONException 
	{
		String startTime, endTime="";
		ActivityTime actTime = new ActivityTime();
		System.out.println("Inside calcTotalTime");
		int len = prevArray.length();
	       if( len > 0 )
	       {
		       	JSONObject jsonObjectStart = prevArray.getJSONObject(0);
		       	startTime = jsonObjectStart.getString("ACCESS_START_TIME");
	
		       	JSONObject jsonObjectEnd = prevArray.getJSONObject( len - 1 );
		       	endTime = jsonObjectEnd.optString("ACCESS_END_TIME");
	
		       	System.out.println("ACCESS_START_TIME>>"+startTime);
		       	System.out.println("ACCESS_END_TIME>>"+endTime);
		       	actTime = new ActivityTime(startTime, endTime);
	       }
	       System.out.println( "ActivityTime calcTotalTime >> " + actTime );
	return actTime;
	}

	public JSONObject processSessionIds(String userCode, NodeList activitySessIdNL) throws JSONException
	{
		JSONObject activityData = new JSONObject();
		StringBuffer  sessionIds = new StringBuffer();
		JSONArray sessionArray = new JSONArray ();
		if( activitySessIdNL != null && activitySessIdNL.getLength() > 0 )
		{
			int len = activitySessIdNL.getLength();
			for( int i = 0; i < len; i++)
			{
				String activitySeesionId = null;
				
				Node activityChildNode = activitySessIdNL.item(i);
				if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityChName = activityChildNode.getNodeName();
					activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
					System.out.println("Inside processSessionIds >> "+ activityChName );
				}

				if(activitySeesionId != null && sessionIds.indexOf(activitySeesionId) == -1 )
				{
					sessionIds.append("'").append(activitySeesionId).append("',");
					sessionArray.put(activitySeesionId);
				}
			}
			sessionIds.append(" '' ");
			System.out.println("SessionIds::::"+sessionIds);
		}
		
		//Get Data from Logintrace
		List<LoginTrace> loginTraceList = getLogDetails(userCode, sessionIds.toString() );
		System.out.println("loginTraceList::::"+loginTraceList);
		
		for( LoginTrace loginTrace : loginTraceList )
		{
			 JSONObject activityObjData = new JSONObject();
			 System.out.println("loginTrace.getClass()>>>>"+loginTrace.getClass());
			 String activitySeesionId = loginTrace.getSessionId();

			 activityObjData.put("SESSION_ID", activitySeesionId);
			 activityObjData.put("DEVICE_TYPE", checkNull(loginTrace.getDeviceType()));
			 activityObjData.put("OS_NAME", checkNull(loginTrace.getOsName()));
			 activityObjData.put("HOST_IP", checkNull(loginTrace.getHostIp()));
			 activityObjData.put("CURRENT_GEO_POS", checkNull(loginTrace.getCurrentGeoPos()));
			 activityObjData.put("OS_VERSION", checkNull(loginTrace.getOsVersion()));
			 activityObjData.put("CLIENT_APP", checkNull(loginTrace.getClientApp()));
			 activityObjData.put("CLIENT_APP_VER",checkNull(loginTrace.getClientAppVer()));
			 activityObjData.put("LOGIN_TIME", checkNullDate(loginTrace.getLoginTime()));
			 activityObjData.put("LOGOUT_TIME", checkNullDate(loginTrace.getLogoutTime()));
			 activityObjData.put("LOGIN_BATTERY_STAT", checkNull(loginTrace.getLoginBatteryStat()));
			 activityObjData.put("LOGOUT_BATTERY_STAT",checkNull(loginTrace.getLogoutBatteryStat()));
			 
			 ActivityTime loginTime = new ActivityTime(loginTrace.getLoginTime(), loginTrace.getLogoutTime());
			 
			// int batteryStatus =loginTrace.getLoginBatteryStat()- loginTrace.getLogoutBatteryStat();
			 activityObjData.put("TOTAL_TIME", loginTime.toJSON());
			 System.out.println("TOTAL_TIME loginTime ["+ loginTime + "]");
			 System.out.println("activityData processSessionIds"+activityData);
			 activityData.put(activitySeesionId, activityObjData);
		}
		
		activityData.put("ALL_SESSIONS", sessionArray);
		System.out.println("activityData processSessionIds"+activityData);
		
		return activityData;
	}

    private  Object checkNull(Object data) {
    	if(data==null){
    		return "NA";
    	}
    	else 
    	{
    		return data;
    	}
    }
    private  Object checkNullDate(Object data) {
    	System.out.println("Inside checkNull"+data);
    	if(data==null){
    		return  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    	}
    	else 
    	{
    		return data;
    	}
    }
    
	public List<LoginTrace> getLogDetails(String userCode, String sessionIds) 
	{
		List<LoginTrace> loginTraceList = null;
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			System.out.println("Inside getLogDetails sessionId: [" + sessionIds + "] USER CODE ["+userCode+"]");
			
			Query query = session.createQuery("FROM LoginTrace where userId='" + userCode + "' AND sessionId IN ( " + sessionIds + " ) ");
			
			System.out.println("Inside getLogDetails query: [" + query + "]");
			loginTraceList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + loginTraceList + "]");

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return loginTraceList;
	}
	
	private Employee getEmployeeDetail(String userCode) 
	{
		System.out.println("Inside getUserDesignation");
		Employee employee = null;
		Employee result = new Employee();
		try {
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createQuery("FROM Employee e WHERE e.empCode IN ( "
					+ " SELECT u.empCode "
					+ " FROM UserProfile u "
					+ " WHERE u.userCode ='"+userCode+"'"
					+ " )");
			
			System.out.println("Inside getLogDetails query: [" + query + "]");
			List<Employee> employeeDataList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + employeeDataList + "]");
			if( employeeDataList != null && employeeDataList.size() > 0 )
			{
				employee = employeeDataList.get(0);
			}
			
			session.close();
		} catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}

		return employee;
	}
	
	public List<String> getUserDetails(String userId, String profileId) 
	{
		List<String> userDetailList = null;
		try 
		{
			// 1. Get Session object

			System.out.println("Inside getUserDetails userId: [" + userId + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select trim(CODE) from users where EMP_CODE in (SELECT emp_code FROM employee START WITH emp_code = (SELECT emp_code FROM users WHERE code = '"+userId+"') CONNECT BY prior emp_code = report_to)");
			
			System.out.println("query result>>>>>"+query);
			userDetailList = query.getResultList();
			System.out.println("query result:::::::"+userDetailList);
			System.out.println("query result:::::::"+userDetailList.size());

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("userDetailList >>>>>>>>>"+userDetailList);
		return userDetailList;
	}

	public JSONArray  getDeviceType(List<String> loginUserList,String today) throws JSONException 
	{
		HashMap<String, JSONObject>  deviceTypeList = new HashMap<String, JSONObject> ();
		JSONArray device=new JSONArray();
		try 
		{
			// 1. Get Session object
			String userList = getEnclosedString(loginUserList);
			System.out.println("Inside getUserDetails userId: [" + loginUserList + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), DEVICE_TYPE "
					+ "from logintrace where to_char(LOGINTIME, 'dd-MM-yy')= '"+today+"'"
					+ " and  userid in ("+userList+")"
					+ " and LOGIN_STATUS = 'T'"
					+ " group by DEVICE_TYPE "
					+ "");
			
			System.out.println("query result>>>>>"+query);
			List<Object[]>  deviceList= (List<Object[]>)query.list();
		     for(Object[] minMaxTime: deviceList){
		    	BigDecimal count = (BigDecimal)minMaxTime[0];
		    	String deviceType = (String) minMaxTime[1];
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("DEVICE_TYPE", deviceType);
		    	jsonObject.put("DEVICE_COUNT", count);
		    	device.put(jsonObject);
		    //	deviceTypeList.put(userId, jsonObject);
				System.out.println("minMaxTimeList query id::::::: jsonObject ["+jsonObject+"]");
		     }
			System.out.println("deviceTypeList result:::::::"+device);

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("deviceTypeList >>>>>>>>>"+deviceTypeList);
		return device;
	}

	public JSONObject  getClientApp(JSONObject activityData,List<String> loginUserList,String today) throws JSONException 
	{
		try 
		{
			// 1. Get Session object
			String userList = getEnclosedString(loginUserList);

			System.out.println("Inside getClientApp userId: [" + loginUserList + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), CLIENT_APP "
					+ " from logintrace "
					+ " where to_char(LOGINTIME, 'dd-MM-yy')= '"+today+"' "
					+ " and LOGIN_STATUS = 'T' "
					+ " and  userid in ("+userList+")"
					+ " and DEVICE_TYPE = 'Browser'"
					+ " group by (CLIENT_APP)");
			
			System.out.println("getClientApp query >>>>>"+query);
	    	JSONObject jsonObject = new JSONObject();
	    	jsonObject.put( "CHROME", 0 );
	    	jsonObject.put( "INTEXP", 0 );
	    	jsonObject.put( "FIREFOX", 0 );
	    	jsonObject.put( "OTHER", 0 );
	    	
	    	BigDecimal total =  new BigDecimal(0);
			List<Object[]>  clientAppList= (List<Object[]>)query.list();
		     for(Object[] clientapplist: clientAppList){
		    	BigDecimal clientAppCount = (BigDecimal)clientapplist[0];
		    	String clientAppName = (String) clientapplist[1];
		    	if("CHROME".equalsIgnoreCase(clientAppName))
		    	{
		    		jsonObject.put( "CHROME",clientAppCount);
		    	}
		    	else if("INTEXP".equalsIgnoreCase(clientAppName))
		    	{
		    		jsonObject.put( "INTEXP",clientAppCount);
		    	}
			    else if("FIREFOX".equalsIgnoreCase(clientAppName))
		    	{
		    		jsonObject.put( "FIREFOX",clientAppCount);
		    	}
		    	else
		    	{
		    		jsonObject.put( "OTHER",clientAppCount);
		    	}
		    	

		       	total=total.add(clientAppCount);
				System.out.println("getClientApp query id::::::: jsonObject ["+jsonObject+"]");
		     }
			    jsonObject.put("TOTAL", total);
			    activityData.put("BROWSER", jsonObject);

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return activityData;
	}
	
	public JSONObject  getOsName(JSONObject activityData,List<String> loginUserList,String today) throws JSONException 
	{
		try 
		{
			String userList = getEnclosedString(loginUserList);
			// 1. Get Session object

			System.out.println("Inside getOsName userId: [" + loginUserList + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), OS_NAME "
					+ "from logintrace "
					+ "where to_char(LOGINTIME, 'dd-MM-yy')= '"+today+"' "
					+ " and LOGIN_STATUS = 'T'"
					+ " and  userid in ("+userList+")"
					+ " and DEVICE_TYPE in ( 'Android Mobile' , 'Android Tablet', 'iOS Mobile' , 'iOS Tablet' ) "
					+ " group by (OS_NAME)");
			
			System.out.println("getOsName query >>>>>"+query);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put( "ANDROID",0);
			jsonObject.put( "IOS",0);
			jsonObject.put( "OTHER",0);
			
			BigDecimal total =  new BigDecimal(0);
			List<Object[]>  osNameList= (List<Object[]>)query.list();
		    for(Object[] osnamelist: osNameList){
		    	BigDecimal osNameCount = (BigDecimal)osnamelist[0];
		    	String osname = (String) osnamelist[1];
		    	//String deviceType = (String) osnamelist[2];
		    	if("ANDROID".equalsIgnoreCase(osname)){
		    		jsonObject.put( "ANDROID",osNameCount);
		    	}
		    	else if("IOS".equalsIgnoreCase(osname) || osname.startsWith("Mac"))
		    	{
		    		jsonObject.put( "IOS",osNameCount);
		    	}
		    	else {
		    		jsonObject.put( "OTHER",osNameCount);
		    	}
		    	total=total.add(osNameCount);
				System.out.println("getOsName query id::::::: TOTAL"+total+"jsonObject ["+jsonObject+"]");
		     }
		    jsonObject.put("TOTAL", total);
		    activityData.put("MOBILE", jsonObject);
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return activityData;
	}

	
	public List<String> getLoginUsers(String today) 
	{
		List<String> allLoginUsers = null;
		try 
		{
			// 1. Get Session object
			System.out.println("Inside getUserDetails userId: [" + today + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select distinct userid from logintrace"
					+ " where to_char(LOGINTIME, 'dd-MM-yy')= '"+today+"'"
					+ "and LOGIN_STATUS = 'T'");
			
			System.out.println("query result>>>>>"+query);
			allLoginUsers = query.getResultList();
			System.out.println("getLoginUsers result:::::::"+allLoginUsers+"size::::"+allLoginUsers.size());
			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("getLoginUsers >>>>>>>>>"+allLoginUsers);
		return allLoginUsers;
	}

	public HashMap<String, JSONObject>  getMinMaxTime(String today, List<String> userDataList ) 
	{
		HashMap<String, JSONObject> minMaxTimeMap = new HashMap<String, JSONObject>();
		try 
		{
			// 1. Get Session object
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}
			System.out.println("Inside getMinMaxTime today: [" + today + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace"
					+ " where to_char(LOGINTIME,'dd-MM-yy') = '"+today+"'"
					+ " and LOGIN_STATUS = 'T'"
					+ whereClausePart
					+ " group by userid");
			System.out.println("query result>>>>>"+query);
			List<Object[]>  minMaxTimeList= (List<Object[]>)query.list();
		     for(Object[] minMaxTime: minMaxTimeList){
		    	String userId = (String)minMaxTime[0];
		    	Date loginTime = (Date) minMaxTime[1];
		    	Date logoutTime = (Date) minMaxTime[2];
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("loginTime", loginTime);
		    	jsonObject.put("logoutTime", logoutTime);
		    	minMaxTimeMap.put(userId, jsonObject);
		    	
				System.out.println("minMaxTimeList query id::::::: ["+userId+"] jsonObject ["+jsonObject+"]");
		     }
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("minMaxTimeMap >>>>>>>>>"+minMaxTimeMap);
		return minMaxTimeMap;
	}

	public HashMap<String, JSONObject> getBatteryStatus(String todayFormat) throws JSONException 
	{
		HashMap<String, JSONObject> minMaxBatteryStatus = new HashMap<String, JSONObject>();
		try 
		{
			// 1. Get Session object

			System.out.println("Inside getBatteryStatus todayFormat: [" + todayFormat + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select A.userid, to_char(A.LOGINTIME,'dd-MM-yy hh24:mi:ss') IN_TIME, "
					+ " to_char(A.LOGOUTTIME,'dd-MM-yy hh24:mi:ss') OUT_TIME, "
					+ " A.LOGIN_BATTERY_STAT, "
					+ " A.LOGOUT_BATTERY_STAT"
					+ " from logintrace A,"
					+ " ("
					+ " select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace"
					+ " where to_char(LOGINTIME,'dd-MM-yy') = '"+todayFormat+"'"
					+ " and LOGIN_BATTERY_STAT is not null "
					+ " and LOGOUT_BATTERY_STAT is not null"
					+ " group by userid"
					+ " )B"
					+ " where A.userid= B.userid"
					+ " and ( A.LOGINTIME = B.LOGINTIME"
					+ " or A.LOGOUTTIME = B.LOGOUTTIME )"
					+ " order by A.userid, A.LOGINTIME"
					+ "");

			List<Object[]> batteryStatusList= (List<Object[]>)query.list();
			 
			JSONObject jsonObject = new JSONObject();
			List userList = new ArrayList<>();
		    for(Object[] batteryStatus: batteryStatusList){
		    	String userId = (String)batteryStatus[0];
		    	if(!userList.contains(userId)){
		    		jsonObject=new JSONObject();
		    		userList.add(userId);
	  		    	 String loginTime = (String) batteryStatus[1];
	    			 BigDecimal loginBatteryStatus = (BigDecimal) batteryStatus[3];
	    			 jsonObject.put("loginTime", loginTime);
	    			 jsonObject.put("loginBatteryStatus", loginBatteryStatus);
		    	}
 		    	 String logoutTime = (String) batteryStatus[2];
	   			 BigDecimal logoutBatteryStatus = (BigDecimal) batteryStatus[4];
	   			 jsonObject.put("logoutTime", logoutTime);
	   			 jsonObject.put("logoutBatteryStatus", logoutBatteryStatus);
		    	 minMaxBatteryStatus.put(userId, jsonObject);
		    	 System.out.println("minMaxBatteryStatus query result userId ["+userId+"] jsonObject ["+jsonObject+"]");
		     }
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("minMaxBatteryStatus >>>>>>>>>"+minMaxBatteryStatus.toString());
		return minMaxBatteryStatus;
	}
	
	public JSONArray processActivityAction(Node activityChildNode, JSONArray eventArray) throws JSONException
	{
		if( activityChildNode != null )
		{
			NodeList activityActionNL = activityChildNode.getChildNodes();
			
			int actActionLen = activityActionNL.getLength();
			for( int actActionCh = 0; actActionCh < actActionLen; actActionCh++)
			{
				Node activityActionNode = activityActionNL.item(actActionCh);
				if( activityActionNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityActionName = activityActionNode.getNodeName();
					//System.out.println("Inside processActivityAction >> "+ activityActionName );
					if( "EVENT_ID".equalsIgnoreCase( activityActionName ) )
					{
						eventArray.put( processEvent(activityActionNode) );
					}
				}
			}
		}
		return eventArray;
	}

	public  JSONObject processEvent(Node activityActionNode) throws JSONException
	{
		JSONObject eventObj = new JSONObject();
		if( activityActionNode != null )
		{
			NodeList eventNL = activityActionNode.getChildNodes();
			
			int eventLen = eventNL.getLength();
			for( int eventId = 0; eventId < eventLen; eventId++)
			{
				Node eventChNode = eventNL.item(eventId);
				if( eventChNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String eventChName = eventChNode.getNodeName();
					String eventChValue = eventChNode.getFirstChild() != null ?  eventChNode.getFirstChild().getNodeValue() : eventChNode.getNodeValue();
					//System.out.println("Inside getUserActivityData >1212> "+ eventChNode.getNodeName() );
					if( "ACCESS_START_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println( new Date (eventChValue));
						//System.out.println( eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
					else if( "ACCESS_END_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println(eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
				}
			}
		}
		return eventObj;
	}
	
//	public List<JSONObject> getUserActivityFileData(List<String> users, String fromDate, String toDate) throws IOException, JSONException
//	{
	public List<JSONObject> getUserActivityFileData(List<String> users, String today) throws IOException, JSONException
	{		
		List<JSONObject> filesArrayList = new ArrayList<JSONObject>();
		String jbossPath=CommonConstants.JBOSSHOME;
		System.out.println("CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");
		File userActivityFolder = new File(jbossPath+"/server/default/UserActivity");
		System.out.println("userActivityFolder ["+userActivityFolder+"] Users "+users+"]");
		if( userActivityFolder.isDirectory() )
		{
			File[] userActivityFiles = userActivityFolder.listFiles(new FileFilter() {
				@Override
				public boolean accept(File pathname) {
					return pathname.getName().endsWith(today+".txt");
				}
			});
			
			for(File userActivityFile: userActivityFiles )
			{
				String fileName = userActivityFile.getName();
				//System.out.println("userActivityFile[" + fileName + "]");
				
				fileName = fileName.replace(".txt", "");
				
				//System.out.println("userActivityFile[" + fileName + "]");
				
				String[] fileArr = fileName.split("_");
				String userId = ( fileArr.length > 0 ) ? fileArr[0] : "SYSTEM";
				String activityDate = ( fileArr.length > 1 ) ? fileArr[1] : today;
				System.out.println("userActivityFile[" + userId + "]["+activityDate+"]");
				
				JSONObject fileData = new JSONObject();
				fileData.put("userId", userId);
				fileData.put("activityDate", activityDate);
				
				if( users == null || ( users != null && users.contains(userId) ) )
				{
					String fileContents =  FileUtils.readFileToString(userActivityFile);
					StringBuffer fileContentsBuff = new StringBuffer();
					fileContentsBuff.append("<ROOT>");
					fileContentsBuff.append(fileContents);
					fileContentsBuff.append("</ROOT>");
					fileData.put("fileContents", fileContentsBuff.toString());
					
					filesArrayList.add(fileData);
				}
				
				System.out.println(fileData.toString().length() + "\n");
			}
		}
		return filesArrayList;
	}

	private String getEnclosedString(List<String> docIdList) 
	{
		StringBuffer buffer = new StringBuffer();
		int len = 0;
		for(String docId : docIdList)
		{
			buffer.append("'").append(docId.trim()).append("'");
			len++;
			if( len < docIdList.size() )
			{
				buffer.append(",");
			}
		}
		if( buffer.length() == 0 )
		{
			buffer.append("''");
		}
		System.out.println("Inside getEnclosedString buffer: [" + buffer +"]");
		
		return buffer.toString();
	}
}

class ActivityTime implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	long seconds = 0;
    long minutes = 0;
    long hours = 0;
	
    public ActivityTime()
    {
    	
    }
    
	public ActivityTime(String startTime, String endTime) 
	{
		 SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.");
		 Date d1 = null;
         Date d2 = null;
         
         try 
         {
             d1 = format.parse(startTime);
             d2 = format.parse(endTime);
             long diff = d2.getTime() - d1.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (ParseException e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public ActivityTime(Date startTime, Date endTime) 
	{
         try 
         {
             long diff = endTime.getTime() - startTime.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (Exception e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public void addTime(ActivityTime time)
	{
		System.out.println("addTime :1:time[" + time + "]this[" + this + "]" ); 
		this.seconds = this.seconds + time.seconds;
		if(this.seconds > 59)
		{
			this.seconds = this.seconds % 60;
			long mins = this.seconds / 60;
			this.minutes = this.minutes + mins;
			System.out.println("this.seconds > 59 ::" + this.seconds ); 
		}
		
		this.minutes = this.minutes + time.minutes;
		if(this.minutes > 59)
		{
			this.minutes = this.minutes % 60;
			long hrs = this.minutes / 60;
			this.hours = this.hours + hrs;
			System.out.println("this.minutes > 59 ::" + this.minutes ); 
		}
		
		this.hours = this.hours + time.hours;
		if(this.hours >= 23) //Should not come here
		{
			System.out.println("this.hours >= 23 ::" + this.hours ); 
		}
		
		System.out.println("addTime :2:time[" + time + "]this[" + this + "]" ); 
	}
	
	public JSONObject toJSON()
	{
		JSONObject jObj = new JSONObject();
		try 
		{
			jObj.put("hours", this.hours);
			jObj.put("minutes", this.minutes);
			jObj.put("seconds", this.seconds);
		}
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		return jObj;
	}
	
	public String toString()
	{
		return this.toJSON().toString();
	}
}
