package proteus.ecm.hibernate.bean;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONException;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ENTITY_ADDRESS")
@XmlRootElement(name = "entityAddress")
public class EntityAddress implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "ENTITY_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String entityCode;

	@Id
	@Column(name = "LINE_NO")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String lineNo;

	@Column(name = "ENTITY_TYPE")
	private String entityType;

	@Column(name = "IS_DEFAULT") // Y - Default Address or N - not A Default// Address
	private String isDefault;

	@Column(name = "ADDR_TYPE")
	private String addrType;

	@Column(name = "ADDR_USE")
	private String addrUse;

	@Column(name = "ADDR1")
	private String addr1;

	@Column(name = "ADDR2")
	private String addr2;

	@Column(name = "ADDR3")
	private String addr3;

	@Column(name = "CITY")
	private String city;

	@Column(name = "PIN_CODE")
	private String pinCode;

	@Column(name = "STAN_CODE")
	private String stanCode;

	@Column(name = "STATE_CODE")
	private String stateCode;

	@Transient
	private String stateDescr;

	@Column(name = "COUNT_CODE")
	private String countCode;

	@Transient
	private String countDescr;

	@Column(name = "EMAIL_ID")
	private String emailId;

	@Column(name = "GEO_POS")
	private String geoPos;

	@Column(name = "ADDR_NAME")
	private String userName;

	@Transient
	private String firstName;

	@Transient
	private String lastName;

	@Column(name = "MOBILE_NO")
	private String contactNo;

	public EntityAddress() {
	}

	public EntityAddress(String entityCode, String lineNo, String entityType, String isDefault, String addrType,
			String addrUse, String addr1, String addr2, String addr3, String city, String pinCode, String stanCode,
			String stateCode, String countCode, String emailId, String geoPos, String userName, String contactNo) {
		this.entityCode = entityCode;
		this.lineNo = lineNo;
		this.entityType = entityType;
		this.isDefault = isDefault;
		this.addrType = addrType;
		this.addrUse = addrUse;
		this.addr1 = addr1;
		this.addr2 = addr2;
		this.addr3 = addr3;
		this.city = city;
		this.pinCode = pinCode;
		this.stanCode = stanCode;
		this.stateCode = stateCode;
		this.countCode = countCode;
		this.emailId = emailId;
		this.geoPos = geoPos;
		this.userName = userName;
		this.contactNo = contactNo;
	}

	public String getEntityCode() {
		return this.entityCode;
	}

	public void setEntityCode(String entityCode) {
		this.entityCode = entityCode;
	}

	public String getLineNo() {
		return this.lineNo;
	}

	public void setLineNo(String lineNo) {
		this.lineNo = lineNo;
	}

	public String getIsDefault() {
		return this.isDefault;
	}

	public void setIsDefault(String isDefault) {
		this.isDefault = isDefault;
	}

	public String getEntityType() {
		return this.entityType;
	}

	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

	public String getAddrType() {
		return this.addrType;
	}

	public void setAddrType(String addrType) {
		this.addrType = addrType;
	}

	public String getAddrUse() {
		return this.addrUse;
	}

	public void setAddrUse(String addrUse) {
		this.addrUse = addrUse;
	}

	public String getAddr1() {
		return this.addr1;
	}

	public void setAddr1(String addr1) {
		this.addr1 = addr1;
	}

	public String getAddr2() {
		return this.addr2;
	}

	public void setAddr2(String addr2) {
		this.addr2 = addr2;
	}

	public String getAddr3() {
		return this.addr3;
	}

	public void setAddr3(String addr3) {
		this.addr3 = addr3;
	}

	public String getCity() {
		return this.city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getPinCode() {
		return this.pinCode;
	}

	public void setPinCode(String pinCode) {
		this.pinCode = pinCode;
	}

	public String getStanCode() {
		return this.stanCode;
	}

	public void setStanCode(String stanCode) {
		this.stanCode = stanCode;
	}

	public String getStateCode() {
		return this.stateCode;
	}

	public void setStateCode(String stateCode) {
		this.stateCode = stateCode;
	}

	public String getCountCode() {
		return this.countCode;
	}

	public void setCountCode(String countCode) {
		this.countCode = countCode;
	}

	public String getStateDescr() {
		return this.stateDescr;
	}

	public void setStateDescr(String stateDescr) {
		this.stateDescr = stateDescr;
	}

	public String getCountDescr() {
		return this.countDescr;
	}

	public void setCountDescr(String countDescr) {
		this.countDescr = countDescr;
	}

	public String getEmailId() {
		return this.emailId;
	}

	public void setEmailId(String emailId) {
		this.emailId = emailId;
	}

	public String getGeoPos() {
		return this.geoPos;
	}

	public void setGeoPos(String geoPos) {
		this.geoPos = geoPos;
	}

	public String getUserName() {
		return this.userName;
	}

	@XmlElement
	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getFirstName() {
		return this.firstName;
	}

	@XmlElement
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return this.lastName;
	}

	@XmlElement
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getContactNo() {
		return this.contactNo;
	}

	@XmlElement
	public void setContactNo(String contactNo) {
		this.contactNo = contactNo;
	}

	public void toEntityAddress(JSONObject addressData) throws JSONException {
		setAddrType(getFieldValue(addressData, "addrType"));
		setAddrUse(getFieldValue(addressData, "addrUse"));
		setAddr1(getFieldValue(addressData, "addr1"));
		setAddr2(getFieldValue(addressData, "addr2"));
		setAddr3(getFieldValue(addressData, "addr3"));
		setCity(getFieldValue(addressData, "city"));
		setPinCode(getFieldValue(addressData, "pinCode"));
		setStateCode(getFieldValue(addressData, "stateCode"));
		setCountCode(getFieldValue(addressData, "countCode"));
		setGeoPos(getFieldValue(addressData, "geoPos"));
		setEmailId(getFieldValue(addressData, "emailId"));
		setStanCode(getFieldValue(addressData, "stanCode"));
		setUserName(getFieldValue(addressData, "userName"));
		setContactNo(getFieldValue(addressData, "contactNo"));
		setIsDefault(getFieldValue(addressData, "isDefault"));
	}

	private String getFieldValue(JSONObject addressData, String key) throws JSONException {
		if (addressData.has(key)) {
			return addressData.getString(key);
		}
		return "";
	}

	@Override
	public String toString() {
		return "\n entityAddress.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
