import { Component, Input, Output, forwardRef, EventEmitter } from '@angular/core';
import { ValueAccessorBase } from '../form/value-accessor';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
let nextUniqueId = 0;
export const BB_CHECKBOX_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => BBCheckboxComponent),
    multi: true
};
export class BBCheckboxComponent extends ValueAccessorBase {
    constructor() {
        super(...arguments);
        this._uniqueId = `bb-checkbox-${++nextUniqueId}`;
        this.uxDesign = 'UX3';
        this.bbId = this._uniqueId;
        this.bbLabelPosition = 'after';
        this.bbChecked = false;
        this.bbIndeterminate = false;
        this.bbDisabled = false;
        this.bbType = 'checkbox';
        this.bbChange = new EventEmitter();
        this.bbIndeterminateChange = new EventEmitter();
    }
    ngOnInit() {
    }
}
BBCheckboxComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-checkbox',
                template: `
      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'" >
      		<span *ngIf="bbLabelPosition =='before'">
      			<ng-container *ngTemplateOutlet="content"></ng-container>
      			<input (bbChange)="bbChange.emit();" [name]="bbName"  [type]="bbType" [required]="bbRequired" [checked]="bbChecked" [value]="bbValue"  [(indeterminate)]="bbIndeterminate" [id]="bbId" [align]="bbAlign" [disabled]="bbDisabled">
      		</span>
      		<span *ngIf="bbLabelPosition =='after'" >
      				<input (bbChange)="bbChange.emit();" [name]="bbName"  [type]="bbType" [required]="bbRequired" [checked]="bbChecked" [value]="bbValue"  [(indeterminate)]="bbIndeterminate" [id]="bbId" [align]="bbAlign" [disabled]="bbDisabled">
      				<ng-container *ngTemplateOutlet="content"></ng-container>		
      		</span>
      	</span>
	
      	<span *ngSwitchCase="'UX3'" >
      		<md-checkbox  (bbChange)="bbChange.emit();" [name]="bbName" [required]="bbRequired" [checked]="bbChecked" [value]="bbValue" [labelPosition]="bbLabelPosition" [(indeterminate)]="bbIndeterminate" [id]="bbId" [align]="bbAlign" [disabled]="bbDisabled">
      		        <ng-container *ngTemplateOutlet="content"></ng-container>
      		</md-checkbox>
      	</span>
	
      	<ng-template #content><ng-content></ng-content></ng-template>

      </span>
    `,
                styles: [`

    `],
                providers: [BB_CHECKBOX_CONTROL_VALUE_ACCESSOR]
            },] },
];
/** @nocollapse */
BBCheckboxComponent.ctorParameters = () => [];
BBCheckboxComponent.propDecorators = {
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbId': [{ type: Input, args: ['id',] },],
    'bbRequired': [{ type: Input, args: ['required',] },],
    'bbAlign': [{ type: Input, args: ['align',] },],
    'bbLabelPosition': [{ type: Input, args: ['labelPosition',] },],
    'bbName': [{ type: Input, args: ['name',] },],
    'bbValue': [{ type: Input, args: ['value',] },],
    'bbChecked': [{ type: Input, args: ['checked',] },],
    'bbIndeterminate': [{ type: Input, args: ['indeterminate',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
    'bbType': [{ type: Input, args: ['type',] },],
    'bbChange': [{ type: Output },],
    'bbIndeterminateChange': [{ type: Output },],
};
//# sourceMappingURL=bb-checkbox.component.js.map