import {Action} from '@ngrx/store';

import {EcmLocation} from '../../ecm-search/ecm-location';
import {LocationActions} from '../actions';

export type LocationState = EcmLocation;
const initialState: LocationState = {
    latitude: '',
    longitude: '',
    address: '',
    pincode: '',
    city: '',
    state: '',
    country: ''
    
}; 

export default function (state = initialState, action: Action): LocationState {
    switch (action.type) {
        case LocationActions.RESET_BLANK_LOCATION: {
            return initialState;
        }
        case LocationActions.GET_LOCATION_SUCCESS: {
            return action.payload;
        }
        default: {
            return state;
        }
    }
}