import { Component, OnInit, HostListener } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Store } from '@ngrx/store';
import { AppState } from '../../ecm-store/reducers';
import { SubCategoryActions, ItemActions } from '../../ecm-store/actions';

import { ScrollService } from '../../scroll.service';
import { Category } from '../../ecm-model/category-model';
import { SubCategory } from '../../ecm-model/subcategory-model';
import { Item } from '../../ecm-model/product-model';

import { Observable } from 'rxjs/Observable';

import { Breadcrumbs } from '../../ecm-breadcrumbs/ecm-breadcrumbs.component';

@Component( {
    selector: 'ecm-sub-category',
    templateUrl: './ecm-sub-category.component.html',
    styleUrls: ['./ecm-sub-category.component.css']
})
export class EcmSubCategoryComponent implements OnInit {

    position = 0;
    isCatItems = 'false';

    @HostListener( "window:scroll", [] )
    onWindowScroll() {
        this.position = window.pageYOffset;
    }

    private subcategories;
    private extra_param = { "catCode": '', "catShDesc": '', scatDesc: '' };

    private category: Category;
    private subcategory: SubCategory;

    constructor( private route: ActivatedRoute, private router: Router, private scroll_service: ScrollService, private store: Store<AppState>, private subCategoryAction: SubCategoryActions, private itemAction:ItemActions, public breadcrumbSerivce: Breadcrumbs ) { }
    ngOnInit() {
        window.scrollTo( 0, 0 );
        this.route.params.subscribe( params => {
            //let id: number = +params['id']; // (+) converts string 'id' to a number
            // In a real app: dispatch action to load the details here.
            let catCode = params['catCode'];
            console.log( 'ngOnInit catCode[' + catCode + ']' );
            console.log( "Subcat Listing..." );
            console.log( window.location.pathname );
            //this.fetchStore(catCode,'Category'); 
            this.getSubCategories( catCode );
        });
    }

    getSubCategories( catCode: string ) {
         this.store.select( 'subcategories' ).subscribe(
                subcategories => {
                    this.subcategories =  subcategories;
                }
        );
        
        let categories: Observable<Category[]> = this.store.select('categories');
        categories.subscribe( items => {
            this.category = items.find(x => x.catCode === catCode);
            if(this.category){
                let breadcrumb = [{label: 'Home', url: '/home'}, {label: this.category.shDescr, url: 'javascript:void(0)'}];
                this.breadcrumbSerivce.breadcrumbs = breadcrumb;
            }
         });
        
    }

    storeSubCategory( selectedSubCategory ) {
        this.store.dispatch( this.itemAction.resetItemList() );
        this.store.dispatch( this.itemAction.loadItems( selectedSubCategory.scatCode ) );
        this.store.dispatch( this.subCategoryAction.getSubCategorySuccess( selectedSubCategory ) );
    }
    
    fetchStore( viewKey: string, viewType: string ) {
        if ( viewType == 'Category' ) {
            let storeCategory;
            this.store.select( 'CATEGORY' ).forEach(
                value => storeCategory = value
            );
            this.category = storeCategory;
        }

        if ( viewType == 'SubCategory' ) {
            let storeSubCategory;
            this.store.select( 'SUBCATEGORY' ).forEach(
                value => { storeSubCategory = value; console.log( value ); }
            );
            this.subcategory = storeSubCategory;
        }
   }
}
