import { BrowserModule } from '@angular/platform-browser';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA } from '@angular/core';

import { LocationStrategy, HashLocationStrategy } from '@angular/common';
import { FormsModule,ReactiveFormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { RouterModule, Routes } from '@angular/router';
//import {BBKeyInputModule} from 'base-blocks';
import { BBComponentModule } from 'base-blocks';
//import { JwtHelper } from 'angular2-jwt'; //For Future
import {StoreModule} from '@ngrx/store';
import {EffectsModule} from '@ngrx/effects';

import { BrowserAnimationsModule } from '@angular/platform-browser/animations';

import { AppComponent } from './app.component';
import { ECMHeaderComponent } from './ecm-header/ecm-header.component';
import { ECMFooterComponent } from './ecm-footer/ecm-footer.component';
import { ECMContentComponent } from './ecm-content/ecm-content.component';
import { ECMSearchComponent } from './ecm-search/ecm-search.component';
import { ECMCardComponent } from './ecm-card/ecm-card.component';
import { ECMNavMenuComponent } from './ecm-nav-menu/ecm-nav-menu.component';
import { ECMHomeComponent } from './ecm-home/ecm-home.component';
import { ShareComponent} from './ecm-view/share.component';
import { ScrollService } from './scroll.service';
import { EcmImageComponent } from './ecm-image/ecm-image.component';
import { EcmSigninComponent } from './ecm-signin/ecm-signin.component';
import { EcmUserOptionComponent } from './ecm-user-option/ecm-user-option.component';
import { EcmSearchResultComponent } from './ecm-search/ecm-search-result/ecm-search-result.component';
import { SearchService } from './ecm-search/ecm-search-result/search.service';
import { EcmBreadcrumbsComponent } from './ecm-breadcrumbs/ecm-breadcrumbs.component';
import { EcmCarouselComponent } from './ecm-carousel/ecm-carousel.component';

import { EcmProductDetailsComponent } from './ecm-product-details/ecm-product-details.component';
import { EcmProductReviewComponent } from './ecm-product-details/ecm-product-review.component';
import { EcmOutingComponent } from './ecm-product-details/ecm-template/ecm-outing.component';
import { EcmFoodComponent } from './ecm-product-details/ecm-template/ecm-food.component';
import { EcmHandicraftComponent } from './ecm-product-details/ecm-template/ecm-handicraft.component';
import { EcmCelebrationComponent } from './ecm-product-details/ecm-template/ecm-celebration.component';
import { EcmTrainingComponent } from './ecm-product-details/ecm-template/ecm-training.component';
import { EcmGeneralComponent } from './ecm-product-details/ecm-template/ecm-general.component';

import { EcmCategoryComponent } from './ecm-view/ecm-category/ecm-category.component';
import { EcmSubCategoryComponent } from './ecm-view/ecm-sub-category/ecm-sub-category.component';
import { EcmProductComponent } from './ecm-view/ecm-product/ecm-product.component';
import { EcmTrendProductComponent } from './ecm-view/ecm-trend-product/ecm-trend-product.component';
import { EcmTemplateComponent, EcmTemplateDirective } from './ecm-product-details/ecm-template/ecm-template.component';
import { EcmCartComponent, ECMConfirmDialog, CounterComponent } from './ecm-view/ecm-cart/ecm-cart.component';

import { EcmCartService } from './ecm-view/ecm-cart/ecm-cart.service';
import { ProfileInfoService } from './user-profile/profile-info.service';
import { UserAddressService } from './user-address/ecm-user-address.service';
import { UserReviewService } from './user-review/ecm-user-review.service';
import { UserCardService } from './user-card/ecm-user-card.service';
import { EcmCheckoutService } from './ecm-view/ecm-checkout/ecm-checkout.service';
import { EcmProductReviewService } from './ecm-product-details/ecm-product-review.service';
import { EcmRecentViewComponent } from './ecm-view/ecm-recent-view/ecm-recent-view.component';
import { EcmReadmoreComponent } from './ecm-view/ecm-readmore/ecm-readmore.component';
import { EcmCheckoutComponent } from './ecm-view/ecm-checkout/ecm-checkout.component';
import { EcmRelatedItemsComponent } from './ecm-view/ecm-related-items/ecm-related-items.component';
import { RatingComponent } from './ecm-view/rating/rating.component';
import { EcmWishListComponent } from './ecm-view/ecm-wish-list/ecm-wish-list.component';
import { EcmWishListService } from './ecm-view/ecm-wish-list/ecm-wish-list.service';
import { EcmCategoryService } from './ecm-view/ecm-category/ecm-category.service';
import { EcmSubCategoryService } from './ecm-view/ecm-sub-category/ecm-sub-category.service';
import { EcmProductService } from './ecm-view/ecm-product/ecm-product.service';
import { EcmProductDetailService } from './ecm-product-details/ecm-product-detail.service';
import { EcmLocationService } from './ecm-search/ecm-location.service';
import { Breadcrumbs } from './ecm-breadcrumbs/ecm-breadcrumbs.component';
import { EcmOrderService } from './ecm-order/ecm-order.service';
import { HostUrlService } from './host-url.service';
import reducer from './ecm-store/reducers';
import {CartActions, CategoryActions, SubCategoryActions, ItemActions, LocationActions, WishListActions, MenuActions,ProfileActions, AdressAction, ReviewAction, SavedCardAction, OrderActions } from './ecm-store/actions';
import {CartEffects, CategoryEffects, SubCategoryEffects, ItemEffects, WishlistEffects, MenuEffects,ProfileEffects, AddressEffects, ReviewsEffects, SavedCardEffects, OrderEffects} from './ecm-store/effects';
import { EcmPanelComponent } from './ecm-view/ecm-panel/ecm-panel.component';

import { UserProfileComponent, ProfileEditor, ProfileScreenComponent } from './user-profile';
import { UserAddressComponent, AddressEditor, AddressScreenComponent } from './user-address';
import { UserCardComponent, CardEditor, CardScreenComponent } from './user-card';
import { UserReviewComponent, ReviewEditor, ReviewScreenComponent } from './user-review';
import { MyProfileComponent } from './my-profile/my-profile.component';
import { ChangePasswordComponent } from './change-password/change-password.component';

import { MaterialModule } from './module';
import { EcmOrderComponent } from './ecm-order/ecm-order.component';
import { EcmVariantsComponent } from './ecm-view/ecm-variants/ecm-variants.component';
import { ECMExploreComponent } from './ecm-home/ecm-explore.component';

import { ECMSigninService } from './ecm-signin/ecm-signin.service';

//Changes by Prajyot
const appRoutes: Routes = [
  { path: '', redirectTo: 'home', pathMatch: 'full' },
  { path: 'home', component: ECMHomeComponent},
  { path: 'categories/:catCode', component: EcmSubCategoryComponent},
  { path: 'products/:scatCode', component: EcmProductComponent},
  { path: 'detail/:itemCode', component: EcmProductDetailsComponent},
  { path: 'share/:itemCode', component: ShareComponent},
  { path: 'signin', component: EcmSigninComponent},
  { path: 'search/:value', component: EcmSearchResultComponent},
  { path: 'cart', component: EcmCartComponent},
  { path: 'checkout', component: EcmCheckoutComponent},
  { path: 'wishlist', component: EcmWishListComponent},
  { path: 'myOrder', component: EcmOrderComponent},
  { path: 'myprofile', component: MyProfileComponent, children: [
  { path: 'userprofile', component: UserProfileComponent, outlet: 'profile' },
  { path: 'useraddress', component: UserAddressComponent, outlet: 'profile' },
  { path: 'chgpassword', component: ChangePasswordComponent, outlet: 'profile' },
  { path: 'usercard', component: UserCardComponent, outlet: 'profile' },
  { path: 'userreview', component: UserReviewComponent, outlet: 'profile' }] 
  },
  { path: 'explore', component: ECMExploreComponent}
];
    
@NgModule({
  declarations: [
    AppComponent,
    ECMHeaderComponent,
    ECMFooterComponent,
    ECMContentComponent,
    ECMSearchComponent,
    ECMCardComponent,
    ECMNavMenuComponent,
    ECMHomeComponent,
    ShareComponent,
    EcmImageComponent,
    EcmSigninComponent,
    EcmUserOptionComponent,
    EcmSearchResultComponent,
    EcmBreadcrumbsComponent,
    EcmCarouselComponent,
    EcmProductDetailsComponent,
    EcmProductReviewComponent,
    EcmOutingComponent,
    EcmFoodComponent,
    EcmHandicraftComponent,
    EcmCelebrationComponent,
    EcmTrainingComponent,
    EcmGeneralComponent,
    EcmCategoryComponent,
    EcmSubCategoryComponent,
    EcmProductComponent,
    EcmTrendProductComponent,
    EcmTemplateComponent,
    EcmTemplateDirective,
    EcmCartComponent,
    EcmRecentViewComponent,
    EcmReadmoreComponent,
    EcmRelatedItemsComponent,
    EcmCheckoutComponent,
    ECMConfirmDialog,
    CounterComponent,
    RatingComponent,
    EcmWishListComponent,
    EcmPanelComponent,
    UserProfileComponent,
    UserAddressComponent,
    UserCardComponent,
    UserReviewComponent,
    MyProfileComponent,
    ChangePasswordComponent,
    AddressEditor,
    AddressScreenComponent,
    ProfileEditor,
    ProfileScreenComponent,
    CardEditor,
    CardScreenComponent,
    ReviewEditor,
    ReviewScreenComponent,
    EcmOrderComponent,
    EcmVariantsComponent,
    ECMExploreComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpModule,
    RouterModule.forRoot(appRoutes),
    ReactiveFormsModule,
    MaterialModule,
    BrowserAnimationsModule,
    StoreModule.provideStore(reducer),
    EffectsModule.run(CartEffects),
    EffectsModule.run(CategoryEffects),
    EffectsModule.run(SubCategoryEffects),
    EffectsModule.run(ItemEffects),
    EffectsModule.run(WishlistEffects),
    EffectsModule.run(ProfileEffects),
    EffectsModule.run(MenuEffects),
    EffectsModule.run(AddressEffects), 
    EffectsModule.run(ReviewsEffects), 
    EffectsModule.run(SavedCardEffects),
    EffectsModule.run(OrderEffects),
    FormsModule,
    BrowserAnimationsModule,
  //  BBKeyInputModule
    BBComponentModule
  ],
  providers: [
	{provide: LocationStrategy, useClass: HashLocationStrategy},
	ScrollService,
	SearchService,
	EcmProductReviewService,
	EcmWishListService,
	EcmCartService,
	CartActions,
	EcmCategoryService,
	CategoryActions,
	EcmSubCategoryService,
	SubCategoryActions,
	OrderActions,
	ProfileInfoService,
	UserAddressService,
	UserReviewService,
	UserCardService,
	ItemActions,
	EcmProductService,
	EcmProductDetailService,
	LocationActions,
	EcmLocationService,
    HostUrlService,
	WishListActions,
	MenuActions,
	ProfileActions,
	AdressAction, ReviewAction, SavedCardAction,
	Breadcrumbs,
	EcmOrderService,
	EcmCheckoutService,
	ECMSigninService
  ],
  entryComponents: [
    EcmOutingComponent,
    EcmFoodComponent,
    EcmHandicraftComponent,
    EcmCelebrationComponent,
    EcmTrainingComponent,
    EcmGeneralComponent,
    ECMConfirmDialog
    
  ],
  schemas:[CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  bootstrap: [AppComponent]
})
export class AppModule { }

