import { ValueAccessorBase } from './value-accessor';
import { message, validate, } from './validate';
export class ElementBase extends ValueAccessorBase {
    constructor(validators, asyncValidators) {
        super();
        this.validators = validators;
        this.asyncValidators = asyncValidators;
    }
    validate() {
        if (this.model)
            return validate(this.validators, this.asyncValidators)(this.model.control);
    }
    get invalid() {
        if (this.model)
            return this.validate().map(v => Object.keys(v || {}).length > 0);
    }
    get failures() {
        if (this.model)
            return this.validate().map(v => Object.keys(v).map(k => message(v, k)));
    }
}
//# sourceMappingURL=element-base.js.map