var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Component, Input, ViewChild, Attribute, ElementRef, Renderer } from '@angular/core';
import { NgModel } from '@angular/forms';
import { ValueAccessorBase } from '../form';
var BBTextAreaComponent = (function (_super) {
    __extends(BBTextAreaComponent, _super);
    function BBTextAreaComponent(elementRef, renderer, validator) {
        var _this = _super.call(this) || this;
        _this.validator = validator;
        _this.bbRows = 3; //default value for rows
        _this.bbColoumn = 12; //default value for column
        _this.bbResize = 'none';
        _this.bbDirection = 'ltr'; //direction of text rtl,ltr
        _this.uxDesign = 'UX3';
        _this.bbPlaceholder = '';
        _this.bbRequired = false;
        _this.value = '';
        _this.bbDisabled = false;
        _this.bbMaxlength = 524288; //default value for maxlength
        _this.bbMinlength = 0; //default value for minlength
        _this.bbReadOnly = false;
        _this.bbAutofocus = false;
        _this.bbAutoexpand = false;
        _this.requiredMessage = 'This field is required';
        _this.bbExpression = /^/;
        _this.invalidMessage = 'Invalid Input';
        _this.customErrorMessages = {
            'required': function () { return _this.requiredMessage; },
            'minlength': function (params) { return 'The min number of characters is ' + params.requiredLength; },
            'maxlength': function (params) { return 'The max allowed number of characters is ' + params.requiredLength; },
            'email': function (params) { return params.message; },
            'password': function (params) { return params.message; },
            'phone': function (params) { return params.message; }
        };
        renderer.listen(elementRef.nativeElement, 'keydown', function (event) {
            // Do something with 'event'
            if (_this.bbAutoexpand)
                _this.autosize();
        });
        return _this;
    }
    BBTextAreaComponent.prototype.autosize = function () {
        var el = this.textArea.nativeElement;
        setTimeout(function () {
            el.style.height = 'auto';
            el.style.padding = '0';
            // for box-sizing other than "content-box" use:
            // el.style.cssText = '-moz-box-sizing:content-box';
            //   console.log("el style",el.style);
            el.style.height = el.scrollHeight + 'px';
        }, 0);
    };
    BBTextAreaComponent.prototype.validate = function (c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        var isValidText = this.bbExpression.test(c.value);
        var message = {
            'textarea': {
                'message': this.invalidMessage
            }
        };
        if (!isValidText) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidText ? null : message;
    };
    BBTextAreaComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-textarea',
                    template: "\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX3'\"> \n      \t\t<md-form-field>\n      \t\t\t<textarea #textArea #textarea=\"ngModel\" mdInput [(ngModel)]=\"value\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"value\" [maxLength]=\"bbMaxlength\" [minLength]=\"bbMinlength\" [style.resize]=\"bbResize\" [style.direction]=\"bbDirection\" [rows]=\"bbRows\" [cols]=\"bbColoumn\" [readOnly]=\"bbReadOnly\"  [autofocus]=\"bbAutofocus\">\n      \t\t\t</textarea>\n      \t\t\t<md-hint>\n      \t\t\t\t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t\t\t</md-hint>\n      \t\t</md-form-field>\t\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX2'\">\n      \t\t<div>{{bbPlaceholder}}</div>\n      \t\t<textarea [value]=\"bbValue\">\n      \t\t</textarea>\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX1'\">\n      \t\t<textarea #textarea=\"ngModel\" [(ngModel)]=\"value\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"value\" [maxLength]=\"bbMaxlength\" [minLength]=\"bbMinlength\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\">\n      \t\t</textarea>\n      \t\t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t</span>\n      </span>\n    ",
                    styles: ["\n\n    "]
                },] },
    ];
    /** @nocollapse */
    BBTextAreaComponent.ctorParameters = function () { return [
        { type: ElementRef, },
        { type: Renderer, },
        { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
    ]; };
    BBTextAreaComponent.propDecorators = {
        'textArea': [{ type: ViewChild, args: ['textArea',] },],
        'model': [{ type: ViewChild, args: [NgModel,] },],
        'align': [{ type: Input, args: ['align',] },],
        'bbRows': [{ type: Input, args: ['rows',] },],
        'bbColoumn': [{ type: Input, args: ['cols',] },],
        'bbResize': [{ type: Input, args: ['resize',] },],
        'bbDirection': [{ type: Input, args: ['direction',] },],
        'uxDesign': [{ type: Input, args: ['uxDesign',] },],
        'uxTheme': [{ type: Input, args: ['uxTheme',] },],
        'bbPlaceholder': [{ type: Input, args: ['placeholder',] },],
        'bbRequired': [{ type: Input, args: ['required',] },],
        'value': [{ type: Input, args: ['value',] },],
        'bbDisabled': [{ type: Input, args: ['disabled',] },],
        'bbMaxlength': [{ type: Input, args: ['maxlength',] },],
        'bbMinlength': [{ type: Input, args: ['minlength',] },],
        'bbReadOnly': [{ type: Input, args: ['readOnly',] },],
        'bbAutofocus': [{ type: Input, args: ['autofocus',] },],
        'bbAutoexpand': [{ type: Input, args: ['autoexpand',] },],
        'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
        'bbExpression': [{ type: Input, args: ['expression',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    };
    return BBTextAreaComponent;
}(ValueAccessorBase));
export { BBTextAreaComponent };
//# sourceMappingURL=bb-text-area.component.js.map