/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateless;

import javax.ejb.EJBObject;
import javax.ejb.RemoteHome;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.proxy.handler.stateless.StatelessRemoteProxyInvocationHandler;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.ejb3.stateless.StatelessHandleRemoteImpl;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStatelessRemoteProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory {
    private RemoteBinding binding;
    private InvokerLocator locator;

    public BaseStatelessRemoteProxyFactory(SessionSpecContainer container, RemoteBinding binding) {
        super(container, ProxyFactoryHelper.getRemoteBusinessJndiName((EJBContainer)container));
        this.binding = binding;
        try {
            String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.getBinding());
            this.locator = new InvokerLocator(clientBindUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final ProxyAccessType getProxyAccessType() {
        return ProxyAccessType.REMOTE;
    }

    @Override
    protected final void validateEjb21Views() {
        SessionSpecContainer container = this.getContainer();
        RemoteHome remoteHome = container.getAnnotation(RemoteHome.class);
        this.validateEjb21Views(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces((Container)container));
    }

    abstract String getStackNameInterceptors();

    protected boolean bindHomeAndEjb21ViewTogether(SessionContainer container) {
        String homeJndiName = ProxyFactoryHelper.getHomeJndiName(container);
        String remoteBusinessJndiName = ProxyFactoryHelper.getRemoteBusinessJndiName(container);
        return homeJndiName.equals(remoteBusinessJndiName);
    }

    @Override
    public Object createProxyBusiness() {
        return this.createProxyBusiness(null);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceType) {
        return this.createProxy(SpecificationInterfaceType.EJB30_BUSINESS, businessInterfaceType);
    }

    public Object createProxy(SpecificationInterfaceType type, String businessInterfaceType) {
        String stackName = this.getStackNameInterceptors();
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        StatelessRemoteProxyInvocationHandler proxy = new StatelessRemoteProxyInvocationHandler((Container)this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), this.locator, businessInterfaceType);
        if (type.equals((Object)SpecificationInterfaceType.EJB21)) {
            return this.constructEjb21Proxy(proxy);
        }
        return this.constructProxyBusiness(proxy);
    }

    @Override
    public final StatelessHandleRemoteImpl createHandle() {
        Object proxy = this.createProxyEjb21(null);
        StatelessHandleRemoteImpl handle = new StatelessHandleRemoteImpl((EJBObject)proxy);
        return handle;
    }

    public <T extends EJBObject> T createProxyEjb21(String businessInterfaceType) {
        return (T)((EJBObject)this.createProxy(SpecificationInterfaceType.EJB21, businessInterfaceType));
    }

    RemoteBinding getBinding() {
        assert (this.binding != null) : "RemoteBinding has not been initialized";
        return this.binding;
    }

    InvokerLocator getLocator() {
        assert (this.locator != null) : "InvokerLocator has not been initialized";
        return this.locator;
    }
}

