package ibase.dashboard.wms.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class WMS3PLSummDtlDashboard extends ValidatorEJB implements WMS3PLSummDtlDashboardRemote, WMS3PLSummDtlDashboardLocal
{
	/**
	 * Default constructor.
	 */
	public WMS3PLSummDtlDashboard()
	{
	}
		
    /*Added method for ShipmentEfficiencySummary by Nikhil on dated 12102016*/
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getShipmentEffSumm(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataShpmentEffiJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		double percentage=0.0,totalCircle=629,dashOffSet=0;	
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		boolean isRreturnValue = false;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getShipmentEffSumm Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			/*facilityCode = "FC001";
			businessType = "T";*/
			String frmDate = "";
			String toDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryStack :"+facilityCode);
			}
			System.out.println("facilityCode outer :"+facilityCode);
			if (facilityCode!= null && facilityCode.trim().length()>0)
			{
			  
				sql = "  SELECT SUM(Total_Order) AS Total_Order ,"+
						" SUM(ON_TIME)          AS ON_TIME ,"+
						" SUM(Delay_time)       AS Delay_time ,"+
						" SUM(Over_Due)         AS Over_Due ,"+
						" SUM(Avg_delay)        AS Avg_delay"+
						" FROM"+
						" (SELECT site_code AS site_code,"+
						" descr           AS site_descr,"+
						" (SELECT NVL(COUNT(Sale_Order),0) Total_Order"+
						" FROM sorder s,"+
						" itemser its"+
						" WHERE s.item_ser      = its.item_ser  AND s.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+appendSql+" "+
						" AND s.site_code       =o.site_code"+
						" ) AS Total_Order,"+
						" (SELECT COUNT(S.LINE_NO) ON_TIME"+
						" FROM Sorddet S"+
						" INNER JOIN"+
						" (SELECT Inv.Invoice_Id,"+
						" Inv.Tran_Date,"+
						" Invd.Sord_No,"+
						" Invd.Sord_Line_No"+
						" FROM Invoice Inv"+
						" INNER JOIN Invdet Invd"+
						" ON Inv.Invoice_Id   = Invd.Invoice_Id"+
						" ) I ON S.Sale_Order = I.Sord_No"+
						" AND S.Line_No         = I.Sord_Line_No"+
						" AND S.Dsp_Date        = I.Tran_Date"+
						" INNER JOIN sorder so"+
						"    ON s.sale_order=so.sale_order"+
						"    INNER JOIN itemser its"+
						"    ON so.item_ser        =its.item_ser"+
						"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
						"    WHERE s.site_code     =o.site_code"+
						"    ) AS ON_TIME ,"+
						"    (SELECT ROUND(NVL(AVG(I.Tran_Date - S.Dsp_Date),0),2) DELAY_TIME"+
						"    FROM Sorddet S"+
						"    INNER JOIN"+
						"      (SELECT Inv.Invoice_Id,"+
						"        Inv.Tran_Date,"+
						"        Invd.Sord_No,"+
						"        Invd.Sord_Line_No"+
						"      FROM Invoice Inv"+
						"      INNER JOIN Invdet Invd"+
						"      ON Inv.Invoice_Id   = Invd.Invoice_Id"+
						"      ) I ON S.Sale_Order = I.Sord_No"+
						"    AND S.Line_No         = I.Sord_Line_No"+
						"    AND S.Dsp_Date        = I.Tran_Date"+
						"    INNER JOIN sorder so"+
						"    ON s.sale_order=so.sale_order"+
						"    INNER JOIN itemser its"+
						"    ON so.item_ser        =its.item_ser"+
						"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
						"    WHERE s.site_code     =o.site_code"+
						"    ) AS DELAY_TIME,"+
						"    (SELECT COUNT(S.LINE_NO) OVER_DUE"+
						"    FROM Sorddet S"+
						"    INNER JOIN"+
						"      (SELECT Inv.Invoice_Id,"+
						"        Inv.Tran_Date,"+
						"        Invd.Sord_No,"+
						"        Invd.Sord_Line_No"+
						"      FROM Invoice Inv"+
						"      INNER JOIN Invdet Invd"+
						"      ON Inv.Invoice_Id   = Invd.Invoice_Id"+
						"      ) I ON S.Sale_Order = I.Sord_No"+
						"    AND S.Line_No         = I.Sord_Line_No"+
						"    AND S.Dsp_Date        < I.Tran_Date"+
						"    INNER JOIN sorder so"+
						"    ON s.sale_order=so.sale_order"+
						"    INNER JOIN itemser its"+
						"    ON so.item_ser        =its.item_ser"+
						"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
						"    WHERE s.site_code     =o.site_code"+
						"    ) AS OVER_DUE,"+
						"    (SELECT SUM(AVG_DELAY) AS AVG_DELAY"+
						"    FROM"+
						"      (SELECT S.SITE_CODE,"+
						"        S.SALE_ORDER,"+
						"        COUNT(s.sale_order) * (ROUND(AVG(I.Tran_Date - S.Dsp_Date),2)) AVG_DELAY"+
						"      FROM Sorddet S"+
						"      INNER JOIN"+
						"        (SELECT Inv.Invoice_Id,"+
						"          Inv.Tran_Date,"+
						"          Invd.Sord_No,"+
						"          Invd.Sord_Line_No"+
						"        FROM Invoice Inv"+
						"        INNER JOIN Invdet Invd"+
						"        ON Inv.Invoice_Id   = Invd.Invoice_Id"+
						"        ) I ON S.Sale_Order = I.Sord_No"+
						"      AND S.Line_No         = I.Sord_Line_No"+
						"      AND S.Dsp_Date        = I.Tran_Date"+
						"      INNER JOIN sorder so"+
						"      ON s.sale_order =so.sale_order"+
						"      INNER JOIN itemser its"+
						"      ON so.item_ser        =its.item_ser"+
						"      "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
						"      GROUP BY S.SITE_CODE,"+
						"        S.SALE_ORDER"+
						"      ) a"+
						"    WHERE a.site_code=o.site_code"+
						"    )AS AVG_DELAY"+
						"  FROM site o"+
						"  WHERE facility_code = '"+facilityCode+"' "+ getSiteCode(sessionUserLevel, sessionSiteCode)+
						"  ) ";
            pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				isRreturnValue = true;
				rowData = new JSONObject();				
				rowData.put("total_order", checkDouble(rs.getString("TOTAL_ORDER")).trim());
				rowData.put("on_time",     checkDouble (rs.getString("ON_TIME")).trim());
				rowData.put("delay_time",  checkDouble(rs.getString("DELAY_TIME")).trim());
				rowData.put("over_due",    checkDouble (rs.getString("OVER_DUE")).trim());
				rowData.put("avg_delay",   checkDouble(rs.getString("AVG_DELAY")).trim());
				rowData.put("circledisplay", "c100");
			    /*Calculate percentage*/
				double delayTime =  Double.parseDouble(checkDouble(rs.getString("DELAY_TIME")).trim());
				double onTime    =  Double.parseDouble(checkDouble(rs.getString("ON_TIME")).trim());
				double totalTime = delayTime + onTime;
			    
				percentage = (delayTime/(delayTime+onTime))*100;
				rowData.put("percentage", Math.round(percentage));
				rowData.put("spanvalue", Math.round(percentage)+"%");				
				dashOffSet=(totalCircle*percentage)/100;
				rowData.put("dashOffSet", dashOffSet);				
				rowData.put("total_time", ""+totalTime);
			    rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
			//Add code for initialisation  variable as default code
			if(!isRreturnValue)
			{
				System.out.println("Execute Default condition when SQL not Execute");
				rowData = new JSONObject();				
				rowData.put("total_order", "0");
				rowData.put("on_time", "0");
				rowData.put("delay_time", "0");
				rowData.put("over_due", "0");
				rowData.put("avg_delay", "0.0");
				rowData.put("circledisplay", "c100");
			    /*Calculate percentage*/
				double delayTime = 0.0;
				double onTime    = 0.0;
				double totalTime = delayTime + onTime;			    
				percentage = 0;
				rowData.put("percentage", "0");
				rowData.put("spanvalue", "0 %");	
				rowData.put("dashOffSet", "0");			
				rowData.put("total_time", ""+totalTime);
			    rawDataShpmentEffiJson.put(count, rowData);
			    System.out.println("Execute Default condition Efficiency Summary==="+rawDataShpmentEffiJson.toString());
				count++;
			}
		//End code for initialisation  variable as default code
			 }	
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getShipmentEffSumm:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataShpmentEffiJson;
	}
	/*Ended method for ShipmentEfficiencySummary by Nikhil on dated 12102016*/
	
	
	/**
	 * Create ShipmentEfficiencyDetailCard dashboard display in Card 
	 * @author base
	 * @return JsonObject
	 * */
	
	
    /*Added method for ShipmentEfficiencyDetailCard by Nikhil on dated 12102016*/
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getShipmentEffDet(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataShpmentEffiJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		double percentage=0.0,totalCircle=629,dashOffSet=0;	
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		boolean isReturnValue=false;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getShipmentEffDet Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			/*facilityCode = "FC001";
			businessType = "T";*/
			String frmDate = "";
			String toDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getShipmentEffDet :"+facilityCode);
			}
			if (facilityCode!= null && facilityCode.trim().length()>0)
			{
			
			sql =   " SELECT site_code AS site_code,"+
					"  descr          AS site_descr,"+
					" (SELECT NVL(COUNT(Sale_Order),0) Total_Order"+
					" FROM sorder s,"+
					" itemser its"+
					" WHERE s.item_ser      = its.item_ser  AND s.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+appendSql+" "+
					" AND s.site_code       =o.site_code"+
					" ) AS Total_Order,"+
					" (SELECT COUNT(S.LINE_NO) ON_TIME"+
					" FROM Sorddet S"+
					" INNER JOIN"+
					" (SELECT Inv.Invoice_Id,"+
					" Inv.Tran_Date,"+
					" Invd.Sord_No,"+
					" Invd.Sord_Line_No"+
					" FROM Invoice Inv"+
					" INNER JOIN Invdet Invd"+
					" ON Inv.Invoice_Id   = Invd.Invoice_Id"+
					" ) I ON S.Sale_Order = I.Sord_No"+
					" AND S.Line_No         = I.Sord_Line_No"+
					" AND S.Dsp_Date        = I.Tran_Date"+
					" INNER JOIN sorder so"+
					"    ON s.sale_order=so.sale_order"+
					"    INNER JOIN itemser its"+
					"    ON so.item_ser        =its.item_ser"+
					"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					"    WHERE s.site_code     =o.site_code"+
					"    ) AS ON_TIME ,"+
					"    (SELECT ROUND(NVL(AVG(I.Tran_Date - S.Dsp_Date),0),2) DELAY_TIME"+
					"    FROM Sorddet S"+
					"    INNER JOIN"+
					"      (SELECT Inv.Invoice_Id,"+
					"        Inv.Tran_Date,"+
					"        Invd.Sord_No,"+
					"        Invd.Sord_Line_No"+
					"      FROM Invoice Inv"+
					"      INNER JOIN Invdet Invd"+
					"      ON Inv.Invoice_Id   = Invd.Invoice_Id"+
					"      ) I ON S.Sale_Order = I.Sord_No"+
					"    AND S.Line_No         = I.Sord_Line_No"+
					"    AND S.Dsp_Date        = I.Tran_Date"+
					"    INNER JOIN sorder so"+
					"    ON s.sale_order=so.sale_order"+
					"    INNER JOIN itemser its"+
					"    ON so.item_ser        =its.item_ser"+
					"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					"    WHERE s.site_code     =o.site_code"+
					"    ) AS DELAY_TIME,"+
					"    (SELECT COUNT(S.LINE_NO) OVER_DUE"+
					"    FROM Sorddet S"+
					"    INNER JOIN"+
					"      (SELECT Inv.Invoice_Id,"+
					"        Inv.Tran_Date,"+
					"        Invd.Sord_No,"+
					"        Invd.Sord_Line_No"+
					"      FROM Invoice Inv"+
					"      INNER JOIN Invdet Invd"+
					"      ON Inv.Invoice_Id   = Invd.Invoice_Id"+
					"      ) I ON S.Sale_Order = I.Sord_No"+
					"    AND S.Line_No         = I.Sord_Line_No"+
					"    AND S.Dsp_Date        < I.Tran_Date"+
					"    INNER JOIN sorder so"+
					"    ON s.sale_order=so.sale_order"+
					"    INNER JOIN itemser its"+
					"    ON so.item_ser        =its.item_ser"+
					"    "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					"    WHERE s.site_code     =o.site_code"+
					"    ) AS OVER_DUE,"+
					"    (SELECT SUM(AVG_DELAY) AS AVG_DELAY"+
					"    FROM"+
					"      (SELECT S.SITE_CODE,"+
					"        S.SALE_ORDER,"+
					"        COUNT(s.sale_order) * (ROUND(AVG(I.Tran_Date - S.Dsp_Date),2)) AVG_DELAY"+
					"      FROM Sorddet S"+
					"      INNER JOIN"+
					"        (SELECT Inv.Invoice_Id,"+
					"          Inv.Tran_Date,"+
					"          Invd.Sord_No,"+
					"          Invd.Sord_Line_No"+
					"        FROM Invoice Inv"+
					"        INNER JOIN Invdet Invd"+
					"        ON Inv.Invoice_Id   = Invd.Invoice_Id"+
					"        ) I ON S.Sale_Order = I.Sord_No"+
					"      AND S.Line_No         = I.Sord_Line_No"+
					"      AND S.Dsp_Date        = I.Tran_Date"+
					"      INNER JOIN sorder so"+
					"      ON s.sale_order =so.sale_order"+
					"      INNER JOIN itemser its"+
					"      ON so.item_ser        =its.item_ser"+
					"      "+appendSql+" AND so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					"      GROUP BY S.SITE_CODE,"+
					"        S.SALE_ORDER"+
					"      ) a"+
					"    WHERE a.site_code=o.site_code"+
					"    )AS AVG_DELAY"+
					" FROM site o "+
					" WHERE facility_code = '"+facilityCode+"' "+ getSiteCode(sessionUserLevel, sessionSiteCode);
            pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				isReturnValue =true;
				rowData = new JSONObject();				
				rowData.put("site_code",   checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("site_descr",  checkNull(rs.getString("site_descr")).trim());
				rowData.put("total_order", checkDouble(rs.getString("TOTAL_ORDER")).trim());
				rowData.put("on_time",     checkDouble(rs.getString("ON_TIME")).trim());
				rowData.put("delay_time",  checkDouble(rs.getString("DELAY_TIME")).trim());
				rowData.put("over_due",    checkDouble(rs.getString("OVER_DUE")).trim());
				rowData.put("avg_delay",   checkDouble(rs.getString("AVG_DELAY")).trim());
				rowData.put("circledisplay", "c100");
			    /*Calculate percentage*/
				double delayTime =  Double.parseDouble(checkDouble(rs.getString("DELAY_TIME")).trim());
				double onTime    =  Double.parseDouble(checkDouble(rs.getString("ON_TIME")).trim());
				double totalTime =  delayTime + onTime;			    
				percentage = (delayTime/(delayTime+onTime))*100;
				rowData.put("percentage", Math.round(percentage));
				rowData.put("spanvalue", Math.round(percentage)+"%");				
				dashOffSet=(totalCircle*percentage)/100;
				rowData.put("dashOffSet", dashOffSet);				
				rowData.put("total_time", ""+totalTime);
			    rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
			//Add code for initialisation  variable as default code
			if(!isReturnValue)
			{
				rowData = new JSONObject();	
				rowData.put("site_code", "");
				rowData.put("site_descr", "");
				rowData.put("total_order", "0");
				rowData.put("on_time", "0");
				rowData.put("delay_time", "0");
				rowData.put("over_due", "0");
				rowData.put("avg_delay", "0.0");
				rowData.put("circledisplay", "c100");
			    /*Calculate percentage*/
				double delayTime = 0.0;
				double onTime    = 0.0;
				double totalTime = delayTime + onTime;			    
				percentage = 0;
				rowData.put("percentage", "0");
				rowData.put("spanvalue", "0 %");	
				rowData.put("dashOffSet", "0");			
				rowData.put("total_time", ""+totalTime);
			    rawDataShpmentEffiJson.put(count, rowData);			    
				count++;
				System.out.println("Execute Default Efficience Details==="+rawDataShpmentEffiJson.toString());
				
			}
		//End code for initialisation  variable as default code
				
			 }	
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getShipmentEffDet:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataShpmentEffiJson;
	}
	/*Ended method for ShipmentEfficiencyDetailCard by Nikhil on dated 12102016*/
	
	/**
	 * Create Fill Rate Summary dashboard display in Card 
	 * @author base
	 * @return JsonObject
	 * */
	
	
    /*Added method for Fill Rate Summary  by Nikhil on dated 12102016*/
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getSkuFillRateSumm(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataShpmentEffiJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		double percentage = 0.0,totalCircle=629,dashOffSet=0;	
		ResultSet rs      = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		boolean isRreturnValue=false;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getSkuFillRateSumm Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			/*facilityCode = "FC001";
			businessType = "T";*/
			String frmDate = "";
			String toDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getSkuFillRateSumm :"+facilityCode);
			}
			
			if (facilityCode!= null && facilityCode.trim().length()>0)
			{
				sql =   " select "+
					" COUNT (M.site_code) AS SITE_CODE, "+
					" sum (NVL(Total_Order,0)) AS Total_Order, "+
					" sum (NVL(Past_Due_date,0)) AS Past_Due_date, "+
					" sum (NVL(Pending_Item,0)) AS Pending_Item, "+
					" sum (NVL(On_Hold,0)) AS On_Hold, "+
					" sum (NVL(ON_TIME,0)) AS InitialShipment, "+
					" sum (ROUND(NVL(M.Total_Sku,0))) AS TotalSKUOrder, "+
					" sum (NVL(WIP,0)) AS WIP , "+
					" CASE "+
					" WHEN sum (ROUND(NVL(M.Total_Sku,0)))  >0 "+
					" THEN ROUND(sum (NVL(ON_TIME,0))/sum (ROUND(NVL(M.Total_Sku,0))) *100,0) "+
					" ELSE 0 "+
					" END AS SKU_Fill_Rate "+
					" FROM"+
					" ("+
					" SELECT (site_code) AS site_code, "+
					" descr  AS site_descr  ,"+
					" (SELECT"+
					" NVL(COUNT(Sale_Order),0) Total_Order "+
					" FROM sorder a, itemser its "+
					" where"+
					" a.item_ser = its.item_ser "+appendSql+"  AND a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					" and a.site_code=o.site_code"+
					" ) as Total_Order,"+
					" ( SELECT"+
					" COUNT(DISTINCT sorditem.item_Code__ORd) AS Pending_Item"+
					" FROM sorditem,"+
					" Sorder, itemser its"+
					" WHERE Sorder.Sale_Order  =sorditem.Sale_Order"+
					" AND sorditem.Qty_Ord-sorditem.qty_Desp>0"+
					" and  Sorder.item_ser = its.item_ser "+appendSql+"  AND Sorder.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					" and  sorder.site_code=o.site_code"+
					" )Pending_Item ,"+
					" (SELECT"+
					" NVL(COUNT(Sale_Order),0) On_Hold"+
					" FROM sorder, itemser its"+
					" WHERE status='H'"+
					" and  sorder.item_ser = its.item_ser "+appendSql+"  "+
					" AND Sorder.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and sorder.site_code=o.site_code"+
					" ) On_Hold  ,"+
					" (SELECT"+
					" COUNT(DISTINCT sorditem.item_Code__ORd) AS Past_Due_date"+
					" FROM sorditem,"+
					" Sorder, itemser its"+
					" WHERE Sorder.Sale_Order   =sorditem.Sale_Order"+
					" AND sorditem.Qty_Ord-sorditem.qty_Desp>0"+
					" AND sorditem.Date_DESP   <CURRENT_DATE"+
					" and  Sorder.item_ser = its.item_ser "+appendSql+"    "+
					" AND Sorder.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and  Sorder.site_code=o.site_code"+
					" )Past_Due_date, "+
					" (SELECT NVL(COUNT(Sale_Order),0)  WIP"+
					" FROM sorder,itemser its"+
					" WHERE status IN ('H','P')"+
					" and  sorder.item_ser = its.item_ser "+appendSql+"   "+
					" AND sorder.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and sorder.site_code=o.site_code "+
					" )WIP, "+
					" (SELECT SUM(sorddet.quantity) Total_Sku"+
					" FROM sorder,   sorddet, itemser its"+
					" WHERE sorder.Sale_order=sorddet.Sale_order"+
					" and  sorder.item_ser = its.item_ser "+appendSql+"   "+
					" and sorder.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and sorder.site_code=o.site_code"+
					" )Total_Sku, "+
					" (SELECT"+
					" COUNT(S.Quantity) ON_TIME"+
					" FROM Sorddet S  "+
					"  INNER JOIN "+
					"    (SELECT Inv.Invoice_Id, "+
					"      Inv.Tran_Date, "+
					"      Invd.Sord_No, "+
					"      Invd.Sord_Line_No "+
					"    FROM Invoice Inv "+
					"    INNER JOIN Invdet Invd "+
					"    ON Inv.Invoice_Id   = Invd.Invoice_Id "+
					"    ) I "+
					"    ON S.Sale_Order     = I.Sord_No "+
					"   AND S.Line_No        = I.Sord_Line_No "+
					"   and S.Dsp_Date  = I.Tran_Date "+
					"   inner join sorder so  on so.sale_order=S.sale_order "+
					"   inner join itemser its  on  so.item_ser = its.item_ser "+
					"   "+appendSql+"  and so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "+
					"  where so.site_code = o.site_code   "+
					"  ) as ON_TIME"+
					"  from site o where facility_code = '"+facilityCode+"' "+ getSiteCode(sessionUserLevel, sessionSiteCode)+
					"  )M ";

 
            pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				isRreturnValue=true;
				rowData = new JSONObject();
				rowData.put("site_code",     checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("total_order",   checkDouble(rs.getString("TOTAL_ORDER")));
				rowData.put("past_due_date", checkDouble(rs.getString("PAST_DUE_DATE")));
				rowData.put("pending_item",  checkDouble(rs.getString("PENDING_ITEM")));
				rowData.put("on_hold",       checkDouble(rs.getString("ON_HOLD")));
				rowData.put("initialshipment",checkDouble(rs.getString("INITIALSHIPMENT")));
				rowData.put("totalskuorder", checkDouble(rs.getString("TOTALSKUORDER")));
				rowData.put("sku_fill_rate", checkDouble(rs.getString("SKU_FILL_RATE")));	
				rowData.put("wip",           checkDouble(rs.getString("WIP")));				
				rowData.put("circledisplay", "c100");	    
				/*Calculate percentage*/

				percentage = Double.parseDouble(checkDouble(rs.getString("SKU_FILL_RATE")));
				rowData.put("percentage", percentage);
				rowData.put("spanvalue", percentage+"%");
				if(percentage != 0.0)
				{
				dashOffSet=(totalCircle*percentage)/100;
				}else{
					dashOffSet=(totalCircle*1)/100;	
				}
				rowData.put("dashOffSet", dashOffSet);				
				rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
			//Add code for initialisation  variable as default code
			if(!isRreturnValue)
			{
				rowData = new JSONObject();
				rowData.put("site_code",   "");
				rowData.put("total_order", "0");
				rowData.put("past_due_date","0");
				rowData.put("pending_item", "0");
				rowData.put("on_hold",     "0");
				rowData.put("initialshipment","0");
				rowData.put("totalskuorder",  "0");
				rowData.put("sku_fill_rate","0");
				rowData.put("wip",  "0");				
				rowData.put("circledisplay", "c100");	    
				/*Calculate percentage*/
				percentage = 0.0;
				rowData.put("percentage", percentage);
				rowData.put("spanvalue", percentage+"%");				
				rowData.put("dashOffSet", "0");				
				rawDataShpmentEffiJson.put(count, rowData);
				count++;
				System.out.println("Execute Default condition for SKU fill Summary1"+rawDataShpmentEffiJson);
				System.out.println("Execute Default condition for SKU fill Summary2"+rawDataShpmentEffiJson.toString());
			}
		   //End code for initialisation  variable as default code
	
		 }	
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getSkuFillRateSumm:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataShpmentEffiJson;
	}
	/*Ended method for Fill Rate Summary by Nikhil on dated 12102016*/
	
	
	/**
	 * Create Fill Rate Detail dashboard display in Card 
	 * @author base
	 * @return JsonObject
	 * */
	
	
    /*Added method for Fill Rate Detail by Nikhil on dated 12102016*/
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getSkuFillRateDet(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataShpmentEffiJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		double percentage=0.0,totalCircle=629,dashOffSet=0;	
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		boolean isRreturnValue=false;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getSkuFillRateDet Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			/*facilityCode = "FC001";
			businessType = "T";*/
			String frmDate = "";
			String toDate = "";
			//Added by Varsha V. on dated 17/04/2017 for mtd date format also added in sql
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getSkuFillRateDet :"+facilityCode);
			}
			if (facilityCode!= null && facilityCode.trim().length()>0)
			{
				sql   = " SELECT M.site_code,"+
					" M.site_descr,"+
					" NVL(M.Total_Order,0) Total_Order,"+
					" NVL(Past_Due_date,0) Past_Due_date,"+
					" NVL(M.Pending_Item,0) Pending_Item,"+
					" NVL(M.On_Hold,0) On_Hold,"+
					" NVL(M.ON_TIME,0)          AS InitialShipment,"+
					" ROUND(NVL(M.Total_Sku,0)) AS TotalSKUOrder,"+
					" NVL(M.WIP,0) WIP,"+
					" CASE"+
					" WHEN NVL(M.Total_Sku,0) >0"+
					" THEN ROUND(NVL(M.ON_TIME,0)/NVL(M.Total_Sku,0)*100,0)"+
					" ELSE 0"+
					" END AS SKU_Fill_Rate"+
					" FROM"+
					" ( SELECT (site_code) AS site_code,"+
					" descr  AS site_descr  ,"+
					" (SELECT"+
					" NVL(COUNT(Sale_Order),0) Total_Order"+
					" FROM sorder a, itemser its"+
					" where"+
					" a.item_ser = its.item_ser "+appendSql+"  AND a.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"'  "+
					" and a.site_code=o.site_code"+
					" ) as Total_Order,"+
					" ( SELECT"+
					" COUNT(DISTINCT sorditem.item_Code__ORd) AS Pending_Item"+
					" FROM sorditem,"+
					" Sorder, itemser its"+
					" WHERE Sorder.Sale_Order  =sorditem.Sale_Order"+
					" AND sorditem.Qty_Ord-sorditem.qty_Desp>0  AND Sorder.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"' "+
					" and  Sorder.item_ser = its.item_ser "+appendSql+"   "+
					" and  sorder.site_code=o.site_code"+
					" )Pending_Item, "+
					" (SELECT"+
					" NVL(COUNT(Sale_Order),0) On_Hold"+
					" FROM sorder, itemser its"+
					" WHERE status='H'   AND Sorder.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"' "+
					" and  sorder.item_ser = its.item_ser "+appendSql+"  "+
					" and sorder.site_code=o.site_code"+
					" ) On_Hold  ,"+
					" (SELECT"+
					" COUNT(DISTINCT sorditem.item_Code__ORd) AS Past_Due_date"+
					" FROM sorditem,"+
					" Sorder, itemser its"+
					" WHERE Sorder.Sale_Order   =sorditem.Sale_Order"+
					" AND sorditem.Qty_Ord-sorditem.qty_Desp>0"+
					" AND sorditem.Date_DESP   <CURRENT_DATE"+
					" and  Sorder.item_ser = its.item_ser "+appendSql+"   AND Sorder.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"'   "+
					" and  Sorder.site_code=o.site_code"+
					" )Past_Due_date ,"+
					" (SELECT NVL(COUNT(Sale_Order),0)  WIP"+
					" FROM sorder,itemser its"+
					" WHERE status IN ('H','P')"+
					" and  sorder.item_ser = its.item_ser "+appendSql+"     AND sorder.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"'  "+
					" and sorder.site_code=o.site_code"+
					" )WIP ,"+
					" (SELECT SUM(sorddet.quantity) Total_Sku"+
					" FROM sorder,   sorddet, itemser its"+
					" WHERE sorder.Sale_order=sorddet.Sale_order"+
					" and  sorder.item_ser = its.item_ser "+appendSql+"    AND sorder.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"'  "+
					" and sorder.site_code=o.site_code"+
					" )Total_Sku, "+
					" (SELECT"+
					" COUNT(S.Quantity) ON_TIME"+
					" FROM Sorddet S "+
					" INNER JOIN"+
					" (SELECT Inv.Invoice_Id,"+
					" Inv.Tran_Date,"+
					" Invd.Sord_No,"+
					" Invd.Sord_Line_No"+
					" FROM Invoice Inv"+
					" INNER JOIN Invdet Invd"+
					" ON Inv.Invoice_Id   = Invd.Invoice_Id"+
					" ) I "+
					" ON S.Sale_Order     = I.Sord_No "+
					" AND S.Line_No        = I.Sord_Line_No"+
					" and S.Dsp_Date  = I.Tran_Date "+
					" inner join sorder so  on so.sale_order=S.sale_order "+
					" inner join itemser its  on  so.item_ser = its.item_ser "+appendSql+"  "+
					" where so.site_code = o.site_code   AND so.CONF_DATE BETWEEN '"+frmDate+"' AND '"+toDate+"'  "+
					" ) as ON_TIME"+
					" from site o where facility_code = '"+facilityCode+"' "+getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )M ";
			
            pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				isRreturnValue=true;
				rowData = new JSONObject();
				rowData.put("site_code",      checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("site_descr",     checkNull(rs.getString("site_descr")).trim());
				rowData.put("total_order",    checkDouble(rs.getString("TOTAL_ORDER")).trim());
				rowData.put("past_due_date",  checkDouble(rs.getString("PAST_DUE_DATE")).trim());
				rowData.put("pending_item",   checkDouble(rs.getString("PENDING_ITEM")).trim());
				rowData.put("on_hold",        checkDouble(rs.getString("ON_HOLD")).trim());
				rowData.put("initialshipment",checkDouble(rs.getString("INITIALSHIPMENT")).trim());
				rowData.put("totalskuorder",  checkDouble(rs.getString("TOTALSKUORDER")).trim());
				rowData.put("sku_fill_rate",  checkDouble(rs.getString("SKU_FILL_RATE")).trim());	
				rowData.put("wip",            checkDouble(rs.getString("WIP")).trim());				
				rowData.put("circledisplay", "c100");			    
				/*Calculate percentage*/
				percentage = Double.parseDouble(checkDouble(rs.getString("SKU_FILL_RATE")));
				rowData.put("percentage", percentage);
				rowData.put("spanvalue", percentage+"%");
				if(percentage != 0.0)
				{
				dashOffSet=(totalCircle*percentage)/100;
				}else{
					dashOffSet=(totalCircle*1)/100;	
				}
				rowData.put("dashOffSet", dashOffSet);	
			    rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
			//Add code for initialisation  variable as default code
			if(!isRreturnValue)
			{
				rowData = new JSONObject();
				rowData.put("site_code",   "");
				rowData.put("site_descr",  "");
				rowData.put("total_order", "0");
				rowData.put("past_due_date","0");
				rowData.put("pending_item","0");
				rowData.put("on_hold",     "0");
				rowData.put("initialshipment","0");
				rowData.put("totalskuorder","0");
				rowData.put("sku_fill_rate","0");
				rowData.put("wip",  "0");				
				rowData.put("circledisplay","c100");	    
				/*Calculate percentage*/
				percentage = 0.0;
				rowData.put("percentage", percentage);
				rowData.put("spanvalue", percentage+"%");				
				rowData.put("dashOffSet", "0");				
				rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
		   //End code for initialisation  variable as default code	
	 }	
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getSkuFillRateDet:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataShpmentEffiJson;
	}
	/*Ended method for Fill Rate Detail by Nikhil on dated 12102016*/
	

	/**
	 * Create Warehouse Efficiency card Summary dashboard display in line
	 * @author base
	 * @return JsonObject
	 * */
	 /*Added method for Warehouse Efficiency card Summary order by Nikhil on dated 06102016*/
	
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffSummOrder(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
			JSONObject rawDataWarehouseEffSummaryJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffSummOrder Method ****************** ");
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/	
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffSummOrder :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{
					sql =    " Select  " +
						" sum(ship_1) as ship_1 " +
						" ,sum(ship_2) as ship_2 " +
						" ,sum(ship_3) as ship_3 " +
						" ,sum(ship_4) as ship_4 " +
						" ,sum(ship_5) as ship_5 " +
						" ,sum(ship_6) as ship_6 " +
						" ,sum(ship_7) as ship_7 " +
						" ,sum(ship_8) as ship_8 " +
						" ,sum(ship_9) as ship_9 " +
						" ,sum(ship_10) as ship_10 " +
						" ,sum(ship_11) as ship_11 " +
						" ,sum(ship_12) as ship_12 " +
						" ,sum(ship_13) as ship_13 " +
						" ,sum(ship_14) as ship_14 " +
						" ,sum(ship_15) as ship_15 " +
						" ,sum(ship_16) as ship_16 " +
						" ,sum(ship_17) as ship_17 " +
						" ,sum(ship_18) as ship_18 " +
						" ,sum(ship_19) as ship_19 " +
						" ,sum(ship_20) as ship_20 " +
						" ,sum(ship_21) as ship_21 " +
						" ,sum(ship_22) as ship_22 " +
						" ,sum(ship_23) as ship_23 " +
						" ,sum(ship_23) as ship_24 " +
						" ,sum(pick_1) as pick_1 " +
						" ,sum(pick_2) as pick_2 " +
						" ,sum(pick_3) as pick_3 " +
						" ,sum(pick_4) as pick_4 " +
						" ,sum(pick_5) as pick_5 " +
						" ,sum(pick_6) as pick_6 " +
						" ,sum(pick_7) as pick_7 " +
						" ,sum(pick_8) as pick_8 " +
						" ,sum(pick_9) as pick_9 " +
						" ,sum(pick_10) as pick_10 " +
						" ,sum(pick_11) as pick_11 " +
						" ,sum(pick_12) as pick_12 " +
						" ,sum(pick_13) as pick_13 " +
						" ,sum(pick_14) as pick_14 " +
						" ,sum(pick_15) as pick_15 " +
						" ,sum(pick_16) as pick_16 " +
						" ,sum(pick_17) as pick_17 " +
						" ,sum(pick_18) as pick_18 " +
						" ,sum(pick_19) as pick_19 " +
						" ,sum(pick_20) as pick_20 " +
						" ,sum(pick_21) as pick_21 " +
						" ,sum(pick_22) as pick_22 " +
						" ,sum(pick_23) as pick_23 " +
						" ,sum(pick_23) as pick_24 " +
						" from( " +
						" select site_code,descr, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
						" and b.Confirmed='Y' ) ship_1, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
						" and b.Confirmed='Y' ) ship_2, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
						" and b.Confirmed='Y' ) ship_3, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
						" and b.Confirmed='Y' ) ship_4, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
						" and b.Confirmed='Y' ) ship_5, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
						" and b.Confirmed='Y' ) ship_6, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
						" and b.Confirmed='Y' ) ship_7, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
						" and b.Confirmed='Y' ) ship_8, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
						" and b.Confirmed='Y' ) ship_9, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
						" and b.Confirmed='Y' ) ship_10, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
						" and b.Confirmed='Y' ) ship_11, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
						" and b.Confirmed='Y' ) ship_12, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
						" and b.Confirmed='Y' ) ship_13, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
						" and b.Confirmed='Y' ) ship_14, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
						" and b.Confirmed='Y' ) ship_15, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
						" and b.Confirmed='Y' ) ship_16, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
						" and b.Confirmed='Y' ) ship_17, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
						" and b.Confirmed='Y' ) ship_18, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
						" and b.Confirmed='Y' ) ship_19, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
						" and b.Confirmed='Y' ) ship_20, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
						" and b.Confirmed='Y' ) ship_21, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
						" and b.Confirmed='Y' ) ship_22, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
						" and b.Confirmed='Y' ) ship_23, " +
						" (Select count(distinct b.sale_order)  " +
						" from invoice b, itemser its where b.site_code = o.site_code " +
						" and b.item_ser = its.item_ser "+appendSql+" " +
						" and b.conf_date = sysdate " +
						" AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
						" and b.Confirmed='Y' ) ship_24, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_1, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_2, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_3, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_4, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_5, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_6, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_7, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_8, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_9, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_10, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_11, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_12, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_13, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_14, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_15, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_16, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_17, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_18, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_19, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_20, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_21, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_22, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_23, " +
						" (select count(sale_order)  " +
						" from sorder k where  k.status not in ('C','X','H')  " +
						" and k.sale_order in  " +
						" (select distinct sale_order  " +
						" from wave_task_det,Wave_task  " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
						" and HDR.conf_date= sysdate " +
						" AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
						" and k.site_code = o.site_code ) pick_24 " +
						" from site o  where facility_code='"+facilityCode+"' "+ getSiteCode(sessionUserLevel, sessionSiteCode) +
						" ) ";
						 
				
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				HashMap<Integer, String> shipMap = new HashMap<Integer, String>();
				HashMap<Integer, String> pickMap = new HashMap<Integer, String>();
				while(rs.next())
				{
					
					shipMap.put(1, rs.getString("SHIP_1").trim());
					shipMap.put(2, rs.getString("SHIP_2").trim());
					shipMap.put(3, rs.getString("SHIP_3").trim());
					shipMap.put(4, rs.getString("SHIP_4").trim());

					shipMap.put(5, rs.getString("SHIP_5").trim());
					shipMap.put(6, rs.getString("SHIP_6").trim());
					shipMap.put(7, rs.getString("SHIP_7").trim());
					shipMap.put(8, rs.getString("SHIP_8").trim());

					shipMap.put(9,  rs.getString("SHIP_9").trim());
					shipMap.put(10, rs.getString("SHIP_10").trim());
					shipMap.put(11, rs.getString("SHIP_11").trim());
					shipMap.put(12, rs.getString("SHIP_12").trim());

					shipMap.put(13, rs.getString("SHIP_13").trim());
					shipMap.put(14, rs.getString("SHIP_14").trim());
					shipMap.put(15, rs.getString("SHIP_15").trim());
					shipMap.put(16, rs.getString("SHIP_16").trim());

					shipMap.put(17, rs.getString("SHIP_17").trim());
					shipMap.put(18, rs.getString("SHIP_18").trim());
					shipMap.put(19, rs.getString("SHIP_19").trim());
					shipMap.put(20, rs.getString("SHIP_20").trim());

					shipMap.put(21, rs.getString("SHIP_21").trim());
					shipMap.put(22, rs.getString("SHIP_22").trim());
					shipMap.put(23, rs.getString("SHIP_23").trim());
					shipMap.put(24, rs.getString("SHIP_24").trim());
					
					pickMap.put(1, rs.getString("PICK_1").trim());
					pickMap.put(2, rs.getString("PICK_2").trim());
					pickMap.put(3, rs.getString("PICK_3").trim());
					pickMap.put(4, rs.getString("PICK_4").trim());

					pickMap.put(5, rs.getString("PICK_5").trim());
					pickMap.put(6, rs.getString("PICK_6").trim());
					pickMap.put(7, rs.getString("PICK_7").trim());
					pickMap.put(8, rs.getString("PICK_8").trim());

					pickMap.put(9,  rs.getString("PICK_9").trim());
					pickMap.put(10, rs.getString("PICK_10").trim());
					pickMap.put(11, rs.getString("PICK_11").trim());
					pickMap.put(12, rs.getString("PICK_12").trim());

					pickMap.put(13, rs.getString("PICK_13").trim());
					pickMap.put(14, rs.getString("PICK_14").trim());
					pickMap.put(15, rs.getString("PICK_15").trim());
					pickMap.put(16, rs.getString("PICK_16").trim());

					pickMap.put(17, rs.getString("PICK_17").trim());
					pickMap.put(18, rs.getString("PICK_18").trim());
					pickMap.put(19, rs.getString("PICK_19").trim());
					pickMap.put(20, rs.getString("PICK_20").trim());

					pickMap.put(21, rs.getString("PICK_21").trim());
					pickMap.put(22, rs.getString("PICK_22").trim());
					pickMap.put(23, rs.getString("PICK_23").trim());
					pickMap.put(24, rs.getString("PICK_24").trim());
					
				}
				for(Map.Entry<Integer, String> entry:shipMap.entrySet())
				{

					rowData = new JSONObject();
					rowData.put("hour", entry.getKey());
					rowData.put("ship", entry.getValue());
					rowData.put("pick", pickMap.get(entry.getKey()));
					rawDataWarehouseEffSummaryJson.put(count, rowData);
					count++;
					
				}	
				System.out.println("********** rawDataWarehouseEffSummaryJson :"+rawDataWarehouseEffSummaryJson.toString());
			 }
				 	
			}catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffSummOrder:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehouseEffSummaryJson;
		}
		/*Ended method for Warehouse Efficiency card Summary order  by Nikhil on dated 06102016*/
		
		/**
		 * Create Warehouse Efficiency card Summary dashboard display in line
		 * @author base
		 * @return JsonObject
		 * */
	
	/*Added method for Warehouse Efficiency card Deatil order DRILLDOWN by Nikhil on dated 07102016*/
		
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffDetOrder(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
		{
			JSONObject rawDataWarehouseEffSummaryJsonOuter = new JSONObject();
			JSONObject rawDataWarehouseEffSummaryJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			String  siteCode               = "";
			String  siteDescr              = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffDetOrder Method ****************** ");
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffDetOrder :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{			
				
					sql =   " select site_code,descr, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
							" and b.Confirmed='Y' ) ship_1, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
							" and b.Confirmed='Y' ) ship_2, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
							" and b.Confirmed='Y' ) ship_3, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
							" and b.Confirmed='Y' ) ship_4, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
							" and b.Confirmed='Y' ) ship_5, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
							" and b.Confirmed='Y' ) ship_6, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
							" and b.Confirmed='Y' ) ship_7, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
							" and b.Confirmed='Y' ) ship_8, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
							" and b.Confirmed='Y' ) ship_9, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
							" and b.Confirmed='Y' ) ship_10, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
							" and b.Confirmed='Y' ) ship_11, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
							" and b.Confirmed='Y' ) ship_12, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
							" and b.Confirmed='Y' ) ship_13, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
							" and b.Confirmed='Y' ) ship_14, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
							" and b.Confirmed='Y' ) ship_15, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
							" and b.Confirmed='Y' ) ship_16, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
							" and b.Confirmed='Y' ) ship_17, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
							" and b.Confirmed='Y' ) ship_18, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
							" and b.Confirmed='Y' ) ship_19, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
							" and b.Confirmed='Y' ) ship_20, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
							" and b.Confirmed='Y' ) ship_21, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
							" and b.Confirmed='Y' ) ship_22, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
							" and b.Confirmed='Y' ) ship_23, " +
							" (Select count(distinct b.sale_order)  " +
							" from invoice b, itemser its where b.site_code = o.site_code " +
							" and b.item_ser = its.item_ser "+appendSql+" " +
							" and b.conf_date = sysdate " +
							" AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
							" and b.Confirmed='Y' ) ship_24, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_1, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_2, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_3, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_4, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_5, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_6, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_7, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_8, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_9, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_10, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_11, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_12, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_13, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_14, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_15, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_16, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_17, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_18, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_19, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_20, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_21, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_22, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_23, " +
							" (select count(sale_order)  " +
							" from sorder k where  k.status not in ('C','X','H')  " +
							" and k.sale_order in  " +
							" (select distinct sale_order  " +
							" from wave_task_det,Wave_task  " +
							" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							" and HDR.conf_date= sysdate " +
							" AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
							" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							" and k.site_code = o.site_code ) pick_24 " +
							" from site o  where facility_code='"+facilityCode+"' "+getSiteCode(sessionUserLevel, sessionSiteCode);
							
						pstmt = conn.prepareStatement(sql);
						rs    = pstmt.executeQuery();
						LinkedHashMap<Integer, String> shipMap = null;
						Map<String, LinkedHashMap<Integer, String>> siteCodeMap = new LinkedHashMap<String, LinkedHashMap<Integer,String>>();
						
					while(rs.next())
					{
						
						shipMap = new LinkedHashMap<Integer, String>();
						
						shipMap.put(1, rs.getString("SHIP_1").trim());
						shipMap.put(2, rs.getString("SHIP_2").trim());
						shipMap.put(3, rs.getString("SHIP_3").trim());
						shipMap.put(4, rs.getString("SHIP_4").trim());

						shipMap.put(5, rs.getString("SHIP_5").trim());
						shipMap.put(6, rs.getString("SHIP_6").trim());
						shipMap.put(7, rs.getString("SHIP_7").trim());
						shipMap.put(8, rs.getString("SHIP_8").trim());

						shipMap.put(9,  rs.getString("SHIP_9").trim());
						shipMap.put(10, rs.getString("SHIP_10").trim());
						shipMap.put(11, rs.getString("SHIP_11").trim());
						shipMap.put(12, rs.getString("SHIP_12").trim());

						shipMap.put(13, rs.getString("SHIP_13").trim());
						shipMap.put(14, rs.getString("SHIP_14").trim());
						shipMap.put(15, rs.getString("SHIP_15").trim());
						shipMap.put(16, rs.getString("SHIP_16").trim());

						shipMap.put(17, rs.getString("SHIP_17").trim());
						shipMap.put(18, rs.getString("SHIP_18").trim());
						shipMap.put(19, rs.getString("SHIP_19").trim());
						shipMap.put(20, rs.getString("SHIP_20").trim());

						shipMap.put(21, rs.getString("SHIP_21").trim());
						shipMap.put(22, rs.getString("SHIP_22").trim());
						shipMap.put(23, rs.getString("SHIP_23").trim());
						shipMap.put(24, rs.getString("SHIP_24").trim());
						
						shipMap.put(25, rs.getString("PICK_1").trim());
						shipMap.put(26, rs.getString("PICK_2").trim());
						shipMap.put(27, rs.getString("PICK_3").trim());
						shipMap.put(28, rs.getString("PICK_4").trim());

						shipMap.put(29, rs.getString("PICK_5").trim());
						shipMap.put(30, rs.getString("PICK_6").trim());
						shipMap.put(31, rs.getString("PICK_7").trim());
						shipMap.put(32, rs.getString("PICK_8").trim());

						shipMap.put(33,  rs.getString("PICK_9").trim());
						shipMap.put(34, rs.getString("PICK_10").trim());
						shipMap.put(35, rs.getString("PICK_11").trim());
						shipMap.put(36, rs.getString("PICK_12").trim());

						shipMap.put(37, rs.getString("PICK_13").trim());
						shipMap.put(38, rs.getString("PICK_14").trim());
						shipMap.put(39, rs.getString("PICK_15").trim());
						shipMap.put(40, rs.getString("PICK_16").trim());

						shipMap.put(41, rs.getString("PICK_17").trim());
						shipMap.put(42, rs.getString("PICK_18").trim());
						shipMap.put(43, rs.getString("PICK_19").trim());
						shipMap.put(44, rs.getString("PICK_20").trim());

						shipMap.put(45, rs.getString("PICK_21").trim());
						shipMap.put(46, rs.getString("PICK_22").trim());
						shipMap.put(47, rs.getString("PICK_23").trim());
						shipMap.put(48, rs.getString("PICK_24").trim());
						
						siteCode = rs.getString("site_code").trim();
						siteDescr = rs.getString("descr").trim();
						siteCodeMap.put(siteCode+"( "+ siteDescr +" )" , shipMap);
					}
					System.out.println("*********** siteCodeMap in detail************** :"+siteCodeMap.toString());
					for(Map.Entry<String, LinkedHashMap<Integer, String>> entry : siteCodeMap.entrySet())
					{

						LinkedHashMap<Integer, String> tempMap = siteCodeMap.get(entry.getKey());
						rawDataWarehouseEffSummaryJson = new JSONObject();
						count = 0;
						for(Map.Entry<Integer, String> entry1:tempMap.entrySet())
						{
							if(entry1.getKey()<=24)
							{
								rowData = new JSONObject();
								rowData.put("hour", entry1.getKey());
								rowData.put("ship", entry1.getValue());
								rowData.put("pick", tempMap.get(entry1.getKey()+24));
								rawDataWarehouseEffSummaryJson.put(count, rowData);
								count++;
							}
						}
						rawDataWarehouseEffSummaryJsonOuter.put(entry.getKey(), rawDataWarehouseEffSummaryJson);
					}		  			 	
				 }
			}
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffDetOrder:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehouseEffSummaryJsonOuter;
		}
		/*Ended method for Warehouse Efficiency Card  order DRILLDOWN by Nikhil on dated 07102016*/

		
		 /*Added method for Warehouse Efficiency card Quantity Summary by Nikhil on dated 06102016*/
		
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffSummQty(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
		{
			JSONObject rawDataWarehouseEffSummQtyJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffSummQty Method ****************** ");
				System.out.println("facilityCode :"+facilityCode+"------- businessType :"+businessType);
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffSummQty :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{
				
					sql =   " Select  " +
							 " sum(ship_1) as ship_1 " +
							 " ,sum(ship_2) as ship_2 " +
							 " ,sum(ship_3) as ship_3 " +
							 " ,sum(ship_4) as ship_4 " +
							 " ,sum(ship_5) as ship_5 " +
							 " ,sum(ship_6) as ship_6 " +
							 " ,sum(ship_7) as ship_7 " +
							 " ,sum(ship_8) as ship_8 " +
							 " ,sum(ship_9) as ship_9 " +
							 " ,sum(ship_10) as ship_10 " +
							 " ,sum(ship_11) as ship_11 " +
							 " ,sum(ship_12) as ship_12 " +
							 " ,sum(ship_13) as ship_13 " +
							 " ,sum(ship_14) as ship_14 " +
							 " ,sum(ship_15) as ship_15 " +
							 " ,sum(ship_16) as ship_16 " +
							 " ,sum(ship_17) as ship_17 " +
							 " ,sum(ship_18) as ship_18 " +
							 " ,sum(ship_19) as ship_19 " +
							 " ,sum(ship_20) as ship_20 " +
							 " ,sum(ship_21) as ship_21 " +
							 " ,sum(ship_22) as ship_22 " +
							 " ,sum(ship_23) as ship_23 " +
							 " ,sum(ship_24) as ship_24 " +
							 " ,sum(pick_1) as pick_1 " +
							 " ,sum(pick_2) as pick_2 " +
							 " ,sum(pick_3) as pick_3 " +
							 " ,sum(pick_4) as pick_4 " +
							 " ,sum(pick_5) as pick_5 " +
							 " ,sum(pick_6) as pick_6 " +
							 " ,sum(pick_7) as pick_7 " +
							 " ,sum(pick_8) as pick_8 " +
							 " ,sum(pick_9) as pick_9 " +
							 " ,sum(pick_10) as pick_10 " +
							 " ,sum(pick_11) as pick_11 " +
							 " ,sum(pick_12) as pick_12 " +
							 " ,sum(pick_13) as pick_13 " +
							 " ,sum(pick_14) as pick_14 " +
							 " ,sum(pick_15) as pick_15 " +
							 " ,sum(pick_16) as pick_16 " +
							 " ,sum(pick_17) as pick_17 " +
							 " ,sum(pick_18) as pick_18 " +
							 " ,sum(pick_19) as pick_19 " +
							 " ,sum(pick_20) as pick_20 " +
							 " ,sum(pick_21) as pick_21 " +
							 " ,sum(pick_22) as pick_22 " +
							 " ,sum(pick_23) as pick_23 " +
							 " ,sum(pick_24) as pick_24 " +
							 " from( " +
							 " select site_code,descr, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
							 " and b.Confirmed='Y' ) ship_1, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
							 " and b.Confirmed='Y' ) ship_2, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
							 " and b.Confirmed='Y' ) ship_3, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
							 " and b.Confirmed='Y' ) ship_4, " +
							 " (Select nvl(Sum(c.Quantity),0) from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
							 " and b.Confirmed='Y' ) ship_5, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
							 " and b.Confirmed='Y' ) ship_6, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
							 " and b.Confirmed='Y' ) ship_7, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
							 " and b.Confirmed='Y' ) ship_8, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
							 " and b.Confirmed='Y' ) ship_9, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
							 " and b.Confirmed='Y' ) ship_10, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
							 " and b.Confirmed='Y' ) ship_11, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
							 " and b.Confirmed='Y' ) ship_12, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
							 " and b.Confirmed='Y' ) ship_13, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
							 " and b.Confirmed='Y' ) ship_14, " +
							 " (Select nvl(Sum(c.Quantity),0) from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
							 " and b.Confirmed='Y' ) ship_15, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
							 " and b.Confirmed='Y' ) ship_16, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
							 " and b.Confirmed='Y' ) ship_17, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
							 " and b.Confirmed='Y' ) ship_18, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
							 " and b.Confirmed='Y' ) ship_19, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
							 " and b.Confirmed='Y' ) ship_20, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
							 " and b.Confirmed='Y' ) ship_21, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
							 " and b.Confirmed='Y' ) ship_22, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
							 " and b.Confirmed='Y' ) ship_23, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
							 " and b.Confirmed='Y' ) ship_24, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_1, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_2, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_3, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_4, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_5, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_6, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_7, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_8, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_9, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_10, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_11, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_12, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_13, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_14, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_15, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_16, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_17, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_18, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_19, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_20, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_21, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_22, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_23, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_24 " +
							 " from site o  where facility_code='"+facilityCode+"' " + getSiteCode(sessionUserLevel, sessionSiteCode)+
							 " ) "; 
							 
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				HashMap<Integer, String> shipMap = new HashMap<Integer, String>();
				HashMap<Integer, String> pickMap = new HashMap<Integer, String>();
				while(rs.next())
				{
					
					shipMap.put(1, rs.getString("SHIP_1").trim());
					shipMap.put(2, rs.getString("SHIP_2").trim());
					shipMap.put(3, rs.getString("SHIP_3").trim());
					shipMap.put(4, rs.getString("SHIP_4").trim());

					shipMap.put(5, rs.getString("SHIP_5").trim());
					shipMap.put(6, rs.getString("SHIP_6").trim());
					shipMap.put(7, rs.getString("SHIP_7").trim());
					shipMap.put(8, rs.getString("SHIP_8").trim());

					shipMap.put(9,  rs.getString("SHIP_9").trim());
					shipMap.put(10, rs.getString("SHIP_10").trim());
					shipMap.put(11, rs.getString("SHIP_11").trim());
					shipMap.put(12, rs.getString("SHIP_12").trim());

					shipMap.put(13, rs.getString("SHIP_13").trim());
					shipMap.put(14, rs.getString("SHIP_14").trim());
					shipMap.put(15, rs.getString("SHIP_15").trim());
					shipMap.put(16, rs.getString("SHIP_16").trim());

					shipMap.put(17, rs.getString("SHIP_17").trim());
					shipMap.put(18, rs.getString("SHIP_18").trim());
					shipMap.put(19, rs.getString("SHIP_19").trim());
					shipMap.put(20, rs.getString("SHIP_20").trim());

					shipMap.put(21, rs.getString("SHIP_21").trim());
					shipMap.put(22, rs.getString("SHIP_22").trim());
					shipMap.put(23, rs.getString("SHIP_23").trim());
					shipMap.put(24, rs.getString("SHIP_24").trim());
					
					pickMap.put(1, rs.getString("PICK_1").trim());
					pickMap.put(2, rs.getString("PICK_2").trim());
					pickMap.put(3, rs.getString("PICK_3").trim());
					pickMap.put(4, rs.getString("PICK_4").trim());

					pickMap.put(5, rs.getString("PICK_5").trim());
					pickMap.put(6, rs.getString("PICK_6").trim());
					pickMap.put(7, rs.getString("PICK_7").trim());
					pickMap.put(8, rs.getString("PICK_8").trim());

					pickMap.put(9,  rs.getString("PICK_9").trim());
					pickMap.put(10, rs.getString("PICK_10").trim());
					pickMap.put(11, rs.getString("PICK_11").trim());
					pickMap.put(12, rs.getString("PICK_12").trim());

					pickMap.put(13, rs.getString("PICK_13").trim());
					pickMap.put(14, rs.getString("PICK_14").trim());
					pickMap.put(15, rs.getString("PICK_15").trim());
					pickMap.put(16, rs.getString("PICK_16").trim());

					pickMap.put(17, rs.getString("PICK_17").trim());
					pickMap.put(18, rs.getString("PICK_18").trim());
					pickMap.put(19, rs.getString("PICK_19").trim());
					pickMap.put(20, rs.getString("PICK_20").trim());

					pickMap.put(21, rs.getString("PICK_21").trim());
					pickMap.put(22, rs.getString("PICK_22").trim());
					pickMap.put(23, rs.getString("PICK_23").trim());
					pickMap.put(24, rs.getString("PICK_24").trim());
					
				}
				for(Map.Entry<Integer, String> entry:shipMap.entrySet())
				{

					rowData = new JSONObject();
					rowData.put("hour", entry.getKey());
					rowData.put("ship", entry.getValue());
					rowData.put("pick", pickMap.get(entry.getKey()));
					rawDataWarehouseEffSummQtyJson.put(count, rowData);
					count++;
					
				}	
				System.out.println("********** rawDataWarehouseEffSummQtyJson :"+rawDataWarehouseEffSummQtyJson.toString());
			 }
				 
			}catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffSummQty:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehouseEffSummQtyJson;
		}
		/*Ended method for Warehouse Efficiency card Quantity Summary  by Nikhil on dated 06102016*/
		
		/**
		 * Create Warehouse Efficiency card Summary dashboard display in line
		 * @author base
		 * @return JsonObject
		 * */
	
	/*Added method for Warehouse Efficiency card Deatil Quantity rate DRILLDOWN by Nikhil on dated 07102016*/
		
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffDetQty(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
		{
			JSONObject rawDataWarehouseEffSummQtyJsonOuter = new JSONObject();
			JSONObject rawDataWarehouseEffSummaryQtyJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			String  siteCode               = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			String siteDescr = "";
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffDetQty Method ****************** ");
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffSummQty :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{			
				
					sql =    " select site_code,descr, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
							 " and b.Confirmed='Y' ) ship_1, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
							 " and b.Confirmed='Y' ) ship_2, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
							 " and b.Confirmed='Y' ) ship_3, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
							 " and b.Confirmed='Y' ) ship_4, " +
							 " (Select nvl(Sum(c.Quantity),0) from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
							 " and b.Confirmed='Y' ) ship_5, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
							 " and b.Confirmed='Y' ) ship_6, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
							 " and b.Confirmed='Y' ) ship_7, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
							 " and b.Confirmed='Y' ) ship_8, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
							 " and b.Confirmed='Y' ) ship_9, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
							 " and b.Confirmed='Y' ) ship_10, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
							 " and b.Confirmed='Y' ) ship_11, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
							 " and b.Confirmed='Y' ) ship_12, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
							 " and b.Confirmed='Y' ) ship_13, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
							 " and b.Confirmed='Y' ) ship_14, " +
							 " (Select nvl(Sum(c.Quantity),0) from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
							 " and b.Confirmed='Y' ) ship_15, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
							 " and b.Confirmed='Y' ) ship_16, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
							 " and b.Confirmed='Y' ) ship_17, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
							 " and b.Confirmed='Y' ) ship_18, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
							 " and b.Confirmed='Y' ) ship_19, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
							 " and b.Confirmed='Y' ) ship_20, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
							 " and b.Confirmed='Y' ) ship_21, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
							 " and b.Confirmed='Y' ) ship_22, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
							 " and b.Confirmed='Y' ) ship_23, " +
							 " (Select nvl(Sum(c.Quantity),0)  from invoice b,INVDET c,  itemser its  " +
							 " where b.site_code = o.site_code and b.invoice_id = c.invoice_id " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
							 " and b.Confirmed='Y' ) ship_24, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_1, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_2, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_3, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_4, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_5, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_6, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_7, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_8, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_9, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_10, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_11, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_12, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_13, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_14, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_15, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_16, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_17, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_18, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_19, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_20, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_21, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_22, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_23, " +
							 " (select NVL(Sum(l.Quantity),0)  " +
							 " from sorder k , sorddet l where  k.status not in ('C','X','H')  " +
							 " and k.sale_order=l.sale_order " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_24 " +
							 " from site o  where facility_code='"+facilityCode+"' "+getSiteCode(sessionUserLevel, sessionSiteCode); 
							 

					
					pstmt = conn.prepareStatement(sql);
					rs    = pstmt.executeQuery();
					LinkedHashMap<Integer, String> shipMap = null;
					Map<String, LinkedHashMap<Integer, String>> siteCodeMap = new LinkedHashMap<String, LinkedHashMap<Integer,String>>();
					
					
					
					
					while(rs.next())
					{
						
						shipMap = new LinkedHashMap<Integer, String>();
						
						shipMap.put(1, rs.getString("SHIP_1").trim());
						shipMap.put(2, rs.getString("SHIP_2").trim());
						shipMap.put(3, rs.getString("SHIP_3").trim());
						shipMap.put(4, rs.getString("SHIP_4").trim());

						shipMap.put(5, rs.getString("SHIP_5").trim());
						shipMap.put(6, rs.getString("SHIP_6").trim());
						shipMap.put(7, rs.getString("SHIP_7").trim());
						shipMap.put(8, rs.getString("SHIP_8").trim());

						shipMap.put(9,  rs.getString("SHIP_9").trim());
						shipMap.put(10, rs.getString("SHIP_10").trim());
						shipMap.put(11, rs.getString("SHIP_11").trim());
						shipMap.put(12, rs.getString("SHIP_12").trim());

						shipMap.put(13, rs.getString("SHIP_13").trim());
						shipMap.put(14, rs.getString("SHIP_14").trim());
						shipMap.put(15, rs.getString("SHIP_15").trim());
						shipMap.put(16, rs.getString("SHIP_16").trim());

						shipMap.put(17, rs.getString("SHIP_17").trim());
						shipMap.put(18, rs.getString("SHIP_18").trim());
						shipMap.put(19, rs.getString("SHIP_19").trim());
						shipMap.put(20, rs.getString("SHIP_20").trim());

						shipMap.put(21, rs.getString("SHIP_21").trim());
						shipMap.put(22, rs.getString("SHIP_22").trim());
						shipMap.put(23, rs.getString("SHIP_23").trim());
						shipMap.put(24, rs.getString("SHIP_24").trim());
						
						shipMap.put(25, rs.getString("PICK_1").trim());
						shipMap.put(26, rs.getString("PICK_2").trim());
						shipMap.put(27, rs.getString("PICK_3").trim());
						shipMap.put(28, rs.getString("PICK_4").trim());

						shipMap.put(29, rs.getString("PICK_5").trim());
						shipMap.put(30, rs.getString("PICK_6").trim());
						shipMap.put(31, rs.getString("PICK_7").trim());
						shipMap.put(32, rs.getString("PICK_8").trim());

						shipMap.put(33,  rs.getString("PICK_9").trim());
						shipMap.put(34, rs.getString("PICK_10").trim());
						shipMap.put(35, rs.getString("PICK_11").trim());
						shipMap.put(36, rs.getString("PICK_12").trim());

						shipMap.put(37, rs.getString("PICK_13").trim());
						shipMap.put(38, rs.getString("PICK_14").trim());
						shipMap.put(39, rs.getString("PICK_15").trim());
						shipMap.put(40, rs.getString("PICK_16").trim());

						shipMap.put(41, rs.getString("PICK_17").trim());
						shipMap.put(42, rs.getString("PICK_18").trim());
						shipMap.put(43, rs.getString("PICK_19").trim());
						shipMap.put(44, rs.getString("PICK_20").trim());

						shipMap.put(45, rs.getString("PICK_21").trim());
						shipMap.put(46, rs.getString("PICK_22").trim());
						shipMap.put(47, rs.getString("PICK_23").trim());
						shipMap.put(48, rs.getString("PICK_24").trim());
						
						siteCode = rs.getString("site_code").trim();
						siteDescr = rs.getString("descr").trim();
						siteCodeMap.put(siteCode+"( "+ siteDescr +" )" , shipMap);
					}
					System.out.println("*********** siteCodeMap in detail************** :"+siteCodeMap.toString());
					for(Map.Entry<String, LinkedHashMap<Integer, String>> entry : siteCodeMap.entrySet())
					{

						LinkedHashMap<Integer, String> tempMap = siteCodeMap.get(entry.getKey());
						rawDataWarehouseEffSummaryQtyJson = new JSONObject();
						count = 0;
						for(Map.Entry<Integer, String> entry1:tempMap.entrySet())
						{
							if(entry1.getKey()<=24)
							{
								rowData = new JSONObject();
								rowData.put("hour", entry1.getKey());
								rowData.put("ship", entry1.getValue());
								rowData.put("pick", tempMap.get(entry1.getKey()+24));
								rawDataWarehouseEffSummaryQtyJson.put(count, rowData);
								count++;
							}
						}
						rawDataWarehouseEffSummQtyJsonOuter.put(entry.getKey(), rawDataWarehouseEffSummaryQtyJson);
					}		  			 	
				 }
			
				 }catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffDetQty:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehouseEffSummQtyJsonOuter;
		}
		/*Ended method for Warehouse Efficiency Card Quantity DRILLDOWN by Nikhil on dated 07102016*/
		
	
	
 /*Added method for Warehouse Efficiency card Value Summary by Nikhil on dated 06102016*/
		
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffSummValue(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
		{
			JSONObject rawDataWarehouseEffValueSummaryJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffSummValue Method ****************** ");
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffSummValue :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{
				
					sql =    " Select  " +
							 " sum(ship_1) as ship_1 " +
							 " ,sum(ship_2) as ship_2 " +
							 " ,sum(ship_3) as ship_3 " +
							 " ,sum(ship_4) as ship_4 " +
							 " ,sum(ship_5) as ship_5 " +
							 " ,sum(ship_6) as ship_6 " +
							 " ,sum(ship_7) as ship_7 " +
							 " ,sum(ship_8) as ship_8 " +
							 " ,sum(ship_9) as ship_9 " +
							 " ,sum(ship_10) as ship_10 " +
							 " ,sum(ship_11) as ship_11 " +
							 " ,sum(ship_12) as ship_12 " +
							 " ,sum(ship_13) as ship_13 " +
							 " ,sum(ship_14) as ship_14 " +
							 " ,sum(ship_15) as ship_15 " +
							 " ,sum(ship_16) as ship_16 " +
							 " ,sum(ship_17) as ship_17 " +
							 " ,sum(ship_18) as ship_18 " +
							 " ,sum(ship_19) as ship_19 " +
							 " ,sum(ship_20) as ship_20 " +
							 " ,sum(ship_21) as ship_21 " +
							 " ,sum(ship_22) as ship_22 " +
							 " ,sum(ship_23) as ship_23 " +
							 " ,sum(ship_24) as ship_24 " +
							 " ,sum(pick_1) as pick_1 " +
							 " ,sum(pick_2) as pick_2 " +
							 " ,sum(pick_3) as pick_3 " +
							 " ,sum(pick_4) as pick_4 " +
							 " ,sum(pick_5) as pick_5 " +
							 " ,sum(pick_6) as pick_6 " +
							 " ,sum(pick_7) as pick_7 " +
							 " ,sum(pick_8) as pick_8 " +
							 " ,sum(pick_9) as pick_9 " +
							 " ,sum(pick_10) as pick_10 " +
							 " ,sum(pick_11) as pick_11 " +
							 " ,sum(pick_12) as pick_12 " +
							 " ,sum(pick_13) as pick_13 " +
							 " ,sum(pick_14) as pick_14 " +
							 " ,sum(pick_15) as pick_15 " +
							 " ,sum(pick_16) as pick_16 " +
							 " ,sum(pick_17) as pick_17 " +
							 " ,sum(pick_18) as pick_18 " +
							 " ,sum(pick_19) as pick_19 " +
							 " ,sum(pick_20) as pick_20 " +
							 " ,sum(pick_21) as pick_21 " +
							 " ,sum(pick_22) as pick_22 " +
							 " ,sum(pick_23) as pick_23 " +
							 " ,sum(pick_24) as pick_24 " +
							 " from( " +
							 " select site_code,descr, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
							 " and b.Confirmed='Y' ) ship_1, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
							 " and b.Confirmed='Y' ) ship_2, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
							 " and b.Confirmed='Y' ) ship_3, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
							 " and b.Confirmed='Y' ) ship_4, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
							 " and b.Confirmed='Y' ) ship_5, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
							 " and b.Confirmed='Y' ) ship_6, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
							 " and b.Confirmed='Y' ) ship_7, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
							 " and b.Confirmed='Y' ) ship_8, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
							 " and b.Confirmed='Y' ) ship_9, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
							 " and b.Confirmed='Y' ) ship_10, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
							 " and b.Confirmed='Y' ) ship_11, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
							 " and b.Confirmed='Y' ) ship_12, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
							 " and b.Confirmed='Y' ) ship_13, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
							 " and b.Confirmed='Y' ) ship_14, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
							 " and b.Confirmed='Y' ) ship_15, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
							 " and b.Confirmed='Y' ) ship_16, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
							 " and b.Confirmed='Y' ) ship_17, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
							 " and b.Confirmed='Y' ) ship_18, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
							 " and b.Confirmed='Y' ) ship_19, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
							 " and b.Confirmed='Y' ) ship_20, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
							 " and b.Confirmed='Y' ) ship_21, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
							 " and b.Confirmed='Y' ) ship_22, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
							 " and b.Confirmed='Y' ) ship_23, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
							 " and b.Confirmed='Y' ) ship_24, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_1, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_2, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_3, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_4, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_5, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_6, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_7, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_8, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_9, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_10, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_11, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_12, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_13, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_14, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_15, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_16, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_17, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_18, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_19, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_20, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_21, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_22, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_23, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_24 " +
							 " from site o  where facility_code='"+facilityCode+"' "+ getSiteCode(sessionUserLevel, sessionSiteCode) +
							 " ) " ;
							 

					
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				HashMap<Integer, String> shipMap = new HashMap<Integer, String>();
				HashMap<Integer, String> pickMap = new HashMap<Integer, String>();
				while(rs.next())
				{
					
					shipMap.put(1, rs.getString("SHIP_1").trim());
					shipMap.put(2, rs.getString("SHIP_2").trim());
					shipMap.put(3, rs.getString("SHIP_3").trim());
					shipMap.put(4, rs.getString("SHIP_4").trim());

					shipMap.put(5, rs.getString("SHIP_5").trim());
					shipMap.put(6, rs.getString("SHIP_6").trim());
					shipMap.put(7, rs.getString("SHIP_7").trim());
					shipMap.put(8, rs.getString("SHIP_8").trim());

					shipMap.put(9,  rs.getString("SHIP_9").trim());
					shipMap.put(10, rs.getString("SHIP_10").trim());
					shipMap.put(11, rs.getString("SHIP_11").trim());
					shipMap.put(12, rs.getString("SHIP_12").trim());

					shipMap.put(13, rs.getString("SHIP_13").trim());
					shipMap.put(14, rs.getString("SHIP_14").trim());
					shipMap.put(15, rs.getString("SHIP_15").trim());
					shipMap.put(16, rs.getString("SHIP_16").trim());

					shipMap.put(17, rs.getString("SHIP_17").trim());
					shipMap.put(18, rs.getString("SHIP_18").trim());
					shipMap.put(19, rs.getString("SHIP_19").trim());
					shipMap.put(20, rs.getString("SHIP_20").trim());

					shipMap.put(21, rs.getString("SHIP_21").trim());
					shipMap.put(22, rs.getString("SHIP_22").trim());
					shipMap.put(23, rs.getString("SHIP_23").trim());
					shipMap.put(24, rs.getString("SHIP_24").trim());
					
					pickMap.put(1, rs.getString("PICK_1").trim());
					pickMap.put(2, rs.getString("PICK_2").trim());
					pickMap.put(3, rs.getString("PICK_3").trim());
					pickMap.put(4, rs.getString("PICK_4").trim());

					pickMap.put(5, rs.getString("PICK_5").trim());
					pickMap.put(6, rs.getString("PICK_6").trim());
					pickMap.put(7, rs.getString("PICK_7").trim());
					pickMap.put(8, rs.getString("PICK_8").trim());

					pickMap.put(9,  rs.getString("PICK_9").trim());
					pickMap.put(10, rs.getString("PICK_10").trim());
					pickMap.put(11, rs.getString("PICK_11").trim());
					pickMap.put(12, rs.getString("PICK_12").trim());

					pickMap.put(13, rs.getString("PICK_13").trim());
					pickMap.put(14, rs.getString("PICK_14").trim());
					pickMap.put(15, rs.getString("PICK_15").trim());
					pickMap.put(16, rs.getString("PICK_16").trim());

					pickMap.put(17, rs.getString("PICK_17").trim());
					pickMap.put(18, rs.getString("PICK_18").trim());
					pickMap.put(19, rs.getString("PICK_19").trim());
					pickMap.put(20, rs.getString("PICK_20").trim());

					pickMap.put(21, rs.getString("PICK_21").trim());
					pickMap.put(22, rs.getString("PICK_22").trim());
					pickMap.put(23, rs.getString("PICK_23").trim());
					pickMap.put(24, rs.getString("PICK_24").trim());
					
				}
				for(Map.Entry<Integer, String> entry:shipMap.entrySet())
				{

					rowData = new JSONObject();
					rowData.put("hour", entry.getKey());
					rowData.put("ship", entry.getValue());
					rowData.put("pick", pickMap.get(entry.getKey()));
					rawDataWarehouseEffValueSummaryJson.put(count, rowData);
					count++;
					
				}	
				System.out.println("********** rawDataWarehouseEffValueSummaryJson :"+rawDataWarehouseEffValueSummaryJson.toString());
			 }
				 	
			}catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffSummValue:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehouseEffValueSummaryJson;
		}
		/*Ended method for Warehouse Efficiency card Value Summary  by Nikhil on dated 06102016*/
		
		/**
		 * Create Warehouse Efficiency card Summary dashboard display in line
		 * @author base
		 * @return JsonObject
		 * */
	
	/*Added method for Warehouse Efficiency card Deatil Value rate DRILLDOWN by Nikhil on dated 07102016*/
		
		@SuppressWarnings("unchecked")
		@Override
	public JSONObject getWarehouseEffDetValue(String facilityCode,String businessType,String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
		{
			JSONObject rawDataWarehEffSummDetJsonOuter = new JSONObject();
			JSONObject rawDataWarehouseEffDetSummaryJson = new JSONObject();
			JSONObject rowData             = null;
			String sql                     = "";
			String  siteCode               = "";
			ResultSet rs                   = null;
			PreparedStatement pstmt        = null;
			Connection conn                = null;
			ConnDriver connDriver          = new ConnDriver();
			int count = 0;	
			String siteDescr = "";
			try
			{
				System.out.println("********** In WMS3PLSummDtlDashboard : getWarehouseEffDetValue Method ****************** ");
				conn= connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				/*facilityCode = "FC001";
				businessType = "T";*/
				String appendSql = "";
				if(businessType.length()>0)
				{
					appendSql = " and its.business_type ='"+businessType+"' ";
				}
				if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
				{
					
					facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
					System.out.println("facilityCode from session getWarehouseEffDetValue :"+facilityCode);
				}
				if (facilityCode!= null && facilityCode.trim().length()>0)
				{			
				
					sql =  " select site_code,descr, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  between 0 and 1 " +
							 " and b.Confirmed='Y' ) ship_1, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >1 and to_number(to_char(b.conf_date,'HH'))<= 2 " +
							 " and b.Confirmed='Y' ) ship_2, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >2 and to_number(to_char(b.conf_date,'HH'))<=  3 " +
							 " and b.Confirmed='Y' ) ship_3, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >3 and to_number(to_char(b.conf_date,'HH'))<= 4 " +
							 " and b.Confirmed='Y' ) ship_4, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >4 and to_number(to_char(b.conf_date,'HH'))<= 5 " +
							 " and b.Confirmed='Y' ) ship_5, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >5 and to_number(to_char(b.conf_date,'HH'))<= 6 " +
							 " and b.Confirmed='Y' ) ship_6, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >6 and to_number(to_char(b.conf_date,'HH'))<=7 " +
							 " and b.Confirmed='Y' ) ship_7, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >7 and to_number(to_char(b.conf_date,'HH'))<= 8 " +
							 " and b.Confirmed='Y' ) ship_8, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >8 and to_number(to_char(b.conf_date,'HH'))<= 9 " +
							 " and b.Confirmed='Y' ) ship_9, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >9 and to_number(to_char(b.conf_date,'HH'))<= 10 " +
							 " and b.Confirmed='Y' ) ship_10, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >10 and to_number(to_char(b.conf_date,'HH'))<= 11 " +
							 " and b.Confirmed='Y' ) ship_11, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >11 and to_number(to_char(b.conf_date,'HH'))<= 12 " +
							 " and b.Confirmed='Y' ) ship_12, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >12 and to_number(to_char(b.conf_date,'HH'))<= 13 " +
							 " and b.Confirmed='Y' ) ship_13, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >13 and to_number(to_char(b.conf_date,'HH'))<= 14 " +
							 " and b.Confirmed='Y' ) ship_14, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >14 and to_number(to_char(b.conf_date,'HH'))<= 15 " +
							 " and b.Confirmed='Y' ) ship_15, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >15 and to_number(to_char(b.conf_date,'HH'))<= 16 " +
							 " and b.Confirmed='Y' ) ship_16, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >16 and to_number(to_char(b.conf_date,'HH'))<= 17 " +
							 " and b.Confirmed='Y' ) ship_17, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >17 and to_number(to_char(b.conf_date,'HH'))<= 18 " +
							 " and b.Confirmed='Y' ) ship_18, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >18 and to_number(to_char(b.conf_date,'HH'))<= 19 " +
							 " and b.Confirmed='Y' ) ship_19, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >19 and to_number(to_char(b.conf_date,'HH'))<= 20 " +
							 " and b.Confirmed='Y' ) ship_20, " +
							 " (Select NVL(Sum(b.NET_AMT),0)  " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >20 and to_number(to_char(b.conf_date,'HH'))<= 21 " +
							 " and b.Confirmed='Y' ) ship_21, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >21 and to_number(to_char(b.conf_date,'HH'))<= 22 " +
							 " and b.Confirmed='Y' ) ship_22, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >22 and to_number(to_char(b.conf_date,'HH'))<= 23 " +
							 " and b.Confirmed='Y' ) ship_23, " +
							 " (Select NVL(Sum(b.NET_AMT),0) " +
							 " from invoice b, itemser its where b.site_code = o.site_code " +
							 " and b.item_ser = its.item_ser "+appendSql+" " +
							 " and b.conf_date = sysdate " +
							 " AND to_number(to_char(b.conf_date,'HH'))  >23 and to_number(to_char(b.conf_date,'HH'))<= 24 " +
							 " and b.Confirmed='Y' ) ship_24, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  between 0 and 1 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_1, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >1 and to_number(to_char(HDR.conf_date,'HH'))<= 2 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_2, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >2 and to_number(to_char(HDR.conf_date,'HH'))<= 3 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_3, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >3 and to_number(to_char(HDR.conf_date,'HH'))<= 4 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_4, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >4 and to_number(to_char(HDR.conf_date,'HH'))<= 5 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_5, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >5 and to_number(to_char(HDR.conf_date,'HH'))<= 6 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_6, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >6 and to_number(to_char(HDR.conf_date,'HH'))<= 7 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_7, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >7 and to_number(to_char(HDR.conf_date,'HH'))<= 8 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_8, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >8 and to_number(to_char(HDR.conf_date,'HH'))<= 9 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_9, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >9 and to_number(to_char(HDR.conf_date,'HH'))<= 10 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_10, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >10 and to_number(to_char(HDR.conf_date,'HH'))<= 11 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_11, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >11 and to_number(to_char(HDR.conf_date,'HH'))<= 12 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_12, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >12 and to_number(to_char(HDR.conf_date,'HH'))<= 13 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_13, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >13 and to_number(to_char(HDR.conf_date,'HH'))<= 14 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_14, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >14 and to_number(to_char(HDR.conf_date,'HH'))<= 15 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_15, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >15 and to_number(to_char(HDR.conf_date,'HH'))<= 16 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_16, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >16 and to_number(to_char(HDR.conf_date,'HH'))<= 17 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_17, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >17 and to_number(to_char(HDR.conf_date,'HH'))<= 18 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_18, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >18 and to_number(to_char(HDR.conf_date,'HH'))<= 19 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_19, " +
							 " (select NVL(Sum(k.TOT_AMT),0)  " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >19 and to_number(to_char(HDR.conf_date,'HH'))<= 20 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_20, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >20 and to_number(to_char(HDR.conf_date,'HH'))<= 21 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_21, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >21 and to_number(to_char(HDR.conf_date,'HH'))<= 22 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_22, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >22 and to_number(to_char(HDR.conf_date,'HH'))<= 23 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_23, " +
							 " (select NVL(Sum(k.TOT_AMT),0) " +
							 " from sorder k where  k.status not in ('C','X','H')  " +
							 " and k.sale_order in  " +
							 " (select distinct sale_order  " +
							 " from wave_task_det,Wave_task  " +
							 " where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and  " +
							 " exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
							 " where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
							 " and HDR.conf_date= sysdate " +
							 " AND to_number(to_char(HDR.conf_date,'HH'))  >23 and to_number(to_char(HDR.conf_date,'HH'))<= 24 And Hdr.Confirmed = 'Y'))  " +
							 " and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y')  " +
							 " and k.site_code = o.site_code ) pick_24 " +
							 " from site o  where facility_code='"+facilityCode+"' "+getSiteCode(sessionUserLevel, sessionSiteCode); 

					pstmt = conn.prepareStatement(sql);
					rs    = pstmt.executeQuery();
					LinkedHashMap<Integer, String> shipMap = null;
					Map<String, LinkedHashMap<Integer, String>> siteCodeMap = new LinkedHashMap<String, LinkedHashMap<Integer,String>>();
					
					
					
					
					while(rs.next())
					{
						
						shipMap = new LinkedHashMap<Integer, String>();
						
						shipMap.put(1, rs.getString("SHIP_1").trim());
						shipMap.put(2, rs.getString("SHIP_2").trim());
						shipMap.put(3, rs.getString("SHIP_3").trim());
						shipMap.put(4, rs.getString("SHIP_4").trim());

						shipMap.put(5, rs.getString("SHIP_5").trim());
						shipMap.put(6, rs.getString("SHIP_6").trim());
						shipMap.put(7, rs.getString("SHIP_7").trim());
						shipMap.put(8, rs.getString("SHIP_8").trim());

						shipMap.put(9,  rs.getString("SHIP_9").trim());
						shipMap.put(10, rs.getString("SHIP_10").trim());
						shipMap.put(11, rs.getString("SHIP_11").trim());
						shipMap.put(12, rs.getString("SHIP_12").trim());

						shipMap.put(13, rs.getString("SHIP_13").trim());
						shipMap.put(14, rs.getString("SHIP_14").trim());
						shipMap.put(15, rs.getString("SHIP_15").trim());
						shipMap.put(16, rs.getString("SHIP_16").trim());

						shipMap.put(17, rs.getString("SHIP_17").trim());
						shipMap.put(18, rs.getString("SHIP_18").trim());
						shipMap.put(19, rs.getString("SHIP_19").trim());
						shipMap.put(20, rs.getString("SHIP_20").trim());

						shipMap.put(21, rs.getString("SHIP_21").trim());
						shipMap.put(22, rs.getString("SHIP_22").trim());
						shipMap.put(23, rs.getString("SHIP_23").trim());
						shipMap.put(24, rs.getString("SHIP_24").trim());
						
						shipMap.put(25, rs.getString("PICK_1").trim());
						shipMap.put(26, rs.getString("PICK_2").trim());
						shipMap.put(27, rs.getString("PICK_3").trim());
						shipMap.put(28, rs.getString("PICK_4").trim());

						shipMap.put(29, rs.getString("PICK_5").trim());
						shipMap.put(30, rs.getString("PICK_6").trim());
						shipMap.put(31, rs.getString("PICK_7").trim());
						shipMap.put(32, rs.getString("PICK_8").trim());

						shipMap.put(33,  rs.getString("PICK_9").trim());
						shipMap.put(34, rs.getString("PICK_10").trim());
						shipMap.put(35, rs.getString("PICK_11").trim());
						shipMap.put(36, rs.getString("PICK_12").trim());

						shipMap.put(37, rs.getString("PICK_13").trim());
						shipMap.put(38, rs.getString("PICK_14").trim());
						shipMap.put(39, rs.getString("PICK_15").trim());
						shipMap.put(40, rs.getString("PICK_16").trim());

						shipMap.put(41, rs.getString("PICK_17").trim());
						shipMap.put(42, rs.getString("PICK_18").trim());
						shipMap.put(43, rs.getString("PICK_19").trim());
						shipMap.put(44, rs.getString("PICK_20").trim());

						shipMap.put(45, rs.getString("PICK_21").trim());
						shipMap.put(46, rs.getString("PICK_22").trim());
						shipMap.put(47, rs.getString("PICK_23").trim());
						shipMap.put(48, rs.getString("PICK_24").trim());
						
						siteCode = rs.getString("site_code").trim();
						siteDescr = rs.getString("descr").trim();
						siteCodeMap.put(siteCode+"( "+ siteDescr +" )" , shipMap);
					}
					System.out.println("*********** siteCodeMap in detail************** :"+siteCodeMap.toString());
					for(Map.Entry<String, LinkedHashMap<Integer, String>> entry : siteCodeMap.entrySet())
					{

						LinkedHashMap<Integer, String> tempMap = siteCodeMap.get(entry.getKey());
						rawDataWarehouseEffDetSummaryJson = new JSONObject();
						count = 0;
						for(Map.Entry<Integer, String> entry1:tempMap.entrySet())
						{
							if(entry1.getKey()<=24)
							{
								rowData = new JSONObject();
								rowData.put("hour", entry1.getKey());
								rowData.put("ship", entry1.getValue());
								rowData.put("pick", tempMap.get(entry1.getKey()+24));
								rawDataWarehouseEffDetSummaryJson.put(count, rowData);
								count++;
							}
						}
						rawDataWarehEffSummDetJsonOuter.put(entry.getKey(), rawDataWarehouseEffDetSummaryJson);
					}		  			 	
				 }
			
				 }catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :getWarehouseEffDetValue:" + d.getMessage());
					throw new ITMException(d);
				}
			}		
			return rawDataWarehEffSummDetJsonOuter;
		}
		/*Ended method for Warehouse Efficiency Card Value DRILLDOWN by Nikhil on dated 07102016*/
		
	
	
	/**
	 * Create OrderStatus summary dashboard display in Stack Chart with Order Wise 
	 * @author base
	 * @return JsonObject
	 * */
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryStack(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException
	{
		JSONObject rawDataOrderStatusSummStackJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryStack Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			
	        /*facilityCode = "FC001";
			businessType = "T";*/
			
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryStack :"+facilityCode);
			}
			
			if(facilityCode!=null && facilityCode.trim().length()>0)
			{
				sql = " select " +
					" sum(OpenOrder) as OpenOrder " +
					" ,sum(PrvOpenOrder) as PrvOpenOrder " +
					" ,sum(PriorOpenOrder) as PriorOpenOrder " +
					" ,sum(Shipped) as Shipped " +
					" ,sum(waved) as Waved " +
					" ,sum(Picked) as Picked " +
					" ,sum(Packed) as Packed " +
					" ,sum(WaitingforConfirmation) as WaitingConfirmation " +
					" ,sum(Credit_Hold) as Credit_Hold " +
					" ,sum(Cancel) as Canceled " +
					" ,sum(Hold) as Hold " +
					" ,sum(waitingforWave) as WaitingWave " +
					" ,sum(StockOut) as StockOut " +
					" from " +
					" ( " +
					" select site_code ,  " +
					" site_descr " +
					" , nvl(OpenOrder,0) as OpenOrder  " +
					" , nvl(PrvOpenOrder,0) as PrvOpenOrder  " +
					" , nvl(PriorOpenOrder,0) as PriorOpenOrder  " +
					" , nvl(Shipped,0) as Shipped  " +
					" ,nvl(Waved,0) as Waved, " +
					" nvl(Picked,0) as Picked " +
					" , nvl(Packed,0) as Packed  " +
					" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
					" ,nvl(Credit_Hold,0) as Credit_Hold " +
					" ,nvl(Cancel,0) as Cancel " +
					" ,nvl(Hold,0) as Hold " +
					" ,nvl(WaitingforWave,0) as WaitingforWave " +
					" ,nvl(StockOut,0) as StockOut " +
					" from  " +
					" ( " +
					" select site_code as site_code,descr as site_descr, " +
					" ( " +
					" select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" (Select count(distinct b.sale_order) from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and " +
					" b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select count(sale_order) " +
					" from sorder k, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select count(sale_order) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select count(sale_order) " +
					" from sorder k, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select count(a.sale_order) from sorder a, itemser its " +
					" where a.due_date <=sysdate and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select count(distinct c.sale_order) " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold, " +
					" ( Select  count(e.sale_order) from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select  count(e.sale_order) from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select count(sale_order) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') and k.confirmed = 'Y' " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order not in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" (  select count(fn_chk_stk_available(a.sale_order)) from sorder a, itemser its " +
					" where a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" and a.status not in ('C','X','H') and a.confirmed = 'Y' " +
					" ) as StockOut " +
					" from site o  where facility_code = '"+facilityCode+"' " + getSiteCode(sessionUserLevel, sessionSiteCode)+
					" ) ) ";


			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					/*For OpenOrder*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					System.out.println("rawDataOrderStatusSummStackJson :"+rawDataOrderStatusSummStackJson);
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :WMS3PLSummDtlDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackJson;
	}	
	
	
	/**
	 * Create OrderStatus detail dashboard display in Stack Chart  with Order Wise
	 * @author base
	 * @return JsonObject
	 * */
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlStack(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode,String sessionUserLevel) throws RemoteException, ITMException
	{
		JSONObject rawDataOrderStatusSummStackJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummStackJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlStack Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr ="";
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlStack :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = "  select site_code ,  " +
					" site_descr " +
					" , nvl(OpenOrder,0) as OpenOrder  " +
					" , nvl(PrvOpenOrder,0) as PrvOpenOrder  " +
					" , nvl(PriorOpenOrder,0) as PriorOpenOrder  " +
					" , nvl(Shipped,0) as Shipped  " +
					" , nvl(Waved,0) as Waved " +
					" , nvl(Picked,0) as Picked " +
					" , nvl(Packed,0) as Packed  " +
					" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
					" ,nvl(Credit_Hold,0) as Credit_Hold " +
					" ,nvl(Cancel,0) as Canceled " +
					" ,nvl(Hold,0) as Hold " +
					" ,nvl(WaitingforWave,0) as WaitingforWave " +
					" ,nvl(StockOut,0) as StockOut " +
					" from  " +
					" ( " +
					" select site_code as site_code,descr as site_descr, " +
					" ( " +
					" select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select count(a.sale_order) from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X') " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" (Select count(distinct b.sale_order) from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and " +
					" b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select count(sale_order) " +
					" from sorder k, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select count(sale_order) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select count(sale_order) " +
					" from sorder k, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select count(a.sale_order) from sorder a, itemser its " +
					" where a.due_date <=sysdate and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select count(distinct c.sale_order) " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold, " +
					" ( Select  count(e.sale_order) from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select  count(e.sale_order) from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select count(sale_order) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') and k.confirmed = 'Y' " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order not in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" (  select count(fn_chk_stk_available(a.sale_order)) from sorder a, itemser its " +
					" where a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" and a.status not in ('C','X','H') and a.confirmed = 'Y' " +
					" ) as StockOut " +
					" from site o  where facility_code = '"+facilityCode+"' " +getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )  ";
			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					rawDataOrderStatusSummStackJson = new JSONObject();
					count = 0;
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					/*For OpenOrder*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("OpenOrder", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("OpenOrder", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("OpenOrder", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingforConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("OpenOrder", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("waitingforWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					System.out.println("rawDataOrderStatusSummStackJson :"+rawDataOrderStatusSummStackJson);
					rawDataOrderStatusSummStackJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummStackJson);
				}
			}
			System.out.println("rawDataOrderStatusSummStackJsonOuter :"+rawDataOrderStatusSummStackJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDtlStack :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackJsonOuter;
	}

	/**
	 * Create OrderStatus Summary dashboard display in Pie Chart  with Order Wise
	 * @author base
	 * @return JsonObject
	 * */
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryPie(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusSummPieJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryPie Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			
			//String siteCode ="";
			//String siteDescr ="";
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
	        System.out.println("frmDate :"+frmDate);
	        /*facilityCode = "FC001";
			businessType = "T";*/
	        if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryPie :"+facilityCode);
			}
	        
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select " +
						" sum(OpenOrder) as OpenOrder " +
						" ,sum(PrvOpenOrder) as PrvOpenOrder " +
						" ,sum(PriorOpenOrder) as PriorOpenOrder " +
						" ,sum(Shipped) as Shipped " +
						" ,sum(waved) as Waved " +
						" ,sum(Picked) as Picked " +
						" ,sum(Packed) as Packed " +
						" ,sum(WaitingforConfirmation) as WaitingConfirmation " +
						" ,sum(Credit_Hold) as Credit_Hold " +
						" ,sum(Cancel) as Canceled " +
						" ,sum(Hold) as Hold " +
						" ,sum(waitingforWave) as WaitingWave " +
						" ,sum(StockOut) as StockOut " +
						" from " +
						" ( " +
						" select site_code ,  " +
						" site_descr " +
						" , nvl(OpenOrder,0) as OpenOrder  " +
						" , nvl(PrvOpenOrder,0) as PrvOpenOrder  " +
						" , nvl(PriorOpenOrder,0) as PriorOpenOrder  " +
						" , nvl(Shipped,0) as Shipped  " +
						" ,nvl(Waved,0) as Waved, " +
						" nvl(Picked,0) as Picked " +
						" , nvl(Packed,0) as Packed  " +
						" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
						" ,nvl(Credit_Hold,0) as Credit_Hold " +
						" ,nvl(Cancel,0) as Cancel " +
						" ,nvl(Hold,0) as Hold " +
						" ,nvl(WaitingforWave,0) as WaitingforWave " +
						" ,nvl(StockOut,0) as StockOut " +
						" from  " +
						" ( " +
						" select site_code as site_code,descr as site_descr, " +
						" ( " +
						" select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as OpenOrder, " +
						" (select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PrvOpenOrder, " +
						" (select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PriorOpenOrder, " +
						" (Select count(distinct b.sale_order) from invoice b, itemser its " +
						" where b.site_code = o.site_code " +
						" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and " +
						" b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
						" )  as Shipped, " +
						" (select count(sale_order) " +
						" from sorder k, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
						" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
						" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Waved, " +
						" (select count(sale_order) " +
						" from sorder k,itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Picked, " +
						" (select count(sale_order) " +
						" from sorder k, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
						" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
						" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Packed, " +
						" ( select count(a.sale_order) from sorder a, itemser its " +
						" where a.due_date <=sysdate and confirmed='N' " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as WaitingforConfirmation,  " +
						" ( Select count(distinct c.sale_order) " +
						" from business_logic_check c,Sorder d, itemser its " +
						" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and d.item_ser = its.item_ser "+appendSql+" " +
						" )  as Credit_Hold, " +
						" ( Select  count(e.sale_order) from sorder  e, itemser its " +
						" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Cancel, " +
						" ( Select  count(e.sale_order) from sorder  e, itemser its " +
						" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Hold, " +
						" (select count(sale_order) " +
						" from sorder k,itemser its where  k.status not in ('C','X','H') and k.confirmed = 'Y' " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order not in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and k.site_code = o.Site_code " +
						" ) WaitingforWave, " +
						" (  select count(fn_chk_stk_available(a.sale_order)) from sorder a, itemser its " +
						" where a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" and a.status not in ('C','X','H') and a.confirmed = 'Y' " +
						" ) as StockOut " +
						" from site o  where facility_code = '"+facilityCode+"' " + getSiteCode(sessionUserLevel, sessionSiteCode)+
						" ) ) ";
			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					
					rawJson = new JSONObject();
					rawJson.put("status", "Current Month");
					rawJson.put("value", rs.getString("OpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Previous Month");
					rawJson.put("value", rs.getString("PrvOpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Prior Months");
					rawJson.put("value", rs.getString("PriorOpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Shipped");
					rawJson.put("value", rs.getString("Shipped"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waved");
					rawJson.put("value", rs.getString("Waved"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Picked");
					rawJson.put("value", rs.getString("Picked"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Packed");
					rawJson.put("value", rs.getString("Packed"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting for Confirmation");
					rawJson.put("value", rs.getString("WaitingConfirmation"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Credit Hold");
					rawJson.put("value", rs.getString("Credit_Hold"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
	
					rawJson = new JSONObject();
					rawJson.put("status", "Canceled");
					rawJson.put("value", rs.getString("Canceled"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Hold");
					rawJson.put("value", rs.getString("Hold"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
				
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting for Wave");
					rawJson.put("value", rs.getString("WaitingWave"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Stock Out");
					rawJson.put("value", rs.getString("StockOut"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
				
					System.out.println("rawDataOrderStatusSummPieJson :"+rawDataOrderStatusSummPieJson);
					
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusSummaryPie:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieJson;
	}

	/**
	 * Create OrderStatus Detail dashboard display in Pie Chart  with Order Wise
	 * @author base
	 * @return JsonObject
	 * */
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlPie(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException
	{
		JSONObject rawDataOrderStatusSummPieJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummPieJson = null;
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//LinkedHashMap<String, String> catValues = null;
		//DashboardUtility dashboardUtility = null;
		int openOrder = 0;
		int shipment = 0;
		int picked = 0;
		int packed = 0;
		int waved = 0;
		int waitingForConf = 0;
		int creditHold = 0;
		int canceled = 0;
		int hold = 0;
		int waitingForWave = 0; 
		int stockOut = 0;
		int prvTotalOrder = 0;
		int priorTotalOrder = 0;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlPie Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr = "";
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			String appendSql = "";
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlPie :"+facilityCode);
			}
	        /*facilityCode = "FC001";
			businessType = "T";*/
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
	        	sql = "  select site_code ,  " +
						" site_descr " +
						" , nvl(OpenOrder,0) as OpenOrder  " +
						" , nvl(PrvOpenOrder,0) as PrvOpenOrder  " +
						" , nvl(PriorOpenOrder,0) as PriorOpenOrder  " +
						" , nvl(Shipped,0) as Shipped  " +
						" , nvl(Waved,0) as Waved " +
						" , nvl(Picked,0) as Picked " +
						" , nvl(Packed,0) as Packed  " +
						" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
						" ,nvl(Credit_Hold,0) as Credit_Hold " +
						" ,nvl(Cancel,0) as Canceled " +
						" ,nvl(Hold,0) as Hold " +
						" ,nvl(WaitingforWave,0) as WaitingforWave " +
						" ,nvl(StockOut,0) as StockOut " +
						" from  " +
						" ( " +
						" select site_code as site_code,descr as site_descr, " +
						" ( " +
						" select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as OpenOrder, " +
						" (select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PrvOpenOrder, " +
						" (select count(a.sale_order) from sorder a, itemser its " +
						" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X') " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PriorOpenOrder, " +
						" (Select count(distinct b.sale_order) from invoice b, itemser its " +
						" where b.site_code = o.site_code " +
						" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and " +
						" b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
						" )  as Shipped, " +
						" (select count(sale_order) " +
						" from sorder k, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
						" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
						" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Waved, " +
						" (select count(sale_order) " +
						" from sorder k,itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Picked, " +
						" (select count(sale_order) " +
						" from sorder k, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
						" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
						" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Packed, " +
						" ( select count(a.sale_order) from sorder a, itemser its " +
						" where a.due_date <=sysdate and confirmed='N' " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as WaitingforConfirmation,  " +
						" ( Select count(distinct c.sale_order) " +
						" from business_logic_check c,Sorder d, itemser its " +
						" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and d.item_ser = its.item_ser "+appendSql+" " +
						" )  as Credit_Hold, " +
						" ( Select  count(e.sale_order) from sorder  e, itemser its " +
						" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Cancel, " +
						" ( Select  count(e.sale_order) from sorder  e, itemser its " +
						" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Hold, " +
						" (select count(sale_order) " +
						" from sorder k,itemser its where  k.status not in ('C','X','H') and k.confirmed = 'Y' " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order not in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and k.site_code = o.Site_code " +
						" ) WaitingforWave, " +
						" (  select count(fn_chk_stk_available(a.sale_order)) from sorder a, itemser its " +
						" where a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" and a.status not in ('C','X','H') and a.confirmed = 'Y' " +
						" ) as StockOut " +
						" from site o  where facility_code = '"+facilityCode+"' " +getSiteCode(sessionUserLevel, sessionSiteCode)+
						" )  ";
			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					rawDataOrderStatusSummPieJson = new JSONObject();
					count = 0;
					
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					
					openOrder = rs.getInt("OpenOrder");
					prvTotalOrder = rs.getInt("PrvOpenOrder");
					priorTotalOrder = rs.getInt("PriorOpenOrder");
					shipment = rs.getInt("Shipped");
					picked = rs.getInt("Picked");
					packed = rs.getInt("Packed");
					waved = rs.getInt("Waved");
					waitingForConf = rs.getInt("WaitingforConfirmation");
					creditHold = rs.getInt("Credit_Hold");
					canceled = rs.getInt("Canceled");
					hold = rs.getInt("Hold");
					waitingForWave = rs.getInt("WaitingforWave");
					stockOut = rs.getInt("StockOut");
					
					
					if(openOrder ==0 && prvTotalOrder ==0 && priorTotalOrder ==0 && shipment == 0 && picked == 0 && packed == 0 && waved == 0 && waitingForConf == 0 
							&& creditHold== 0 && canceled== 0 && hold== 0 && waitingForWave== 0 && stockOut == 0 )
					{
						rawJson = new JSONObject();
						rawJson.put("status", "No Data");
						rawJson.put("value", 1);
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
					}else
					{
					
						rawJson = new JSONObject();
						rawJson.put("status", "Current Month");
						rawJson.put("value", rs.getString("OpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						rawJson = new JSONObject();
						rawJson.put("status", "Previous Month");
						rawJson.put("value", rs.getString("PrvOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						rawJson = new JSONObject();
						rawJson.put("status", "Prior Months");
						rawJson.put("value", rs.getString("PriorOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Shipped");
						rawJson.put("value", rs.getString("Shipped"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Picked");
						rawJson.put("value", rs.getString("Picked"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Packed");
						rawJson.put("value", rs.getString("Packed"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Waved");
						rawJson.put("value", rs.getString("Waved"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Waiting for Confirmation");
						rawJson.put("value", rs.getString("WaitingforConfirmation"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Credit Hold");
						rawJson.put("value", rs.getString("Credit_Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
		
						rawJson = new JSONObject();
						rawJson.put("status", "Canceled");
						rawJson.put("value", rs.getString("Canceled"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Hold");
						rawJson.put("value", rs.getString("Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					
						rawJson = new JSONObject();
						rawJson.put("status", "Waiting for Wave");
						rawJson.put("value", rs.getString("waitingforWave"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Stock Out");
						rawJson.put("value", rs.getString("StockOut"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					}
					rawDataOrderStatusSummPieJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummPieJson);
				}
			}
			System.out.println("rawDataOrderStatusSummPieJsonOuter :"+rawDataOrderStatusSummPieJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDtlPie :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieJsonOuter;
	}

	/**
	 * Create OrderStatus summary dashboard display in Stack Chart with Val Wise 
	 * @author base
	 * @return JsonObject
	 * */
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryStackValWise(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusSummStackValWiseJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryStackValWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			//System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryStackValWise :"+facilityCode);
			}
	        
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select  " +
					" round(sum(OpenOrder),0) as OpenOrder " +
					" ,sum(PrvOpenOrder) as PrvOpenOrder " +
					" ,sum(PriorOpenOrder) as PriorOpenOrder " +
					" ,round(sum(Shipped),0)  as Shipped " +
					" ,round(sum(waved),0)   as Waved " +
					" ,round(sum(Picked),0)  as Picked " +
					" ,round(sum(Packed),0)  as Packed " +
					" ,round(sum(WaitingforConfirmation),0)  as WaitingConfirmation " +
					" ,round(sum(Credit_Hold),0)  as Credit_Hold " +
					" ,round(sum(Cancel),0)  as Canceled " +
					" ,round(sum(Hold),0)  as Hold " +
					" ,round(sum(WaitingforWave),0)  as WaitingWave " +
					" ,round(sum(StockOut),0)  as StockOut " +
					" from " +
					" ( " +
					" select site_code , site_descr, nvl(OpenOrder,0) as OpenOrder , nvl(PrvOpenOrder,0) as PrvOpenOrder , nvl(PriorOpenOrder,0) as PriorOpenOrder ,nvl(Shipped,0) as Shipped ,nvl(Waved,0) as Waved, " +
					" nvl(Picked,0) as Picked, nvl(Packed,0) as Packed,  nvl(WaitingforConfirmation,0) as WaitingforConfirmation,nvl(Credit_Hold,0) as Credit_Hold,nvl(Cancel,0) as Cancel,nvl(Hold,0) as Hold, " +
					" nvl(WaitingforWave,0) as WaitingforWave,nvl(StockOut,0) as StockOut  " +
					" from ( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select NVL(Sum(b.NET_AMT),0)  from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(k.TOT_AMT),0) " +
					" from sorder k, itemser its  where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(a.TOT_AMT),0)  " +
					" from sorder a, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select NVL(Sum(d.TOT_AMT),0)  " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM(fn_chk_stk_available(a.TOT_AMT)),0) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                      " +
					" ) as StockOut " +
					" from site o where facility_code = '"+facilityCode+"' " + getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )  ) ";

			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					/*For OpenOrder*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					
					
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackValWiseJson.put(count, rawJson);
					count++;
					
					//System.out.println("rawDataOrderStatusSummStackValWiseJson :"+rawDataOrderStatusSummStackValWiseJson);
				
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :WMS3PLSummDtlDashboard getOrderStatusSummaryStackValWise:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackValWiseJson;
	}

	/**
	 * Create OrderStatus detail dashboard display in Stack Chart with Val Wise 
	 * @author base
	 * @return JsonObject
	 * */
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlStackValWise(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusSummStackJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummStackJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlStackValWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr = "";
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlStackValWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select site_code , site_descr " +
					" ,round(nvl(OpenOrder,0),0) as OpenOrder  " +
					" ,round(nvl(PrvOpenOrder,0),0) as PrvOpenOrder  " +
					" ,round(nvl(PriorOpenOrder,0),0) as PriorOpenOrder  " +
					" ,round(nvl(Shipped,0),0) as Shipped " +
					" ,round(nvl(Waved,0),0) as waved " +
					" ,round(nvl(Picked,0),0) as Picked " +
					" ,round(nvl(Packed,0),0) as Packed " +
					" ,round(nvl(WaitingforConfirmation,0),0) as WaitingforConfirmation " +
					" ,round(nvl(Credit_Hold,0),0) as Credit_Hold " +
					" ,round(nvl(Cancel,0),0) as Canceled " +
					" ,round(nvl(Hold,0),0) as Hold " +
					" ,round(nvl(WaitingforWave,0),0) as waitingforWave " +
					" ,round(nvl(StockOut,0),0) as StockOut  " +
					" from ( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select NVL(Sum(b.NET_AMT),0)  from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(k.TOT_AMT),0) " +
					" from sorder k, itemser its  where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(a.TOT_AMT),0)  " +
					" from sorder a, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select NVL(Sum(d.TOT_AMT),0)  " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM(fn_chk_stk_available(a.TOT_AMT)),0) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                      " +
					" ) as StockOut " +
					" from site o Where facility_code = '"+facilityCode+"' " +getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )  ";

			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					rawDataOrderStatusSummStackJson = new JSONObject();
					count = 0;
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					/*For OpenOrder*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingforConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("waitingforWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					System.out.println("rawDataOrderStatusSummStackJson :"+rawDataOrderStatusSummStackJson);
					rawDataOrderStatusSummStackJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummStackJson);
				}
			}
			System.out.println("rawDataOrderStatusSummStackJsonOuter :"+rawDataOrderStatusSummStackJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDtlStackValWise :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackJsonOuter;
	}
	
	
	/**
	 * Create OrderStatus summary dashboard display in Pie Chart with Val Wise 
	 * @author base
	 * @return JsonObject
	 * */
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryPieValWise(String facilityCode,String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException,ITMException 
	{
		JSONObject rawDataOrderStatusSummPieValJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryPieValWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryPieValWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
	        	
	        	sql = " select  " +
					" round(sum(OpenOrder),0) as OpenOrder " +
					" ,round(sum(PrvOpenOrder),0)  as PrvOpenOrder " +
					" ,round(sum(PriorOpenOrder),0)  as PriorOpenOrder " +
					" ,round(sum(Shipped),0)  as Shipped " +
					" ,round(sum(waved),0)   as Waved " +
					" ,round(sum(Picked),0)  as Picked " +
					" ,round(sum(Packed),0)  as Packed " +
					" ,round(sum(WaitingforConfirmation),0)  as WaitingConfirmation " +
					" ,round(sum(Credit_Hold),0)  as Credit_Hold " +
					" ,round(sum(Cancel),0)  as Canceled " +
					" ,round(sum(Hold),0)  as Hold " +
					" ,round(sum(WaitingforWave),0)  as WaitingWave " +
					" ,round(sum(StockOut),0)  as StockOut " +
					" from " +
					" ( " +
					" select site_code , site_descr, nvl(OpenOrder,0) as OpenOrder , nvl(PrvOpenOrder,0) as PrvOpenOrder, nvl(PriorOpenOrder,0) as PriorOpenOrder, nvl(Shipped,0) as Shipped ,nvl(Waved,0) as Waved, " +
					" nvl(Picked,0) as Picked, nvl(Packed,0) as Packed,  nvl(WaitingforConfirmation,0) as WaitingforConfirmation,nvl(Credit_Hold,0) as Credit_Hold,nvl(Cancel,0) as Cancel,nvl(Hold,0) as Hold, " +
					" nvl(WaitingforWave,0) as WaitingforWave,nvl(StockOut,0) as StockOut  " +
					" from ( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select NVL(Sum(b.NET_AMT),0)  from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k ,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(k.TOT_AMT),0) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(a.TOT_AMT),0)  " +
					" from sorder a, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select NVL(Sum(d.TOT_AMT),0)  " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM(fn_chk_stk_available(a.TOT_AMT)),0) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                      " +
					" ) as StockOut " +
					" from site o where facility_code = '"+facilityCode+"' " + getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )  ) ";
			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					
					rawJson = new JSONObject();
					rawJson.put("status", "Current Month");
					rawJson.put("value", rs.getString("OpenOrder"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					rawJson = new JSONObject();
					rawJson.put("status", "Previous Month");
					rawJson.put("value", rs.getString("PrvOpenOrder"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Prior Months");
					rawJson.put("value", rs.getString("PriorOpenOrder"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Shipped");
					rawJson.put("value", rs.getString("Shipped"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Picked");
					rawJson.put("value", rs.getString("Picked"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Packed");
					rawJson.put("value", rs.getString("Packed"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waved");
					rawJson.put("value", rs.getString("Waved"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting Confirmation");
					rawJson.put("value", rs.getString("WaitingConfirmation"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Credit Hold");
					rawJson.put("value", rs.getString("Credit_Hold"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
	
					rawJson = new JSONObject();
					rawJson.put("status", "Canceled");
					rawJson.put("value", rs.getString("Canceled"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Hold");
					rawJson.put("value", rs.getString("Hold"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
				
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting for Wave");
					rawJson.put("value", rs.getString("WaitingWave"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Stock Out");
					rawJson.put("value", rs.getString("StockOut"));
					rawDataOrderStatusSummPieValJson.put(count, rawJson);
					count++;
				
					//System.out.println("rawDataOrderStatusSummPieValJson :"+rawDataOrderStatusSummPieValJson);
					
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusSummaryPieValWise:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieValJson;
	}

	/**
	 * Create OrderStatus detail dashboard display in Pie Chart with Val Wise 
	 * @author base
	 * @return JsonObject
	 * */
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlPieValWise(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException,ITMException 
	{
		JSONObject rawDataOrderStatusSummPieJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummPieJson = null;
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//DashboardUtility dashboardUtility = null;
		long totalOrder = 0;
		long prvTotalOrder = 0;
		long priorTotalOrder = 0;
		long shipment = 0;
		long picked = 0;
		long packed = 0;
		long waved = 0;
		long waitingForConf = 0;
		long creditHold = 0;
		long canceled = 0;
		long hold = 0;
		long waitingForWave = 0; 
		long stockOut = 0;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlPieValWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr = "";
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlPieValWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
	        	sql = " select site_code , site_descr " +
					" ,round(nvl(OpenOrder,0),0) as OpenOrder  " +
					" ,round(nvl(PrvOpenOrder,0),0) as PrvOpenOrder  " +
					" ,round(nvl(PriorOpenOrder,0),0) as PriorOpenOrder  " +
					" ,round(nvl(Shipped,0),0) as Shipped " +
					" ,round(nvl(Waved,0),0) as waved " +
					" ,round(nvl(Picked,0),0) as Picked " +
					" ,round(nvl(Packed,0),0) as Packed " +
					" ,round(nvl(WaitingforConfirmation,0),0) as WaitingforConfirmation " +
					" ,round(nvl(Credit_Hold,0),0) as Credit_Hold " +
					" ,round(nvl(Cancel,0),0) as Canceled " +
					" ,round(nvl(Hold,0),0) as Hold " +
					" ,round(nvl(WaitingforWave,0),0) as waitingforWave " +
					" ,round(nvl(StockOut,0),0) as StockOut  " +
					" from ( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select NVL(Sum(a.TOT_AMT),0)  from sorder a, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select NVL(Sum(b.NET_AMT),0)  from invoice b, itemser its " +
					" where b.site_code = o.site_code " +
					" and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" )  as Shipped, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k ,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(k.TOT_AMT),0) " +
					" from sorder k,itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(a.TOT_AMT),0)  " +
					" from sorder a, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N' " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as WaitingforConfirmation,  " +
					" ( Select NVL(Sum(d.TOT_AMT),0)  " +
					" from business_logic_check c,Sorder d, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status ='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(e.TOT_AMT),0)  " +
					" from sorder  e, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(k.TOT_AMT),0)  " +
					" from sorder k,itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM(fn_chk_stk_available(a.TOT_AMT)),0) from sorder a, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                      " +
					" ) as StockOut " +
					" from site o Where facility_code = '"+facilityCode+"' " +getSiteCode(sessionUserLevel, sessionSiteCode)+
					" )  ";

			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					rawDataOrderStatusSummPieJson = new JSONObject();
					count = 0;
					
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					
					totalOrder = rs.getLong("OpenOrder");
					prvTotalOrder =  rs.getLong("PrvOpenOrder");
					priorTotalOrder =  rs.getLong("PriorOpenOrder");
					shipment = rs.getLong("Shipped");
					picked = rs.getLong("Picked");
					packed = rs.getLong("Packed");
					waved = rs.getLong("Waved");
					waitingForConf = rs.getLong("WaitingforConfirmation");
					creditHold = rs.getLong("Credit_Hold");
					canceled = rs.getLong("Canceled");
					hold = rs.getLong("Hold");
					waitingForWave = rs.getLong("WaitingforWave");
					stockOut = rs.getLong("StockOut");
					
					
					if(totalOrder ==0 && prvTotalOrder ==0 && priorTotalOrder ==0 && shipment == 0 && picked == 0 && packed == 0 && waved == 0 && waitingForConf == 0 
							&& creditHold== 0 && canceled== 0 && hold== 0 && waitingForWave== 0 && stockOut == 0 )
					{
						rawJson = new JSONObject();
						rawJson.put("status", "No Data");
						rawJson.put("value", 1);
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
					}else
					{
					
						rawJson = new JSONObject();
						rawJson.put("status", "Current Month");
						rawJson.put("value", rs.getString("OpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Previous Month");
						rawJson.put("value", rs.getString("PrvOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Prior Months");
						rawJson.put("value", rs.getString("PriorOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Shipped");
						rawJson.put("value", rs.getString("Shipped"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Picked");
						rawJson.put("value", rs.getString("Picked"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Packed");
						rawJson.put("value", rs.getString("Packed"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Waved");
						rawJson.put("value", rs.getString("Waved"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "WaitingforConfirmation");
						rawJson.put("value", rs.getString("WaitingforConfirmation"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Credit_Hold");
						rawJson.put("value", rs.getString("Credit_Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
		
						rawJson = new JSONObject();
						rawJson.put("status", "Canceled");
						rawJson.put("value", rs.getString("Canceled"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Hold");
						rawJson.put("value", rs.getString("Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					
						rawJson = new JSONObject();
						rawJson.put("status", "Waiting for Wave");
						rawJson.put("value", rs.getString("waitingforWave"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Stock Out");
						rawJson.put("value", rs.getString("StockOut"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					}
					System.out.println("rawDataOrderStatusSummPieJson :"+rawDataOrderStatusSummPieJson);
					
					rawDataOrderStatusSummPieJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummPieJson);
				}
			}
			System.out.println("rawDataOrderStatusSummPieJsonOuter :"+rawDataOrderStatusSummPieJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDtlPieValWise :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieJsonOuter;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryStackQtyWise(String facilityCode, String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusSummStackJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryStackQtyWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String frmDate = "";
			String toDate = "";
			 
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			///System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryStackQtyWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
	        	sql = " select  " +
					" sum(OpenOrder) as OpenOrder " +
					" ,sum(PrvOpenOrder) as PrvOpenOrder " +
					" ,sum(PriorOpenOrder) as PriorOpenOrder " +
					" ,sum(Shipped) as Shipped " +
					" ,sum(waved)  as Waved " +
					" ,sum(Picked) as Picked " +
					" ,sum(Packed) as Packed " +
					" ,sum(WaitingforConfirmation) as WaitingConfirmation " +
					" ,sum(Credit_Hold) as Credit_Hold " +
					" ,sum(Cancel) as Canceled " +
					" ,sum(Hold) as Hold " +
					" ,sum(WaitingforWave) as WaitingWave " +
					" ,sum(StockOut) as StockOut " +
					" from " +
					" ( " +
					" select site_code , site_descr, nvl(OpenOrder,0) as OpenOrder , nvl(PrvOpenOrder,0) as PrvOpenOrder, nvl(PriorOpenOrder,0) as PriorOpenOrder , nvl(Shipped,0) as Shipped ,nvl(Waved,0) as Waved, " +
					" nvl(Picked,0) as Picked, nvl(Packed,0) as Packed, nvl(WaitingforConfirmation,0) as WaitingforConfirmation,nvl(Credit_Hold,0) as Credit_Hold,nvl(Cancel,0) as Cancel,nvl(Hold,0) as Hold, " +
					" nvl(WaitingforWave,0) as WaitingforWave,nvl(StockOut,0) as StockOut  " +
					" From( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select Sum(c.Quantity)  from invoice b,INVDET c,  itemser its " +
					" where b.site_code = o.site_code " +
					" and b.invoice_id = c.invoice_id and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"'  " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" ) as Shipped, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k , sorddet l, itemser its  where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(l.Quantity),0) " +
					" from sorder k , sorddet l, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(b.Quantity),0)  " +
					" from sorder a, sorddet b, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N'  " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" ) as WaitingforConfirmation,     " +
					" ( Select NVL(Sum(e.Quantity),0)  " +
					" from business_logic_check c,Sorder d,sorddet e, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.sale_order=e.sale_order " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(f.Quantity),0)  " +
					" from sorder  e,sorddet f, itemser its " +
					" where e.status='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'" +
					" and e.sale_order=f.sale_order " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(f.Quantity),0)  " +
					" from sorder  e,sorddet f, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.sale_order=f.sale_order " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM (fn_chk_stk_available(b.Quantity)),0) from sorder a,sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                       " +
					" )  as StockOut " +
					" from site o Where facility_code = '"+facilityCode+"'  " +getSiteCode(sessionUserLevel, sessionSiteCode)+
					" ) ) ";


			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					/*For OpenOrder*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					System.out.println("rawDataOrderStatusSummStackJson :"+rawDataOrderStatusSummStackJson);
				
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :WMS3PLSummDtlDashboard getOrderStatusSummaryStackQtyWise:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlStackQtyWise(String facilityCode,String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException,ITMException 
	{
		JSONObject rawDataOrderStatusSummStackJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummStackJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		LinkedHashMap<String, String> catValues = null;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlStackQtyWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//DashboardUtility dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr = "";
			String frmDate = "";
			String toDate = "";
			 
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			///System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
	        /*facilityCode = "FC001";
			businessType = "T";*/
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlStackQtyWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select site_code , site_descr " +
					" ,nvl(OpenOrder,0) as OpenOrder " +
					" ,nvl(PrvOpenOrder,0) as PrvOpenOrder " +
					" ,nvl(PriorOpenOrder,0) as PriorOpenOrder " +
					" ,nvl(Shipped,0) as Shipped " +
					" ,nvl(Waved,0) as waved " +
					" ,nvl(Picked,0) as Picked " +
					" ,nvl(Packed,0) as Packed " +
					" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
					" ,nvl(Credit_Hold,0) as Credit_Hold " +
					" ,nvl(Cancel,0) as Canceled " +
					" ,nvl(Hold,0) as Hold " +
					" ,nvl(WaitingforWave,0) as waitingforWave " +
					" ,nvl(StockOut,0) as StockOut  " +
					" From( " +
					" select site_code as site_code,descr as site_descr, " +
					" (  " +
					" select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as OpenOrder, " +
					" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PrvOpenOrder, " +
					" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
					" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')   " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" )  as PriorOpenOrder, " +
					" ( Select Sum(c.Quantity)  from invoice b,INVDET c,  itemser its " +
					" where b.site_code = o.site_code " +
					" and b.invoice_id = c.invoice_id and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"'  " +
					" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
					" ) as Shipped, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
					" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
					" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Waved, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k , sorddet l, itemser its  where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Picked, " +
					" (select NVL(Sum(l.Quantity),0) " +
					" from sorder k , sorddet l, itemser its where  k.status not in ('C','X','H') " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
					" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
					" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.site_code = o.Site_code " +
					" ) Packed, " +
					" ( select NVL(Sum(b.Quantity),0)  " +
					" from sorder a, sorddet b, itemser its " +
					" where  a.DUE_DATE <= sysdate  and confirmed='N'  " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code " +
					" ) as WaitingforConfirmation,     " +
					" ( Select NVL(Sum(e.Quantity),0)  " +
					" from business_logic_check c,Sorder d,sorddet e, itemser its " +
					" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and d.sale_order=e.sale_order " +
					" and d.item_ser = its.item_ser "+appendSql+" " +
					" )  as Credit_Hold,   " +
					" ( Select NVL(Sum(f.Quantity),0)  " +
					" from sorder  e,sorddet f, itemser its " +
					" where e.status='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'" +
					" and e.sale_order=f.sale_order " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Cancel, " +
					" ( Select NVL(Sum(f.Quantity),0)  " +
					" from sorder  e,sorddet f, itemser its " +
					" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
					" and e.sale_order=f.sale_order " +
					" and e.site_code   = o.site_code " +
					" and e.item_ser = its.item_ser "+appendSql+" " +
					" )  as Hold, " +
					" (select NVL(Sum(l.Quantity),0)  " +
					" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
					" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
					" and k.sale_order in  " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
					" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
					" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
					" ) WaitingforWave, " +
					" ( select NVL(SUM (fn_chk_stk_available(b.Quantity)),0) from sorder a,sorddet b, itemser its " +
					" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
					" and a.sale_order=b.sale_order " +
					" and a.item_ser = its.item_ser "+appendSql+" " +
					" and a.site_code = o.site_code                       " +
					" )  as StockOut " +
					" from site o where facility_code = '"+facilityCode+"'  " +getSiteCode(sessionUserLevel, sessionSiteCode)+
					" ) " ;

			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					rawDataOrderStatusSummStackJson = new JSONObject();
					count = 0;
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					
					/*For OpenOrder*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PriorOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Prior Months");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("PrvOpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Previous Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", rs.getString("OpenOrder"));
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Current Month");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					
					/*For Shipped*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", rs.getString("Shipped"));
					catValues.put("WIP", "");
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Shipped");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For WIP*/
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("waved"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Waved");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Picked"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Picked");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", rs.getString("Packed"));
					catValues.put("Exception", "");
					
					rawJson.put("date",count);
					rawJson.put("status","Packed");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					/*For Exception*/
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("WaitingforConfirmation"));
					
					rawJson.put("date",count);
					rawJson.put("status","Wating for Confirmation");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Credit_Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Credit Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Canceled"));
					
					rawJson.put("date",count);
					rawJson.put("status","Canceled");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("Hold"));
					
					rawJson.put("date",count);
					rawJson.put("status","Hold");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("waitingforWave"));
					
					rawJson.put("date",count);
					rawJson.put("status","Waiting for Wave");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put("Open order", "");
					catValues.put("Shipped", "");
					catValues.put("WIP", "");
					catValues.put("Exception", rs.getString("StockOut"));
					
					rawJson.put("date",count);
					rawJson.put("status","Stock Out");
					rawJson.put("category_value",catValues);
					rawDataOrderStatusSummStackJson.put(count, rawJson);
					count++;
					
					System.out.println("rawDataOrderStatusSummStackJson :"+rawDataOrderStatusSummStackJson);
					rawDataOrderStatusSummStackJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummStackJson);
				}
			}
			System.out.println("rawDataOrderStatusSummStackJsonOuter :"+rawDataOrderStatusSummStackJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : getOrderStatusDtlStackQtyWise:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummStackJsonOuter;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummaryPieQtyWise(String facilityCode,String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException,ITMException 
	{
		JSONObject rawDataOrderStatusSummPieJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//LinkedHashMap<String, String> catValues = null;
		//DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusSummaryPieQtyWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			String frmDate = "";
			String toDate = "";
			 
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			///System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
	        /*facilityCode = "FC001";
			businessType = "T";*/
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusSummaryPieQtyWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select  " +
						" sum(OpenOrder) as OpenOrder " +
						" ,sum(PrvOpenOrder) as PrvOpenOrder " +
						" ,sum(PriorOpenOrder) as PriorOpenOrder " +
						" ,sum(Shipped) as Shipped " +
						" ,sum(waved)  as Waved " +
						" ,sum(Picked) as Picked " +
						" ,sum(Packed) as Packed " +
						" ,sum(WaitingforConfirmation) as WaitingConfirmation " +
						" ,sum(Credit_Hold) as Credit_Hold " +
						" ,sum(Cancel) as Canceled " +
						" ,sum(Hold) as Hold " +
						" ,sum(WaitingforWave) as WaitingWave " +
						" ,sum(StockOut) as StockOut " +
						" from " +
						" ( " +
						" select site_code , site_descr, nvl(OpenOrder,0) as OpenOrder , nvl(PrvOpenOrder,0) as PrvOpenOrder, nvl(PriorOpenOrder,0) as PriorOpenOrder , nvl(Shipped,0) as Shipped ,nvl(Waved,0) as Waved, " +
						" nvl(Picked,0) as Picked, nvl(Packed,0) as Packed, nvl(WaitingforConfirmation,0) as WaitingforConfirmation,nvl(Credit_Hold,0) as Credit_Hold,nvl(Cancel,0) as Cancel,nvl(Hold,0) as Hold, " +
						" nvl(WaitingforWave,0) as WaitingforWave,nvl(StockOut,0) as StockOut  " +
						" From( " +
						" select site_code as site_code,descr as site_descr, " +
						" (  " +
						" select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as OpenOrder, " +
						" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PrvOpenOrder, " +
						" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PriorOpenOrder, " +
						" ( Select Sum(c.Quantity)  from invoice b,INVDET c,  itemser its " +
						" where b.site_code = o.site_code " +
						" and b.invoice_id = c.invoice_id and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"'  " +
						" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
						" ) as Shipped, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
						" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
						" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Waved, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k , sorddet l, itemser its  where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Picked, " +
						" (select NVL(Sum(l.Quantity),0) " +
						" from sorder k , sorddet l, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
						" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
						" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Packed, " +
						" ( select NVL(Sum(b.Quantity),0)  " +
						" from sorder a, sorddet b, itemser its " +
						" where  a.DUE_DATE <= sysdate  and confirmed='N'  " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" ) as WaitingforConfirmation,     " +
						" ( Select NVL(Sum(e.Quantity),0)  " +
						" from business_logic_check c,Sorder d,sorddet e, itemser its " +
						" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
						" and d.sale_order=e.sale_order " +
						" and d.item_ser = its.item_ser "+appendSql+" " +
						" )  as Credit_Hold,   " +
						" ( Select NVL(Sum(f.Quantity),0)  " +
						" from sorder  e,sorddet f, itemser its " +
						" where e.status='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'" +
						" and e.sale_order=f.sale_order " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Cancel, " +
						" ( Select NVL(Sum(f.Quantity),0)  " +
						" from sorder  e,sorddet f, itemser its " +
						" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.sale_order=f.sale_order " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Hold, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
						" ) WaitingforWave, " +
						" ( select NVL(SUM (fn_chk_stk_available(b.Quantity)),0) from sorder a,sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code                       " +
						" )  as StockOut " +
						" from site o Where facility_code = '"+facilityCode+"'  " +getSiteCode(sessionUserLevel, sessionSiteCode)+
						" ) ) ";
			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					
					rawJson = new JSONObject();
					rawJson.put("status", "Current Month");
					rawJson.put("value", rs.getString("OpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Previous Month");
					rawJson.put("value", rs.getString("PrvOpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Prior Months");
					rawJson.put("value", rs.getString("PriorOpenOrder"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Shipped");
					rawJson.put("value", rs.getString("Shipped"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Picked");
					rawJson.put("value", rs.getString("Picked"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Packed");
					rawJson.put("value", rs.getString("Packed"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waved");
					rawJson.put("value", rs.getString("Waved"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting Confirmation");
					rawJson.put("value", rs.getString("WaitingConfirmation"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Credit Hold");
					rawJson.put("value", rs.getString("Credit_Hold"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
	
					rawJson = new JSONObject();
					rawJson.put("status", "Canceled");
					rawJson.put("value", rs.getString("Canceled"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Hold");
					rawJson.put("value", rs.getString("Hold"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
				
					rawJson = new JSONObject();
					rawJson.put("status", "Waiting for Wave");
					rawJson.put("value", rs.getString("WaitingWave"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
					
					rawJson = new JSONObject();
					rawJson.put("status", "Stock Out");
					rawJson.put("value", rs.getString("StockOut"));
					rawDataOrderStatusSummPieJson.put(count, rawJson);
					count++;
				
					System.out.println("rawDataOrderStatusSummPieJson :"+rawDataOrderStatusSummPieJson);
					
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusSummaryPieQtyWise:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDtlPieQtyWise(String facilityCode,String businessType, String dataSourceName, String sessionSiteCode, String sessionUserLevel) throws RemoteException,ITMException 
	{
		JSONObject rawDataOrderStatusSummPieJsonOuter = new JSONObject();
		JSONObject rawDataOrderStatusSummPieJson = null;
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		//LinkedHashMap<String, String> catValues = null;
		//DashboardUtility dashboardUtility = null;
		long openOrder = 0;
		long shipment = 0;
		long picked = 0;
		long packed = 0;
		long waved = 0;
		long waitingForConf = 0;
		long creditHold = 0;
		long canceled = 0;
		long hold = 0;
		long waitingForWave = 0; 
		long stockOut = 0;
		long prvOpenOrder = 0;
		long priorOpenOrder = 0;
		boolean returnValue = false;
		
		try
		{
			System.out.println("********** In WMS3PLSummDtlDashboard : getOrderStatusDtlPieQtyWise Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			//dashboardUtility = new DashboardUtility();
			String siteCode ="";
			String siteDescr = "";
			String frmDate = "";
			String toDate = "";
			 
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			
			 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			///System.out.println("toDate :"+toDate);
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        //System.out.println("frmDate :"+frmDate);
	        
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
	        /*facilityCode = "FC001";
			businessType = "T";*/
	        String appendSql = "";
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
			{
				
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				System.out.println("facilityCode from session getOrderStatusDtlPieQtyWise :"+facilityCode);
			}
	        if(facilityCode!=null && facilityCode.trim().length()>0)
			{
			
	        	sql = " select site_code , site_descr " +
						" ,nvl(OpenOrder,0) as OpenOrder " +
						" ,nvl(PrvOpenOrder,0) as PrvOpenOrder " +
						" ,nvl(PriorOpenOrder,0) as PriorOpenOrder " +
						" ,nvl(Shipped,0) as Shipped " +
						" ,nvl(Waved,0) as waved " +
						" ,nvl(Picked,0) as Picked " +
						" ,nvl(Packed,0) as Packed " +
						" ,nvl(WaitingforConfirmation,0) as WaitingforConfirmation " +
						" ,nvl(Credit_Hold,0) as Credit_Hold " +
						" ,nvl(Cancel,0) as Canceled " +
						" ,nvl(Hold,0) as Hold " +
						" ,nvl(WaitingforWave,0) as waitingforWave " +
						" ,nvl(StockOut,0) as StockOut  " +
						" From( " +
						" select site_code as site_code,descr as site_descr, " +
						" (  " +
						" select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as OpenOrder, " +
						" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PrvOpenOrder, " +
						" (select  NVL(SUM(b.Quantity),0) from sorder a, Sorddet b, itemser its " +
						" where  a.CONF_DATE < '"+prvMonthFrmDate+"' and a.status not in('C','X')   " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" )  as PriorOpenOrder, " +
						" ( Select Sum(c.Quantity)  from invoice b,INVDET c,  itemser its " +
						" where b.site_code = o.site_code " +
						" and b.invoice_id = c.invoice_id and  b.CONF_DATE between '"+frmDate+"' and   '"+toDate+"'  " +
						" and b.item_ser = its.item_ser "+appendSql+" and b.confirmed='Y' " +
						" ) as Shipped, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+"  and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N'  and Wave_task.tran_date between '"+frmDate+"' and   '"+toDate+"' " +
						" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
						" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Waved, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k , sorddet l, itemser its  where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and " +
						" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
						" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Picked, " +
						" (select NVL(Sum(l.Quantity),0) " +
						" from sorder k , sorddet l, itemser its where  k.status not in ('C','X','H') " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK' and " +
						" exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
						" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
						" and HDR.conf_date between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.site_code = o.Site_code " +
						" ) Packed, " +
						" ( select NVL(Sum(b.Quantity),0)  " +
						" from sorder a, sorddet b, itemser its " +
						" where  a.DUE_DATE <= sysdate  and confirmed='N'  " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code " +
						" ) as WaitingforConfirmation,     " +
						" ( Select NVL(Sum(e.Quantity),0)  " +
						" from business_logic_check c,Sorder d,sorddet e, itemser its " +
						" where d.site_code = o.site_code and d.sale_order=c.sale_order and  c.aprv_stat='F' and  d.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
						" and d.sale_order=e.sale_order " +
						" and d.item_ser = its.item_ser "+appendSql+" " +
						" )  as Credit_Hold,   " +
						" ( Select NVL(Sum(f.Quantity),0)  " +
						" from sorder  e,sorddet f, itemser its " +
						" where e.status='X' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'" +
						" and e.sale_order=f.sale_order " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Cancel, " +
						" ( Select NVL(Sum(f.Quantity),0)  " +
						" from sorder  e,sorddet f, itemser its " +
						" where e.status='H' and e.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' " +
						" and e.sale_order=f.sale_order " +
						" and e.site_code   = o.site_code " +
						" and e.item_ser = its.item_ser "+appendSql+" " +
						" )  as Hold, " +
						" (select NVL(Sum(l.Quantity),0)  " +
						" from sorder k ,sorddet l, itemser its where  k.status not in ('C','X','H')  " +
						" and k.item_ser = its.item_ser "+appendSql+" and k.sale_order=l.sale_order " +
						" and k.sale_order in  " +
						" (select distinct sale_order " +
						" from wave_task_det,Wave_task " +
						" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' ) " +
						" and not exists(select 1 from despatch where sord_no = k.sale_order and confirmed = 'Y') " +
						" and k.CONF_DATE between '"+frmDate+"' and  '"+toDate+"' and k.site_code = o.Site_code " +
						" ) WaitingforWave, " +
						" ( select NVL(SUM (fn_chk_stk_available(b.Quantity)),0) from sorder a,sorddet b, itemser its " +
						" where  a.CONF_DATE between '"+frmDate+"' and  '"+toDate+"'  " +
						" and a.sale_order=b.sale_order " +
						" and a.item_ser = its.item_ser "+appendSql+" " +
						" and a.site_code = o.site_code                       " +
						" )  as StockOut " +
						" from site o where facility_code = '"+facilityCode+"'  " +getSiteCode(sessionUserLevel, sessionSiteCode)+
						" ) " ;


			
			
				pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				while(rs.next())
				{
					returnValue = true;
					rawDataOrderStatusSummPieJson = new JSONObject();
					count = 0;
					
					siteCode = rs.getString("site_code").trim();
					siteDescr = rs.getString("site_descr").trim();
					
					openOrder = rs.getLong("OpenOrder");
					prvOpenOrder= rs.getLong("PrvOpenOrder");
					priorOpenOrder= rs.getLong("PriorOpenOrder");
					shipment = rs.getLong("Shipped");
					picked = rs.getLong("Picked");
					packed = rs.getLong("Packed");
					waved = rs.getLong("Waved");
					waitingForConf = rs.getLong("WaitingforConfirmation");
					creditHold = rs.getLong("Credit_Hold");
					canceled = rs.getLong("Canceled");
					hold = rs.getLong("Hold");
					waitingForWave = rs.getLong("WaitingforWave");
					stockOut = rs.getLong("StockOut");
					
					
					if(openOrder ==0 && prvOpenOrder == 0 && priorOpenOrder ==0 && shipment == 0 && picked == 0 && packed == 0 && waved == 0 && waitingForConf == 0 
							&& creditHold== 0 && canceled== 0 && hold== 0 && waitingForWave== 0 && stockOut == 0 )
					{
						rawJson = new JSONObject();
						rawJson.put("status", "No Data");
						rawJson.put("value", 1);
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
					}else
					{
					
						rawJson = new JSONObject();
						rawJson.put("status", "Current Month");
						rawJson.put("value", rs.getString("OpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Previous Month");
						rawJson.put("value", rs.getString("PrvOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						rawJson = new JSONObject();
						rawJson.put("status", "Prior Months");
						rawJson.put("value", rs.getString("PriorOpenOrder"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						
						rawJson = new JSONObject();
						rawJson.put("status", "Shipped");
						rawJson.put("value", rs.getString("Shipped"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Picked");
						rawJson.put("value", rs.getString("Picked"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Packed");
						rawJson.put("value", rs.getString("Picked"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						
						rawJson = new JSONObject();
						rawJson.put("status", "Waved");
						rawJson.put("value", rs.getString("Waved"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "WaitingforConfirmation");
						rawJson.put("value", rs.getString("WaitingforConfirmation"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Credit_Hold");
						rawJson.put("value", rs.getString("Credit_Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
		
						rawJson = new JSONObject();
						rawJson.put("status", "Canceled");
						rawJson.put("value", rs.getString("Canceled"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Hold");
						rawJson.put("value", rs.getString("Hold"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					
						rawJson = new JSONObject();
						rawJson.put("status", "Waiting for Wave");
						rawJson.put("value", rs.getString("waitingforWave"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
						
						rawJson = new JSONObject();
						rawJson.put("status", "Stock Out");
						rawJson.put("value", rs.getString("StockOut"));
						rawDataOrderStatusSummPieJson.put(count, rawJson);
						count++;
					}
					System.out.println("rawDataOrderStatusSummPieJson :"+rawDataOrderStatusSummPieJson);
					
					rawDataOrderStatusSummPieJsonOuter.put(siteCode+" ( "+siteDescr+" )", rawDataOrderStatusSummPieJson);
				}
			}
			System.out.println("rawDataOrderStatusSummPieJsonOuter :"+rawDataOrderStatusSummPieJsonOuter);
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDtlPieQtyWise :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSummPieJsonOuter;
	}	
	
	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}	
	
	private String checkDouble(String str)
	{
		if (str == null)
		{
		return "0";
		} else
		{
		return str;
		}

	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getSalesOrderDetailGrid(String facilityCode, String businessType, String productCategory, String caption, String dataSourceName) throws RemoteException, ITMException 
	{ 
		JSONObject rawDataSalesOrderDetailGridJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" ********** In WMS3PLSummDtlDashboard : getSalesOrderDetailGrid Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			String frmDate = "";
			String toDate = "";
			String prvMonthFrmDate = "";
			String prvMonthToDate = "";
			String appendSql = "";
			String siteCode = "";
			String[] splitedCaption ;
			String appendDynamicSql = "";
			String status = "";
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");   
			Calendar calendar         = Calendar.getInstance();
			toDate         = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	        frmDate          = simpleDateFormat.format(calendar.getTime());
	        calendar.add(Calendar.MONTH, -1);
	        prvMonthFrmDate = simpleDateFormat.format(calendar.getTime());
			calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));
			prvMonthToDate = simpleDateFormat.format(calendar.getTime());
			
	        splitedCaption = caption.split("\\(");
			siteCode = splitedCaption[0].trim();
			if(businessType.length()>0)
			{
				appendSql = " and its.business_type ='"+businessType+"' ";
			}
			
			if(productCategory.equalsIgnoreCase("Current Month"))
			{
				System.out.println("************ in Current Month ********** ");
				appendDynamicSql = " and so.status not in ('C','X') and so.site_code='"+siteCode+"'  and so.CONF_DATE between '"+frmDate+"' and   '"+toDate+"' "; 
								  
			}else if(productCategory.equalsIgnoreCase("Previous Month"))
			{
				System.out.println("************ in Previous Month ********** ");
				appendDynamicSql = " and so.status not in ('C','X') and so.site_code='"+siteCode+"'  and so.CONF_DATE between '"+prvMonthFrmDate+"' and   '"+prvMonthToDate+"' ";
				
			}else if(productCategory.equalsIgnoreCase("Prior Months"))
			{
				System.out.println("************ in Prior Months ********** ");
				appendDynamicSql = " and so.status not in ('C','X') and so.site_code='"+siteCode+"'  and so.CONF_DATE < '"+prvMonthFrmDate+"' ";
				
			}else if(productCategory.equalsIgnoreCase("Shipped"))
			{
				System.out.println("************ in Shipped ********** ");
				
			}else if(productCategory.equalsIgnoreCase("Waved"))
			{
				System.out.println("************ in Waved ********** ");
				
				appendDynamicSql =" and so.status not in ('C','X','H') and so.sale_order in " +
								" (select distinct sale_order " +
								" from wave_task_det,Wave_task " +
								" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID  " +
								" and Wave_task.CANCEL='N'  " +
								" and wave_task.tran_date  between '"+frmDate+"' and   '"+toDate+"' " +
								" and Trim(Ref_SER) in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') " +
								" and not exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
								" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
								" And Hdr.Confirmed = 'Y' )) " +
								" and not exists(select 1 from despatch where sord_no = so.sale_order and confirmed = 'Y') " +
								" and so.site_code = '"+siteCode+"' ";
				
			}else if(productCategory.equalsIgnoreCase("Picked"))
			{
				System.out.println("************ in Picked ********** ");
				
				appendDynamicSql = " and so.status not in ('C','X','H') and so.sale_order in " +
									" (select distinct sale_order from wave_task_det,Wave_task " +
									" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER)  " +
									" in ('A-PICK','M-PICK','C-PICK','R-CAPK','P-PICK') and exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
									" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
									" and HDR.conf_date  between '"+frmDate+"' and   '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
									" and not exists(select 1 from despatch where sord_no = so.sale_order and confirmed = 'Y') " +
									" and so.site_code = '"+siteCode+"' ";
				
			}else if(productCategory.equalsIgnoreCase("Packed"))
			{
				System.out.println("************ in Packed ********** ");
				appendDynamicSql = " and so.status not in ('C','X','H') and so.sale_order in (select distinct sale_order " +
								" from wave_task_det,Wave_task where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER) = 'M-PACK'  " +
								" and exists (select 1 from PACK_HDR HDR,PACK_DET DET " +
								" where HDR.tran_id =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
								" and HDR.conf_date between '"+frmDate+"' and '"+toDate+"' And Hdr.Confirmed = 'Y')) " +
								" and not exists(select 1 from despatch where sord_no = so.sale_order and confirmed = 'Y') " +
								" and so.site_code = '"+siteCode+"' ";
			}
			else if(productCategory.equalsIgnoreCase("Wating for Confirmation"))
			{
				System.out.println("************ in Wating for Confirmation ********** ");
				appendDynamicSql = "and so.due_date <= sysdate   and so.confirmed='N' and so.site_code = '"+siteCode+"' ";
			}
			else if(productCategory.equalsIgnoreCase("Credit Hold"))
			{
				System.out.println("************ in Credit Hold ********** ");
				appendDynamicSql = "and so.sale_order=blc.sale_order and  blc.aprv_stat='F' and  so.sale_order = '"+siteCode+"' and so.CONF_DATE between '"+frmDate+"' and '"+toDate+"'  ";
			}
			else if(productCategory.equalsIgnoreCase("Canceled"))
			{
				System.out.println("************ in Canceled ********** ");
				appendDynamicSql = "and so.status ='X' and so.site_code= '"+siteCode+"' and so.CONF_DATE between '"+frmDate+"' and '"+toDate+"' ";
			}
			else if(productCategory.equalsIgnoreCase("Hold"))
			{
				System.out.println("************ in Hold ********** ");
				appendDynamicSql = "and so.status ='H' and so.site_code='"+siteCode+"' and so.CONF_DATE between '"+frmDate+"' and '"+toDate+"' ";
			}
			else if(productCategory.equalsIgnoreCase("Waiting for Wave"))
			{
				System.out.println("************ in Waiting for Wave ********** ");
				appendDynamicSql = " and  so.status not in ('C','X','H') and so.confirmed = 'Y' " +
									" and so.sale_order not in (select distinct sale_order " +
									" from wave_task_det,Wave_task where Wave_task.WAVE_ID = wave_task_det.WAVE_ID  " +
									" and Wave_task.CANCEL='N' and not exists(select 1 from despatch where sord_no = so.sale_order and confirmed = 'Y')) " +
									" and so.CONF_DATE between '"+frmDate+"' and '"+toDate+"' and so.site_code = '"+siteCode+"' ";
			}
			else if(productCategory.equalsIgnoreCase("Stock Out"))
			{
				System.out.println("************ in Stock Out ********** ");
				appendDynamicSql = "and so.CONF_DATE between '"+frmDate+"' and '"+toDate+"' and so.status not in ('C','X','H') and so.confirmed = 'Y' and so.site_code ='"+siteCode+"' ";
			}
			
			if(!"No Data".equalsIgnoreCase(productCategory))
			{
		        sql = " Select cust.cust_name, so.sale_order , count(sod.line_no) No_Of_Item,so.tot_amt as Total_Order_Value, sod.quantity,so.status "+
					" from sorder so,sorddet sod ,customer cust,itemser its "+
					" where so.sale_order=sod.sale_order  "+
					" and so.item_ser = its.item_ser  "+appendSql+" "+
					" and so.cust_code =cust.cust_code "+
					" "+appendDynamicSql+" "+ 
					" group by cust.cust_name, so.sale_order, so.tot_amt, sod.quantity, so.status order by cust.cust_name ";
		        
	            pstmt = conn.prepareStatement(sql);
				rs= pstmt.executeQuery();
				
				while(rs.next())
				{
					rowData = new  JSONObject();
					
					rowData.put("cust_name", rs.getString("cust_name"));
					rowData.put("sale_order", rs.getString("sale_order"));
					rowData.put("no_of_item", rs.getString("No_Of_Item"));
					rowData.put("total_order_value", rs.getString("Total_Order_Value"));
					rowData.put("quantity", rs.getString("quantity"));
					status = checkNull(rs.getString("status")).trim();
					if("P".equalsIgnoreCase(status))
					{
						status ="Pending";
					}
					else if("C".equalsIgnoreCase(status))
					{
						status ="Cancel";
					}
					else if("X".equalsIgnoreCase(status))
					{
						status ="Closed";
					}
					else if("H".equalsIgnoreCase(status))
					{
						status ="Hold";
					}
					rowData.put("status", status);
					
					rawDataSalesOrderDetailGridJson.put(count, rowData);
					count++;
				}
			}
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getSalesOrderDetailGrid:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataSalesOrderDetailGridJson;
	}

	@SuppressWarnings("unused")
	private String getFacilityCode(String siteCode, String dataSourceName) throws  ITMException
	{
		String facilityCode = "";
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try {
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = "Select facility_code from site where site_code='"+siteCode+"'"; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				facilityCode = checkNull(rs.getString("facility_code")).trim();
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getFacilityCode:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return facilityCode;
	}
	
	//Added by varsha v. for showing results as per user rights on 13 April 2017
	private String getSiteCode(String sessionUserLevel, String sessionSiteCode)
	{
		String appendSiteCode = "";
		//sessionUserLevel="2";
		if(Integer.parseInt(sessionUserLevel)>0)
		{
			appendSiteCode = " and o.site_code ='"+sessionSiteCode+"' ";
		}
		System.out.println("In getSiteCode appendSiteCode: " + appendSiteCode);
		return appendSiteCode;
	}
	//Ended by varsha v. for showing results as per user rights on 13 April 2017

	
}
