package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.LiveEventMgrWiseDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class ActiveEventMgrWiseServlet extends HttpServlet
{

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		LiveEventMgrWiseDetailsRemote liveEventMgrWiseDetRemote = null;
		InitialContext context        = null;
		AppConnectParm appConnectParm = null;
		String dataSourceName         = "",loginId = "",month = "", year = "";
		HttpSession session           = null;
		UserInfoBean userInfo         = null;
				
		try
		{
			response.setContentType("application/xml");
			session 				  = request.getSession(true);
			userInfo 				  = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId 				  = userInfo.getLoginCode();
			month                     = request.getParameter("month");
			year                      = request.getParameter("year");
			appConnectParm 			  = new AppConnectParm();
			dataSourceName 			  = request.getParameter("dataSourceName");			
			context 				  = new InitialContext(appConnectParm.getProperty());
			liveEventMgrWiseDetRemote = (LiveEventMgrWiseDetailsRemote) context.lookup("ibase/LiveEventMgrWiseDetails/remote");
			JSONObject jsonObjData    = (JSONObject) liveEventMgrWiseDetRemote.getActiveEvent(dataSourceName,loginId, month, year);
			OutputStream outputStream = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ActiveEventMgrWiseServlet ===" + jsonObjData);		

		} catch (Exception e)
		{
			System.out.println("Exception : ActiveEventMgrWiseServlet :doPost() :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}
}