package ibase.e12ria.e12widgets.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;

public class SearchField extends ScanInput
{
	
	private boolean loaded;

	protected Panel outerDiv = new SimplePanel();
	protected Panel innerDiv = new SimplePanel();

	public SearchField() 
	{
		super( ScanMode.MAPPING );
	}
	
	@Override
	protected void onLoad()
	{
		try 
		{
			if( !loaded )
			{
				inputTextBox.setStyleName( "searchboxinput" );
				inputTextBox.getElement().setPropertyString( "placeholder" , "Search" );
				innerDiv.setStyleName( "searchboxform" );
				outerDiv.setStyleName( "searchbox" );
				
				innerDiv.add( inputTextBox );
				outerDiv.add( innerDiv );
				//Chnaged by Dnyaneshwar on 03/08/2012 [  WM2DSUN001 ] Start 
			    parentPanel.setWidth("100%");
			    //Chnaged by Dnyaneshwar on 03/08/2012 [  WM2DSUN001 ] Start 
				parentPanel.add( outerDiv );
				
				configureEvents();
				
				loaded = true;
			}
		} catch (Exception e) {
			Window.alert("Exception : SearchField : onLoad() : "+e.getMessage());
		}
	}
	
	//Chnaged by Dnyaneshwar on 08/Nov/2012 [  WS2GSUN003 ] Start 
	/**
    * Updates the UI parameters for this widget based on the current state. 
    */
	@Override
	protected void updateWidget() {
		String txtValue = inputTextBox.getText();
		super.updateWidget();
		inputTextBox.setText( txtValue );
		inputTextBox.selectAll();
	}
	/**
     * Sets event handlers for child widgets.
     */
	@Override
	protected void configureEvents() {

        // The following code fragment will be used when we want to fire
        // a tab-out event on the text box after scan.
//        inputTextBox.addBlurHandler( new BlurHandler()
//        {
//            @Override
//            public void onBlur( BlurEvent blurEvent )
//            {
//                doScan();
///                tabDummyWidget.setFocus( true );
//            }
//        } );
        
        // The following code fragment will be used when we want to fire
        // an event on the text box after scan, by hitting the ENTER key.
    	if( keyUpHandler == null )
    	{
            keyUpHandler = new KeyUpHandler()
            {
                
                @Override
                public void onKeyUp(KeyUpEvent event)
                {
                	if( "".equals( inputTextBox.getText().trim() ) )
                	{
                		doScan();
                	}
                    if( Window.Navigator.getUserAgent().indexOf( "Opera" ) != -1 )
                    {
                        doScan();
                    }
                    else if( event.getNativeKeyCode() == 13 || event.getNativeKeyCode() == 0 )
                    {
                        doScan();
                    }
                }
            };
    		inputTextBox.addKeyUpHandler( keyUpHandler );
    	}
    
		
	}
	
	//Chnaged by Dnyaneshwar on 08/Nov/2012 [  WS2GSUN003 ] End
	
   
}
