/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GstrPurchasePosEJB extends ValidatorEJB implements GstrPurchasePosEJBLocal,GstrPurchasePosEJBRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	GSTCommonUtil gstUtility = new GSTCommonUtil();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public GstrPurchasePosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
			
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside GstrPurchasePosEJB Post Save ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		Timestamp validUptoDate = null;
		boolean isError = false,isLocCon = false;
		Document dom = null;
		String sql = "",retString = "";
		int cnt = 0,cnt1 = 0;
		FinCommon  finCommon = null;
		String loginSite = "";
		java.sql.Date chg_date=null;
		String val = "";
		String loginSiteCode = "";
		String name="",addr1="",addr2="",addr3="",city="",state="",pin="",taxRegNo="",tran_type="",tranId="";
		String 	recordType = "", // Gstr type rec_type
				sPos = "", // Supplier Place Of Supplay gst_code
				cPos = "", // Customer Place Of Supplay
				gstType ="", 
				docType ="",
				reverseCharge ="N",//Reverse Charge reverse_chrg
				eCommGtin ="",//Ecommerce Gtin  ecom_reg_no
				gtin = "",//Supplier GTIN
				tranType = "";		
		double invAmt =0.0,b2clInvVal = 0.0,gstRate = 0.0;//amount
		boolean isWithPay = false;
		
		
		
		try
		{	
			System.out.println("===================Inside GstrPosEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail1") != -1))
			{
				finCommon = new FinCommon(); 
				currDate = new java.sql.Timestamp(System.currentTimeMillis());
	            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
	            SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
	            String currDateStr = sdfAppl.format(currDate.getTime());
	            currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
	            //System.out.println("currDate:::::::::"+currDate);			
			    dom = genericUtility.parseString(xmlstring); 				
				NodeList detail1NodeList =dom.getElementsByTagName("Detail1");
				int detail3NodeListlen = detail1NodeList.getLength();
				loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				System.out.println("loginSite>>>>>>>>>>"+loginSite);
				
				for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
				{
					NodeList childNodeList = detail1NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					System.out.println("childNodeListlen>>>>>"+childNodeListlen);
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						System.out.println("childNode.getNodeName()>>"+childNode.getNodeName());
						if(childNode != null && "tran_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tran_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer tran_type is===="+tran_type);
						}
						else if(childNode != null && "tax_reg_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							taxRegNo = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer tax_reg_no is===="+taxRegNo);
						}
						else if(childNode != null && "name".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							name = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer Name is===="+name);
						}
						else if(childNode != null && "addr1".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							addr1 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer addr1 is===="+addr1);
						}
						else if(childNode != null && "addr2".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							addr2 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer addr2 is===="+addr2);
						}
						else if(childNode != null && "addr3".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							addr3 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer addr3 is===="+addr3);
						}
						else if(childNode != null && "city".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							city = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer city is===="+city);
						}
						else if(childNode != null && "gst_state_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							state = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer state is===="+state);
						}
						else if(childNode != null && "pin".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							pin = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer pin is===="+pin);
						}
						//Changed By Pragyan.start
						else if(childNode != null && "rec_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							recordType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "gst_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							gstType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "doc_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							docType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "reverse_chrg".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							reverseCharge = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "ecom_reg_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							eCommGtin = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "gst_code_state".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							cPos = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "amount".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							invAmt = Double.parseDouble(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "tran_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tranId = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
				}
				NodeList nodeList =dom.getElementsByTagName("Detail2");
				int nodeListlen = nodeList.getLength();
				System.out.println("NodeList for Detail2 is ========"+nodeListlen);
				cnt1 = gstUtility.getNumOfNonDelDetail(dom,2);
				System.out.println("Value of cnt1 in GstrPosEJB is =="+cnt1);
				
				for(int ctr = 0; ctr < nodeListlen ; ctr++)
				{
					NodeList childNodeList = nodeList.item(ctr).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					System.out.println("childNodeListlen>>>>>"+childNodeListlen);
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						if(childNode != null && "gst_rate".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							gstRate = Double.parseDouble(childNode.getFirstChild().getNodeValue());
							System.out.println("gstRate::::::::::::"+gstRate);
							
							if(gstRate <= 0)
							{
								isWithPay = true;
								break;
							}
						}
						
						if(isWithPay)
						{
							break;
						}
					}
				}
				
				System.out.println("tax_reg_no["+taxRegNo+"]"+"name["+name+"]"+"addr1["+addr1+"]"+"addr2["+addr2+"]"+"addr3["+addr3+"]"+"city["+city+"]"+"state["+state+"]"+"pin["+pin+"]");
			
				if(taxRegNo != null && taxRegNo.trim().length() > 0)
				{
					 if("I".equalsIgnoreCase(gstType) || "R".equalsIgnoreCase(gstType) || "G".equalsIgnoreCase(gstType)
					  ||"D".equalsIgnoreCase(gstType) || "C".equalsIgnoreCase(gstType))
					{
						sql = "select count(*) as cnt from gst_registration where gst_no=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,taxRegNo);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt = rs.getInt("cnt");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						} 
						if(cnt > 0)
						{
							sql = "update gst_registration set name=?,addr1=?,addr2=?,addr3=?,city=?,state_code=?,pin=? where gst_no=?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,name);
							pstmt.setString(2,addr1);
							pstmt.setString(3,addr2);
							pstmt.setString(4,addr3);
							pstmt.setString(5,city);
							pstmt.setString(6,state);
							pstmt.setString(7,pin);
							pstmt.setString(8,taxRegNo);
							pstmt.executeUpdate();
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
						}
						else
						{
							sql = " insert into gst_registration (gst_no,name,addr1,addr2,addr3,city,state_code,pin) values(?,?,?,?,?,?,?,?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,taxRegNo);
							pstmt.setString(2,name);
							pstmt.setString(3,addr1);
							pstmt.setString(4,addr2);
							pstmt.setString(5,addr3);
							pstmt.setString(6,city);
							pstmt.setString(7,state);
							pstmt.setString(8,pin);
							pstmt.addBatch();
							pstmt.executeBatch();
							if(pstmt != null)
							{
							pstmt.close(); 
							pstmt = null;
							}
						}
					}
				}//end of if block for taxRegNo
								
				//Changed By Pragyan 04/07/17 to update tran type logics.start.
				sPos = getGstStateCode(loginSite,conn);
					
				System.out.println("Record Type["+recordType+"]Gst Type ["+gstType+"]Doc Type["+docType+"]");
				System.out.println("CTIN["+taxRegNo+"]Ecom Gtin["+eCommGtin+"]Suppplier POS["+sPos+"] Customer Pos["+cPos+"]Revrse Charge["+reverseCharge+"]Invoice amount ["+invAmt+"]");
				System.out.println("isWithPay:::::"+isWithPay);
				
				if("2".equalsIgnoreCase(recordType))
				{
					b2clInvVal = Double.parseDouble(finCommon.getFinparams("999999", "GST_B2CL_INV_VAL", conn));
					System.out.println("b2clInvVal:::"+b2clInvVal);
					
					if("I".equalsIgnoreCase(gstType)) //B2B Supplies, with SEZ and deemed exports
					{
						if((taxRegNo.length() > 0)
								&& ("N".equalsIgnoreCase(reverseCharge) || "".equalsIgnoreCase(reverseCharge))
								&& ("R".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType)))
						{
							tranType = "01";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseCharge) || "".equalsIgnoreCase(reverseCharge))
								&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType) && !isWithPay))
						{
							tranType = "02";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseCharge) || "".equalsIgnoreCase(reverseCharge))
								&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType) && isWithPay))
						{
							tranType = "03";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseCharge) || "".equalsIgnoreCase(reverseCharge))
								&& ("DE".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType)))
						{
							tranType = "04";
						}
					}
					
					else if("R".equalsIgnoreCase(gstType)) //B2B Reverse Charge supplies
					{
						tranType = "05";
					}
					
					else if("U".equalsIgnoreCase(gstType)) //B2BUR  unregistered supplies 
					{
						tranType = "06";
					}
					
					else if("S".equalsIgnoreCase(gstType))//IMPS Import of service invoice data
					{
						tranType = "07";
					}
					
					else if("G".equalsIgnoreCase(gstType))
					{
						if( taxRegNo.length() > 0)  //IMPG Import of goods from SEZ
						{
							tranType = "09";
						}
						else
						{
							tranType = "08"; //IMPG Import of goods
						}
					}
					
					else if("D".equalsIgnoreCase(gstType))//Debit Note to registered customer 
					{
						if( taxRegNo.length() > 0)  
						{
							tranType = "10";
						}
						else //Debit Note to unregistered customer 
						{
							tranType = "11";
						}
					}
					else if("C".equalsIgnoreCase(gstType))
					{
						if( taxRegNo.length() > 0) //Credit Note to registered customer 
						{
							tranType = "12";
						}
						else
						{
							tranType = "13"; //Credit Note to unregistered customer 
						}
					}
					else if("A".equalsIgnoreCase(gstType))//Advance Paid
					{
						if(sPos.equalsIgnoreCase(cPos)) //TXPI Intra-State advance Paid(Rate wise)
						{
							tranType = "14";
						}
						else if(!sPos.equalsIgnoreCase(cPos)) // TXPI Inter-State advance Paid(Rate wise)
						{
							tranType = "15";
						}
					}
					else if("T".equalsIgnoreCase(gstType))//Advance adjusted 
					{
						if(sPos.equalsIgnoreCase(cPos)) //TXPD Intra-State advance adjusted(Rate wise)
						{
							tranType = "16";
						}
						else if(!sPos.equalsIgnoreCase(cPos))//TXPD Inter-State advance adjusted(Rate wise)
						{
							tranType = "17";
						}
					}
					
					System.out.println("Tran Id ::::["+tranId+"]");
					
					
					System.out.println("Tran Type is ====="+tranType);
					sql = "update gst_data_hdr set tran_type=? where tran_id=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranType);
					pstmt.setString(2,tranId);
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}	
				}

				//Changed By Pragyan 04/07/17 to update tran type logics.end	
			}	
			else //if(xmlstring == null ||  (xmlstring.indexOf("Detail1") == 0))
			{
				System.out.println("Detail1 not found");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
				return retString;
			}
			//if(xmlstring != null && xmlstring.indexOf("Detail2") == -1 && !(gstType.equalsIgnoreCase("L")))
			if(cnt1 == 0 && !(gstType.equalsIgnoreCase("L")))
			{
				System.out.println("Detail2 is empty in xmlString....");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL2","","",conn);
				return retString;
			}
		}// end of try block
		catch(Exception e)
		{
			System.out.println("Exception GstrPosEJB ==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally GstrPurchasePosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save GstrPosEJB =["+retString+"]");
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String  getGstStateCode(String siteCode , Connection conn) throws ITMException
	{
		String pos ="";
		String sSQL ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			
			sSQL = "SELECT ST.GST_CODE FROM TARODEV.SITE S,TARODEV.STATE ST WHERE S.STATE_CODE = ST.STATE_CODE AND S.SITE_CODE = ?";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				pos = rs.getString("GST_CODE");
			}
			
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			} 
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return pos;
	}
	
}
