package ibase.webitm.ejb.fin;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class RelPartyDefIC extends ValidatorEJB implements RelPartyDefICLocal, RelPartyDefICRemote{
	E12GenericUtility genericUtility= new  E12GenericUtility();
	String keyFlagSql = "";
	String keyFlag = "";
	public String itemChanged() throws RemoteException,ITMException
	{
		return "";	
	}
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println(" ************* Call inside  Item Change ***************");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
            System.out.println("Inside Exception Inside RelPartyDefIC.itemChanged() ["+e.getMessage()+"]");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from RelPartyDefIC itemChanged" );
		return errString;
        }
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{


		Connection conn = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String chgTerm ="";
		ResultSet rs = null;
		String sql = "";
		String columnValue = "";
		String siteCode = "";
		String chgUser = "";
		String siteDescr = "";
		String finEntity = "";
		String acctprdDescr = "";
		String contactName = "";
		String address1 = "";
		String address2 = "";
		String address3 = "";
		String city = "";
		String stateCode = "";
		String pinCode = "";
		String countryCode = "";
		String tranType = "";
		String tranDescr = "";
		String tranCatDescr = "";
		try
		{
			
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			columnValue = genericUtility.getColumnValue(currentColumn, dom);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			if( objContext != null && objContext.trim().length() > 0 )	{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());

			switch ( currentFormNo ){

			case 1:

				System.out.println("Inside Switch case 1");
				valueXmlString.append( "<Detail1>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) ){
					siteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");

					System.out.println("--------------------ITM_DEFAULT Called -----------------------");
					
					valueXmlString.append( "<tran_date><![CDATA[" ).append(sysDate).append( "]]></tran_date>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append(siteCode).append( "]]></site_code>\r\n" );
					System.out.println("Now the date is :=>  " + sysDate);

					if( siteCode != null )
					{
						sql =   " SELECT  S.DESCR, F.DESCR, S.FIN_ENTITY " +
								" FROM SITE S, FINENT F " +
								" WHERE S.FIN_ENTITY = F.FIN_ENTITY AND SITE_CODE = ?";

						System.out.println("columnValue (site_code) ::: ["+siteCode+" ]");
						System.out.println("Sql Query default (site_code) ["+ sql + "]");

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if( rs.next() ){
							siteDescr = checkNull( rs.getString( "DESCR" ));
							finEntity = checkNull( rs.getString( "fin_entity" ));
						}
						if( rs != null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
					valueXmlString.append( "<fin_entity><![CDATA[" ).append( finEntity ).append( "]]></fin_entity>\r\n" );
					}
					//End if block
				    valueXmlString.append("<confirmed><![CDATA[").append("N").append( "]]></confirmed>\r\n" );	
					
				    valueXmlString.append("<add_date><![CDATA[").append(checkNull(sysDate)).append("]]></add_date>\r\n");
					valueXmlString.append("<chg_date><![CDATA[").append(checkNull(sysDate)).append("]]></chg_date>\r\n" );
					
					
					keyFlagSql = "select key_flag from transetup  where tran_window = 'w_rela_party_def'";
		 			pstmt = conn.prepareStatement(keyFlagSql);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							keyFlag = rs.getString("key_flag");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
		 			System.out.println(" default keyFlag ==============>>>>"+keyFlag);
						if("M".equals(keyFlag)){
							valueXmlString.append("<tran_id  protect ='1'><![CDATA[").append("").append("]]></tran_id>\r\n");
						}
				}//End Default item change

				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
				{
					valueXmlString.append( "<chg_user><![CDATA[" ).append(checkNull(chgUser)).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append(checkNull(sysDate)).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(checkNull(chgTerm)).append( "]]></chg_term>\r\n" );
				} // end default edit defaultiem
				
				
				else if( currentColumn.trim().equalsIgnoreCase( "site_code" ) ){ // start site code

					columnValue = genericUtility.getColumnValue("site_code",dom);

					sql = "   SELECT  S.DESCR, F.DESCR, S.FIN_ENTITY " +
							" FROM SITE S, FINENT F " +
							" WHERE S.FIN_ENTITY = F.FIN_ENTITY AND SITE_CODE = ?";

					System.out.println("columnValue (site_code) ::: ["+ columnValue+ " ]");
					System.out.println("Sql Query default (site_code) ["+ sql + "]");

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() ){

						siteDescr = checkNull( rs.getString( "DESCR" ));
						finEntity = checkNull( rs.getString( "fin_entity" ));
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
					valueXmlString.append( "<fin_entity><![CDATA[" ).append( finEntity ).append( "]]></fin_entity>\r\n" );
				}//end else if site code 1st
				
				/*else if(currentColumn.trim().equalsIgnoreCase( "fin_entity" )){ // start fin_entity if
					
					columnValue = genericUtility.getColumnValue("fin_entity", dom);
					System.out.println("fin_entity [" + columnValue + "]");
					
					sql = "SELECT  DESCR FROM FINENT WHERE FIN_ENTITY = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs 	= pstmt.executeQuery();
					if( rs.next() ){
						
						System.out.println("------------------------APPENDING DESCRIPTION-- INSERTING FINENT CODE-----------------");
						valueXmlString.append( "<finent_descr><![CDATA[" ).append( checkNull( rs.getString( "DESCR" )) ).append( "]]></finent_descr>\r\n" );
					
					}
					else{
						
						System.out.println("------------------------EMPTY DESCRIPTION- SITE CODE------------------");
						valueXmlString.append( "<finent_descr><![CDATA[" ).append("" ).append( "]]></finent_descr>\r\n" );

					}
					
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}

				} // end if fin_entity
*/				
				else if(currentColumn.trim().equalsIgnoreCase("acct_prd")){ // start acct_prd if
					
					columnValue = genericUtility.getColumnValue("acct_prd", dom);
					System.out.println("acct_prd ["+ columnValue + "]");
					sql = "SELECT DESCR  FROM ACCTPRD WHERE CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next() ){
						
						acctprdDescr = checkNull( rs.getString( "DESCR" ));
					}
					
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("acctprdDescr ["+ acctprdDescr + "]");
					
				    valueXmlString.append( "<acctprd_descr><![CDATA[" ).append( acctprdDescr ).append( "]]></acctprd_descr>\r\n" );
				}  // end if acct_prd descr

				else if( currentColumn.trim().equalsIgnoreCase("contact_code") ){ // start if contact_code

					columnValue = genericUtility.getColumnValue("contact_code", dom);
					
					sql = " SELECT NAME,  ADDR1, ADDR2, ADDR3, CITY, STATE_CODE, PIN, COUNT_CODE " +
						  " FROM CONTACT " +
						  " where contact_code = ?";

					System.out.println("Sql Query  (contact_code) ["+ sql + "]");
					System.out.println("Contact Code [ "+ columnValue + "]");

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();

					if( rs.next() ){
						
					contactName =     checkNull( rs.getString( "NAME" ));
					address1    =	  checkNull( rs.getString( "ADDR1" ));
					address2    =	  checkNull( rs.getString( "ADDR2" ));
					address3    =     checkNull( rs.getString( "ADDR3" ));
					city        =	  checkNull( rs.getString( "CITY" ));
					stateCode   =	  checkNull( rs.getString( "STATE_CODE"));
					pinCode     =     checkNull( rs.getString( "PIN" ));
					countryCode =	  checkNull( rs.getString( "COUNT_CODE" ));
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					} 
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				
					valueXmlString.append( "<name><![CDATA[" ).append( contactName  ).append( "]]></name>\r\n" );
					valueXmlString.append( "<addr1><![CDATA[" ).append( address1 ).append( "]]></addr1>\r\n" );
					valueXmlString.append( "<addr2><![CDATA[" ).append( address2 ).append( "]]></addr2>\r\n" );
					valueXmlString.append( "<addr3><![CDATA[" ).append( address3 ).append( "]]></addr3>\r\n" );
					valueXmlString.append( "<city><![CDATA[" ).append( city  ).append( "]]></city>\r\n" );
					valueXmlString.append( "<state_code><![CDATA[").append( stateCode ).append( "]]></state_code>\r\n" );
					valueXmlString.append( "<pin><![CDATA[" ).append( pinCode ).append( "]]></pin>\r\n" );
				    valueXmlString.append( "<count_code><![CDATA[" ).append( countryCode ).append( "]]></count_code>\r\n" );

				}// End else if contact_code

				else if ( currentColumn.trim().equalsIgnoreCase("tran_type")  ) { // start if tran_type 

					columnValue = genericUtility.getColumnValue("tran_type", dom);
					System.out.println("Tran type [" + columnValue + "]");

					sql = "select descr from gencodes where fld_value = ? and mod_name = ? " ;
					System.out.println("Tran Type [" + sql + "]");

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					pstmt.setString(2, "W_RELA_PARTY_DEF");
					rs = pstmt.executeQuery();

					if( rs.next() ){

                        tranDescr =  checkNull( rs.getString( "descr" )); 

					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					} 
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("Tran_type ["+ tranType + "]");
					System.out.println("Tran description ["+ tranDescr+"]");

					valueXmlString.append( "<descr><![CDATA[" ).append( tranDescr ).append( "]]></descr>\r\n" );
				
				
				} // end if tran_type
				
				valueXmlString.append( "</Detail1>\r\n" );
				System.out.println("------------------------COMPLETE  CASE 1-------------------");
				break;
				// end switch case 1

				// start Case 2

			case 2:

				System.out.println("Inside Case 2");
				valueXmlString.append( "<Detail2>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase("tran_cat") ){

					columnValue = genericUtility.getColumnValue("tran_cat", dom);
					System.out.println("tran_cat [" + columnValue + "]");

					sql = " select DESCR from TRANSACTION_CAT   where  TRAN_CAT = ?" ;

					System.out.println("Tran Cat SAQL [" + sql + "]");

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();

					if( rs.next() ){

						tranCatDescr = checkNull( rs.getString( "descr" )); 

					}String keyFlagSql = "";
					String keyFlag = "";
					if( rs != null )
					{
						rs.close();
						rs = null;
					} 
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("trancat description ["+ tranCatDescr+"]");
					valueXmlString.append( "<descr><![CDATA[" ).append(  tranCatDescr  ).append( "]]></descr>\r\n" );
				}
				
				valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n" );
				valueXmlString.append("<add_user><![CDATA[").append(checkNull(chgUser)).append("]]></add_user>\r\n");
				valueXmlString.append("<add_term><![CDATA[").append(checkNull(chgTerm)).append("]]></add_term>\r\n");
				valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n" );
			
				valueXmlString.append( "</Detail2>\r\n" );
				System.out.println("------------------------COMPLETE  CASE 2-------------------");
				break;

			}	//end switch case2		
		}//try block ends here
		catch(Exception e)
		{
			System.out.println("Inside Exception RelPartyDefIC.itemChanged()["+e.getMessage()+"]");
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null && ! conn.isClosed() )
				{
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}

					conn.close();
				}
				//System.out.println("------------------------INSIDE FINALLY-------------------");
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RelPartyDefIC HEADER :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}// end finally block

		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n **** ValueXmlString [:" + valueXmlString.toString() + ":]********" );
		return valueXmlString.toString();

}// end item change methods
	
	
	
	// Start WfValdata method
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2 + "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("RelPartyDefIC.wfValData()["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		return(errString);
	}//End WFVALDTA METHOD
	
	
	// Start DOM WFVALDATA 
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException{
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int childNodeListLength;
		int currentFormNo = 0;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String sql = "";
		String userId = "";
		String errFldName="";
		String acctoutPeriod="";
		String periodCodeFrom = ""; 
		String periodCodeTo = "";
		String contactCode = "";
		String tranCat = "";
		String activeStatus = "";
		String siteCode = "";
		double alertMaxAmount;
		double maxAmount;
		String tranDate = "";
        String tranType = "";
		long cnt = 0;
		int countValue = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat simpleDateFormat = null;
		String tranID = "";
		java.sql.Timestamp currDate = null;
		String currAppdate ="";
		String	finEntity = "";
		String cantactCode = "";
		String prdCodeFrm = "";
		String prdCodeTo = "";
		String lineNo = "";
		int countRecord = 0;
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
        
		try
		{
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			currAppdate = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(currDate);
			System.out.println("Current Date ["+ currAppdate + "]");
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo)
			{
			 case 1:
				 	parentNodeList = dom.getElementsByTagName("Detail1");
				 	parentNode = parentNodeList.item(0);
				 	childNodeList = parentNode.getChildNodes();
				 	childNodeListLength = childNodeList.getLength();
				 	for(ctr = 0; ctr < childNodeListLength; ctr ++)
				 	{
				 		childNode = childNodeList.item(ctr);
				 		childNodeName = childNode.getNodeName();
				 		
				 		/*if(childNodeName.equalsIgnoreCase("fin_entity")) // start if fin_entity
				 		{
					
				 			finEntity = checkNull(genericUtility.getColumnValue("fin_entity",dom));
								
								if(finEntity == null || finEntity.length() ==0)				
								{
									errCode = "VTNULFINCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									System.out.println("Null Value in finentity code");
									
								}
								else 
								{
				 						sql = "select count(1) as fin_entity from FINENT where FIN_ENTITY = ?";
				 						pstmt = conn.prepareStatement(sql);
				 						pstmt.setString(1, finEntity);
				 						rs = pstmt.executeQuery();
				 						if(rs.next())
				 						{
				 							countValue = rs.getInt("fin_entity");
				 						}
				 						rs.close();
				 						rs = null;
				 						pstmt.close();
				 						pstmt = null;
							    	
				 						if( countValue == 0 )
				 						{
				 							System.out.println("Fin entity  does not exsit in finent master table");
				 							errCode = "VMFINETYCD";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());
											
				 						 }
							        				
								 }
				 		     } */  // end if fin_entity
				 		
				 		if(childNodeName.equalsIgnoreCase("tran_id")){// start tran_id 
				 			
				 			keyFlagSql = " select key_flag from transetup  where tran_window = 'w_rela_party_def'";
				 			pstmt = conn.prepareStatement(keyFlagSql);
	 						rs = pstmt.executeQuery();
	 						if(rs.next())
	 						{
	 							keyFlag = rs.getString("key_flag");
	 						}
	 						rs.close();
	 						rs = null;
	 						pstmt.close();
	 						pstmt = null;
				 			System.out.println("keyFlag ==============>>>>"+keyFlag);
	 						if("M".equals(keyFlag)){
	 							
	 							tranID  =  checkNull(genericUtility.getColumnValue("tran_id",dom)) ; 
					 			System.out.println("tran Id ===============>>["+ tranID +"]");
					 			
					 			if( tranID == null || tranID.length() ==0){

									errCode = "VTNULTRNID";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									System.out.println("Null Value in tran_id");
					 				
					 			}
					 			else{
									if("A".equals(editFlag))
									{
									sql = "select count(1) as tran_id from RELA_PARTY_HDR where tran_id = ?";
			 						pstmt = conn.prepareStatement(sql);
			 						pstmt.setString(1, tranID);
			 						rs = pstmt.executeQuery();
			 						if(rs.next())
			 						{
			 							countValue = rs.getInt("tran_id");
			 						}
			 						rs.close();
			 						rs = null;
			 						pstmt.close();
			 						pstmt = null;
						    	
			 						if( countValue == 1 )
			 						{
			 							System.out.println("tran_id already exists");
			 							errCode = "VMTRNID";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
			 						 }
					 			   }
					 				
					 			}
	 						}
				 			
				 		}// end tran_id
				 		
				 		if(childNodeName.equalsIgnoreCase("site_code")){ // start if site_code
				 			
				 			siteCode = checkNull(genericUtility.getColumnValue("site_code",dom)) ; 
							
							if(siteCode == null || siteCode.length() ==0)				
							{
								errCode = "VTNULSITCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in site code");

								
							}
							else{
								
								sql = "select count(1) as site_code from site where site_code = ?";
		 						pstmt = conn.prepareStatement(sql);
		 						pstmt.setString(1, siteCode);
		 						rs = pstmt.executeQuery();
		 						if(rs.next())
		 						{
		 							countValue = rs.getInt("site_code");
		 						}
		 						rs.close();
		 						rs = null;
		 						pstmt.close();
		 						pstmt = null;
					    	
		 						if( countValue == 0 )
		 						{
		 							System.out.println("site code does not exsit in  site  master table");
		 							errCode = "VMSITECD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									
		 						 }
								
							}
				 			
				 		} // end if site_code 
				 		
				 		if(childNodeName.equalsIgnoreCase("tran_date")){ // start if tran_date
				 			
				 			tranDate = checkNull(genericUtility.getColumnValue("tran_date",dom));
				 			if(tranDate == null || tranDate.length() ==0)				
							{
								errCode = "VTNULTRNDT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in tran date code");

								
							}
				 			else if(tranDate!= null || tranDate.length() > 0){

				 				Date date = sdf.parse(sysDate);
				 				Date date1 = sdf.parse(tranDate);
				 				if(date.before(date1)){
				 					System.out.println("Inside future date checkking");
				 					errCode = "VTFUTRNDT";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									System.out.println("Null Value in tran date code");
				 				}
				 				
				 			}
				 		} // end if tran_date
				 		if(childNodeName.equalsIgnoreCase("tran_type")){ // start if tran_type
				 			
				 			tranType  = checkNull(genericUtility.getColumnValue("tran_type",dom));
				 			System.out.println("tran_type ["+tranType+"]");
				 			//tranType = "I";
				 			if(tranType == null || tranType.length() ==0)				
							{
								errCode = "VTNULTRNTP";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in tran type code");
							}
				 			else
				 			{
								sql = "select count(1) as tran_type  from gencodes  where fld_value = ? and mod_name = ?";
		 						pstmt = conn.prepareStatement(sql);
		 						pstmt.setString(1, tranType);
		 						pstmt.setString(2, "W_RELA_PARTY_DEF");
		 						rs = pstmt.executeQuery();
		 						if(rs.next())
		 						{
		 							countValue = rs.getInt("tran_type");
		 						}
		 						rs.close();
		 						rs = null;
		 						pstmt.close();
		 						pstmt = null;
					    	
		 						if( countValue == 0 )
		 						{
		 							System.out.println("tran type   does not exsit in transaction cat  master table");
		 							errCode = "VMATRNTYPE";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									
		 						 }
				 			}
				 		} // End tran_type
				 		
				 		if(childNodeName.equalsIgnoreCase("acct_prd")) // start if acct_prd
				 		{

				 			acctoutPeriod = checkNull(genericUtility.getColumnValue("acct_prd",dom));
							
							if(acctoutPeriod == null || acctoutPeriod.length() ==0)				
							{
								errCode = "VTNULPRDCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in acct_prd code");

								
							}
							else 
							{

									sql = "select count(1) as acct_code from ACCTPRD where code = ? ";
			 						pstmt = conn.prepareStatement(sql);
			 						pstmt.setString(1, acctoutPeriod);
			 						rs = pstmt.executeQuery();
			 						if(rs.next())
			 						{
			 							countValue = rs.getInt("acct_code");
			 						}
			 						rs.close();
			 						rs = null;
			 						pstmt.close();
			 						pstmt = null;
						    	
			 						if( countValue == 0 )
			 						{
			 							System.out.println("acct_code  does not exsit in ACCTPRD master table");
			 							errCode = "VMACTPRDCD";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
										
			 						 }
								
								
							}
				 		} // end if acct_prd
				 		
				 		if(childNodeName.equalsIgnoreCase("prd_code__fr")){ // start if prd_code__fr
				 			
				 			periodCodeFrom = checkNull(genericUtility.getColumnValue("prd_code__fr",dom));
				 			periodCodeTo = checkNull(genericUtility.getColumnValue("prd_code__to",dom));

				 			String acctountPeriod = checkNull(genericUtility.getColumnValue("acct_prd",dom));
                            
				 			System.out.println("acctountPeriod ["+ acctountPeriod + "]");
				 			
				 			if( periodCodeFrom == null || periodCodeFrom.length() ==0 ){

								errCode = "VTNULPRDFR";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in period  code from");
				 			}
				 			else{
				 				    //SELECT  COUNT(1)  AS PRD_CODE__TO FROM PERIOD WHERE CODE  = 201504 AND ACCT_PRD = 201516;
									sql = "select  count(1)  as prd_code__from from period where code  = ? and ACCT_PRD = ?";

			 						pstmt = conn.prepareStatement(sql);
			 						pstmt.setString(1, periodCodeFrom);
			 						pstmt.setString(2, acctountPeriod);
			 						rs = pstmt.executeQuery();
			 						if(rs.next())
			 						{
			 							countValue = rs.getInt("prd_code__from");
			 						}
			 						rs.close();
			 						rs = null;
			 						pstmt.close();
			 						pstmt = null;
						    	
			 						if( countValue == 0 )
			 						{
			 							System.out.println("acct_code  does not exsit in period master table");
			 							errCode = "VMPRDFRCD";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
										
			 						 }
			 						else
			 						{
			 							finEntity = checkNull(genericUtility.getColumnValue("fin_entity",dom));
				 						cantactCode  = checkNull(genericUtility.getColumnValue("contact_code",dom));
				 						
				 						
	                                    		tranID  =  checkNull(genericUtility.getColumnValue("tran_id",dom)) ;
						 						if(tranID ==null || tranID.trim().length()==0)
						 						{
						 							tranID ="@@";
						 						}
						 				    	
						 						sql =" select count(1) as count from rela_party_hdr where ? between prd_code__fr and prd_code__to " +
						 				    		 " and    fin_entity = ? and acct_prd = ? and contact_code = ? and  tran_id <> ? ";
					 							System.out.println("sql ===========>>>>[" + sql + "]");
		                                    	pstmt = conn.prepareStatement(sql);
		                                    	pstmt.setString(1, periodCodeFrom);
					 							pstmt.setString(2, finEntity);
					 							pstmt.setString(3, acctountPeriod);
					 							pstmt.setString(4, cantactCode);
					 							pstmt.setString(5, tranID);
					 							rs = pstmt.executeQuery();
					 							if(rs.next()){
					 								
					 								countRecord = rs.getInt("count");
					 							}
					 							
					 							rs.close();
						 						rs = null;
						 						pstmt.close();
						 						pstmt = null; 
						 						
						 						
						 						
					 									if( countRecord > 0 )
						 							{
						 								System.out.println("errorrrrrrrrrrrrr");
						 								errCode = "VTTRANSACT";
														errList.add(errCode);
														errFields.add(childNodeName.toLowerCase());
						 								
						 							}
						 						
			 						}
				 					
		 							
			 					
								
							}
				 			
				 		} 
				 		
				 		if(childNodeName.equalsIgnoreCase("prd_code__to")){  // start if prd_code to
				 			periodCodeTo = checkNull(genericUtility.getColumnValue("prd_code__to",dom));
				 			periodCodeFrom = checkNull(genericUtility.getColumnValue("prd_code__fr",dom));
				 			
				 			String acctountPeriod = checkNull(genericUtility.getColumnValue("acct_prd",dom));
                            
				 			System.out.println("acctountPeriod ["+ acctountPeriod + "]");
				 			
				 			if( periodCodeTo == null || periodCodeTo.length() ==0 ){

								errCode = "VTNULPRDTO";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								
				 			}
				 			else{

       			 				    //SELECT  COUNT(1)  AS PRD_CODE__TO FROM PERIOD WHERE CODE  = 201504 AND ACCT_PRD = 201516;
									sql = "select  count(1)  as perid_code_to from period where code  = ?  and ACCT_PRD = ?";

			 						pstmt = conn.prepareStatement(sql);
			 						pstmt.setString(1, periodCodeTo);
			 						pstmt.setString(2, acctountPeriod);
			 						rs = pstmt.executeQuery();
			 						if(rs.next())
			 						{
			 							countValue = rs.getInt("perid_code_to");
			 						}
			 						rs.close();
			 						rs = null;
			 						pstmt.close();
			 						pstmt = null;
						    	
			 						if( countValue == 0 )
			 						{
			 							System.out.println("Period code to does not exist  in Period master table");
			 							errCode = "VMPRDFRT0";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
										
			 						 }
			 						if( countValue == 1){
			 							if(Integer.parseInt(checkNllOrBlank(periodCodeFrom)) > Integer.parseInt(checkNllOrBlank(periodCodeTo))){
							 				System.out.println("period code to greater then period code from");
				 							errCode = "VTPRDGRT0";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());
							 			}
			 							else{

				 							finEntity = checkNull(genericUtility.getColumnValue("fin_entity",dom));
					 						cantactCode  = checkNull(genericUtility.getColumnValue("contact_code",dom));
					 						
					 						
		                                     
		                                    		tranID  =  checkNull(genericUtility.getColumnValue("tran_id",dom)) ;
							 						if(tranID ==null || tranID.trim().length()==0)
							 						{
							 							tranID ="@@";
							 						}
							 				    	
							 				    	sql =" select count(1) as count from rela_party_hdr where ? between prd_code__fr and prd_code__to " +
							 				    		 " and    fin_entity = ? and acct_prd = ? and contact_code = ?  and  tran_id <> ? ";
						 							System.out.println("sql ===========>>>>[" + sql + "]");
			                                    	pstmt = conn.prepareStatement(sql);
			                                    	pstmt.setString(1, periodCodeTo);
						 							pstmt.setString(2, finEntity);
						 							pstmt.setString(3, acctountPeriod);
						 							pstmt.setString(4, cantactCode);
						 							pstmt.setString(5, tranID);
						 							rs = pstmt.executeQuery();
						 							if(rs.next()){
						 								
						 								countRecord = rs.getInt("count");
						 							}
						 							
						 							rs.close();
							 						rs = null;
							 						pstmt.close();
							 						pstmt = null; 
							 						
							 						
							 						
						 						if( countRecord > 0 )
							 							{
							 								System.out.println("errorrrrrrrrrrrrr");
							 								errCode = "VTTRANSACT";
															errList.add(errCode);
															errFields.add(childNodeName.toLowerCase());
							 								
							 							}
							 						
				 						
			 							}
			 						}
			 					
					 						
							          }
				 		} 
				 		// end if prd_code to
				 		
				 		if(childNodeName.equalsIgnoreCase("contact_code")){ // start if contact code
				 			
				 			contactCode = checkNull(genericUtility.getColumnValue("contact_code",dom));
				 			
				 			if( contactCode == null || contactCode.length() ==0 ){

								errCode = "VTNULCONCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								System.out.println("Null Value in contact  code from");

								
				 			}
				 			else{

									sql = "select count(1) as cntact_code from contact where contact_code =  ?";

			 						pstmt = conn.prepareStatement(sql);
			 						pstmt.setString(1, contactCode);
			 						rs = pstmt.executeQuery();
			 						if(rs.next())
			 						{
			 							countValue = rs.getInt("cntact_code");
			 						}
			 						rs.close();
			 						rs = null;
			 						pstmt.close();
			 						pstmt = null;
						    	
			 						if( countValue == 0 )
			 						{
			 							System.out.println("Contact code to does not exist  in contact master table");
			 							errCode = "VMCONTCD";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
										
			 						 }
								
							}
				 		} // end if contact code
				 	 }
				 	
		   break;
		   
			 case 2:
				 System.out.println("Inside Detail2");
				 parentNodeList = dom.getElementsByTagName("Detail2");
				 	parentNode = parentNodeList.item(0);
				 	childNodeList = parentNode.getChildNodes();
				 	childNodeListLength = childNodeList.getLength();
				 	for(ctr = 0; ctr < childNodeListLength; ctr ++)
				 	{
				 		childNode = childNodeList.item(ctr);
				 		childNodeName = childNode.getNodeName();
				 	
				 	if(childNodeName.equalsIgnoreCase("tran_cat")){  // start if tran_cat
				 		
			 			tranCat  = checkNull(genericUtility.getColumnValue("tran_cat",dom));
	 					lineNo = genericUtility.getColumnValue("line_no",dom);


			 			if( tranCat == null || tranCat.length() ==0 ){

			 				errCode = "VTNULTRCAT";
			 				errList.add(errCode);
			 				errFields.add(childNodeName.toLowerCase());
							System.out.println("Null Value in tran_cat  code from");


			 			}
			 			else{

			 					sql = "select count(1) as tran_cat from TRANSACTION_CAT where  tran_cat = ?";

			 					pstmt = conn.prepareStatement(sql);
			 					pstmt.setString(1, tranCat);
			 					rs = pstmt.executeQuery();
			 					if(rs.next())
			 					{
			 						countValue = rs.getInt("tran_cat");
			 					}
			 					if( countValue == 0 )
			 					{
			 						System.out.println("Tran Cat code  does not exist  in transaction categarey  master table");
			 						errCode = "VMTRNCATCD";
			 						errList.add(errCode);
			 						errFields.add(childNodeName.toLowerCase());

			 					}
			 					if( countValue > 0){
			 						String sql1 = "select NVL(active,'Y') as active from transaction_cat where  TRAN_CAT = ?";
			 						pstmt = conn.prepareStatement(sql1);
				 					pstmt.setString(1, tranCat);
				 					rs = pstmt.executeQuery();
				 					
				 					if(rs.next()){
				 						
				 					activeStatus =	rs.getString("active");
				 					
				 					}
				 					rs.close();
				 					rs = null;
				 					pstmt.close();
				 					pstmt = null;
			 					}
			 					if(!"Y".equalsIgnoreCase(activeStatus)){
			 						System.out.println("Invalid Active Status");
			 						errCode = "VMSTATUSCD";
			 						errList.add(errCode);
			 						errFields.add(childNodeName.toLowerCase());
			 						
			 					}
			 					
									if (isDulplicateFrmDom(dom2,tranCat,lineNo))
									{
										errCode = "VTDUPTRCAT";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
			 				
			 			}
			 		} // end if tran_cat
				 	
				 	if(childNodeName.equalsIgnoreCase("max_amt")){ // start if max_amt

			 			maxAmount  = Double.parseDouble(checkNllOrBlank(genericUtility.getColumnValue("max_amt",dom))); 
			 			if( maxAmount <= 0 ){
	 						System.out.println("max Amount should be greater then Zero");
			 				errCode = "VTAMTPR";
			 				errList.add(errCode);
			 				errFields.add(childNodeName.toLowerCase());

			 			}
			 		} //  end if max_amt
				 	
					if(childNodeName.equalsIgnoreCase("alert_amt_perc")){ // start if alert_amt_perc

			 			alertMaxAmount  = Double.parseDouble(checkNllOrBlank(genericUtility.getColumnValue("alert_amt_perc",dom)));
                        System.out.println("alert amount percentage["+ alertMaxAmount + "]");
			 			if( alertMaxAmount <= 0 || alertMaxAmount > 100 ){
	 						System.out.println("alert max amount persentace should be greter then zero and less then hundread");
			 				errCode = "VTALTAMTPR";
			 				errList.add(errCode);
			 				errFields.add(childNodeName.toLowerCase());

			 			}
			 			
			 		} // end if alert_amt_perc
				 }
				 	break;

		}
			int errListSize = errList.size();
			cnt = 0;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null; 
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception e)
			{
				System.out.println("RelPartyDefIC.wfValData() ["+ e.getMessage() + "]");
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}
	
	private boolean isDulplicateFrmDom(Document dom2, String tranCat,
			String lineNo) {
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		String lineNoDom = "";
		boolean isDulplicate = false;
		String tranCategory = "";
		System.out.println(" inside duplicate ======");
		try
		{

			parentList = dom2.getElementsByTagName("Detail2");
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr-- )
			{	
				parentNode = parentList.item(prntCtr-1);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					System.out.println("childNode>>>>"+childNode);
					
					if(childNode != null &&  childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						String updateFlag = "";
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						if (updateFlag.equalsIgnoreCase("D"))
						{
							System.out.println("Break from here as the record is deleted");
							break;
						}
					}	
					if ( childNode != null && childNode.getFirstChild() != null &&  
					childNode.getNodeName().equalsIgnoreCase("line_no") )
					{
						lineNoDom = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("lineNo["+lineNo+"]lineNoDom["+lineNoDom+"]");
						if (lineNo.trim().equalsIgnoreCase(lineNoDom.trim()))
						{
							System.out.println("Break from here as line No match");
							break;
						}	
					}

					if ( childNode != null && childNode.getFirstChild() != null &&  
					childNode.getNodeName().equalsIgnoreCase("tran_Cat") )
					{
						tranCategory = childNode.getFirstChild().getNodeValue().trim();
					}
					if (tranCat.trim().equalsIgnoreCase(tranCategory.trim()) )
					{
						isDulplicate = true;
						break;
					}
					
				}
				
			}//for loop
			
		
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}	
		System.out.println("isDulplicate>>>>>> ["+isDulplicate+"]");
		return isDulplicate;
	}
	private String checkNllOrBlank(String input) {

		if(input == null || input.trim().equals(""))
		{
			return "0";
		}
		else
		{
			return input ;
		}

	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
}
