alter table customeritem add repl_month VARCHAR2(3);
alter table customer_series add repl_month VARCHAR2(3);
alter table customer add repl_month VARCHAR2(3); 

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('cust_stock','pre_submit','1','prcm_default_submit',null,'0',to_date('04-12-07','DD-MM-RR'),'Base      ','Base','2','EJB','CustStockSubmit',null);

Insert into OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,MULTI_ROW_OPT,ACTION_ID,SWIPE_POSITION) 
values ('cust_stock',11,'confirm.gif','Submit','pre_submit','a','F','Submit','1','2',null,'U',null,null,null,null,null,null,null,null,null,null,null);

Insert into OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,MULTI_ROW_OPT,ACTION_ID,SWIPE_POSITION) 
values ('cust_stock',12,'confirm.gif','Default','act_stock','a','F','Default','3','3','1','U',null,null,null,null,null,null,null,null,null,null,null);

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM,SERVICE_NAMESPACE,RES_ELEM,SOAP_ACTION)
values ('prcm_default_submit','Action To Submit','http://localhost:9090/axis/services/ValidatorService','Base Information','submit','String','S',null,null,to_date('01-06-12','DD-MM-RR'),'base      ','base',null,null,null);

Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('cust_stock','3  ','cl_stock','Y');

Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('cust_stock','3  ','op_stock','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('cust_stock','3  ','purc_rcp','Y');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prcm_default_submit',1,'COMPONENT_TYPE','I','Component Type','C.String',null,to_date('01-06-12','DD-MM-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prcm_default_submit',2,'COMPONENT_NAME','I','Component Name','C.String',null,to_date('01-06-12','DD-MM-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prcm_default_submit',3,'<tran_id>','I','tranid','C.String',null,to_date('01-06-12','DD-MM-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prcm_default_submit',4,'XTRA_PARAMS','I','Extra Arguments','S',null,to_date('01-06-12','DD-MM-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prcm_default_submit',5,'FORCED_FLAG','I','Forced Flag','S',null,to_date('01-06-12','DD-MM-RR'),'BASE      ','BASE',null);

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTCONFMDSM','Transaction Confirmed.','Transaction Already Confirmed.Can not be Submitted','E','Y',null,null,null,sysdate,'BASE','BASE',null,null);

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTSUBM1','Submit successful!','Selected transaction is submitted successfully.','P','Y',null,null,null,sysdate,'BASE','BASE',null,null);

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTSUBM1AD','Already Submitted!','Selected transaction is Already submitted.','P','Y',null,null,null,sysdate,'BASE','BASE',null,null);

---------------Java to pb---------------------------

update system_events set service_code = 'prv_default_nvo_brow_all' ,comp_name = 'nvo_bo_cust_stock' ,comp_type = 'WSR' where obj_name = 'cust_stock' and event_code= 'pre_validate';
update system_events set service_code = 'poic_default_nvo_brow_all' ,comp_name = 'nvo_bo_cust_stock' ,comp_type = 'WSR' where obj_name = 'cust_stock' and event_code= 'post_item_change';


---------------PB TO JAVA---------------------------
update system_events set service_code = 'prv_default_ejb' ,comp_name = 'CustStock' ,comp_type = 'EJB' where obj_name = 'cust_stock' and event_code= 'pre_validate';
update system_events set service_code = 'poic_default_ejb' ,comp_name = 'CustStock' ,comp_type = 'EJB' where obj_name = 'cust_stock' and event_code= 'post_item_change';


-------------fUNCTIONS---------------------------------------------------------
create or replace function fn_get_cust_deposit
(as_sitecode in char, as_custcode in char)
	return number is lc_bal number(14,3);
	lc_sbal number(14,3);
	ls_acctprd char(6);
	ls_prdcode char(6);
	ldt_today date;
	ls_acctcode accounts.acct_code%type;
	ldate_to date;
	
begin

	ldt_today := to_date(sysdate);
	select var_value into ls_acctcode from finparm where prd_code = '999999' and var_name = 'CUST_DEPOSIT_ACC';
	select acct_prd , code, to_date
	into ls_acctprd , ls_prdcode, ldate_to
	from period
	where ldt_today between fr_date and to_date;
	select nvl(sum((dr_amt__base) - (cr_amt__base)),0)
	 into lc_sbal
	from sundrybal
	where  acct_prd = ls_acctprd
	and prd_code < ls_prdcode
	and site_code = as_sitecode
	and sundry_type = 'C'
	and sundry_code = as_custcode
	and acct_code = ls_acctcode
	and nvl(cctr_code,'0') >= ' '
	and nvl(cctr_code,'0') <= 'Z' ;

	Select nvl(sum((dr_amt * exch_rate) - (cr_amt * exch_rate)) , 0)
	 into lc_bal
	 from gltrace
	 where site_code = as_sitecode
	 and tran_date >= ldt_today and tran_date < ldate_to
	 and sundry_type = 'C' and sundry_code= as_custcode
	 and acct_code = ls_acctcode;
	 lc_bal := lc_sbal + lc_bal;

	 Return lc_bal;
end;
 
 
 
 ---------------------------------------------------------------------------------------------------------------------------------------------------------------------
 
 
 
 
 create or replace 
FUNCTION  FN_GET_CUSTOS (as_cust_code char, as_site_code char,
 as_type char)
return number is lc_osamt number(14,3);
begin
if as_type = 'T' then
 select sum(tot_amt-adj_amt) into lc_osamt from receivables
 where  cust_code = as_cust_code
 and    site_code = as_site_code;
elsif as_type = 'O' then
 select sum(tot_amt-adj_amt) into lc_osamt from receivables
 where  cust_code = as_cust_code
 and    site_code = as_site_code
 and    due_date  < fn_sysdate();
end if;
 If lc_osamt is null then
  lc_osamt := 0 ;
 end if;
 return lc_osamt;
 Exception
   when OTHERS then
   return 0;
end;


---------------------------------------------------------------------------------------------------------------------------------------------------------------------

create or replace 
function FN_GET_CUST_SORDER_QTY
(as_custcode in char ,as_itemcode char ,lc_sales number, lc_clstock number , lc_transQty number )
	return number is lc_netsale number(14,3);
	
	lc_sbal number(14,3);
	replfactor char(3);
	replperiod number(3);
	itemser char(5);
	
	
begin
 
	select repl_factor into replfactor from  customeritem where cust_code = as_custcode and item_code = as_itemcode ;
  
	if replfactor is null then 
	  Select item_ser into itemser from item where item_code =   as_itemcode ;
	  select repl_factor into replfactor from  customer_series where cust_code = as_custcode and item_ser = itemser ; 
     if replfactor is null then 
     select repl_factor into replfactor from  customer where cust_code = as_custcode ;
       if replfactor is null then 
        select var_value into replfactor  from disparm where prd_code = '999999' and var_name = 'REPL_FACTOR';
        end if;
     
     end if;
	end if;
		
	select repl_period into replperiod from  customeritem where cust_code = as_custcode and item_code = as_itemcode ;
	if replperiod is null then 
	  Select item_ser into itemser from item where item_code =   as_itemcode ;
	  select repl_period into replperiod from  customer_series where cust_code = as_custcode and item_ser = itemser ; 
     if replperiod is null then 
     select repl_period into replperiod from  customer where cust_code = as_custcode ;
     if replperiod is null then 
     select var_value into replperiod  from disparm where prd_code = '999999' and var_name = 'REPL_PERIOD';
    end if;
    end if;
	end if;
	
  lc_netsale := ROUND(lc_sales /replperiod) * replfactor;
  
	lc_netsale := lc_netsale - lc_clstock - lc_transQty ;



	 Return ROUND(lc_netsale);
end;



------------------------------------------------FN_GET_CUST_SORDER_VAL----------------------------------

create or replace 
function         FN_GET_CUST_SORDER_VAL
(as_custcode in char ,as_itemcode char ,lc_sales number, lc_clstock number , lc_transQty number ,lc_rate number)
	return number is lc_netrate number(14,3);
	
	lc_sbal number(14,3);
  lc_netsale number(14,3);
	replfactor char(3);
	replperiod number(3);
	itemser char(5);
	
	
begin
 
	select repl_factor into replfactor from  customeritem where cust_code = as_custcode and item_code = as_itemcode ;
  
	if replfactor is null then 
	  Select item_ser into itemser from item where item_code =   as_itemcode ;
	  select repl_factor into replfactor from  customer_series where cust_code = as_custcode and item_ser = itemser ; 
     if replfactor is null then 
     select repl_factor into replfactor from  customer where cust_code = as_custcode ;
       if replfactor is null then 
        select var_value into replfactor  from disparm where prd_code = '999999' and var_name = 'REPL_FACTOR';
        end if;
     
     end if;
	end if;
		
	select repl_period into replperiod from  customeritem where cust_code = as_custcode and item_code = as_itemcode ;
	if replperiod is null then 
	  Select item_ser into itemser from item where item_code =   as_itemcode ;
	  select repl_period into replperiod from  customer_series where cust_code = as_custcode and item_ser = itemser ; 
     if replperiod is null then 
     select repl_period into replperiod from  customer where cust_code = as_custcode ;
     if replperiod is null then 
     select var_value into replperiod  from disparm where prd_code = '999999' and var_name = 'REPL_PERIOD';
    end if;
    end if;
	end if;
	
  lc_netsale := ROUND(lc_sales /replperiod) * replfactor;
  
	lc_netsale := lc_netsale - lc_clstock - lc_transQty ;

   lc_netrate := lc_netsale * lc_rate ;

	 Return ROUND(lc_netsale);
end;
 