package ibase.dashboard.wms.ejb;


import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

/**
 * Session Bean implementation class ProfitLossBalSheet
 */
@Stateless

public class ProfitNLossSummary extends ValidatorEJB  implements ProfitNLossSummaryLocal, ProfitNLossSummaryRemote {

    /**
     * Default constructor. 
     */
	JSONObject rawDataJson = new JSONObject();   
	String codes[]=new String[20];
	String signs[] =new String[20];
	DecimalFormat decFormator =new DecimalFormat("#.##");
	String currancyCode = "";
	String titleCodeParentMain = "";
	LinkedHashMap<String, String> createRowBufferMap = new LinkedHashMap<String, String>();; 

	@SuppressWarnings("unchecked")
    public JSONObject generateReport(String siteCode,String acctPrd, String formatCode,String reportType,String dataSourceName, String formatValueScale) throws RemoteException, ITMException
    { 	
    	
    	ResultSet rs=null;
    	ResultSet rs1 = null;
   		PreparedStatement pstmt=null;
   		PreparedStatement pstmt1 = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String sql="";
   		String sql1="";
   		JSONObject rowData = null;
   		String factor="";
   		String titleCode="",titleCodeParent = "";
   		String titleDescr="";
   		String siteDescr="";
   		String balType="";
   		String codeString="";
   		StringBuffer rowBuffer = null;
   		double curGroupTotal,preGroupTotal;
   		int printLevel = 0;
		int llCount=0;
		String curFinPrdFrom = "",curFinPrdTo = "",prvFinPrdFrom = "",prvFinPrdTo = "",prvFinPeriod = "";
		boolean noScrollRequired = false;
		try
   		{
    	
    	conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;	
		
		if((formatValueScale == null)  || (formatValueScale.length() == 0))
		{
			formatValueScale = "1";
		}
		System.out.println("formatValueScale: "+formatValueScale);
		
		sql = "SELECT C.code CUR_CODE, (SELECT D.code FROM acctprd D WHERE C.FR_DATE-1 BETWEEN D.FR_DATE AND D.To_DATE ) AS prv_fin_prd FROM acctprd C WHERE C.code IN ('"+acctPrd+"')";
    	pstmt = conn.prepareStatement(sql);		
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			prvFinPeriod  = checkNull(rs.getString("prv_fin_prd"));
		}
		rs.close();
		rs=null;
		pstmt.close();
		pstmt=null;	
		
		sql = "SELECT MIN(code) AS cur_prd_code_from, MAX(code)  AS cur_prd_code_to FROM period WHERE acct_prd='"+acctPrd+"'";
    	pstmt = conn.prepareStatement(sql);		
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			curFinPrdFrom = checkNull(rs.getString("cur_prd_code_from"));
			curFinPrdTo   = checkNull(rs.getString("cur_prd_code_to"));
		}
		rs.close();
		rs=null;
		pstmt.close();
		pstmt=null;	
		
		sql = "SELECT MIN(code) AS prv_prd_code_from, MAX(code)  AS prv_prd_code_to FROM period WHERE acct_prd='"+prvFinPeriod+"'";
    	pstmt = conn.prepareStatement(sql);		
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			prvFinPrdFrom = checkNull(rs.getString("prv_prd_code_from"));
			prvFinPrdTo   = checkNull(rs.getString("prv_prd_code_to"));
		}
		rs.close();
		rs=null;
		pstmt.close();
		pstmt=null;	
		
		
		sql="select s.site_code, s.descr, fi.curr_code from finent fi inner join site s on fi.fin_entity=s.fin_entity  where s.site_code = ?";
		pstmt = conn.prepareStatement(sql);		
		pstmt.setString(1, siteCode);
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			siteDescr= checkNull(rs.getString("descr"));
			currancyCode= checkNull(rs.getString("curr_code"));
		}
		
		if((reportType==null)|| (reportType.length()<0))
		{
			reportType = formatCode;
		}
		rs.close();
		rs=null;
		pstmt.close();
		pstmt=null;		
		
		sql =" select PL_FORMAT.TITLE_CODE, PL_FORMAT.DESCR, PL_FORMAT.SCHEDULE_NO, PL_FORMAT.SCHEDULE_NO_NEXT, "
	             +" PL_FORMAT.TITLE_CODE__PARENT,pl_format.cmp_grp, pl_format.cmp_sgrp,pl_format.cmp_acct, "
	             +" pl_format.disp_tot,pl_format.disp_type,pl_format.print_level,pl_format.underline, "
	             +" pl_format.bal_type FROM pl_format  where (PL_FORMAT.TITLE_CODE__PARENT is null  or ascii( pl_format.title_code__parent) <= 32 ) And PL_FORMAT.FORMAT_CODE ='"+formatCode + "' and pl_format.report_type = '"+ reportType + "' ORDER BY pl_format.print_level ASC ";
	 
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
			rs = pstmt.executeQuery();
			int count = 0, rowCount = 0;
			rs.last();
			rowCount = rs.getRow();
			rs.beforeFirst();
			
			String prvFinYear = "";
			if(prvFinPeriod.trim()!=null && prvFinPeriod.trim().length() > 0)
			{
				prvFinYear= "("+prvFinPeriod+")";
			}
			
			
			if(!(rowCount == 0)){
				rowBuffer = new StringBuffer("<table border='1'  width='100%' cellpadding='4' name ='localityDetail'  style = 'table-layout: fixed; width: 100%;'  id='htmlTable' class = 'mtBackgroundWhite' cellpadding='3' " +
						"border='1'><thead class='mtBackgroundWhitethead'><tr><td rowspan='2' align='center' class = 'commonHeaderCardhtml' style='width: 5%;'>Description</td> <td colspan='2'  " +
						"align='center' style='width: 4%;' class = 'commonHeaderCardhtml'>Current financial year ("
						+acctPrd+") - "+currancyCode+"</td> <td colspan='2' align='center' style='width: 4%;' " +
						"class = 'commonHeaderCardhtml'>Previous financial year ("+prvFinYear+
						") - "+currancyCode+"</td></tr><tr><td align='center' style='width: 2%;' class = 'commonHeaderCardhtml'>In</td>" +
						"<td class='commonHeaderCardhtml' align='center' style='width: 2%;'>Out</td>" +
						"<td class='commonHeaderCardhtml' align='center' style='width: 2%;'>In</td>" +
						"<td align='center' style='width: 2%;' class = 'commonHeaderCardhtml'>Out</td></tr></thead>" +
						"<tbody class='mtBackgroundWhitetbody'>");
			}
			else{
				rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data Found</td></tr></table>");
				noScrollRequired = true;
			}
			while (rs.next())
			{
				titleCode      = checkNull(rs.getString("TITLE_CODE"));
				titleCodeParent= checkNull(rs.getString("TITLE_CODE__PARENT"));
				titleDescr     = checkNull(rs.getString("DESCR"));
				balType        = checkNull(rs.getString("bal_type")); 
				/*rowData        = new JSONObject();
				rowData.put("title_descr",titleDescr );
				if(count == 0){
					rowData.put("heading",heading );
				}else {
					rowData.put("heading","");
				}*/
				
				curGroupTotal = 0.0;
				preGroupTotal = 0.0;
				printLevel    = 0;
				
				sql1="SELECT count(*)  as total "		  
					 +" FROM pl_format "  
					 +" where PL_FORMAT.TITLE_CODE__PARENT = ? " 
					 +" and pl_format.format_code=?";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, titleCode);	
				pstmt1.setString(2, formatCode);	
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					llCount = (rs1.getInt("total"));
				}
				rs1.close();
				rs1=null;
				pstmt1.close();
				pstmt1=null;
				
				if(llCount >0)
				{
					if(populateSubGroup(siteCode,siteDescr,titleCode,curGroupTotal,preGroupTotal, printLevel,acctPrd,curFinPrdFrom,curFinPrdTo,prvFinPeriod,
							prvFinPrdFrom,prvFinPrdTo,formatCode,reportType,factor,rawDataJson,dataSourceName,titleCodeParent,conn,rowBuffer,formatValueScale))
					{
						
					}
				}
				else
				{
					System.out.println("In generateReport Method");
					/*******************start of  group formula******************/
					codeString = checkNull(rs.getString("cmp_grp"));
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempGroupCode = "";
						double ldAmount = 0.0;
						getformula_arys(codeString);
						System.out.println("codes:"+codes+"///////signs:"+signs);
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							tempGroupCode = codes[llCtr-1];
							// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code )  " 
									 +" and ( acctbal.acct_prd		=	'"+acctPrd+"'	) "  
									 +" and ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"')) " 
									 +" AND ( acctsgrp.group_code = '"+tempGroupCode+"' )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+acctPrd+"') and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+acctPrd+"') and "  
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}							
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = checkDoubleNull(rs1.getString("total")); 
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
                            {
                                curGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("curGroupTotal:"+curGroupTotal);
						//end of current year	
							
						//Start of Previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code )  " 
									 +" and ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) "  
									 +" and ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ))  " 
									 +" AND ( acctsgrp.group_code = '"+tempGroupCode+"' )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"') and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
                            {
                                preGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("preGroupTotal:"+preGroupTotal);
						// end of previous year
						} // end of for of codes.length //end of  group formula
						
					}
					System.out.println("end  of group formula");
				/***********end if of group formula**************/
					
				/***********Start of sub group formula********************/	
					codeString = checkNull(rs.getString("cmp_sgrp"));	
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempSubGroupCode="";
						double ldAmount=0.0;
						getformula_arys(codeString) ;
						
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							tempSubGroupCode = codes[llCtr-1];
						// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and  "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) "
									+"and ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"' ))  "
									+" AND ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"')"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and  "
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) AND "
									+" ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal,accounts,acctsgrp  "
								    +" WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) AND "
									+" ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
                            {
                                curGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("curGroupTotal:"+curGroupTotal);
						//end of current year	
						//start  of previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									 +" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									 +" ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ))  "
									 +"AND ( acctsgrp.group_code = '"+tempSubGroupCode+"' )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempSubGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempSubGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							
							if(llCtr==1)
                            {
                                preGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
 
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("preGroupTotal:"+preGroupTotal);
					    //end of previous year
						}
						
					}	
					System.out.println("end  of sub group formula");
				/***********End of sub group formula********************/	
					
				/***********Start of a/c group formula********************/
					codeString = checkNull(rs.getString("cmp_acct"));
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempAcctGroupCode="";
						double ldAmount=0.0;
						getformula_arys(codeString) ;
						
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							tempAcctGroupCode = codes[llCtr-1];
						// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and  "
									+" ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"' ) ) "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"')"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and  "
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) AND "
									+" ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal,accounts,acctsgrp  "
								    +" WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) AND "
									+" ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							
							if (rs1.next())
							{
								ldAmount =( rs1.getInt("total")); //sum
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							
							if(llCtr==1)
                            {
                                curGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
 
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    curGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("curGroupTotal:"+curGroupTotal);
						//end of current year	
						//start  of previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code )  " 
									 +"and ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	)  "  
									 +" and ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ) ) "
									 +"AND ( acctbal.acct_code = '"+tempAcctGroupCode+"')"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"' ) "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+ siteCode + "') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount =( rs1.getInt("total")); //sum
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
                            {
                                preGroupTotal += ldAmount;
                            }
                            else if(llCtr==2)
 
                            {
                                System.out.println("signs:"+Arrays.toString(signs));
                                if("+".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal += ldAmount;
                                }
                                else if("-".equalsIgnoreCase(signs[(llCtr-1) - 1]))
                                {
                                    preGroupTotal -= ldAmount;
                                }
                            }
							System.out.println("preGroupTotal:"+preGroupTotal);
					    //end of previous year
						}						
					}	
					System.out.println("end  of a/c group formula");
				/***********End of a/c group formula********************/	
					/*rowData.put("curr_out_val", curGroupTotal);
					rowData.put("prev_out_val", preGroupTotal);
					rowData.put("curr_in_val", 0);
					rowData.put("prev_in_val", 0);
					rawDataJson.put(count, rowData);*/
					rowBuffer.append("<tr class='mtBackgroundWhitetbodytr'><td class= 'cardHtmlTableBodyAlignLft' style='width: 5%; overflow: hidden;'>"+titleDescr+"</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>0.0</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(curGroupTotal/Integer.parseInt(formatValueScale))+"</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>0.0</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(preGroupTotal/Integer.parseInt(formatValueScale))+"</td></tr>");
					System.out.println("In generatereport() count:"+count+" titleDescr: "+titleDescr+"curr_in_val: 0.0 ,prev_in_val:0.0, curr_out_val: "+curGroupTotal+"prev_out_val: "+preGroupTotal);
					count++;	
				} // end of else of llCount >0				
			}// end of while
			System.out.println("After all execution==========================");
			createRowBufferForTable(rowBuffer,formatValueScale);
			rowBuffer.append("</tbody></table>");
			System.out.println("rowBuffer"+rowBuffer);
			System.out.println("createRowBufferMap map value: "+createRowBufferMap);
			rowData = new JSONObject();
			rowData.put("plblTableData", rowBuffer.toString());
			if(noScrollRequired){
				rowData.put("tableScroll", "");
				rowData.put("exportToExcel", "");
			}
			else{
				rowData.put("tableScroll", "style='overflow-y: scroll; height: 350px;'");
				//rowData.put("exportToExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='30px' height='30px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel()'></td>");
			}
			rawDataJson.put(0, rowData);
   		}
   		catch(Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		} finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :ProfitLossBalSheet:generateReport:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}	
    	return rawDataJson;
    }
    
    @SuppressWarnings("unchecked")
	public boolean populateSubGroup(String siteCode,String siteDescr,String titleCode,double curGroupTotal,double preGroupTotal,
    		int printLevel,String acctPrd,String curFinPrdFrom,String curFinPrdTo,String prvFinPeriod,
    		String prvFinPrdFrom,String prvFinPrdTo,String formatCode,String reportType,String factor,JSONObject rawDataJson,String dataSourceName,String titleCodeParent, Connection conn,StringBuffer rowBuffer, String formatValueScale) throws RemoteException, ITMException
    {
    	ResultSet rs=null;
    	ResultSet rs1 = null;
   		PreparedStatement pstmt = null;
   		PreparedStatement pstmt1 = null;
   		//Connection conn = null;
   		//ConnDriver connDriver = null;
   		String sql="";
   		String sql1="";
   		JSONObject rowData = null;
   		String titleCodeLocal ="";
   		String titleDescr="";
   		String siteDescrSGrp="";
   		String balType="";
   		String factorSGrp="";
   		String codeString="";
   		double totalCurr[]=null;
   		double totalPrev[]=null;
   		double curGroupTotalSGrp=0.0;
   		double preGroupTotalSGrp=0.0, currAmount = 0.0, prvAmount = 0.0;
		int llCount=0;
		String currTitleCode = "";
		
   		try
   		{
			/*for(int i=0;i<100;i++)
			{
				totalCurr[i]=0;
				totalPrev[i]=0;
			}*/
   			
			sql =" select PL_FORMAT.TITLE_CODE, PL_FORMAT.DESCR, PL_FORMAT.SCHEDULE_NO, PL_FORMAT.SCHEDULE_NO_NEXT, "
		             +" PL_FORMAT.TITLE_CODE__PARENT,pl_format.cmp_grp, pl_format.cmp_sgrp,pl_format.cmp_acct, "
		             +" pl_format.disp_tot,pl_format.disp_type,pl_format.print_level,pl_format.underline, "
		             +" pl_format.bal_type FROM pl_format where  PL_FORMAT.TITLE_CODE__PARENT = '"+titleCode+"' "
		             +" AND PL_FORMAT.FORMAT_CODE ='"+formatCode+ "' and  pl_format.report_type ='"+reportType+ "' ORDER BY pl_format.print_level ASC ";
			 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			printLevel=0;
			while (rs.next())
			{
				printLevel++;
				totalCurr = new double[printLevel+1];
				totalPrev = new double[printLevel+1];
				totalCurr[printLevel]=0;
				totalPrev[printLevel]=0;
				System.out.println("printlevel: "+printLevel);
				
				titleCodeLocal = checkNull(rs.getString("TITLE_CODE"));
				titleDescr     = checkNull(rs.getString("DESCR"));
				balType        = checkNull(rs.getString("bal_type")); 
				String prvTitleCode = "";
				currTitleCode  = checkNull(rs.getString("TITLE_CODE__PARENT"));
				/*rowData = new JSONObject();
				rowData.put("title_descr",titleDescr );*/
				
				
				curGroupTotalSGrp = 0.0;
				preGroupTotalSGrp = 0.0;
				
				
				sql1="SELECT count(*)  as total FROM pl_format where PL_FORMAT.TITLE_CODE__PARENT = ? " 
					 +" and pl_format.format_code=?";
				
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, titleCodeLocal);	
				pstmt1.setString(2, formatCode);	
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					llCount = rs1.getInt("Total");
				}
				
				rs1.close();
				rs1=null;
				pstmt1.close();
				pstmt1=null;
				
				if(llCount >0)
				{
					if(populateSubGroup(siteCode,siteDescrSGrp,titleCodeLocal,curGroupTotalSGrp,preGroupTotalSGrp,
							printLevel,acctPrd,curFinPrdFrom,curFinPrdTo,prvFinPeriod,prvFinPrdFrom,prvFinPrdTo,formatCode,
							          	reportType,factorSGrp,rawDataJson,dataSourceName,titleCodeParent,conn,rowBuffer, formatValueScale))
					{
						totalCurr[printLevel] = 0;
						totalPrev[printLevel]= 0;
						printLevel--;
					}
					
				}
				else
				{
					/*******************start of  group formula******************/
					System.out.println("In populate Method");
					codeString = checkNull(rs.getString("cmp_grp"));
					System.out.println("codeString: "+codeString);
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempGroupCode="";
						double ldAmount=0.0;
						getformula_arys(codeString) ;
						System.out.println("Codes: "+Arrays.toString(codes)+" ///////Signs: "+Arrays.toString(signs));
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							System.out.println("llCtr: "+llCtr);
							tempGroupCode = codes[llCtr-1];
							// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total,  Acctbal.curr_code__ac " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									 +" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "  
									 +" ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"' ) AND " 
									 +" ( acctsgrp.group_code = '"+tempGroupCode+"' ) ) group by  Acctbal.curr_code__ac"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total,  Acctbal.curr_code__ac " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' )) group by  Acctbal.curr_code__ac";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total,  Acctbal.curr_code__ac " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "  
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' )) group by  Acctbal.curr_code__ac";
							}							
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); 
								System.out.println("curr ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								curGroupTotalSGrp = ldAmount;
							}
							else if(llCtr==2)
							{
								System.out.println("In curr llctr is 2 ");
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									curGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									curGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("curGroupTotalSGrp: group"+curGroupTotalSGrp);
						//end of current year	
							
						//Start of Previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+ siteCode + "') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									 +" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									 +" ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ) AND " 
									 +" ( acctsgrp.group_code = '"+tempGroupCode+"' ) )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+ siteCode + "') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+ siteCode + "') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
								System.out.println("prev ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								preGroupTotalSGrp = ldAmount;
								
							}
							else if(llCtr==2)
							{
								System.out.println("In prev llctr is 2 ");
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									preGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									preGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("preGroupTotalSGrp: group"+preGroupTotalSGrp);
						// end of previous year
						} // end of for of codes.length //end of  group formula
						
					}
				/***********end if of group formula**************/
					
				/***********Start of sub group formula********************/	
					codeString = checkNull(rs.getString("cmp_sgrp"));	
					System.out.println("codeString: "+codeString);
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempSubGroupCode="";
						double ldAmount=0.0;
						getformula_arys(codeString) ;
						System.out.println("Codes: "+Arrays.toString(codes)+" ///////Signs: "+Arrays.toString(signs));
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							System.out.println("llCtr: "+llCtr);
							tempSubGroupCode = codes[llCtr-1];
						// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode + "') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd +"'	) and  "
									+" ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"' ) AND "
									+" ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"' ))"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+ siteCode + "') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+ acctPrd +"'	) and  "
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) AND "
									+" ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal,accounts,acctsgrp  "
								    +" WHERE site_code IN ('"+ siteCode + "') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+ acctPrd +"'	) and "
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) AND "
									+" ( acctsgrp.sgroup_code = '"+tempSubGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = checkDoubleNull(rs1.getString("total")); //sum
								System.out.println("curr ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								curGroupTotalSGrp += ldAmount;
								
							}
							else if(llCtr==2)
							{
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									curGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									curGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("curGroupTotalSGrp subgroup: "+curGroupTotalSGrp);
						//end of current year	
						//start  of previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+ siteCode + "') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									 +" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									 +" ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ) AND " 
									 +" ( acctsgrp.group_code = '"+tempSubGroupCode+"' ) )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+ siteCode + "') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempSubGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+ siteCode + "') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+ prvFinPeriod +"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctsgrp.group_code = '"+tempSubGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
								System.out.println("prev ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								preGroupTotalSGrp += ldAmount;
							}
							else if(llCtr==2)
							{
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									preGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									preGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("preGroupTotalSGrp subgroup: "+preGroupTotalSGrp);
					    //end of previous year
						}
					}	
				/***********End of sub group formula********************/	
					
				/***********Start of a/c group formula********************/
					codeString = checkNull(rs.getString("cmp_acct"));	
					System.out.println("codeString: "+codeString);
					if(codeString.trim()!=null && codeString.trim().length() > 0)
					{
						String tempAcctGroupCode="";
						double ldAmount=0.0;
						getformula_arys(codeString) ;
						System.out.println("Codes: "+Arrays.toString(codes)+" ///////Signs: "+Arrays.toString(signs));
						for(int llCtr=1;llCtr<=codes.length;llCtr++)
						{
							System.out.println("llCtr: "+llCtr);
							tempAcctGroupCode = codes[llCtr-1];
						// start of current year 							
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) "
									+" and  ( acctbal.acct_prd		=	'"+acctPrd+"'	)   "
									+" and ( (acctbal.prd_code between '000000' and '"+curFinPrdTo+"' )  "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal, accounts, acctsgrp  WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and  "
									+" ( (acctbal.prd_code >= '000000' and acctbal.prd_code < '"+curFinPrdFrom+"' ) AND "
									+" ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total "
									+" FROM acctbal,accounts,acctsgrp  "
								    +" WHERE site_code IN ('"+siteCode+"') AND  "
									+" ( acctbal.acct_code = accounts.acct_code ) and  "
									+" ( acctsgrp.sgroup_code = accounts.sgroup_code ) and "
									+" ( acctbal.acct_prd		=	'"+acctPrd+"'	) and "
									+" ( (acctbal.prd_code between '"+curFinPrdFrom+"' and '"+curFinPrdTo+"' ) AND "
									+" ( acctbal.acct_code = '"+tempAcctGroupCode+"' ))";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount = (rs1.getInt("total")); //sum
								System.out.println("curr ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								curGroupTotalSGrp += ldAmount;
							}
							else if(llCtr==2)
							{
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									curGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									curGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("curGroupTotalSGrp: account "+curGroupTotalSGrp);
						//end of current year	
						//start  of previous year
							if(balType.trim().equals("C"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									 +" FROM acctbal,  accounts, acctsgrp "  
									 +" WHERE site_code IN ('"+siteCode+"') AND "  
									 +" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									 +" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									 +" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									 +" ( (acctbal.prd_code between '000000' and '"+prvFinPrdTo+"' ) AND " 
									 +" ( acctbal.acct_code = '"+tempAcctGroupCode+"' ) )"; 
							}
							else if(balType.trim().equals("O"))
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal,   accounts, 	acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+"  acctbal.acct_code 		= 	accounts.acct_code  and "  
									+"  acctsgrp.sgroup_code 	= 	accounts.sgroup_code  and " 
									+"  acctbal.acct_prd		=	'"+prvFinPeriod+"'	 and "  
									+" acctbal.prd_code >= '000000' and acctbal.prd_code < '"+prvFinPrdFrom+"'  "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"'";
							}
							else 
							{
								sql="SELECT sum(case when accounts.typ_bal = 'D' then acctbal.dr_amt__base - acctbal.cr_amt__base else acctbal.cr_amt__base - acctbal.dr_amt__base end) as total " 
									+" FROM acctbal, accounts,acctsgrp "  
									+" WHERE site_code IN ('"+siteCode+"') AND "  
									+" ( acctbal.acct_code 		= 	accounts.acct_code ) and "  
									+" ( acctsgrp.sgroup_code 	= 	accounts.sgroup_code ) and " 
									+" ( acctbal.acct_prd		=	'"+prvFinPeriod+"'	) and "  
									+" ( (acctbal.prd_code between '"+prvFinPrdFrom+"' and '"+prvFinPrdTo+"' ) "
									+" AND ( acctbal.acct_code = '"+tempAcctGroupCode+"' )";
							}
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								ldAmount =( rs1.getInt("total")); //sum
								System.out.println("prev ldAmount: "+ldAmount);
							}
							pstmt1.close();
							pstmt1=null;
							rs1.close();
							rs1=null;
							if(llCtr==1)
							{
								preGroupTotalSGrp += ldAmount;
							}
							else if(llCtr==2)
							{
								if(signs[(llCtr-1) - 1].equalsIgnoreCase("+"))
								{
									preGroupTotalSGrp += ldAmount;
								}
								else if(signs[(llCtr-1) - 1].equalsIgnoreCase("-"))
								{
									preGroupTotalSGrp -= ldAmount;
								}
							}
							System.out.println("preGroupTotalSGrp: account "+preGroupTotalSGrp);
					    //end of previous year
						}						
					}	
					
				/***********End of a/c group formula********************/
					
					/*rowData.put("curr_in_val", curGroupTotalSGrp);
					rowData.put("prev_in_val", preGroupTotalSGrp);
					*/
					totalCurr[printLevel] += curGroupTotalSGrp;
					totalPrev[printLevel] += preGroupTotalSGrp;
					

					if((currTitleCode!=null && currTitleCode.length()>0) && "".equalsIgnoreCase(prvTitleCode))
					{
						currAmount += curGroupTotalSGrp;
						prvAmount  += preGroupTotalSGrp;
						
					}
					else if(prvTitleCode.equalsIgnoreCase(currTitleCode))
					{
						currAmount += curGroupTotalSGrp;
						prvAmount  += preGroupTotalSGrp;
					}
					prvTitleCode = currTitleCode;
					
					createRowBufferMap.put(titleDescr, curGroupTotalSGrp+"~"+preGroupTotalSGrp);
					/*rowData.put("curr_out_val", totalCurr[printlevel]);
					rowData.put("prev_out_val", totalPrev[printlevel]);
					rawDataJson.put(count, rowData);*/
					//System.out.println("totalCurr: "+totalCurr.toString()+" totalCurr length : "+totalCurr.length+" totalPrev: "+totalPrev.toString()+" totalPrev length : "+totalPrev.length);
					/*System.out.println("totalCurr: "+Arrays.toString(totalCurr)+" totalPrev: "+Arrays.toString(totalPrev));
					rowBuffer.append("<tr class='mtBackgroundWhitetbodytr'><td class= 'cardHtmlTableBodyAlignLft' style='width: 5%; overflow: hidden;'>"+titleDescr+"</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(curGroupTotalSGrp/Integer.parseInt(formatValueScale))+"</td>");
					System.out.println("totalCurr[printlevel]: "+totalCurr[printLevel]);
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(currAmount/Integer.parseInt(formatValueScale))+"</td>");
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(preGroupTotalSGrp/Integer.parseInt(formatValueScale))+"</td>");
					System.out.println("totalPrev[printlevel]: "+totalPrev[printLevel]);
					rowBuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(prvAmount/Integer.parseInt(formatValueScale))+"</td></tr>");
					System.out.println("In populate() count:"+count+" titleDescr: "+titleDescr+"curr_in_val: "+curGroupTotalSGrp+"prev_in_val: "+preGroupTotalSGrp+"curr_out_val: "+totalCurr[printLevel]+"prev_out_val: "+totalPrev[printLevel]);
					*/
					//System.out.println("printlevel: "+printlevel);
					count++;	
				} // end of else of llCount >0				
			}// end of while 
			createRowBufferMap.put(titleDescr+"extra", currAmount+"~"+prvAmount);
   		}
   		catch(Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		} finally
   		{
   			try
   			{
   				/*if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;*/
   				if (rs != null){
   					rs.close();
   					rs = null;
				}
				if (pstmt != null){
					pstmt.close();
					pstmt = null;
				}
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :ProfitLossBalSheet:getProductWiseRecallDetails:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}	
    			
    	return true;
    }
    
   	public JSONObject getProfitBalanceSheetDetails(String sitecode, String acctPrd,String formatcode,String reporttype,String dataSourceName, String formatValueScale) throws RemoteException, ITMException
   	{
       	JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
   		
   		try
   		{
   			acctPrd = checkNull(acctPrd);
   			if("".equalsIgnoreCase(acctPrd)){
   				int year = Calendar.getInstance().get(Calendar.YEAR);
   			    int month = Calendar.getInstance().get(Calendar.MONTH) + 1;
   			    if (month <= 3) {
   			    	acctPrd = (year - 1) + (String.valueOf(year)).substring(2, 4);
   			    } else {
   			    	acctPrd = year + (String.valueOf(year + 1)).substring(2, 4);
   			    }
   			    System.out.println("Current Financial year"+acctPrd);
   			}
   			rawDataMnthDivWiseSalesJson = generateReport(sitecode,acctPrd,formatcode,reporttype,dataSourceName,formatValueScale);
   			System.out.println("getProfitBalanceSheetDetails data :"+rawDataMnthDivWiseSalesJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		} 
   		return rawDataMnthDivWiseSalesJson;
   	}
    

    private void createRowBufferForTable(StringBuffer rowbuffer, String formatValueScale)
    {
    	for(Map.Entry<String, String> entry: createRowBufferMap.entrySet())
		{
    		String mapKey = entry.getKey();
			String mapValue = entry.getValue();
			
			String[] splitMapValue = mapValue.split("~");
			
			System.out.println(mapKey+" : "+Arrays.toString(splitMapValue)+"\n");
			
			//System.out.println("totalCurr: "+Arrays.toString(totalCurr)+" totalPrev: "+Arrays.toString(totalPrev));
			if(!(mapKey.contains("extra")))
			{
				rowbuffer.append("<tr class='mtBackgroundWhitetbodytr'><td class= 'cardHtmlTableBodyAlignLft' style='width: 5%; overflow: hidden;'>"+mapKey+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[0])/Integer.parseInt(formatValueScale))+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[1])/Integer.parseInt(formatValueScale))+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+"</td></tr>");
			}
			else
			{
				rowbuffer.append("<tr class='mtBackgroundWhitetbodytr'><td class= 'cardHtmlTableBodyAlignLft' style='width: 5%; overflow: hidden;'>"+mapKey.replace("extra", " ")+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[0])/Integer.parseInt(formatValueScale))+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[0])/Integer.parseInt(formatValueScale))+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[1])/Integer.parseInt(formatValueScale))+"</td>");
				rowbuffer.append("<td class= 'cardHtmlTableBodyAlignRgt' style='width: 2%; overflow: hidden;'>"+decFormator.format(Double.parseDouble(splitMapValue[1])/Integer.parseInt(formatValueScale))+"</td></tr>");
			}
		}
    }
    
    private double checkDoubleNull(String str)
	{
		if(str == null || str.trim().length() == 0)
		{
			return 0.0;
		}
		else
		{
			return Math.round(Double.parseDouble(str)* Math.pow(10, 2)) / Math.pow(10, 2); 
		}
	}
    private String checkNull(String str)
	{
		if(str == null || str.trim().length() == 0)
		{
			return "";
		}
		else{
			str = str.trim();
		}
		return str;
	}
    private void getformula_arys(String codeString)
    {
    	List<String> operatorList = new ArrayList<String>();
    	 List<String> operandList = new ArrayList<String>();
    	 StringTokenizer st = new StringTokenizer(codeString, "+-*/", true);
    	 while (st.hasMoreTokens()) {
    	    String token = st.nextToken();

    	    if ("+-/*".contains(token)) {
    	       operatorList.add(token);
    	    } else {
    	       operandList.add(token);
    	    }
    	 }
    	 codes=  operandList.toArray(new String[operandList.size()]);
    	 signs=  operatorList.toArray(new String[operatorList.size()]);
    }
  
}
