/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.user.client.Window;
import com.google.gwt.xml.client.NodeList;
import ibase.e12ria.client.E12ActionWrapper;
import ibase.e12ria.client.ObjFormDetails;
import ibase.e12ria.e12widgets.collections.FeedData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ObjDetails {
    private static HashMap<String, ObjDetails> objDetails = null;
    private HashMap<String, ObjFormDetails> objFormDetailsMap = new HashMap();
    private HashMap<String, E12ActionWrapper> e12ActionWrapperMap = new HashMap();
    private ArrayList<Integer> subFormsList = new ArrayList();
    private int startForm = 1;
    private String isAttachment;
    private String isRepeateAdd;
    private String isAutoSave;

    public static ObjDetails get(String objName) {
        try {
            if (objDetails == null) {
                objDetails = new HashMap();
            }
            if (!objDetails.containsKey(objName)) {
                objDetails.put(objName, new ObjDetails());
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception : ObjDetails getInstance " + e.getMessage()));
            e.printStackTrace();
        }
        return objDetails.get(objName);
    }

    public void createObjFormDetails(String objName, String objFormDetailString) {
        try {
            String[] formTokens = objFormDetailString.split("~");
            int formTokenLen = formTokens.length;
            int formInfoCtr = 0;
            while (formInfoCtr < formTokenLen) {
                String formToken = formTokens[formInfoCtr];
                if (formToken.indexOf("#") != -1) {
                    String[] propTokens = formToken.split("#");
                    int propTokenLen = propTokens.length;
                    ObjFormDetails objFormDetails = new ObjFormDetails();
                    objFormDetails.setObjName(objName);
                    objFormDetails.setTitle(propTokens[0]);
                    objFormDetails.setScrFlag(propTokens[1]);
                    if (propTokenLen > 2) {
                        String formType = this.checkNull(propTokens[2]);
                        objFormDetails.setFormType(formType);
                        if (formType.contains(":")) {
                            String[] multiFormArr = formType.split(":");
                            int mulPgStartNo = (int)Double.parseDouble(multiFormArr[0]) + 1;
                            int mulPgEndNo = (int)Double.parseDouble(multiFormArr[2]) - 1;
                            while (mulPgStartNo < mulPgEndNo) {
                                this.addSubForm(mulPgStartNo + 1);
                                ++mulPgStartNo;
                            }
                        }
                    } else {
                        objFormDetails.setFormType("");
                    }
                    if (propTokenLen > 3) {
                        objFormDetails.setDispMetadata(this.checkNull(propTokens[3]));
                    } else {
                        objFormDetails.setDispMetadata("");
                    }
                    if (propTokenLen > 4) {
                        objFormDetails.setParentKeyCol(this.checkNull(propTokens[4]));
                    } else {
                        objFormDetails.setParentKeyCol("");
                    }
                    if (propTokenLen > 5) {
                        objFormDetails.setScanMetadata(this.checkNull(propTokens[5]));
                    } else {
                        objFormDetails.setScanMetadata("");
                    }
                    if (propTokenLen > 6) {
                        objFormDetails.setAssistedMode(this.checkNull(propTokens[6]));
                    } else {
                        objFormDetails.setAssistedMode("");
                    }
                    if (propTokenLen > 7) {
                        objFormDetails.setStorageKeyMetadata(this.checkNull(propTokens[7]));
                    }
                    if (propTokenLen > 8) {
                        objFormDetails.setSelectionMode(this.checkNull(propTokens[8]));
                    } else {
                        objFormDetails.setSelectionMode("");
                    }
                    if (propTokenLen > 9) {
                        objFormDetails.setDefaultView(this.checkNull(propTokens[9]));
                    } else {
                        objFormDetails.setDefaultView("A");
                    }
                    this.objFormDetailsMap.put("" + (formInfoCtr + 1), objFormDetails);
                } else {
                    this.setIsAttachment(formToken);
                }
                ++formInfoCtr;
            }
        }
        catch (Exception ex) {
            Window.alert((String)("Exception createObjFormDetails:[" + ex.getMessage() + "]"));
        }
    }

    public ObjFormDetails getObjFormDetails(int formNo) {
        return this.getObjFormDetails(String.valueOf(formNo));
    }

    public ObjFormDetails getObjFormDetails(String formNo) {
        ObjFormDetails objFormDetail = this.objFormDetailsMap.get(formNo);
        if (objFormDetail == null) {
            objFormDetail = new ObjFormDetails();
            this.objFormDetailsMap.put(formNo, objFormDetail);
        }
        return objFormDetail;
    }

    public int getNoOfForms() {
        return this.objFormDetailsMap.size();
    }

    public void createActionWrapper(NodeList actionInfoNodeLst) {
        try {
            int i = 0;
            while (i < actionInfoNodeLst.getLength()) {
                E12ActionWrapper actionWrapper = new E12ActionWrapper(actionInfoNodeLst.item(i).getAttributes());
                E12ActionWrapper prevActionWrapper = this.e12ActionWrapperMap.get(actionWrapper.getObjContext());
                if (prevActionWrapper != null) {
                    prevActionWrapper.setRightsChar(actionWrapper.getId());
                    this.e12ActionWrapperMap.put(actionWrapper.getObjContext(), prevActionWrapper);
                } else {
                    actionWrapper.setRightsChar(actionWrapper.getId());
                    this.e12ActionWrapperMap.put(actionWrapper.getObjContext(), actionWrapper);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception createActionWrapper:[" + e.getMessage() + "]"));
        }
    }

    public E12ActionWrapper getActionWrapper(int formNo) {
        return this.getActionWrapper(String.valueOf(formNo));
    }

    public E12ActionWrapper getActionWrapper(String formNo) {
        E12ActionWrapper actionWrapper = this.e12ActionWrapperMap.get(formNo);
        if (actionWrapper == null) {
            actionWrapper = new E12ActionWrapper();
            this.e12ActionWrapperMap.put(formNo, actionWrapper);
        }
        return actionWrapper;
    }

    private String checkNull(String value) {
        if (value == "undefined" || value == null || "null".equalsIgnoreCase(value) || "undefined".equalsIgnoreCase(value)) {
            value = "";
        }
        return value;
    }

    public void setIsAttachment(String isAttachment) {
        this.isAttachment = isAttachment;
    }

    public boolean isAttachment() {
        return "Y".equalsIgnoreCase(this.isAttachment);
    }

    public void setIsRepeateAdd(String isRepeateAdd) {
        this.isRepeateAdd = isRepeateAdd;
    }

    public boolean isRepeateAdd() {
        return "Y".equalsIgnoreCase(this.isRepeateAdd);
    }

    public void setStartForm(String startForm) {
        if (!"".equalsIgnoreCase(startForm)) {
            Double dStartForm = Double.parseDouble(startForm);
            this.startForm = dStartForm.intValue();
        }
    }

    public int getStartForm() {
        return this.startForm;
    }

    public void addSubForm(int formNo) {
        if (!this.subFormsList.contains(formNo)) {
            this.subFormsList.add(formNo);
        }
    }

    public boolean isSubForm(int formNo) {
        return this.subFormsList.contains(formNo);
    }

    public int getParentFormNo(int formNo) {
        while (this.subFormsList.contains(formNo)) {
            --formNo;
        }
        return formNo;
    }

    public String getFeedTitle(HashMap<String, String> feedDataMap, ArrayList<FeedData> subRowFormDataLst, String delimiter, int formNo) {
        String feedInfoStr = this.getObjFormDetails(formNo).getDispMetadata();
        if (feedInfoStr != null && feedInfoStr.indexOf("@img") != -1) {
            feedInfoStr = feedInfoStr.substring(feedInfoStr.lastIndexOf("@img") + 4);
        }
        StringBuffer feedTitle = new StringBuffer();
        try {
            Boolean flag = true;
            if (subRowFormDataLst != null && subRowFormDataLst.size() != 0) {
                for (FeedData subFormRowDataMap : subRowFormDataLst) {
                    String[] feedInfoArr = feedInfoStr.split(">");
                    List<String> feedInfoList = Arrays.asList(feedInfoArr);
                    for (String feedTitleStr : feedInfoList) {
                        String[] feedTitleArr = feedTitleStr.toString().split("<");
                        feedTitle.append(String.valueOf(this.checkNull(feedTitleArr[0])) + this.checkNull((String)subFormRowDataMap.get((Object)feedTitleArr[1])));
                    }
                    feedTitle.append(String.valueOf(delimiter) + " ");
                }
                feedTitle.substring(0, feedTitle.length() - 2);
            } else if (feedDataMap != null && feedDataMap.size() != 0) {
                String[] feedInfoArr = feedInfoStr.split(">");
                List<String> feedInfoList = Arrays.asList(feedInfoArr);
                for (String feedTitleStr : feedInfoList) {
                    String[] feedTitleArr = feedTitleStr.toString().split("<");
                    String feedTitleArr1 = feedTitleArr.length > 1 ? feedTitleArr[1] : "";
                    String value = this.checkNull(feedDataMap.get(feedTitleArr1));
                    if ("".equalsIgnoreCase(value)) {
                        if (flag.booleanValue()) {
                            feedTitle.append("Click here for " + this.getObjFormDetails(formNo).getTitle());
                            flag = false;
                        }
                    } else {
                        String feedTitleArr0 = feedTitleArr[0];
                        if (feedDataMap.get(feedTitleArr1) != null && feedTitleArr0 != null) {
                            feedTitle.append(String.valueOf(this.checkNull(feedTitleArr0)) + this.checkNull(feedDataMap.get(feedTitleArr1)));
                        }
                    }
                    flag = false;
                }
            } else {
                feedTitle.append("Click here for " + this.getObjFormDetails(formNo).getTitle());
            }
        }
        catch (Exception e) {
            Window.alert((String)("ObjDetails : getFeedTitle :" + e.getMessage()));
        }
        return feedTitle.toString();
    }

    public void setIsAutoSave(String isAutoSave) {
        this.isAutoSave = isAutoSave;
    }

    public boolean isAutoSave() {
        return "A".equalsIgnoreCase(this.isAutoSave);
    }

    protected static interface AssistedMode {
        public static final String NOT_APPLICABLE = "N";
        public static final String ENFORCED = "E";
        public static final String ASSISTED = "A";
    }
}

