/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.CommonConstants;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.SQLMaker;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaDataObject {
    Document dom = null;
    ArrayList columnsList;
    ArrayList argNamesList;
    ArrayList logicalNameList;
    String queryString = null;
    String tableToBeUpdated = null;
    ArrayList keyList;
    ArrayList primaryKeyPhyNameList;
    ArrayList primaryKeyLogNameList;
    ArrayList primaryKeyDataTypeList;
    HashMap colIDLogNameMap;
    HashMap colLogNameTypeMap;
    HashMap colLogNameSizeMap;
    HashMap physicalNameDisplayNameMap;
    HashMap physicalNameLogicalNameMap;
    Hashtable updateableLogPhyColNames;
    Hashtable updateableLogNameColType;
    LinkedList noUpdateBandLinkList;
    String objContext;
    private HashMap colDataTypeNameMap;
    String database = "oracle";
    protected String filename;

    public MetaDataObject(String string) throws ITMException {
        try {
            System.out.println("Creating metadata object parsing file :[" + string + "]");
            this.filename = string;
            File file = new File(string);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.dom = documentBuilder.parse(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Exception :DWObject :constructor :==>" + fileNotFoundException.getMessage());
            throw new ITMException(fileNotFoundException);
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :constructor :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    public void initialize() throws ITMException {
        try {
            this.createColumns();
            this.setArgumentNames();
            this.createKeyList();
            this.createPrimaryKeyPhyNameList();
            this.createColIDLogNameMap();
            this.createColLogNameTypeMap();
            this.createColLogNameSizeMap();
            this.createPhysicalNameDisplayNameMap();
            this.createPhysicalNameLogicalNameMap();
            this.createUpdateableLogPhyColNames();
            this.createUpdateableLogNameColType();
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :initialize :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private Node getCol_OtherTextInfo(String string) throws ITMException {
        Node node;
        block5: {
            node = null;
            try {
                NodeList nodeList = this.dom.getElementsByTagName("TextObject");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    for (int j = 1; j < n2; ++j) {
                        String string2 = null;
                        String string3 = null;
                        Node node3 = nodeList2.item(j);
                        string2 = node3.getNodeName().trim();
                        if (node3.getFirstChild() != null) {
                            string3 = node3.getFirstChild().getNodeValue().trim();
                        }
                        if (!string2.equals("name") || !string3.equals(string.trim() + "_t")) continue;
                        node = nodeList.item(i);
                        break block5;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception :DWObject :getCol_OtherTextInfo :==>" + exception.getMessage());
                throw new ITMException(exception);
            }
        }
        return node;
    }

    private Node getCol_OtherInfo(String string) throws ITMException {
        Node node;
        block5: {
            node = null;
            try {
                NodeList nodeList = this.dom.getElementsByTagName("ColumnObject");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    for (int j = 1; j < n2; ++j) {
                        String string2 = null;
                        String string3 = null;
                        Node node3 = nodeList2.item(j);
                        string2 = node3.getNodeName().trim();
                        if (node3.getFirstChild() != null) {
                            string3 = node3.getFirstChild().getNodeValue().trim();
                        }
                        if (!string2.equals("name") || !string3.equals(string)) continue;
                        node = nodeList.item(i);
                        break block5;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception :DWObject :getCol_OtherInfo :==>" + exception.getMessage());
                throw new ITMException(exception);
            }
        }
        return node;
    }

    private void setArgumentNames() throws ITMException {
        try {
            this.argNamesList = new ArrayList();
            int n = this.dom.getElementsByTagName("argument").getLength();
            for (int i = 0; i < n; ++i) {
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = "";
                NodeList nodeList = this.dom.getElementsByTagName("argument").item(i).getChildNodes();
                int n2 = nodeList.getLength();
                for (int j = 0; j < n2; ++j) {
                    if (nodeList.item(j).getFirstChild() == null) continue;
                    if (nodeList.item(j).getNodeName().equals("field_name")) {
                        string = nodeList.item(j).getFirstChild().getNodeValue();
                    }
                    if (nodeList.item(j).getNodeName().equals("name")) {
                        string2 = nodeList.item(j).getFirstChild().getNodeValue();
                        for (int k = 0; k < this.columnsList.size(); ++k) {
                            Column column = (Column)this.columnsList.get(k);
                            if (column.getDisplayName() != null && column.getLogicalName().equals(string2)) {
                                string4 = ((Column)this.columnsList.get(k)).getColType();
                            }
                            column = null;
                        }
                    }
                    if (!nodeList.item(j).getNodeName().equals("type")) continue;
                    String string5 = nodeList.item(j).getFirstChild().getNodeValue();
                    if (string4.length() > 0) {
                        string3 = string4;
                        string4 = "";
                        continue;
                    }
                    string3 = string5.equals("datetime") || string5.equals("date") ? "date" : string5;
                }
                string = string != null && string.length() > 0 ? string : string2;
                this.argNamesList.add(string + "~" + string2 + "~" + string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :setArgumentName_Type :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void setTableToBeUpdated() throws ITMException {
        try {
            NodeList nodeList = this.dom.getElementsByTagName("TableDefinition").item(0).getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i).getFirstChild() == null || !nodeList.item(i).getNodeName().equals("update")) continue;
                this.tableToBeUpdated = nodeList.item(i).getFirstChild().getNodeValue();
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :setTableToBeUpdated :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("[DWObject]Set the table to be updated :" + this.tableToBeUpdated + ":");
    }

    public void createColumns() throws ITMException {
        try {
            this.columnsList = new ArrayList();
            Node node = null;
            Node node2 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Node node3 = this.dom.getElementsByTagName("database").item(0);
            if (node3 != null && node3.getFirstChild() != null) {
                string3 = node3.getFirstChild().getNodeValue();
            }
            if (string3 == null) {
                string3 = CommonConstants.DB_NAME;
            }
            this.setDatabase(string3);
            this.setTableToBeUpdated();
            NodeList nodeList = this.dom.getElementsByTagName("table_column");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                Column column = new Column();
                int n2 = nodeList2.getLength();
                for (int j = 1; j < n2; j += 2) {
                    int n3;
                    int n4;
                    Object object;
                    string = null;
                    string2 = null;
                    Node node4 = nodeList2.item(j);
                    string = node4.getNodeName();
                    if (string != null) {
                        string2 = node4.getFirstChild().getNodeValue().trim();
                    }
                    column.setColID(i + 1);
                    if (string.equals("type")) {
                        string4 = string2;
                        column.setColType(string2);
                        object = "0";
                        if (nodeList2.item(j).getAttributes().getNamedItem("size") != null) {
                            object = nodeList2.item(j).getAttributes().getNamedItem("size").getNodeValue();
                        }
                        column.setSize(Integer.parseInt((String)object));
                    }
                    if (string.equals("dbname")) {
                        column.setPhysicalName(string2);
                    }
                    if (string.equals("updatewhereclause")) {
                        column.setUpdateWhereClause(string2.equals("yes"));
                    }
                    if (string.equals("update")) {
                        column.setUpdate(string2);
                    }
                    if (string.equals("key")) {
                        column.setKey(string2.equals("yes"));
                    }
                    if (!string.equals("name")) continue;
                    column.setLogicalName(string2);
                    node2 = this.getCol_OtherTextInfo(string2.trim());
                    if (node2 != null) {
                        object = node2.getChildNodes();
                        n4 = object.getLength();
                        for (n3 = 1; n3 < n4; n3 += 2) {
                            Node node5 = object.item(n3);
                            if (!node5.getNodeName().equals("text") || node5.getFirstChild() == null) continue;
                            column.setDisplayName(node5.getFirstChild().getNodeValue());
                        }
                    }
                    node = this.getCol_OtherInfo(string2.trim());
                    if (node == null) continue;
                    object = node.getChildNodes();
                    n4 = 0;
                    n3 = 0;
                    int n5 = object.getLength();
                    for (int k = 1; k < n5; k += 2) {
                        Node node6 = object.item(k);
                        if (node6.getNodeName().equals("band") && node6.getFirstChild() != null) {
                            column.setBand(node6.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node6.getNodeName().equals("format") && node6.getFirstChild() != null) {
                            column.setFormat(node6.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node6.getNodeName().equals("alignment") && node6.getFirstChild() != null) {
                            column.setAlignment(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                            continue;
                        }
                        if (node6.getNodeName().equals("tabsequence") && node6.getFirstChild() != null) {
                            column.setTabSequence(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                            continue;
                        }
                        if (node6.getNodeName().equals("EditStyle") && node6.getFirstChild() != null) {
                            NodeList nodeList3 = node6.getChildNodes();
                            boolean bl = false;
                            int n6 = nodeList3.getLength();
                            for (int i2 = 0; i2 < n6; ++i2) {
                                Node node7 = nodeList3.item(i2);
                                if (node7.getNodeName().equals("mask") && node7.getFirstChild() != null) {
                                    bl = true;
                                    if (!"datetime".equalsIgnoreCase(string4) && !"date".equalsIgnoreCase(string4) && !"timestamp".equalsIgnoreCase(string4)) continue;
                                    if (node7.getFirstChild().getNodeValue().toLowerCase().startsWith("hh:mm:ss")) {
                                        column.setColType("time");
                                        continue;
                                    }
                                    if (node7.getFirstChild().getNodeValue().toLowerCase().indexOf("hh:mm") != -1) {
                                        column.setColType("datetime");
                                        continue;
                                    }
                                    column.setColType("date");
                                    continue;
                                }
                                if ((bl || !"datetime".equalsIgnoreCase(string4)) && !"date".equalsIgnoreCase(string4)) continue;
                                column.setColType("date");
                            }
                            continue;
                        }
                        if (node6.getNodeName().equals("color") && node6.getFirstChild() != null) {
                            column.setColor(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                            continue;
                        }
                        if (node6.getNodeName().equals("x") && node6.getFirstChild() != null) {
                            column.setX(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                            continue;
                        }
                        if (node6.getNodeName().equals("y") && node6.getFirstChild() != null) {
                            column.setY(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                            continue;
                        }
                        if (node6.getNodeName().equals("height") && node6.getFirstChild() != null) {
                            n4 = Integer.parseInt(node6.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node6.getNodeName().equals("width") && node6.getFirstChild() != null) {
                            n3 = Integer.parseInt(node6.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!node6.getNodeName().equals("visible") || node6.getFirstChild() == null) continue;
                        column.setVisible(Integer.parseInt(node6.getFirstChild().getNodeValue()));
                    }
                }
                this.columnsList.add(column);
                column = null;
            }
            System.out.println(" ..... Column List  created ");
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createColumns :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    public String getDatabase() {
        return this.database;
    }

    private void setDatabase(String string) {
        this.database = string;
    }

    private void createPhysicalNameDisplayNameMap() throws ITMException {
        try {
            this.physicalNameDisplayNameMap = new HashMap();
            String string = null;
            String string2 = null;
            for (int i = 0; i < this.columnsList.size(); ++i) {
                string2 = ((Column)this.columnsList.get(i)).getPhysicalName();
                if (string2.indexOf(46) == -1) continue;
                string = ((Column)this.columnsList.get(i)).getDisplayName();
                if (string == null) {
                    string = ((Column)this.columnsList.get(i)).getLogicalName();
                }
                this.physicalNameDisplayNameMap.put(string2, string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createPhysicalNameDisplayNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createPhysicalNameLogicalNameMap() throws ITMException {
        try {
            this.physicalNameLogicalNameMap = new HashMap();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                this.physicalNameLogicalNameMap.put(((Column)this.columnsList.get(i)).getPhysicalName(), ((Column)this.columnsList.get(i)).getLogicalName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createPhysicalNameLogicalNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createNoUpdateBandLinkList() throws ITMException {
        try {
            this.noUpdateBandLinkList = new LinkedList();
            if (this.columnsList != null) {
                for (int i = 0; i < this.columnsList.size(); ++i) {
                    if (((Column)this.columnsList.get(i)).getBand() != null || ((Column)this.columnsList.get(i)).getUpdate() != null) continue;
                    this.noUpdateBandLinkList.add(((Column)this.columnsList.get(i)).getLogicalName());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createNoUpdateBandLinkList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createColIDLogNameMap() throws ITMException {
        try {
            this.colIDLogNameMap = new HashMap();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                this.colIDLogNameMap.put(new Integer(((Column)this.columnsList.get(i)).getColID()), ((Column)this.columnsList.get(i)).getLogicalName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createColIDLogNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createColLogNameTypeMap() throws ITMException {
        try {
            this.colLogNameTypeMap = new HashMap();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                this.colLogNameTypeMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getColType());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createColLogNameTypeMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createColLogNameSizeMap() throws ITMException {
        try {
            this.colLogNameSizeMap = new HashMap();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                this.colLogNameSizeMap.put(((Column)this.columnsList.get(i)).getLogicalName(), new Integer(((Column)this.columnsList.get(i)).getSize()));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createColLogNameSizeMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createKeyList() throws ITMException {
        try {
            this.keyList = new ArrayList();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                if (!((Column)this.columnsList.get(i)).isKey()) continue;
                this.keyList.add(new Integer(((Column)this.columnsList.get(i)).getColID()));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createKeyList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createLogicalNameList() throws ITMException {
        try {
            this.logicalNameList = new ArrayList();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                this.logicalNameList.add(((Column)this.columnsList.get(i)).getLogicalName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createLogicalNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createPrimaryKeyPhyNameList() throws ITMException {
        try {
            this.primaryKeyPhyNameList = new ArrayList();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                if (!((Column)this.columnsList.get(i)).isKey()) continue;
                this.primaryKeyPhyNameList.add(((Column)this.columnsList.get(i)).getPhysicalName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createPrimaryKeyPhyNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createPrimaryKeyLogNameList() throws ITMException {
        try {
            this.primaryKeyLogNameList = new ArrayList();
            this.primaryKeyDataTypeList = new ArrayList();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                if (!((Column)this.columnsList.get(i)).isKey()) continue;
                this.primaryKeyLogNameList.add(((Column)this.columnsList.get(i)).getLogicalName());
                this.primaryKeyDataTypeList.add(((Column)this.columnsList.get(i)).getColType());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createPrimaryKeyLogNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createUpdateableLogPhyColNames() throws ITMException {
        try {
            this.updateableLogPhyColNames = new Hashtable();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                if (((Column)this.columnsList.get(i)).getUpdate() == null || !((Column)this.columnsList.get(i)).getUpdate().equals("yes")) continue;
                this.updateableLogPhyColNames.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getPhysicalName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createUpdateableLogPhyColNames :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    private void createUpdateableLogNameColType() throws ITMException {
        try {
            this.updateableLogNameColType = new Hashtable();
            for (int i = 0; i < this.columnsList.size(); ++i) {
                if (((Column)this.columnsList.get(i)).getUpdate() == null || !((Column)this.columnsList.get(i)).getUpdate().equals("yes")) continue;
                this.updateableLogNameColType.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getColType());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :createUpdateableLogNameColType :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    public Hashtable getUpdateableLogPhyColNames() throws ITMException {
        try {
            if (this.updateableLogPhyColNames == null) {
                this.createUpdateableLogPhyColNames();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getUpdateableLogPhyColNames :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.updateableLogPhyColNames;
    }

    public LinkedList getNoUpdateBandLinkList() throws ITMException {
        try {
            if (this.noUpdateBandLinkList == null) {
                this.createNoUpdateBandLinkList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getNoUpdateBandLinkList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.noUpdateBandLinkList;
    }

    public Hashtable getUpdateableLogNameColType() throws ITMException {
        try {
            if (this.updateableLogNameColType == null) {
                this.createUpdateableLogNameColType();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getUpdateableLogNameColType :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.updateableLogNameColType;
    }

    public ArrayList getColumnsList() throws ITMException {
        try {
            if (this.columnsList == null) {
                this.createColumns();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getColumnsList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.columnsList;
    }

    public ArrayList getLogicalNameList() throws ITMException {
        try {
            if (this.logicalNameList == null) {
                this.createLogicalNameList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getLogicalNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.logicalNameList;
    }

    public String getQueryString() throws ITMException {
        try {
            String string;
            SQLMaker sQLMaker = new SQLMaker(this.database);
            this.queryString = string = sQLMaker.makeSQL(this.filename);
        }
        catch (Exception exception) {
            System.out.println("Exception : DWObject : getQueryString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.queryString;
    }

    public String getTableToBeUpdated() {
        return this.tableToBeUpdated;
    }

    public ArrayList getArgNamesList() {
        return this.argNamesList;
    }

    public HashMap getPhysicalNameDisplayNameMap() throws ITMException {
        try {
            if (this.physicalNameDisplayNameMap == null) {
                this.createPhysicalNameDisplayNameMap();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getPhysicalNameDisplayNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.physicalNameDisplayNameMap;
    }

    public HashMap getPhysicalNameLogicalNameMap() throws ITMException {
        try {
            if (this.physicalNameLogicalNameMap == null) {
                this.createPhysicalNameLogicalNameMap();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getPhysicalNameLogicalNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.physicalNameLogicalNameMap;
    }

    public HashMap getColIDLogNameMap() throws ITMException {
        try {
            if (this.colIDLogNameMap == null) {
                this.createColIDLogNameMap();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getColIDLogNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.colIDLogNameMap;
    }

    public HashMap getColLogNameTypeMap() throws ITMException {
        try {
            if (this.colLogNameTypeMap == null) {
                this.createColLogNameTypeMap();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getColLogNameTypeMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.colLogNameTypeMap;
    }

    public HashMap getColLogNameSizeMap() throws ITMException {
        try {
            if (this.colLogNameSizeMap == null) {
                this.createColLogNameSizeMap();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getColLogNameSizeMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.colLogNameSizeMap;
    }

    public ArrayList getKeyList() throws ITMException {
        try {
            if (this.keyList == null) {
                this.createKeyList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getKeyList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.keyList;
    }

    public ArrayList getPrimaryKeyPhyNameList() throws ITMException {
        try {
            if (this.primaryKeyPhyNameList == null) {
                this.createPrimaryKeyPhyNameList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getPrimaryKeyLogNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.primaryKeyPhyNameList;
    }

    public ArrayList getPrimaryKeyLogNameList() throws ITMException {
        try {
            if (this.primaryKeyLogNameList == null) {
                this.createPrimaryKeyLogNameList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getPrimaryKeyLogNameList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.primaryKeyLogNameList;
    }

    public ArrayList getPrimaryKeyDataTypeList() throws ITMException {
        try {
            if (this.primaryKeyDataTypeList == null) {
                this.createPrimaryKeyLogNameList();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DWObject :getPrimaryKeyDataTypeList :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return this.primaryKeyDataTypeList;
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setObjContext(String string) {
        this.objContext = string;
    }

    public HashMap getColDataTypeMap() throws ITMException {
        if (this.colDataTypeNameMap == null) {
            try {
                this.setColDataTypeNameMap();
            }
            catch (Exception exception) {
                System.out.println("Exception : MetaDataObject : getColDataTypeMap :==>" + exception.getMessage());
                throw new ITMException(exception);
            }
        }
        return this.colDataTypeNameMap;
    }

    private void setColDataTypeNameMap() throws ITMException {
        try {
            this.colDataTypeNameMap = new HashMap();
            if (this.columnsList != null) {
                for (int i = 0; i < this.columnsList.size(); ++i) {
                    this.colDataTypeNameMap.put(((Column)this.columnsList.get(i)).getPhysicalName(), ((Column)this.columnsList.get(i)).getColType());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : MetaDataObject :setColDataTypeNameMap :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
    }

    public void remove() {
        if (this.columnsList != null) {
            this.columnsList.clear();
            this.columnsList = null;
        }
    }
}

