/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMFilterModel;
import ibase.webitm.bean.ITMTransactionModel;
import ibase.webitm.ejb.MasterDataRemote;
import ibase.webitm.ejb.XSLBuilderRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.naming.InitialContext;

public class ITMTransactionHeaderModel
extends ITMTransactionModel
implements Serializable {
    private UserInfoBean userInfo = null;
    private String objName = "";
    private String titleName = "";
    private ArrayList pkNamesList = null;
    private ArrayList pkTypesList = null;
    private ArrayList pkValuesList = null;
    private int viewOpt = 0;
    private ITMFilterModel itmFilterModel = null;
    private String userLang = "en";
    private String userCountry = "US";

    public ITMTransactionHeaderModel() {
        this(null, null);
    }

    public ITMTransactionHeaderModel(String string) {
        this(string, null);
    }

    public ITMTransactionHeaderModel(String string, String string2) {
        this.objName = string;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfoBean) {
        this.userInfo = userInfoBean;
    }

    @Override
    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setObjName(String string) throws ITMException {
        try {
            this.objName = string;
            if (this.userInfo == null) {
                throw new Exception("Invalid Session");
            }
            this.itmFilterModel = new ITMFilterModel(string, this.userInfo);
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
    }

    @Override
    public String getObjName() {
        return this.objName;
    }

    public void setTitleName(String string) {
        this.titleName = string;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public int getViewOpt() {
        return this.viewOpt;
    }

    @Override
    public ITMFilterModel getITMFilterModel() {
        return this.itmFilterModel;
    }

    public void setUserLang(String string) {
        this.userLang = string;
    }

    public String getUserLang() {
        return this.userLang;
    }

    public void setUserCountry(String string) {
        this.userCountry = string;
    }

    public String getUserCountry() {
        return this.userCountry;
    }

    public String getHTMLData() throws ITMException {
        String string = "";
        try {
            String string2 = this.getXSLFileName();
            String string3 = this.getXMLData();
            if (string3 != null && string3.length() > 0) {
                String string4 = CommonConstants.APPLICATION_CONTEXT + File.separator + "temp";
                string = new GenericUtility().transformToString(string2, string3, string4, "Output", ".html");
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    public String getXMLData() throws ITMException {
        String string = null;
        try {
            if (this.userInfo != null) {
                InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
                MasterDataRemote masterDataRemote = (MasterDataRemote)initialContext.lookup("ibase/MasterDataEJB/remote");
                String string2 = this.itmFilterModel.getFormalFilterNamesString();
                String string3 = this.itmFilterModel.getFormalFilterValuesString();
                String string4 = this.itmFilterModel.getFormalFilterTypesString();
                if (string2 == null || string2.length() == 0 || string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                    string = masterDataRemote.getXMLFromDBForBrow(this.objName, "1", "1", string3, string4, this.itmFilterModel.getUserFilterValuesString(), this.userInfo, true);
                }
            } else {
                string = "ERR_MSG :User Info not in session";
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    private String getXSLFileName() throws ITMException {
        String string = null;
        try {
            String string2 = null;
            string2 = CommonConstants.APPLICATION_CONTEXT != null ? CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            String string3 = this.objName + "11" + "_" + this.userLang + "_" + this.userCountry + "_" + "V.xsl";
            if (!new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                System.out.println("ITMTransactionHeaderModel :: creating  theme folder");
                new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
            }
            File file = new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME, string3);
            System.out.println(" ITMTransactionHeaderModel::getXSLFileName::xslFile[" + file + "]");
            if (file.exists()) {
                string = file.getAbsolutePath();
            } else {
                AppConnectParm appConnectParm = new AppConnectParm();
                Properties properties = appConnectParm.getProperty();
                InitialContext initialContext = new InitialContext(properties);
                XSLBuilderRemote xSLBuilderRemote = (XSLBuilderRemote)initialContext.lookup("ibase/XSLBuilderEJB/remote");
                String string4 = xSLBuilderRemote.buildXSLString(this.objName, "1", this.userLang, this.userCountry, "1", "V", CommonConstants.APPLICATION_CONTEXT, this.userInfo.getProfileIdRes());
                if (!string4.endsWith(".xsl")) {
                    byte[] byArray = string4.getBytes();
                    int n = byArray.length;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray, 0, n);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                    string = file.getAbsolutePath();
                } else {
                    string = string4;
                }
            }
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    public String getDisplayMsg(String string, String string2) {
        String string3 = null;
        String string4 = null;
        try {
            Locale locale = new Locale(string);
            String string5 = ".." + File.separator + "setting" + File.separator + "CustomMessage" + "_" + locale + ".properties";
            File file = new File(string5);
            if (file.exists()) {
                string3 = "No Data Found";
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                boolean bl = false;
                while ((string4 = bufferedReader.readLine()) != null) {
                    String string6 = string4.substring(0, string4.indexOf("="));
                    if (string2.trim().equalsIgnoreCase(string6.trim())) {
                        string3 = string4.substring(string4.indexOf("=") + 1, string4.length());
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    string3 = "No Data Found";
                }
                bufferedReader.close();
            } else {
                System.out.println("Message file " + string5 + " Does not exist");
                string3 = "No Data Found";
            }
        }
        catch (Exception exception) {
            System.out.println(" ITMTransactionHeaderModel :: getDisplayMsg ::=> ");
            exception.printStackTrace();
        }
        System.out.println(" ITMTransactionHeaderModel :: getDisplayMsg ::=> message [" + string3 + "]");
        return string3;
    }

    @Override
    public String toString() {
        return null;
    }
}

