/********************************************************
	Title : CustItemUpdatePrc[D14LSUN003]
	Date  : 11/03/15
	Developer: Priyanka Shinde

 ********************************************************/
package ibase.webitm.ejb.dis.adv;
import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;

import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;
import java.text.SimpleDateFormat; 
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3
             
public class CustItemUpdatePrc extends ProcessEJB implements CustItemUpdatePrcLocal,CustItemUpdatePrcRemote
{	
String loginSiteCode = null;
GenericUtility genericUtility = GenericUtility.getInstance();
String currDateTs = null;
String chgUser = "";
String chgTerm = ""; 
ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
	throws RemoteException,ITMException
{
	Document detailDom = null;
	Document headerDom = null;
	String retStr = "";	
	System.out.println("Process method called@@@@@@@@@@@@@......");	
	try
	{	
		if(xmlString != null && xmlString.trim().length()!=0)
		{
			headerDom = genericUtility.parseString(xmlString); 
			System.out.println("headerDom" + headerDom);
		}
		if(xmlString2 != null && xmlString2.trim().length()!=0)
		{
			detailDom = genericUtility.parseString(xmlString2); 
			System.out.println("detailDom" + detailDom);
		}		 
		retStr = process(headerDom, detailDom, windowName, xtraParams);
	}
	catch (Exception e)
	{			
		System.out.println("Exception :CustItemUpdatePrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
		e.printStackTrace();
		throw new ITMException(e);
	}
	return retStr;
}//END OF PROCESS (1)

public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
{
	System.out.println("Process method called$$$$$$$$$$$..");	
	Connection conn = null;	
	String resultString = "", errString = "";
	boolean isError = false;
	PreparedStatement pstmt = null;	
	PreparedStatement pstmt1 = null;	
	ResultSet rs = null;
	//ResultSet rs1 = null;
	String sql = "",sql1="";	
	int updCnt=0;		
	String custCodeFrom="",custCodeTo="";
	String itemCodeFrom="",itemCodeTo="";
	String integralQty="";
	double intQty=0,minQty=0,intQtyExst=0;
	
	String custCode="",itemCode="";
	
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();	
	String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
	loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
	chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
	chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");	
	
	try
	{

			
		ConnDriver connDriver = new ConnDriver();
		conn = connDriver.getConnectDB("DriverITM");
		connDriver = null;
		conn.setAutoCommit(false);
		
		custCodeFrom = checkNull(genericUtility.getColumnValue("cust_code__from",headerDom ));	
		custCodeTo= checkNull(genericUtility.getColumnValue("cust_code__to",headerDom ));
		itemCodeFrom = checkNull(genericUtility.getColumnValue("item_code__from",headerDom ));
		itemCodeTo = checkNull(genericUtility.getColumnValue("item_code__to",headerDom ));
		integralQty   = checkNull(genericUtility.getColumnValue("integral_qty",headerDom ));
		if(integralQty==null|| integralQty.trim().length()==0)
		{
			resultString = itmDBAccessEJB.getErrorString("","PROCFAILED",userId);
			return resultString;
		} 		
		else
		{
			  intQty=Double.parseDouble(integralQty);
		}	  
		
		System.out.println("custCodeFrom========="+custCodeFrom);
		System.out.println("custCodeTo========="+custCodeTo);
		System.out.println("itemCodeFrom========="+itemCodeFrom);
		System.out.println("itemCodeTo========="+itemCodeTo);
		System.out.println("integralQty========="+integralQty);
		System.out.println("intQty========="+intQty);
		
		
		sql="select min(integral_qty) as min_qty from customeritem where item_code >= ? and item_code <= ?";
		pstmt=conn.prepareStatement(sql);
		pstmt.setString(1,itemCodeFrom);
		pstmt.setString(2,itemCodeTo);	
		rs=pstmt.executeQuery();
		if(rs.next())
		{
			minQty=rs.getDouble("min_qty");			
		}
		pstmt.close();
    	rs.close();
    	pstmt = null;
    	rs = null;
    	System.out.println("Getting mininum existing integral quantity======"+minQty);
    	
    	sql="select integral_qty,cust_code,item_code from customeritem where item_code >= ? and item_code <= ? and cust_code >= ? and cust_code <= ?";
    	pstmt=conn.prepareStatement(sql);
		pstmt.setString(1,itemCodeFrom);
		pstmt.setString(2,itemCodeTo);
		pstmt.setString(3,custCodeFrom);
		pstmt.setString(4,custCodeTo);
		rs=pstmt.executeQuery();
		while(rs.next())
		{
			intQtyExst=rs.getDouble("integral_qty");
			custCode=rs.getString("cust_code");
			itemCode=rs.getString("item_code");
			
			System.out.println("Intergral Qty existing Minimum========"+minQty);
			System.out.println("custCode========"+custCode);
			System.out.println("itemCode========"+itemCode);
			System.out.println("Intergral Qty existing========"+intQtyExst);
			if(intQtyExst <= minQty)
			{
				intQtyExst=intQty;
			}
			else if(intQtyExst>minQty)
			{
				intQtyExst=(intQtyExst/intQty) ;
				intQtyExst=Math.ceil(intQtyExst)*intQty;
			}
			
			System.out.println("Getting new integral Quantity====="+intQtyExst);
			
			sql1="update customeritem set integral_qty= ? where  item_code= ? and cust_code= ?  ";
			System.out.println("sql :" + sql1);
			pstmt1 = conn.prepareStatement(sql1);
			pstmt1.setDouble(1,intQtyExst);
			pstmt1.setString(2,itemCode);
			pstmt1.setString(3,custCode);
			
			updCnt = pstmt1.executeUpdate();
			System.out.println(updCnt + " Records Updated");
			if(updCnt>0)
			{
				System.out.println("Process Sucessful");
				
			}
			
			pstmt1.close();
			pstmt1 = null;
		}
		pstmt.close();
    	rs.close();
    	pstmt = null;
    	rs = null;
		
	} // end of try code 
   	catch(Exception e)
	{
		isError = true;
		e.printStackTrace();
		errString = e.getMessage();
		throw  new ITMException(e);
	}		
	finally
	{
		try
		{
			if(rs != null)
			rs.close();
			rs = null;
			if(pstmt != null)
			pstmt.close();
			pstmt = null;				
			if(conn != null)
			{
				if(isError)
				{
					conn.rollback();
					System.out.println("connection rollback.............");
					resultString = itmDBAccessEJB.getErrorString("","PROCFAILED",userId);
				}	
				else
				{
					
						conn.commit();
						System.out.println("commiting connection.............");
					
					if(errString.equals(""))
					{
						errString = "PROCSUCC";
					}
					resultString = itmDBAccessEJB.getErrorString("",errString,userId);
					
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
		}
		catch(SQLException sqle)
		{
			sqle.printStackTrace();
		}
	}	
	System.out.println("returning from     "+resultString);
	return resultString;
	} //end process

	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input.trim();
	}


}

 