package ibase.webitm.utility.wms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wms.ShipmentStatus;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wms.UploadOrderEJB;
import ibase.webitm.utility.ITMException;

public class DDUpdTrackSchedule implements Schedule
{
	String chgUser = null;
	String chgTerm = null;
	static long count_records=0;
	boolean isError = false;
	static int Lineno =0;

	public String schedulePriority( String wrkflwPriority )throws Exception
	{
		return "";
	}
	public String schedule(HashMap map)throws Exception
	{
		return "";
	}
	public String schedule(String scheduleParamXML)throws Exception
	{
		String siteCode = "";
		ibase.utility.UserInfoBean userInfo = null;
		String xtraParams = "";
		try
		{
			System.out.println("Schedule Param ["+scheduleParamXML+"]");
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			xtraParams= getXtraParams( userInfo );
			System.out.println("xtraParams=======["+xtraParams+"]");
			UpdTrackSchedule(xtraParams);
			System.out.println("Final Return from schedular");
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		return "";
	}
	public String UpdTrackSchedule(String xtraParams) throws RemoteException,ITMException
	{

		String sql = "", saleOrd = "", ptcn = "";
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		java.util.Date currDate = new java.util.Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(currDate);
		cal.add(Calendar.DATE, -1);
		java.util.Date prvDate = cal.getTime();// One Day before current date
		try
		{
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			System.out.println("xtraParams=======["+xtraParams+"]");
			String applDateFormat = genericUtility.getApplDateFormat();
			String dbDateFormat = genericUtility.getDBDateFormat();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			//String currDateStr = sdf.format(currDate);
			String prvDateStr = sdf.format(prvDate);
			java.sql.Timestamp tranDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateString( prvDateStr , applDateFormat, dbDateFormat ) + " 00:00:00.0") ;

			ShipmentStatus objShipment = new ShipmentStatus();
			CommonWmsUtil wmsUtil = new CommonWmsUtil();
			String apiShipUrl = wmsUtil.getDDSalesConfig("SHIP_STATUS_URL");		
			String apiKey = wmsUtil.getDDSalesConfig("API_KEY");
			
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			sql = "SELECT SORD_NO, PTCN FROM DESPATCH WHERE CONFIRMED = 'Y' AND CONF_DATE >= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, tranDate);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				System.out.println("======WHILE LOOP START=====");
				try
				{
					saleOrd = rs.getString(1);
					ptcn = rs.getString(2);
					errString = updateTracking(saleOrd, ptcn, apiShipUrl, apiKey, objShipment, wmsUtil, conn);
					System.out.println("RETURN STRING FROM updateTracking IS====["+errString+"]");
					writeLog(errString);
				}
				catch(Exception ex)
				{
					System.out.println("Exception caught for SaleOrder["+saleOrd+"] so rollbacking and going for next despatch");
					conn.rollback();
					ex.printStackTrace(pw);
					writeLog(errString);
					continue;
				}
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}	

		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(conn != null)
				{	
					conn.close();
					conn = null;
				}
			}
			catch(Exception ex)
			{
				System.out.println("Exception is "+ex.getMessage());
			}
		}
		return errString;
	} 
	public String updateTracking(String saleOrder, String ptcn, String apiShipUrl, String apiKey, ShipmentStatus objShipment, CommonWmsUtil wmsUtil, Connection conn) throws ITMException
	{
		String retString = "";
		try
		{
			System.out.println("status tracking update in magento start");
			objShipment.setApiKey(apiKey);			
			objShipment.setOrderID(saleOrder);
			objShipment.setStatus("complete");
			objShipment.setTrackingNumbers(wmsUtil.getTrackingNo(ptcn, conn));
			objShipment.setComment("Sale Order Complete");
			retString = wmsUtil.CallTrackShipStatus(objShipment, apiShipUrl);
			System.out.println("RETURN STRING FROM CallTrackShipStatus IS====["+retString+"]");
			System.out.println("status tracking update in magento END");
		}
		catch(Exception e)
		{
			System.out.println("Exception inCalling confirmed");
			e.printStackTrace();
		}
		return retString;
	}
	public String getXtraParams( UserInfoBean userInfoBean )throws Exception
	{
		String XTRA_PARAMS_SEPARATOR = "~~";
		StringBuffer xtraParamsBuff = new StringBuffer();
		xtraParamsBuff.append("loginCode=" + userInfoBean.getLoginCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfoBean.getEmpCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfoBean.getSiteCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfoBean.getEntityCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfoBean.getProfileId());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfoBean.getUserType());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfoBean.getUserLanguage());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfoBean.getUserCountry());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfoBean.getCharEnc());		
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+userInfoBean.getRemoteHost());

		String chgTerm = userInfoBean.getRemoteHostName();
		if( chgTerm != null && chgTerm.length() > 15 )
		{
			chgTerm = chgTerm.substring(0, 15);
		}
		else if( chgTerm == null || chgTerm.length() == 0 )
		{
			chgTerm = userInfoBean.getRemoteHost();
		}
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );

		System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");

		return xtraParamsBuff.toString();
	}
	public void writeLog(String errString) throws Exception
	{
		FileOutputStream fos1 = null;
		String fileName = "";
		final Logger logger = Logger.getLogger(DDUpdTrackSchedule.class.getName());
		java.util.Date currDate = new java.util.Date();
	//	SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
		try
		{
			
			String time = sdf.format(currDate);
			time = time.replaceAll(":", "-");
			System.out.println("currDate is :::"+time);
			fileName = "SHIPSTATUS_"+time;

			System.out.println("Schdular Log Name is ="+fileName);

			File dir = new File ( CommonConstants.JBOSSHOME + File.separator + "log" );
			if(!dir.exists())
			{
				dir.mkdirs();
			}
			File file1 = new File( dir ,fileName);
			file1.createNewFile();

			System.out.println("PATH123 :"+file1.getAbsolutePath());

			Handler fh = new FileHandler(file1.getAbsolutePath(), true);
			fh.setFormatter(new SimpleFormatter());  								
			logger.addHandler(fh);								
			logger.setLevel(Level.FINE);								
			logger.log(Level.SEVERE, errString, errString);								
			fh.flush();
			fh.close();	    
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
	}

}
