package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.B2CS;

public class B2CSSerializer extends BaseSerializer<B2CS>
{
	@Override
	public void serialize(B2CS b2cs, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		if(b2cs.taxPayerAction!= null)
		{
			json.writeStringField("flag", b2cs.taxPayerAction);
		}
		json.writeStringField("sply_ty", b2cs.supplyType);
		json.writeNumberField("txval", b2cs.txval);
		json.writeStringField("typ", b2cs.typ);
		if(b2cs.etin!=null)
		{
			json.writeStringField("etin", b2cs.etin);
		}
		json.writeStringField("pos", b2cs.pos);
		json.writeNumberField("rt", b2cs.rate);
		if(b2cs.iamt > 0)
		{
			json.writeNumberField("iamt", b2cs.iamt);
		}
		if(b2cs.camt > 0)
		{
			json.writeNumberField("camt", b2cs.camt);
		}
		if(b2cs.samt > 0)
		{
			json.writeNumberField("samt", b2cs.samt);
		}
		if(b2cs.csamt > 0)
		{
			json.writeNumberField("csamt", b2cs.csamt);
		}
		json.writeEndObject();
	}
}
