/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4jProxy;

public class Log4JLogger
implements Log,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private transient Log theLogger;

    public Log4JLogger() {
        this(null);
    }

    public Log4JLogger(String name) {
        this.name = name;
        try {
            ClassLoader loader = Log4jProxy.threadContextClassLoader();
            Class<?> priorityClass = Class.forName("org.apache.log4j.Priority", false, loader);
            Class<?> levelClass = Class.forName("org.apache.log4j.Level", false, loader);
            if (!priorityClass.isAssignableFrom(levelClass)) {
                throw new InstantiationError("Log4J 1.2 not available");
            }
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
        this.getLogger();
    }

    public void trace(Object message) {
        this.getLogger().trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.getLogger().trace(message, t);
    }

    public void debug(Object message) {
        this.getLogger().debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().debug(message, t);
    }

    public void info(Object message) {
        this.getLogger().info(message, null);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().info(message, t);
    }

    public void warn(Object message) {
        this.getLogger().warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().warn(message, t);
    }

    public void error(Object message) {
        this.getLogger().error(message, null);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void fatal(Object message) {
        this.getLogger().fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().fatal(message, t);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    Log getLogger() {
        if (this.theLogger == null) {
            this.theLogger = new Log4jProxy(this.name);
        }
        return this.theLogger;
    }
}

