create or replace trigger itemdescrtypeupd
after update of descr, unit on item
referencing old as old new as new

FOR EACH ROW

DECLARE
  isupdated boolean := false;
  itemcode char(10);
  dissite char(120);
  item_code char(10);
  idescr varchar2(120);
  iunit char(3);
  item_ser__rg1 char(10);
  loc_zone__pref number(16,0);
  qc_sample_type char(10);
  analysis_class char(1);
  tran_id char(10);
  refser char(6);
  PRAGMA AUTONOMOUS_TRANSACTION;

begin

  if updating then
    if updating ('DESCR') then
      isupdated := true;
      idescr := :new.descr;
    else
      idescr := :old.descr;
    end if;
    if updating ('UNIT') then
      isupdated := true;
      iunit := :new.unit;
    else
      iunit := :old.unit;
    end if;

     if isupdated then
      select var_value into dissite from disparm where var_name = 'SITE_CODE_DADRA2';
	  
        if dissite is not null then
          select item_code into itemcode from item where item_code = :old.item_code;
          if itemcode is not null then

            select ref_ser into refser from transetup where tran_window = 'w_interface2';
            select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;

            insert into host_to_wms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
            select tran_id, tran_id, siteitem.item_code, idescr, iunit, siteitem.item_ser__rg1 , siteitem.analysis_class, 'M' , sysdate, 'N',
            siteitem.qc_sample_type, siteitem.loc_zone__pref from siteitem siteitem, item item where siteitem.item_code = item.item_code and
            item.item_code = itemcode and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;

            update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;

            commit;

            select ref_ser into refser from transetup where tran_window = 'w_interface2';
            select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;

            insert into swms_to_awms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
            select tran_id, tran_id, siteitem.item_code, idescr, iunit, siteitem.item_ser__rg1 , siteitem.analysis_class, 'M' , sysdate, 'N',
            siteitem.qc_sample_type, siteitem.loc_zone__pref from siteitem siteitem, item item where siteitem.item_code = item.item_code and
            item.item_code = itemcode and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;

            update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;

            commit;

          end if;
        end if;
     end if;
  end if;
end;